#ifndef __map_repl_hh__
#define __map_repl_hh__

#include "repl.hh"
#include <vector>
#include "string_map.hh"
#include "itr_equal.hh"

namespace afilter {

  template <typename In, typename Out>
  class MapReplBase : virtual public CharReplInfo {
  public:
    string name_;
    int max_in_;
    int max_out_;
    double order_num_;
  public:
    typedef vector<In>  InString;
    typedef vector<Out> String;
    virtual ~MapReplBase() {}
    
    string name() const {return name_;}
    double order_num() const {return order_num_;}
    int max_in() const {return max_in_;}
    int max_out() const {return max_out_;}

    virtual void add (const In * key, const Out * value) = 0;
    virtual void init() {}
  };

  class MapReplData;

  void get_map(MapReplData & from_data, MapReplData & to_data,
	       const ConfigData & opts, MapReplBase<char,char> & con);
  void get_map(MapReplData & data, const ConfigData & opts,
	       MapReplBase<char,unichar> & con);
  void get_map(MapReplData & data, const ConfigData & opts,
	       MapReplBase<unichar,char> & con);
  bool get_map(const string & name, const ConfigData & opts, MapReplData & data);
}

#endif
