/* util.c -- Simple utility functions that everyone uses. */

/* Copyright (C) 1988, 1990, 1992  Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  */

#include "util.h"
#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static void
memory_error_and_abort (const char *what, int nbytes)
{
  fprintf (stderr, "Fatal error: can't %s %d bytes.\n", what, nbytes);
  abort ();
}

void *
xmalloc (int nbytes)
{
  char *temp = (char *) malloc ((size_t)nbytes);

  if (!temp)
    memory_error_and_abort ("alloc", (int)nbytes);

  return ((void *) temp);
}


void *
xrealloc (void *pointer, int nbytes)
{
  char *temp;

  if (!pointer)
    temp = (char *) xmalloc (nbytes);
  else
    temp = (char *) realloc (pointer, (size_t)nbytes);

  if (!temp)
    memory_error_and_abort (pointer ? "realloc" : "alloc", nbytes);

  return ((void *) temp);
}

/* Return freshly allocated copy of S. */

char *
xstrdup (const char *s)
{
  char *tmp = xmalloc (strlen (s) + 1);

  strcpy (tmp, s);

  return tmp;
}

/* create a full path from a base path and a file name on a fresh
   place */

char *
xmakepath (const char *s, const char *q)
{
  char *tmp = xmalloc (strlen (s) + strlen (q) + 2);
  sprintf (tmp, "%s/%s", s, q);
  return tmp;
}
