/*
 *  Copyright (C) 1998-99 Luca Deri <deri@unipi.it>
 *                      
 *  			  Centro SERRA, University of Pisa
 *  			  http://www-serra.unipi.it/
 *  					
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "ntop.h"

/* #define DEBUG  */

extern void sendStringLen(char *theString, int len);
extern void sendString(char *theString);
extern void printHTTPheader();

extern HostTraffic* hash_hostTraffic[HASHNAMESIZE];

typedef struct tableColumns {
  char *name;
  short length;
  short deploy;

#define CMP_NONE                  0
#define CMP_EQUAL                 1
#define CMP_LESS_THAN             2
#define CMP_GREATHER_THAN         3
#define CMP_LESS_EQUAL_THAN       4
#define CMP_GREATHER_EQUAL_THAN   5
#define CMP_DIFFERENT_THAN        6
  short comparison;

#define AND_JUNCTION     0
#define OR_JUNCTION      1
  short junction;

  char cmpValue[32];
} TableColumns;

#define STR_LEN_32 "                                "
static TableColumns hostsCols[] = {
  { "MAC_ADDR",        18, 1, 0, 0, STR_LEN_32 },
  { "NUM_IP",          16, 1, 0, 0, STR_LEN_32 },
  { "SYM_IP",          48, 1, 0, 0, STR_LEN_32 },
  { "OS",              32, 1, 0, 0, STR_LEN_32 },
  { "PKT_SENT",        16, 1, 0, 0, STR_LEN_32 },
  { "PKT_RCVD",        16, 1, 0, 0, STR_LEN_32 },
  { "BYTES_BKST_SENT",        16, 1, 0, 0, STR_LEN_32 },
  { "BYTES_MKST_SENT",        16, 1, 0, 0, STR_LEN_32 },
  { "ACT_BWDTH",        16, 1, 0, 0, STR_LEN_32 },
  { "BYTES_SENT",        16, 1, 0, 0, STR_LEN_32 },
  { "BYTES_SENT_L",        16, 1, 0, 0, STR_LEN_32 },
  { "BYTES_SENT_R",        16, 1, 0, 0, STR_LEN_32 },
  { "BYTES_RCVD",        16, 1, 0, 0, STR_LEN_32 },
  { "BYTES_RCVD_L",        16, 1, 0, 0, STR_LEN_32 },
  { "BYTES_RCVD_R",        16, 1, 0, 0, STR_LEN_32 },

  { "TCP_SENT_L",        16, 1, 0, 0, STR_LEN_32 },
  { "TCP_SENT_R",        16, 1, 0, 0, STR_LEN_32 },
  { "TCP_RCVD_L",        16, 1, 0, 0, STR_LEN_32 },
  { "TCP_RCVD_R",        16, 1, 0, 0, STR_LEN_32 },

  { "UDP_SENT_L",        16, 1, 0, 0, STR_LEN_32 },
  { "UDP_SENT_R",        16, 1, 0, 0, STR_LEN_32 },
  { "UDP_RCVD_L",        16, 1, 0, 0, STR_LEN_32 },
  { "UDP_RCVD_R",        16, 1, 0, 0, STR_LEN_32 },


  { "ICMP_SENT",        16, 1, 0, 0, STR_LEN_32 },
  { "ICMP_RCVD",        16, 1, 0, 0, STR_LEN_32 },
  { "IGMP_SENT",        16, 1, 0, 0, STR_LEN_32 },
  { "IGMP_RCVD",        16, 1, 0, 0, STR_LEN_32 },

  { "IPX_SENT",        16, 1, 0, 0, STR_LEN_32 },
  { "IPX_RCVD",        16, 1, 0, 0, STR_LEN_32 },

  { "OSI_SENT",        16, 1, 0, 0, STR_LEN_32 },
  { "OSI_RCVD",        16, 1, 0, 0, STR_LEN_32 },

  { "DLC_SENT",        16, 1, 0, 0, STR_LEN_32 },
  { "DLC_RCVD",        16, 1, 0, 0, STR_LEN_32 },

  { "ARP_SENT",        16, 1, 0, 0, STR_LEN_32 },
  { "ARP_RCVD",        16, 1, 0, 0, STR_LEN_32 },

  { "DECNET_SENT",        16, 1, 0, 0, STR_LEN_32 },
  { "DECNET_RCVD",        16, 1, 0, 0, STR_LEN_32 },

  { "ATALK_SENT",        16, 1, 0, 0, STR_LEN_32 },
  { "ATALK_RCVD",        16, 1, 0, 0, STR_LEN_32 },

  { "NBIOS_SENT",        16, 1, 0, 0, STR_LEN_32 },
  { "NBIOS_RCVD",        16, 1, 0, 0, STR_LEN_32 },

  { "OTHER_SENT",        16, 1, 0, 0, STR_LEN_32 },
  { "OTHER_RCVD",        16, 1, 0, 0, STR_LEN_32 },

  { NULL, 0, 0, 0, 0, STR_LEN_32 } /* End of table */
};

/* ****************************** */

static void returnError(char *errStr) {
  sendString("HTTP/1.0 500 ");
  sendString(errStr);
  sendString("\n\n");
}

/* ****************************** */

static void returnOkHeader() {
  sendString("HTTP/1.0 200 Query succeeded\n\n");
}

/* ****************************** */

void sendAttributeLen(char* value, int len) {
  char tmpStr[128];

  if(value == NULL)
    strcpy(tmpStr, "\t");
  else    
  sprintf(tmpStr, "%s\t%d\t", value, len);

  sendString(tmpStr);
}

/* ****************************** */

char* computeAttributeString(char* value) {
  static char tmpAttr[128];

  if(value == NULL)
    return("\t");
  else {
    sprintf(tmpAttr, "%s\t", value);
    return(tmpAttr);
  }
}

/* ****************************** */

int computeRowString(char* theRow, char* theAttr) {
  char tmpStr[512], *attr;
  int rc;

  if((theAttr == NULL) || (theAttr[0] == '\0')) {
    attr = "\t";
    rc = 0;
  } else {
    attr = computeAttributeString(theAttr);
    rc = strlen(theAttr);
  }
  
  sprintf(tmpStr, "%s%s", theRow, attr);
  strcpy(theRow, tmpStr);
  
  return(rc);
}

/* ****************************** */

int computeRowNString(char* theRow, TrafficCounter theAttr) {
  char tmpStr[32];
  
  sprintf(tmpStr, "%ld", (unsigned long)theAttr);
  return(computeRowString(theRow, tmpStr));
}

/* ****************************** */

int checkRowNString(TableColumns col, TrafficCounter theAttr) {
  int rc;
  TrafficCounter a, b;

  if(col.cmpValue[0] == '\0')
    return(0); /* OK */

  rc = 0;
  
  a = theAttr;
  b = (TrafficCounter)atol(col.cmpValue);

  switch(col.comparison) {
  case CMP_NONE:
    break;
  case CMP_EQUAL:
    if(!(a == b)) rc = 1;
    break;
  case CMP_LESS_THAN:
    if(!(a < b)) rc = 1;
    break;
  case CMP_GREATHER_THAN:
    if(!(a > b)) rc = 1;
    break;
  case CMP_LESS_EQUAL_THAN:
    if(!(a <= b)) rc = 1;
    break;
  case CMP_GREATHER_EQUAL_THAN:
    if(!(a >= b)) rc = 1;
    break;
  case CMP_DIFFERENT_THAN:
    if(!(a != b)) rc = 1;
    break;
  }

#ifdef DEBUG
  printf("%d %d [rc=%d]\n", (int)a, (int)b, rc);
#endif

  return(rc);
}

/* ****************************** */

int checkRowString(TableColumns col, char* theAttr) {
  int rc;

#ifdef DEBUG
  printf("checkRowString [%s][%s] ", col.name, col.cmpValue);

  if(theAttr == NULL) 
    printf(" [NULL]\n");
  else
    printf(" [%s]\n", theAttr);
#endif

  if(col.cmpValue[0] == '\0')
    return(0); /* OK */

  if(theAttr == NULL) {
    if(col.comparison == CMP_NONE)
      return(0); /* OK */
    else
      return(1); /* NOT OK */
  }

  rc = strcmp(theAttr, col.cmpValue);

  switch(col.comparison) {
  case CMP_NONE:
    rc = 0;
    break;
  case CMP_EQUAL:
    if(rc == 0) rc = 0; else rc = 1;
    break;
  case CMP_LESS_THAN:
    if(rc < 0) rc = 0; else rc = 1;
    break;
  case CMP_GREATHER_THAN:
    if(rc > 0) rc = 0; else rc = 1;
    break;
  case CMP_LESS_EQUAL_THAN:
    if(rc <= 0) rc = 0; else rc = 1;
    break;
  case CMP_GREATHER_EQUAL_THAN:
    if(rc >= 0) rc = 0; else rc = 1;
    break;
  case CMP_DIFFERENT_THAN:
    if(rc != 0) rc = 0; else rc = 1;
    break;
  }

  printf("'%s' '%s' [rc=%d]\n", theAttr, col.cmpValue, rc);

  return(rc);
}

/* ****************************** */

void parseWhereClause(TableColumns cols[], char* whereClause) {
  char *colName, theColName[32], *clause=whereClause, 
    *nextRule="", *theValue;
  char theOperator[4], 
    *junctionOperator = "AND", *nextJunctionOperator;
  int i, len;

  while(nextRule != NULL) {
    nextRule = strstr(clause, "AND");
    if(nextRule == NULL) nextRule = strstr(clause, "and");

    if(nextRule == NULL) {
      nextRule = strstr(clause, "OR");
      if(nextRule == NULL) nextRule = strstr(clause, "or");

      if(nextRule != NULL) {
	nextJunctionOperator = "OR";
	nextRule[0] = '\0';
	nextRule = &nextRule[strlen("OR")];
      }
    } else {
      nextJunctionOperator = "AND";
      nextRule[0] = '\0';
      nextRule = &nextRule[strlen("AND")];
    }

    if(nextRule != NULL) {
      while(nextRule[0] == ' ')
	nextRule++;
    }

#ifdef DEBUG
    if(nextRule == NULL)
      printf("nextRule:     NULL\n");
    else
      printf("nextRule:     '%s'\n", nextRule);
#endif

    /* clause = 'PKT_SENT < 2323423' */
    colName = strstr(clause, "<");
    if(colName == NULL) {
      colName = strstr(clause, ">");
      if(colName == NULL) {
	colName = strstr(clause, "=");
	if(colName == NULL) {
	  colName = strstr(clause, "!");
	}
      }
    }
    
    len = strlen(clause)-strlen(colName);
    for(i=0; i<len; i++)
      if(clause[i] == ' ') {
	colName = &clause[i];       
	break;
      }

    if(colName == NULL) 
      continue;
    else {
      len = strlen(clause)-strlen(colName);

      for(i=0; i<len; i++)
      if((clause[i] == '=')
	 || (clause[i] == '!')
	 || (clause[i] == '<')
	 || (clause[i] == '>'))
	break;
      
      strncpy(theColName, clause, i);
      theColName[i] = '\0';
      clause = &clause[i];
    }

    i = 0;
    while((theColName[i] == ' ') && (theColName[i] != '\0'))
      i++;

    i = strlen(theColName)-1;
    while((theColName[i] == ' ') && (i > 0))
      theColName[i--] = '\0';

#ifdef DEBUG    
    if(theColName == NULL)
      printf("theColName:     NULL\n");
    else
      printf("theColName:     '%s'\n", theColName);
#endif

    while((clause[0] == ' ') && (clause[0] != '\0'))
      clause++;


    for(i=0; clause[i] != '\0'; i++)
      if(!((clause[i] == '<')
	 || (clause[i] == '>')
	 || (clause[i] == '=')
	 || (clause[i] == '!')))
	break;
      
    strncpy(theOperator, clause, i);
    theOperator[i] = '\0';

    clause = &clause[i];

#ifndef DEBUG
    printf("->%s<-\n", clause);
#endif

    i=0;
    while((clause[i] == ' ') && (clause[i] != '\0'))
      i++;

    theValue = &clause[i];

    if((theValue[0] == '\'')
       || (theValue[0] == '\"'))
      theValue++;
    
    len = strlen(theValue)-1;

    if((theValue[len] == '\'')
       || (theValue[len] == '\"'))
      theValue[len]='\0';

       
#ifndef DEBUG
    printf("Column:     '%s'\n", theColName);
    printf("Operator:   '%s'\n", theOperator);
    printf("Value:      '%s'\n", theValue);
    printf("Junction:   '%s'\n", junctionOperator);
#endif




    for(i=0; hostsCols[i].name != NULL; i++)
      if(hostsCols[i].deploy
	 & (strcasecmp(hostsCols[i].name, theColName) == 0)) {
	strcpy(hostsCols[i].cmpValue, theValue);
	
	if(strncmp(theOperator, "<=", 2) == 0)
	  hostsCols[i].comparison = CMP_LESS_EQUAL_THAN;
	else if(strncmp(theOperator, ">=", 2) == 0)
	  hostsCols[i].comparison = CMP_GREATHER_EQUAL_THAN;
	else if((strncmp(theOperator, "<>", 2) == 0)
		|| (strncmp(theOperator, "!=", 2) == 0))
	  hostsCols[i].comparison = CMP_DIFFERENT_THAN;
	else if(strncmp(theOperator, "=", 1) == 0)
	  hostsCols[i].comparison = CMP_EQUAL;
	else if(strncmp(theOperator, "<", 1) == 0)
	  hostsCols[i].comparison = CMP_LESS_THAN;
	else if(strncmp(theOperator, ">", 1) == 0)
	  hostsCols[i].comparison = CMP_GREATHER_THAN;
	else
	  break;

	if(strcasecmp(junctionOperator, "OR") == 0)
	  hostsCols[i].junction = OR_JUNCTION;
	else
	  hostsCols[i].junction = AND_JUNCTION;

#ifndef DEBUG
	printf("=> '%s' - '%d' - '%s' - '%s'\n", 
	       theColName, hostsCols[i].comparison, 
	       theValue, junctionOperator);
#endif

	break;
      }









    /* next round... */
    clause = nextRule;
    junctionOperator = nextJunctionOperator;

#ifdef DEBUG
    if(clause != NULL)
      printf("NextRule:      '%s'\n\n", clause);
#endif

  }
}

/* ****************************** */

void printHostTrafficEntries(char *columns, 
char* whereClause, char* sortColumn) {
  int i, numCols;
  HostTraffic *el;

  returnOkHeader();

  for(i=0; hostsCols[i].name != NULL; i++) {
    hostsCols[i].comparison = CMP_NONE;
    hostsCols[i].junction = AND_JUNCTION;
  }

  if(columns[0] == '*') {
    for(i=0; hostsCols[i].name != NULL; i++)
      hostsCols[i].deploy = 1;
  } else {
    char *colname = strtok(columns, " ");

    for(i=0; hostsCols[i].name != NULL; i++)
      hostsCols[i].deploy = 0;
    
    while(colname != NULL) {
      
      for(i=0; hostsCols[i].name != NULL; i++)
	if(strcasecmp(hostsCols[i].name, colname) == 0) {
	  hostsCols[i].deploy = 1;
	  break;
	}

      colname = strtok(NULL, " ");
    }
  }

  for(i=0, numCols=0; hostsCols[i].name != NULL; i++)
    if(hostsCols[i].deploy == 1) {
      sendAttributeLen(hostsCols[i].name, hostsCols[i].length);
      numCols++;
    }
  
  sendString("\n"); /* Header end */

  parseWhereClause(hostsCols, whereClause);

  for(i=0; i<HASHNAMESIZE; i++) {
    el = hash_hostTraffic[i];

    if(el != NULL) {
      int rc = 0, idx;
      char theRow[512];      
      
      /* Check first if the row matches the SELECT ... */
      idx = 0, rc = 0;
      if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowString(hostsCols[idx], el->ethAddressString);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowString(hostsCols[idx], el->hostNumIpAddress);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowString(hostsCols[idx], el->hostSymIpAddress);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowString(hostsCols[idx], el->osName); 
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->pktSent);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->pktReceived);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->bytesBroadcastSent);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->bytesMulticastSent);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->actBandwidthUsage);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->bytesSent);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->bytesSentLocally);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->bytesSentRemotely);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->bytesReceived);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->bytesReceivedLocally);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->bytesReceivedFromRemote);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->tcpSentLocally);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->tcpSentRemotely);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->tcpReceivedLocally);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->tcpReceivedFromRemote);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->udpSentLocally);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->udpSentRemotely);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->udpReceivedLocally);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->udpReceivedFromRemote);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->icmpSent);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->icmpReceived);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->igmpSent);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->igmpReceived);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->ipxSent);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->ipxReceived);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->osiSent);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->osiReceived);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->dlcSent);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->dlcReceived);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->arp_rarpSent);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->arp_rarpReceived);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->decnetSent);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->decnetReceived);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->appletalkSent);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->appletalkReceived);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->netbiosSent);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->netbiosReceived);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->otherSent);
      idx++; if(hostsCols[idx].comparison != CMP_NONE) 
	rc += checkRowNString(hostsCols[idx], el->otherReceived);
      
      if(rc > 0) 
	continue; /* this row is not what we want... */

      /* ********************************************* */
      idx = 0, rc = 0, theRow[0] = '\0';
      if(hostsCols[idx++].deploy) rc += computeRowString(theRow, el->ethAddressString);
      if(hostsCols[idx++].deploy) rc += computeRowString(theRow, el->hostNumIpAddress);
      if(hostsCols[idx++].deploy) rc += computeRowString(theRow, el->hostSymIpAddress);
      if(hostsCols[idx++].deploy) rc += computeRowString(theRow, el->osName); 
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->pktSent);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->pktReceived);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->bytesBroadcastSent);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->bytesMulticastSent);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->actBandwidthUsage);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->bytesSent);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->bytesSentLocally);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->bytesSentRemotely);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->bytesReceived);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->bytesReceivedLocally);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->bytesReceivedFromRemote);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->tcpSentLocally);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->tcpSentRemotely);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->tcpReceivedLocally);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->tcpReceivedFromRemote);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->udpSentLocally);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->udpSentRemotely);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->udpReceivedLocally);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->udpReceivedFromRemote);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->icmpSent);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->icmpReceived);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->igmpSent);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->igmpReceived);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->ipxSent);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->ipxReceived);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->osiSent);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->osiReceived);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->dlcSent);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->dlcReceived);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->arp_rarpSent);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->arp_rarpReceived);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->decnetSent);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->decnetReceived);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->appletalkSent);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->appletalkReceived);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->netbiosSent);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->netbiosReceived);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->otherSent);
      if(hostsCols[idx++].deploy) rc += computeRowNString(theRow, el->otherReceived);
      
#ifdef DEBUG
      /* printf("rc=%d\n" ,rc); */
#endif
      sendString(theRow);
      sendString("\n"); /* Row end */  
    }
  }
}

/* ****************************** */

static void removeBlanks(char* theString) {
  int i, tmpIdx=0;
  char tmpString[256];

  memset(tmpString, 0, sizeof(tmpString));

  for(i=0; (theString[i] == ' ') 
	&& (theString[i] != '\0'); i++)
    ;

  for(; (theString[i] != '\0'); i++) {
    switch(theString[i]) {
    case ',':
      theString[i] = ' ';
      /* do NOT add a 'break' here */
    case ' ':
      if(tmpIdx == 0)
	continue;
      else if(tmpString[tmpIdx-1] != ' ')
	tmpString[tmpIdx++] = theString[i];
      break;
    default:
      tmpString[tmpIdx++] = theString[i];
    }
  }

  if(tmpString[tmpIdx-1] == ' ')
     tmpString[tmpIdx-1] = '\0';

  tmpString[tmpIdx] = '\0';

  strcpy(theString, tmpString);
}

/* ****************************** */
static void handleOdbcRequest(char* url) {
  int i, beginIdx, found=0;
  char *tableName="", *cols, *sortOrder="", *whereClause="";

  for(i=0; url[i] != '\0'; i++)
     if(url[i] == '&') {
       url[i] = '\0';
       break;
}

  i = strlen("SELECT ");
  cols = &url[i];

  for(beginIdx=i; url[i] != '\0'; i++)
    if(strncasecmp(&url[i], "FROM ", strlen("FROM ")) == 0) {
      url[i] = 0;
      found = 1;
      i += strlen("FROM ");
      tableName = &url[i];
      break;
    }

  if(found) {
    for(; url[i] != '\0'; i++)
      if(url[i] == ' ') {
	url[i] = '\0';
	break;
      }

    i++;

    printf("-> %s\n", &url[i]);
    for(beginIdx=i; url[i] != '\0'; i++)
      if(strncasecmp(&url[i], "WHERE ", strlen("WHERE ")) == 0) {
	url[i] = '\0';
	i += strlen("WHERE ");
	whereClause = &url[i];
	break;
      }


    printf("-> %s\n", &url[i]);
    for(beginIdx=i; url[i] != '\0'; i++)
      if(strncasecmp(&url[i], "ORDER BY ", strlen("ORDER BY ")) == 0) {
	url[i] = '\0';
	i += strlen("ORDER BY ");
	sortOrder = &url[i];
	break;
      }
  }

  removeBlanks(tableName);
  removeBlanks(cols);
  removeBlanks(sortOrder);
  removeBlanks(whereClause);

#ifdef DEBUG  
  printf("Table='%s'\n", tableName);
  printf("Columns='%s'\n", cols);
  printf("Where='%s'\n", whereClause);
  printf("Sort='%s'\n", sortOrder);
#endif

  if(strcasecmp(tableName, "hosts") == 0)
    printHostTrafficEntries(cols, whereClause, sortOrder);
  else
    returnError("Unknown table");
}

/* ****************************** */

static void termOdbcFunct() {
  printf("Thanks for using the ODBC plugin.\n");
}

/* ****************************** */

static PluginInfo odbcPluginInfo[] = {
  "odbcServerPlugin",
  "This plugin handles ODBC requests issued by the ntop ODBC driver",
  "1.0",           /* version */
  "<A HREF=http://jake.unipi.it/~deri/>Luca Deri</A>", 
  "odbcServer",      /* http://<host>:<port>/plugins/odbcWatch */
  termOdbcFunct,    /* TermFunc   */
  NULL, /* PluginFunc */
  handleOdbcRequest,
  NULL  /* BPF filter */
};

/* Plugin entry fctn */
PluginInfo* PluginEntryFctn() {
  printf("Welcome to %s. (C) 1999 by Luca Deri.\n",  odbcPluginInfo->pluginName);

  return(odbcPluginInfo);
}
