/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998,1999 Bert Vermeulen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <stdlib.h>
#include <ctype.h>
#include <time.h>

#include <glib.h>

#include <lber.h>
#include <ldap.h>

#include <config.h>
#include "common.h"
#include "util.h"
#include "ldif.h"


void prepend_ldif_header(GString *out, struct ldapserver *server, GSList *bases)
{
     time_t stamp;
     GString *tmp;
     char *username;

     tmp = g_string_sized_new(256);
     username = get_username();
     time(&stamp);
     g_string_sprintf(tmp, "# This file was generated by %s %s   (http://biot.com/gq/)\n"
		      "# run by %s %s",
		      PACKAGE, VERSION, username ? username : "NULL", ctime(&stamp));

     while(bases) {
	  g_string_sprintfa(tmp, "# subtree search on %s\n", (char *) bases->data);
	  bases = bases->next;
     }
     g_string_sprintfa(tmp, "# server: %s:%d\n# binddn: %s\nversion: 1\n\n",
		       server->ldaphost, server->ldapport,
		       (server->binddn && strlen(server->binddn))? server->binddn: "(anonymous)");
     g_string_prepend(out, tmp->str);
     free(username);
     g_string_free(tmp, TRUE);

}


gboolean ldif_entry_out(GString *out, LDAP *ld, LDAPMessage *msg)
{
     BerElement *ptr;
     int i;
     char *dn, *attr, **vals, *value;

     dn = ldap_get_dn(ld, msg);
     ldif_line_out(out, "dn", dn, strlen(dn));
     g_string_append(out, "\n");
     free(dn);

     for(attr = ldap_first_attribute(ld, msg, &ptr); attr != NULL;
	 attr = ldap_next_attribute(ld, msg, ptr)) {

	  vals = ldap_get_values(ld, msg, attr);
	  if(vals) {
	       for(i = 0; vals[i]; i++) {

		    value = vals[i];
		    ldif_line_out(out, attr, value, strlen(value));
		    g_string_append(out, "\n");
	       }
	  }
     }
     g_string_append(out, "\n");

     return(TRUE);
}


gboolean ldif_line_out(GString *out, char *attr, char *value, int vlen)
{
     GString *tmp;
     int i, w, do_base64;

     g_string_append(out, attr);
     tmp = g_string_sized_new(64);

     do_base64 = 0;
     for(i = 0; i < vlen && !do_base64; i++) {
	  if(!isascii(value[i]) || !isprint(value[i]))
	       do_base64 = 1;
     }

     if(do_base64) {
	  g_string_append_c(out, ':');
	  b64_encode(tmp, value, vlen);
     }
     else {
	  g_string_append(tmp, value);
     }

     g_string_append(out, ": ");

     w = strlen(attr) + do_base64 + 2;
     for(i = 0; i < tmp->len; i++) {
	  g_string_append_c(out, tmp->str[i]);
	  if(++w > 76) {
	       g_string_append(out, "\n ");
	       w = 1;
	  }
     }

     g_string_free(tmp, TRUE);

     return(TRUE);
}


void b64_encode(GString *out, char *value, int vlen)
{
     int i,j;
     char ch[]="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
     char chin[4], chout[5];

     j = 0;
     chin[0] = chin[1] = chin[2] = 0;
     chout[0] = chout[1] = chout[2] = chout[3] = chout[4] = 0;
     for(i = 0; i < vlen; i++) {
	  chin[j++] = value[i];

	  chout[0] = ch[(chin[0] >> 2) & 0x3f];
	  chout[1] = ch[((chin[0] << 4) & 0x30) | ((chin[1] >> 4) & 0x0f)];
	  chout[2] = ch[((chin[1] << 2) & 0x3c) | ((chin[2] >> 6) & 0x03)];
	  if(j == 3) {
	       chout[3] = ch[chin[2] & 0x3f];
	       g_string_append(out, chout);
	       chout[0] = chout[1] = chout[2] = chout[3] = 0;
	       j = 0;
	  }

     }

     if(j == 1)
	  chout[2] = chout[3] = '=';
     else if(j == 2)
	  chout[3] = '=';
     g_string_append(out, chout);

}


