/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998,1999 Bert Vermeulen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/* maximum number of values for an attribute */
#define MAX_VALS_PER_ATTR    128

#define NO_RESULTS_MSG    "No attributes were returned.\n" \
                          "Did you define an objectclass for this entry?"

/* rebuild_edit_table flags */
#define ADD_NEW_ROW   1
#define MAKE_LINE     2
#define MAKE_TEXTAREA 3

struct attrs {
     char name[128];
     int column;
     struct attrs *next;
};


struct transform_types {
     int num;
     char string[20];
};

void view_entry(struct resultset *set);
void edit_entry_values(struct resultset *set);
void edit_entry_novalues(struct resultset *set);
void edit_entry_table(GtkWidget *target_vbox, struct ldapserver *server,
		      char *dn, int show_values);
GtkWidget *gq_new_arrowbutton(GtkWidget *window);
gboolean keypress_inputbox(GtkWidget *inputbox, GdkEventKey *event, GtkWidget *target_vbox);
GtkWidget *widget_by_coord(GList *children, int x, int y);
void value_from_widget(GtkWidget *inputbox, char **value);
void edit_entry_ok_callback(GtkWidget *table);
void rebuild_edit_table(GtkWidget *table, GtkWidget *button);
