/*****************************************************************************/
/*  cache.c - contains the cache routines                                    */
/*  Copyright (C) 1998-1999 Brian Masney <masneyb@seul.org>                  */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either version 2 of the License, or        */
/*  (at your option) any later version.                                      */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA      */
/*****************************************************************************/

#include "ftp.h"

FILE *new_cache_entry (char *description) {
   char *cachedir, *tempstr, *cachefile, buf[MAXSTR], *pos;
   int found, len;
   FILE *fd;
 
   found = 0;
   cachefile = NULL;
   cachedir = expand_path (BASE_CONF_DIR "/cache");
   if (access (cachedir, F_OK) == -1) mkdir (cachedir, 0x1C0);
   else chmod (cachedir, 0x1C0);
   
   tempstr = g_strdup_printf ("%s/index.db", cachedir);
   if ((fd = fopen (tempstr, "a+")) == NULL) {
      g_free (tempstr);
      g_free (cachedir);
      return (NULL);
   }
   fseek (fd, 0, SEEK_SET);
   g_free (tempstr);

   while (fgets (buf, sizeof (buf), fd)) {
      if (!((pos = strchr (buf, '\t')) != NULL && *(pos + 1) != '\0')) continue;
      len = (pos - buf > strlen (description)) ? pos - buf : strlen (description);
      if (strncmp (buf, description, len) == 0) {
         pos++;
         pos[strlen (pos) - 1] = '\0';
         cachefile = g_malloc (strlen (pos) + 1);
         strcpy (cachefile, pos);
         found = 1;
         break;
      }
   }
   
   if (!found) {         
      srand (time (NULL));
      tempstr = NULL;
      do {
         if (tempstr != NULL) g_free (tempstr);
         cachefile = g_strdup_printf ("cache%ld", 1 + (long) (99999999.0 * rand () / (RAND_MAX + 1.0)));
         tempstr = g_strdup_printf ("%s/%s", cachedir, cachefile);
      } while (access (tempstr, F_OK) != -1);
      g_free (tempstr);

      tempstr = g_strdup_printf ("%s\t%s\n", description, cachefile);
      fseek (fd, 0, SEEK_END);
      fwrite (tempstr, 1, strlen (tempstr), fd);
      g_free (tempstr);
   }
   fclose (fd);
   
   tempstr = g_strdup_printf ("%s/%s", cachedir, cachefile);
   fd = fopen(tempstr, "w+");
   g_free (cachefile);
   g_free (cachedir);
   return (fd);
}
/*****************************************************************************/
FILE *find_cache_entry (char *description) {
   char *cachedir, *tempstr, buf[MAXSTR], *pos;
   FILE *indexfd, *cachefd;
   int len;

   cachedir = expand_path (BASE_CONF_DIR "/cache");
   if (access (cachedir, F_OK) == -1) mkdir (cachedir, 0x1C0);
   
   tempstr = g_strdup_printf ("%s/index.db", cachedir);
   if ((indexfd = fopen (tempstr, "r")) == NULL) {
      g_free (tempstr);
      g_free (cachedir);
      return (NULL);
   }
   g_free (tempstr);

   while (fgets (buf, sizeof (buf), indexfd)) {
      if (!((pos = strchr (buf, '\t')) != NULL && *(pos + 1) != '\0')) continue;
      len = (pos - buf > strlen(description)) ? pos - buf : strlen (description);
      if (strncmp (buf, description, len) == 0) {
         pos++;
         pos[strlen (pos) - 1] = '\0';
         tempstr = g_strdup_printf ("%s/%s", cachedir, pos);
         if ((cachefd = fopen(tempstr, "r")) == NULL) {
            g_free (tempstr);
            return (NULL);
         }
         g_free (tempstr);
         g_free (cachedir);
         fclose (indexfd);
         return (cachefd);
      }
   }
   fclose (indexfd);
   g_free (cachedir);
   return (NULL);
}
/*****************************************************************************/
void clear_cache_files (void) {
   char *cachedir, *tempstr, buf[MAXSTR], *pos;
   FILE *indexfd;

   cachedir = expand_path (BASE_CONF_DIR "/cache");
   if (access (cachedir, F_OK) == -1) mkdir(cachedir, 0x1C0);
   
   tempstr = g_strdup_printf ("%s/index.db", cachedir);
   if ((indexfd = fopen (tempstr, "r")) == NULL) {
      g_free (tempstr);
      g_free (cachedir);
      return;
   }
   unlink (tempstr);

   while (fgets (buf, sizeof (buf), indexfd)) {
      if (!((pos = strchr (buf, '\t')) != NULL && *(pos + 1) != '\0')) continue;
      pos++;
      pos[strlen (pos) - 1] = '\0';
      tempstr = g_strdup_printf ("%s/%s", cachedir, pos);
      unlink (tempstr);
      g_free (tempstr);
   }
   fclose (indexfd);
}
/*****************************************************************************/
void delete_cache_entry (char *description) {
   char *cachedir, *tempstr, *pos, *oldfile, *newfile, buf[MAXSTR];
   FILE *indexfd, *newfd;

   cachedir = expand_path (BASE_CONF_DIR "/cache");
   if (access (cachedir, F_OK) == -1) {
      g_free (cachedir);
      return;
   }
   
   oldfile = g_strdup_printf ("%s/index.db", cachedir);
   if ((indexfd = fopen(oldfile, "r")) == NULL) {
      g_free (oldfile);
      g_free (cachedir);
      return;
   }
   
   newfile = g_strdup_printf ("%s/index.db.new", cachedir);
   if ((newfd = fopen (newfile, "w")) == NULL) {
      g_free (oldfile);
      g_free (newfile);
      g_free (cachedir);
      return;
   }
   while (fgets (buf, sizeof (buf), indexfd)) {
      if (!((pos = strchr (buf, '\t')) != NULL && *(pos + 1) != '\0')) continue;
      *pos = '\0';
      if (strcmp (buf, description) == 0) {
         tempstr = g_strdup_printf ("%s/%s", cachedir, pos + 1);
         unlink (tempstr);
         g_free (tempstr);
      }
      else {
         fwrite (buf, 1, strlen (buf), newfd);
      }
   }
   fclose (indexfd);
   fclose (newfd);
   
   unlink (oldfile);
   rename (newfile, oldfile);
   
   g_free (oldfile);
   g_free (newfile);
   g_free (cachedir);
}
/*****************************************************************************/
