.\" manual page [] for diald 0.99
.\" SH section heading
.\" SS subsection heading
.\" LP paragraph
.\" IP indented paragraph
.\" TP hanging label
.TH DCTRL 1 "DIALD 0.99 - 1999.04.06"
.SH NAME
dctrl \- graphical diald control utility
.SH SYNOPSIS
.B /usr/bin/dctrl
[-title \fI<title>\fR]
[-fifo \fI<fifo-path>\fR]
[-host \fI<host>\fR -port \fI<port>\fR]
[-i] [-animated-icon]
[-c] [-control-window] [-iconic] [standard X options]
.SH DESCRIPTION
.LP
.B Dctrl
is used to issue control commands to a running
.B diald
process,
and to monitor the current status of the link. The
.B diald
process
must have been configured with the "fifo" option in order for
dctrl to work. See the "diald" and "diald-control" manual pages for
further information on the "fifo" option of
.B diald.
The interface presented by
.B dctrl
is very simple, and should be easy to understand.

.SH OPTIONS
.TP
.B -title \fI<title>\fR
Sets the title used for the
.B dctrl
window.

.TP
.B -fifo \fI<fifo-path>\fR
Tell
.B dctrl
where to find the control fifo for the diald process that
you wish to control. By default
.B dctrl
will use /etc/diald/diald.ctl.

.TP
.B -host \fI<host>\fR -port \fI<port>\fR
Tell
.B dctrl
to connect to the given port on the given host using TCP rather than
using a fifo. It is expected that a diald is listening for connections
on the port.

.TP
.B -i
.TP
.B -animated-icon
These options both tell
.B dctrl
to make the icon an animated picture displaying a short synopsis
of the current state of diald.
.TP
.B -c
.TP
.B -control-window
These options both tell
.B dctrl
to construct a window named "dctrlIcon" that appears similar to an icon.
This window can be swallowed by an AfterStep, Bowman or FVWM module.
For example, an AfterStep configuration line to have Wharf swallow dctrl
might look like:

.IP
*Wharf dctrl   nil   Swallow "dctrlIcon" dctrl -iconic -geometry +520+23 -c &

.LP
Note that when this option is selected, iconifying the main
.B dctrl
window simply
unmaps that window, leaving the miniature control icon present.
Pressing button <1> over the control icon will deiconify the main
.B dctrl
window.

.TP
.B -iconic
Tell
.B dctrl
to start up in the iconified state.

.SH SEE ALSO
.LP
fvwm(1), afterstep(1), bowman(1), diald(1),
diald-examples(5), diald-control(5), diald-monitor(5)

.SH AUTHOR
.LP
Eric Schenk (Eric.Schenk@dna.lth.se)

.SH BUGS
This manual page is really much too abreviated. There should be
more discussion about what dctrl will do and how to use it.
