/*
   Copyright (C) 1996, 1997  Ulric Eriksson <ulric@edu.stockholm.se>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the Licence, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.
 */

#ifndef s_TableP_h
#define s_TableP_h

#include "Table.h"
/* include superclass private header file */
#include <X11/CoreP.h>

/* define unique representation types not found in <X11/StringDefs.h> */

#define XtRTableResource "TableResource"

typedef struct {
    int empty;
} TableClassPart;

typedef struct s_TableClassRec {
    CoreClassPart	core_class;
    CompositeClassPart	composite_class;
    TableClassPart	table_class;
} TableClassRec;

extern TableClassRec tableClassRec;

typedef struct {
    /* resources */
	int max_row, max_col;
	int prot_row, prot_col;
	int top_row, top_col;
	int sel_top_row, sel_bottom_row;
	int sel_left_col, sel_right_col;
	int point_row, point_col;
	int default_width, default_height;
	int (*col_width)();
	int (*row_height)();
	int (*type)();
	char *(*text)();
	unsigned long (*format)();
	void (*gc)();
	int (*adj_horiz)();
	int (*adj_vert)();
	Pixel background;
	Pixel foreground;
	Pixel grid;
	Pixel cursor;
	Pixel highlight;
	XtPointer data;
	Boolean redisplay;
	Boolean grid_lines;
	Boolean visible_cursor;
	void (*plugin_coords)(Widget, XtPointer, int *, int *);
	Boolean threeD;
    /* private state */
	unsigned long white, grey, black;
	GC clear_gc;
	GC cell_gc;
	GC grid_gc;
	GC cursor_gc;
	GC block_gc;
} TablePart;

typedef struct s_TableRec {
    CorePart		core;
    CompositePart	composite;
    TablePart	table;
} TableRec;

#endif /* s_TableP_h */
