/* Copyright (C) 1999 Aaron Lehmann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

%{
#include <math.h>  /* For math functions, cos(), sin(), etc. */
#include "mathparsesym.h"  /* Contains definition of `symrec'        */
#include "mathparse.h"
#include <stdlib.h>

int yyparse ();
int yylex ();
int yyerror (char *);
int yyerror_real (char *s);

short parseerr=0;
char errtext[80];
%}
%union {
double     val;  /* For returning numbers.                   */
symrec  *tptr;   /* For returning symbol-table pointers      */
}

%token <val>  NUM             /* Simple double precision number   */
%token <tptr> VAR FNCT CONST  /* Variable and Function            */
%type  <val>  exp

%right '='
%left NEG     /* Negation--unary minus */
%left OPEN    /* Multiplication        */
%nonassoc EXPNUM
%left '-' '+'
%left '*' '/'
%right '^'    /* Exponentiation        */


/* Grammar follows */

%%

input:   /* empty */
        | input line
;

line:
          exp   '\n'  { parseerr = 0;                                     }
        | error '\n'  { if (!parseerr) { yyerror_real ("Syntax error"); } }
;

exp:      NUM                                 { mp_push_num ($1);            }

        | FNCT '(' exp ')' NUM %prec EXPNUM   { mp_push_fnct ($1);
	                                        mp_push_num ($5);
					        mp_push_op (MP_TOKEN_MULT);  }

        | FNCT '(' exp ')' CONST %prec EXPNUM { mp_push_fnct ($1);
	                                        mp_push_const ($5);
						mp_push_op (MP_TOKEN_MULT);  }

        | FNCT '(' exp ')' VAR %prec EXPNUM   { mp_push_fnct ($1);
	                                        mp_push_var (*($5->name),
						$5->value.var);
						mp_push_op (MP_TOKEN_MULT);  }

        | CONST                               { mp_push_const ($1);          }

        | VAR                                 { mp_push_var (*($1->name),
						$1->value.var);              }

        | VAR '=' exp                         { if (!formn)
	                                        { $1->value.var = $3;      } }

        | NUM VAR                             { mp_push_num ($1);
	                                        mp_push_var (*($2->name),
						$2->value.var);
						mp_push_op (MP_TOKEN_MULT);  }

        | CONST VAR                           { mp_push_const ($1);
                                                mp_push_var (*($2->name),
						$2->value.var);
						mp_push_op (MP_TOKEN_MULT);  }

        | VAR CONST                           { mp_push_const ($2);
                                                mp_push_var (*($1->name),
						$1->value.var);
						mp_push_op (MP_TOKEN_MULT);  }

        | NUM CONST                           { mp_push_const ($2);
                                               	mp_push_num ($1);
						mp_push_op (MP_TOKEN_MULT);  }

        | exp '(' exp ')' %prec OPEN          { mp_push_op (MP_TOKEN_MULT);  }

        | '(' exp ')' exp %prec OPEN          { mp_push_op (MP_TOKEN_MULT);  }

        | '(' exp ')' '-' exp %prec OPEN      { mp_push_op (MP_TOKEN_MINUS); }

        | exp '(' exp ')' exp %prec OPEN      { mp_push_op (MP_TOKEN_MULT);
	                                        mp_push_op (MP_TOKEN_MULT);  }

        | FNCT '(' exp ')'                    { mp_push_fnct ($1);           }

        | '-' exp  %prec NEG                  { mp_push_op
						  (MP_TOKEN_UNARY_MINUS);    }

        | exp '+' exp                         { mp_push_op (MP_TOKEN_PLUS);  }

        | exp '-' exp                         { mp_push_op (MP_TOKEN_MINUS); }

        | exp '*' exp                         { mp_push_op (MP_TOKEN_MULT);  }

        | exp '/' exp                         { mp_push_op (MP_TOKEN_DIV);   }

        | exp '^' exp                         { mp_push_op (MP_TOKEN_POW);   }

        | exp '!'                             { mp_push_op (MP_TOKEN_FACT);  }

	| '|' exp '|'                         { mp_push_fnct(getsym("abs")); }

        | '(' exp ')'                         { /* Intentionally empty */    }
;

/* End of grammar */
%%
