/*
 * Adapted from Mini-Commander Applet
 * Copyright (C) 1998 Oliver Maruhn <om@linuxhq.com>
 *
 * Author: Oliver Maruhn <om@linuxhq.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <string.h>

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "gtkplot.h"
#include "gtksheet.h"

#include "app.h"
#include "command_line.h"
#include "history.h"
#include "calc.h"
#include "prefs.h"

static gint historyPopupClicked_cb(GtkWidget *widget, gpointer data);
static gint historyPopupClickedInside_cb(GtkWidget *widget, gpointer data);
static void historySelectionMade_cb(GtkWidget *clist, gint row, gint column,
				    GdkEventButton *event, gpointer data);


#define MAX_COMMAND_LENGTH 255


GtkWidget *entryCommand;
int historyPosition = HISTORY_DEPTH-1;


gint
commandKey_event(GtkWidget *widget, GdkEventKey *event, gpointer data)
{
    guint key = event->keyval;
    int propagateEvent = TRUE;
    
    
    if(key == GDK_Up
       || key == GDK_KP_Up
       || key == GDK_ISO_Move_Line_Up
       || key == GDK_Pointer_Up)
    {
	/* up key pressed */
	if(historyPosition > 0 && existsHistoryEntry(historyPosition - 1))
	{
	    gtk_entry_set_text(GTK_ENTRY(widget), (gchar *) getHistoryEntry(--historyPosition));
	}
	propagateEvent = FALSE;
    }
    else if(key == GDK_Down
	    || key == GDK_KP_Down
	    || key == GDK_ISO_Move_Line_Down
	    || key == GDK_Pointer_Down)
    {
	/* down key pressed */
	if(historyPosition <  HISTORY_DEPTH - 1  && existsHistoryEntry(historyPosition + 1))
	{
	    gtk_entry_set_text(GTK_ENTRY(widget), (gchar *) getHistoryEntry(++historyPosition));
	    
	}
	
	else if (historyPosition == HISTORY_DEPTH -1  && prf.calcmode == CALCMODE_CLEAR)
	{
	    gtk_entry_set_text(GTK_ENTRY(widget), "");
	    ++historyPosition;
	}
        propagateEvent = FALSE;
	
    }
    else if(key == GDK_Return
	    || key == GDK_KP_Enter
	    || key == GDK_ISO_Enter
	    || key == GDK_3270_Enter)
    {
	calc_eval (NULL, NULL);
    }
    /*else if (key == GDK_KP_Add
      || key == GDK_KP_Multiply
      || key == GDK_KP_Subtract
      || key == GDK_KP_Divide)*/
    else if (   !strcmp (event->string, "/")
	     || !strcmp (event->string, "*")
	     || !strcmp (event->string, "^")
	     || !strcmp (event->string, "!"))
    {
	calc_key(event->string);
	propagateEvent = FALSE;
    }
    if(propagateEvent == FALSE)
    {
	/* I have to do this to stop gtk from propagating this event;
	   error in gtk? */
	event->keyval = GDK_Right;
	event->state = 0;
	event->length = 0;  
    }
    return (propagateEvent == FALSE);
}


/* no longer needed */
static void
historySelectionMade_cb(GtkWidget *clist, gint row, gint column,
			GdkEventButton *event, gpointer data)
{
    gchar *command;
    extern GtkWidget *eqnentry;
    
    gtk_clist_get_text(GTK_CLIST(clist), row, column, &command);
    gtk_entry_set_text(GTK_ENTRY(eqnentry), command);
    
    /* close history window */
    gtk_widget_destroy(GTK_WIDGET(clist->parent->parent->parent));
}

static gint
historyPopupClicked_cb(GtkWidget *widget, gpointer data)
{
    gdk_pointer_ungrab(GDK_CURRENT_TIME);
    gtk_grab_remove(GTK_WIDGET(widget));
    gtk_widget_destroy(GTK_WIDGET(widget));
    widget = NULL;
     
    /* go on */
    return (FALSE);
}

static gint
historyPopupClickedInside_cb(GtkWidget *widget, gpointer data)
{
    /* eat signal (prevent that popup will be destroyed) */
    return(TRUE);
}

gint 
showHistory_signal(GtkWidget *widget, gpointer data)
{
    GtkWidget *window;
    GtkWidget *frame;
    GtkWidget *scrolled_window;
    GtkWidget *clist;
    gchar *commandList[1];
    int i, j;
    
    /* count commands stored in history list */
    for(i = 0, j = 0; i < HISTORY_DEPTH; i++)
	if(existsHistoryEntry(i))
	    j++;
    
    if(j == 0)
    {
	
	/* don't show history popup window; go on */
	return FALSE;  	     
    }
    
    window = gtk_window_new(GTK_WINDOW_POPUP); 
    gtk_window_set_policy(GTK_WINDOW(window), 0, 0, 1);
    /* cb */
    gtk_signal_connect_after(GTK_OBJECT(window),
			     "button_press_event",
			     GTK_SIGNAL_FUNC(historyPopupClicked_cb),
			     NULL);
    /* position */
    gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_MOUSE);
    /* size */
    gtk_widget_set_usize(GTK_WIDGET(window), 200, 350);
    /* title */
    gtk_window_set_title(GTK_WINDOW(window), (gchar *) _("Command history"));
    gtk_widget_show(window);
    
    /* frame */
    frame = gtk_frame_new(NULL);
    gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_OUT);
    gtk_widget_show(frame);
    gtk_container_add(GTK_CONTAINER(window), frame);
    
    /* scrollbars */
    /* create scrolled window to put the GtkList widget inside */
    scrolled_window=gtk_scrolled_window_new(NULL, NULL);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window),
				    GTK_POLICY_AUTOMATIC,
				   GTK_POLICY_AUTOMATIC);
    gtk_signal_connect(GTK_OBJECT(scrolled_window),
		       "button_press_event",
		       GTK_SIGNAL_FUNC(historyPopupClickedInside_cb),
		       NULL);
    gtk_container_add(GTK_CONTAINER(frame), scrolled_window);
    gtk_container_set_border_width (GTK_CONTAINER(scrolled_window), 2);
    gtk_widget_show(scrolled_window);
    
    
    /* the history list */
    /* style 
       style = malloc(sizeof(GtkStyle));
       style = gtk_style_copy(gtk_widget_get_style(GTK_WIDGET(applet)));
       
       style->fg[GTK_STATE_NORMAL].red = (gushort) prop.cmdLineColorFgR;
       style->fg[GTK_STATE_NORMAL].green = (gushort) prop.cmdLineColorFgG;
       style->fg[GTK_STATE_NORMAL].blue = (gushort) prop.cmdLineColorFgB;
       
       style->base[GTK_STATE_NORMAL].red = (gushort) prop.cmdLineColorBgR;
       style->base[GTK_STATE_NORMAL].green = (gushort) prop.cmdLineColorBgG;
       style->base[GTK_STATE_NORMAL].blue = (gushort) prop.cmdLineColorBgB;
       
       gtk_widget_push_style (style);
    */
    clist = gtk_clist_new(1);
    /*      gtk_widget_pop_style (); */
    gtk_signal_connect(GTK_OBJECT(clist),
		       "select_row",
		       GTK_SIGNAL_FUNC(historySelectionMade_cb),
		       NULL);
    
    
    /* add history entries to list */
    for(i = 0; i < HISTORY_DEPTH; i++)
    {
	if(existsHistoryEntry(i))
	{
	    commandList[0] = getHistoryEntry(i);
	    gtk_clist_append(GTK_CLIST(clist), commandList);
	}
    }
    gtk_container_add(GTK_CONTAINER(scrolled_window), clist);
    gtk_widget_show(clist);    
    
    /* grab focus */
    gdk_pointer_grab (window->window,
		      TRUE,
		      GDK_BUTTON_PRESS_MASK
		      | GDK_BUTTON_RELEASE_MASK
		      | GDK_ENTER_NOTIFY_MASK
		      | GDK_LEAVE_NOTIFY_MASK 
		      | GDK_POINTER_MOTION_MASK,
		      NULL,
		      NULL,
		      GDK_CURRENT_TIME); 
    gtk_grab_add(window);
    
    
    /* go on */
    return FALSE;  
}
