/*
 *  Dr Geo an interactive geometry software
 * (C) Copyright Hilaire Fernandes  1997-1999
 * hilaire.fernandes@iname.com 
 * 
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef vecteur_h
#define vecteur_h

#include <string.h>
#include <libintl.h>
#include <math.h>

#include "classbase.h"
#include "complexe.h"
#include "mode_obj.h"
#include "graphic.h"
#include "traite.h"

class vecteur1:public vecteur_c
{
  public:
  point_c * M2;
  vecteur1 (void):vecteur_c ()
  {
    classe = VE_2PT;
  }
  vecteur1 (liste_elem & lp):vecteur_c ()
  {
    classe = VE_2PT;
    M1 = (point_c *) lp.lire (1);
    M2 = (point_c *) lp.lire (2);
    init_nom ();
  }
  vecteur1 (char a, char b, char c, char d, liste_elem & lp):vecteur_c (a, b, c, d)
  {
    classe = VE_2PT;
    M1 = (point_c *) lp.lire (1);
    M2 = (point_c *) lp.lire (2);
    init_nom ();
  }
  void init_nom (void);
  vecteur_s vecteur ();
  void actualise (void);
  liste_elem *parents (liste_elem * liste_parent);
  void move (int xm, int ym);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
  droite_s coordonnees (void);
};

// Transformed vector
// By relfexion
class reflexion_vecteur:public vecteur_c
{
  public:
  droite_c * axe;
  vecteur_c *vect;
    reflexion_vecteur ():vecteur_c ()
  {
    classe = VE_RE;
  }
  reflexion_vecteur (liste_elem & lp):vecteur_c ()
  {
    figure_c *f1, *f2;
    f1 = (figure_c *) lp.lire (1);
    f2 = (figure_c *) lp.lire (2);
    if (f1->type == FIG_DROITE)
      {
	vect = (vecteur_c *) f2;
	axe = (droite_c *) f1;
      }
    else
      {
	vect = (vecteur_c *) f1;
	axe = (droite_c *) f2;
      }
    actualise ();
    classe = VE_RE;
    init_nom ();
  }
  droite_s coordonnees (void);
  void actualise (void);
  vecteur_s normal (void);
  vecteur_s directeur (void);
  vecteur_s vecteur (void);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
// By translation
class translation_vecteur:public vecteur_c
{
  public:
  vecteur_c * v_img, *v;
  translation_vecteur ():vecteur_c ()
  {
    classe = VE_TR;
  }
  translation_vecteur (liste_elem & lp):vecteur_c ()
  {
    v_img = (vecteur_c *) lp.lire (2);
    v = (vecteur_c *) lp.lire (1);
    actualise ();
    classe = VE_TR;
    init_nom ();
  }
  droite_s coordonnees (void);
  void actualise (void);
  vecteur_s normal (void);
  vecteur_s directeur (void);
  vecteur_s vecteur (void);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
// By rotation
class rotation_vecteur:public vecteur_c
{
  public:
  point_c * c;
  valeur_c *v;
  vecteur_c *v_img;
    rotation_vecteur ():vecteur_c ()
  {
    classe = VE_RO;
  }
  rotation_vecteur (liste_elem & lp):vecteur_c ()
  {
    figure_c *f1, *f2, *f3;
    f1 = (figure_c *) lp.lire (1);
    f2 = (figure_c *) lp.lire (2);
    f3 = (figure_c *) lp.lire (3);
    if (f1->type == FIG_POINT)
      {
	c = (point_c *) f1;
	if (f2->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f2;
	    v_img = (vecteur_c *) f3;
	  }
	else
	  {
	    v = (valeur_c *) f3;
	    v_img = (vecteur_c *) f2;
	  }
      }
    else if (f2->type == FIG_POINT)
      {
	c = (point_c *) f2;
	if (f1->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f1;
	    v_img = (vecteur_c *) f3;
	  }
	else
	  {
	    v = (valeur_c *) f3;
	    v_img = (vecteur_c *) f1;
	  }
      }
    else
      {
	c = (point_c *) f3;
	if (f1->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f1;
	    v_img = (vecteur_c *) f2;
	  }
	else
	  {
	    v = (valeur_c *) f2;
	    v_img = (vecteur_c *) f1;
	  }
      }
    actualise ();
    classe = VE_RO;
    init_nom ();
  }
  droite_s coordonnees (void);
  void actualise (void);
  vecteur_s normal (void);
  vecteur_s directeur (void);
  vecteur_s vecteur (void);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
// By homothetie
class homothetie_vecteur:public vecteur_c
{
  public:
  point_c * c;
  valeur_c *v;
  vecteur_c *v_img;
    homothetie_vecteur ():vecteur_c ()
  {
    classe = VE_HO;
  }
  homothetie_vecteur (liste_elem & lp):vecteur_c ()
  {
    figure_c *f1, *f2, *f3;
    f1 = (figure_c *) lp.lire (1);
    f2 = (figure_c *) lp.lire (2);
    f3 = (figure_c *) lp.lire (3);
    if (f1->type == FIG_POINT)
      {
	c = (point_c *) f1;
	if (f2->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f2;
	    v_img = (vecteur_c *) f3;
	  }
	else
	  {
	    v = (valeur_c *) f3;
	    v_img = (vecteur_c *) f2;
	  }
      }
    else if (f2->type == FIG_POINT)
      {
	c = (point_c *) f2;
	if (f1->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f1;
	    v_img = (vecteur_c *) f3;
	  }
	else
	  {
	    v = (valeur_c *) f3;
	    v_img = (vecteur_c *) f1;
	  }
      }
    else
      {
	c = (point_c *) f3;
	if (f1->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f1;
	    v_img = (vecteur_c *) f2;
	  }
	else
	  {
	    v = (valeur_c *) f2;
	    v_img = (vecteur_c *) f1;
	  }
      }
    actualise ();
    classe = VE_HO;
    init_nom ();
  }
  droite_s coordonnees (void);
  void actualise (void);
  vecteur_s normal (void);
  vecteur_s directeur (void);
  vecteur_s vecteur (void);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};


#endif
