/*
 *  Dr Geo an interactive geometry software
 * (C) Copyright Hilaire Fernandes  1997-1999
 * hilaire.fernandes@iname.com 
 * 
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef valeur_h
#define valeur_h

#include <string.h>
#include <libintl.h>
#include <math.h>

#include "classbase.h"
#include "complexe.h"
#include "mode_obj.h"
#include "graphic.h"
#include "traite.h"

// Class derived from the base class valeur_c
// Segment length
class longueur_segment:public valeur_c
{
  public:
  segment_c * parent;
  longueur_segment (void):valeur_c ()
  {
    classe = VA_LO_SE;
  }
  longueur_segment (liste_elem & lp, double mx, double my):valeur_c (mx, my)
  {
    classe = VA_LO_SE;
    parent = (segment_c *) lp.lire (1);
    init_nom ();
  }
longueur_segment (liste_elem & lp):valeur_c ()
  {
    classe = VA_LO_SE;
    parent = (segment_c *) lp.lire (1);
    init_nom ();
  }
  virtual void init_nom (void);
  void actualise (void);
  liste_elem *parents (liste_elem * liste_parent);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
// Vector's length
class norme_vecteur:public longueur_segment
{
  public:
  norme_vecteur (void):longueur_segment ()
  {
    classe = VA_NO_VE;
  }
  norme_vecteur (liste_elem & lp, double mx, double my):longueur_segment (lp, mx, my)
  {
    classe = VA_NO_VE;
    init_nom ();
  }
norme_vecteur (liste_elem & lp):longueur_segment (lp)
  {
    classe = VA_NO_VE;
    init_nom ();
  }
  virtual void init_nom (void);
};
// distance between two points
class distance_pt_pt:public valeur_c
{
  public:
  point_c * parent1, *parent2;
  distance_pt_pt (void):valeur_c ()
  {
    classe = VA_DI_PT_PT;
  }
  distance_pt_pt (liste_elem & lp, double mx, double my):valeur_c (mx, my)
  {
    classe = VA_DI_PT_PT;
    parent1 = (point_c *) lp.lire (1);
    parent2 = (point_c *) lp.lire (2);
    init_nom ();
  }
distance_pt_pt (liste_elem & lp):valeur_c ()
  {
    classe = VA_DI_PT_PT;
    parent1 = (point_c *) lp.lire (1);
    parent2 = (point_c *) lp.lire (2);
    init_nom ();
  }
  virtual void init_nom (void);
  void actualise (void);
  liste_elem *parents (liste_elem * liste_parent);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
//
class distance_point_cercle:public valeur_c
{
  public:
  point_c * pt;
  cercle_c *c;
    distance_point_cercle (void):valeur_c ()
  {
    classe = VA_DI_PT_CE;
  }
  distance_point_cercle (liste_elem & lp, double mx, double my):valeur_c (mx, my)
  {
    figure_c *obj1, *obj2;
    obj1 = (figure_c *) lp.lire (1);
    obj2 = (figure_c *) lp.lire (2);
    classe = VA_DI_PT_CE;
    if (obj1->type == FIG_CERCLE)
      {
	c = (cercle_c *) obj1;
	pt = (point_c *) obj2;
      }
    else
      {
	c = (cercle_c *) obj2;
	pt = (point_c *) obj1;
      }
    init_nom ();
  }
distance_point_cercle (liste_elem & lp):valeur_c ()
  {
    figure_c *obj1, *obj2;
    obj1 = (figure_c *) lp.lire (1);
    obj2 = (figure_c *) lp.lire (2);
    classe = VA_DI_PT_CE;
    if (obj1->type == FIG_CERCLE)
      {
	c = (cercle_c *) obj1;
	pt = (point_c *) obj2;
      }
    else
      {
	c = (cercle_c *) obj2;
	pt = (point_c *) obj1;
      }
    init_nom ();
  }
  virtual void init_nom (void);
  void actualise (void);
  liste_elem *parents (liste_elem * liste_parent);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
//
class distance_point_droite:public valeur_c
{
  public:
  point_c * pt;
  droite_c *d;
    distance_point_droite (void):valeur_c ()
  {
    classe = VA_DI_PT_DR;
  }
  distance_point_droite (liste_elem & lp, double mx, double my):valeur_c (mx, my)
  {
    figure_c *obj1, *obj2;
    obj1 = (figure_c *) lp.lire (1);
    obj2 = (figure_c *) lp.lire (2);
    classe = VA_DI_PT_DR;
    if (obj1->type == FIG_DROITE)
      {
	d = (droite_c *) obj1;
	pt = (point_c *) obj2;
      }
    else
      {
	d = (droite_c *) obj2;
	pt = (point_c *) obj1;
      }
    init_nom ();
  }
distance_point_droite (liste_elem & lp):valeur_c ()
  {
    figure_c *obj1, *obj2;
    obj1 = (figure_c *) lp.lire (1);
    obj2 = (figure_c *) lp.lire (2);
    classe = VA_DI_PT_DR;
    if (obj1->type == FIG_DROITE)
      {
	d = (droite_c *) obj1;
	pt = (point_c *) obj2;
      }
    else
      {
	d = (droite_c *) obj2;
	pt = (point_c *) obj1;
      }
    init_nom ();
  }
  virtual void init_nom (void);
  void actualise (void);
  liste_elem *parents (liste_elem * liste_parent);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
//
class perimetre_cercle:public valeur_c
{
  public:
  cercle_c * c;
  perimetre_cercle (void):valeur_c ()
  {
    classe = VA_PE_CE;
  }
  perimetre_cercle (liste_elem & lp, double mx, double my):valeur_c (mx, my)
  {
    classe = VA_PE_CE;
    c = (cercle_c *) lp.lire (1);
    init_nom ();
  }
perimetre_cercle (liste_elem & lp):valeur_c ()
  {
    classe = VA_PE_CE;
    c = (cercle_c *) lp.lire (1);
    init_nom ();
  }
  virtual void init_nom (void);
  void actualise (void);
  liste_elem *parents (liste_elem * liste_parent);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
// Free value, the user can edit it
class valeur_libre:public valeur_c
{
  public:
  valeur_libre (void):valeur_c ()
  {
    classe = VA_LI;
  }
  valeur_libre (liste_elem & lp, double mx, double my):valeur_c (mx, my)
  {
    val = *((double *) lp.lire (1));
    classe = VA_LI;
    init_nom ();
  }
valeur_libre (liste_elem & lp):valeur_c ()
  {
    val = *((double *) lp.lire (1));
    classe = VA_LI;
    init_nom ();
  }
  // virtual void init_nom(void);
  void actualise (void)
  {
  };
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig)
  {
    return false;
  };
};
// Line slope
class pente_droite:public valeur_c
{
  public:
  droite_c * d;
  pente_droite (void):valeur_c ()
  {
    classe = VA_PE_DR;
  }
  pente_droite (liste_elem & lp, double mx, double my):valeur_c (mx, my)
  {
    classe = VA_PE_DR;
    d = (droite_c *) lp.lire (1);
    init_nom ();
  }
pente_droite (liste_elem & lp):valeur_c ()
  {
    classe = VA_PE_DR;
    d = (droite_c *) lp.lire (1);
    init_nom ();
  }
  void actualise (void);
  virtual void init_nom (void);
  liste_elem *parents (liste_elem * liste_parent);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};



#endif
