


/*
 *  Dr Geo an interactive geometry software
 * (C) Copyright Hilaire Fernandes  1997-1998
 * hilaire.fernandes@iname.com 
 * 
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <libintl.h>

/* Gnome XML header
   #include <tree.h>
   #include <parser.h>
 */
#include "geoclass.h"
#include "var_decl.h"
#include "gui.h"
#include "main.h"
#include "tree.h"

GdkColor tab_couleur[DRGEO_NUMBER_COLOR];


double ECHELLE, ORIGIN_W, ORIGIN_H, MON_L, MON_R, MON_T, MON_B;

extern GdkPixmap *current_screen;
extern GtkWidget *figure_drawing_area, *main_window, *dialog_style, *erase_dialog,
 *macroname_dialog, *macroname_entry, *value_dialog, *value_entry;
extern GdkGC *figure_gc, *font_gc, *object_gc;
extern creer_point_c creer_point;
extern creer_point_milieu_c creer_point_milieu;
extern creer_point_inter_c creer_point_inter;
extern creer_point_repere_c creer_point_repere;
extern creer_droite_c creer_droite;
extern creer_demi_droite_c creer_demi_droite;
extern creer_segment_c creer_segment;
extern creer_demi_droite_c creer_vecteur;
extern creer_cercle_c creer_cercle;
extern creer_arc_cercle_c creer_arc_cercle;
extern creer_lieu_point_c creer_lieu_point;
extern creer_droite_parallele_c creer_droite_parallele;
extern creer_droite_orthogonale_c creer_droite_orthogonale;
extern creer_reflexion_c creer_reflexion;
extern creer_symetrie_c creer_symetrie;
extern creer_translation_c creer_translation;
extern creer_rotation_c creer_rotation;
extern creer_homothetie_c creer_homothetie;
extern creer_numerique_c creer_numerique;
extern creer_angle_c creer_angle;
extern creer_coordonnees_c creer_coordonnees;
extern int mode;

char erasing = FALSE;
char drgeoversion[] = "0.8.0";
static figure_c *erase_object;
gint tag_clignote;

// Mode de stockage des adresses des objets geometriques
// liste d'historique de creation des objets
// liste des objets libres dans un sous-espace
// the geometric objects are referenced in this lists
// liste_figure : ref. all the object
// liste_figure_libre : only ref. free object (=movable with the mouse) 
liste_elem liste_figure, liste_figure_libre;

// Stockage des macro
liste_elem liste_macro;
// used to execute a macro
macro *selected_macro = NULL;

void
point_libre (int x, int y, figure_c * selected_object)
{
  figure_c *new_fig;
  char cas;
  // Creation d'un point libre
  if (!trouve)
    {
      new_fig = new point2 (MONx (x), MONy (y), ROUGE, FALSE, 1, ROND);
      liste_figure.ajoute ((void *) new_fig);
      liste_figure_libre.ajoute ((void *) new_fig);

      ((point2 *) new_fig)->dessine (current_screen, FALSE);
      swap ();
    }
  else
    {
      cas = creer_point.inserer_figure (selection, selected_object);
      if (cas != -1)
	{
	  switch (cas)
	    {
	    case 0:
	      new_fig = new point_sur_droite (MONx (x), MONy (y), selection, ROUGE, FALSE, 1, ROND);
	      liste_figure.ajoute ((void *) new_fig);
	      liste_figure_libre.ajoute ((void *) new_fig);
	      ((point_sur_droite *) new_fig)->dessine (current_screen, FALSE);
	      swap ();
	      break;
	    case 1:
	      new_fig = new point_sur_demi_droite (MONx (x), MONy (y), selection, ROUGE, FALSE, 1, ROND);
	      liste_figure.ajoute ((void *) new_fig);
	      liste_figure_libre.ajoute ((void *) new_fig);
	      ((point_sur_demi_droite *) new_fig)->dessine (current_screen, FALSE);
	      swap ();
	      break;
	    case 2:
	      new_fig = new point_sur_segment (MONx (x), MONy (y), selection, ROUGE, FALSE, 1, CROIX);
	      liste_figure.ajoute ((void *) new_fig);
	      liste_figure_libre.ajoute ((void *) new_fig);
	      ((point_sur_segment *) new_fig)->dessine (current_screen, FALSE);
	      swap ();
	      break;
	    case 3:
	      // Verifier si rayon<>0
	      if (((cercle_c *) selection.lire (1))->rayon () == 0)
		break;
	      new_fig = new point_sur_cercle (MONx (x), MONy (y), selection, ROUGE, FALSE, 1, CARRE);
	      liste_figure.ajoute ((void *) new_fig);
	      liste_figure_libre.ajoute ((void *) new_fig);
	      ((point_sur_cercle *) new_fig)->dessine (current_screen, FALSE);
	      swap ();
	      break;
	    case 4:
	      new_fig = new point_sur_lieu (MONx (x), MONy (y), selection);
	      liste_figure.ajoute ((void *) new_fig);
	      liste_figure_libre.ajoute ((void *) new_fig);
	      ((point_sur_lieu *) new_fig)->dessine (current_screen, FALSE);
	      swap ();
	      break;
	    case 5:
	      new_fig = new point_sur_arc_cercle (MONx (x), MONy (y), selection);
	      liste_figure.ajoute ((void *) new_fig);
	      liste_figure_libre.ajoute ((void *) new_fig);
	      new_fig->dessine (current_screen, FALSE);
	      swap ();
	      break;
	    }
	  selection.vide ();
	  creer_point.reset ();
	}
    }
}
void
point_milieu (int x, int y, figure_c * selected_object)
{
  figure_c *new_fig;
  char cas;
  cas = creer_point_milieu.inserer_figure (selection, selected_object);
  if (cas != -1)
    {
      switch (cas)
	{
	case 0:
	  new_fig = new point_milieu_segment (selection, ROUGE, FALSE, 1, CARRE);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((point_milieu_segment *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 1:
	  new_fig = new point_milieu_2points (selection, ROUGE, FALSE, 1, CARRE);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((point_milieu_2points *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	}
      selection.vide ();
      creer_point_milieu.reset ();
    }
}
void
point_inter (int x, int y, figure_c * selected_object)
{
  figure_c *new_fig;
  char cas;
  cas = creer_point_inter.inserer_figure (selection, selected_object);
  if (cas != -1)
    {
      switch (cas)
	{
	case 0:
	  // deux droites
	  new_fig = new point_sur_droite_et_droite (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((point_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 1:
	  // droite et demi-droite
	  new_fig = new point_sur_droite_et_demi_droite (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((point_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 2:
	  // droite et segment
	  new_fig = new point_sur_droite_et_segment (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((point_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 3:
	  // deux demi-droites
	  new_fig = new point_sur_demi_droite_et_demi_droite (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((point_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 4:
	  // demi-droites et segment
	  new_fig = new point_sur_demi_droite_et_segment (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((point_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 5:
	  // deux segments
	  new_fig = new point_sur_segment_et_segment (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((point_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 6:
	  // droite et cercle
	  new_fig = new point_sur_cercle_et_droite (selection, 1);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;		// l'autre point existe deja

	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((point_c *) new_fig)->dessine (current_screen, FALSE);
	  new_fig = new point_sur_cercle_et_droite (selection, -1);
	  liste_figure.ajoute ((void *) new_fig);
	  ((point_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 7:
	  // demi_droite et cercle
	  new_fig = new point_sur_cercle_et_demi_droite (selection, 1);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((point_c *) new_fig)->dessine (current_screen, FALSE);
	  new_fig = new point_sur_cercle_et_demi_droite (selection, -1);
	  liste_figure.ajoute ((void *) new_fig);
	  ((point_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 8:
	  // segment et cercle
	  new_fig = new point_sur_cercle_et_segment (selection, 1);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((point_c *) new_fig)->dessine (current_screen, FALSE);
	  new_fig = new point_sur_cercle_et_segment (selection, -1);
	  liste_figure.ajoute ((void *) new_fig);
	  ((point_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 9:
	  // deux cercles
	  new_fig = new point_sur_cercle_et_cercle (selection, 1);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((point_c *) new_fig)->dessine (current_screen, FALSE);
	  new_fig = new point_sur_cercle_et_cercle (selection, -1);
	  liste_figure.ajoute ((void *) new_fig);
	  ((point_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 10:
	  // arc circle and line
	  new_fig = new point_sur_arc_cercle_et_droite (selection, 1);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  new_fig = new point_sur_arc_cercle_et_droite (selection, -1);
	  liste_figure.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 11:
	  // arc circle and half-line
	  new_fig = new point_sur_arc_cercle_et_demi_droite (selection, 1);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  new_fig = new point_sur_arc_cercle_et_demi_droite (selection, -1);
	  liste_figure.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 12:
	  // arc circle and segment
	  new_fig = new point_sur_arc_cercle_et_segment (selection, 1);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  new_fig = new point_sur_arc_cercle_et_segment (selection, -1);
	  liste_figure.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 13:
	  // arc circle and circle
	  new_fig = new point_sur_arc_cercle_et_cercle (selection, 1);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  new_fig = new point_sur_arc_cercle_et_cercle (selection, -1);
	  liste_figure.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 14:
	  // arc circle and arc circle
	  new_fig = new point_sur_arc_cercle_et_arc_cercle (selection, 1);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  new_fig = new point_sur_arc_cercle_et_arc_cercle (selection, -1);
	  liste_figure.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  swap ();
	  break;
	}
      selection.vide ();
      creer_point_inter.reset ();
    }
}
void
point_repere (int x, int y, figure_c * selected_object)
{
  figure_c *new_fig;
  char cas;
  cas = creer_point_repere.inserer_figure (selection, selected_object);
  if (cas != -1)
    {
      switch (cas)
	{
	case 0:
	  // 
	  new_fig = new point1 (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  swap ();
	  break;
	}
      selection.vide ();
      creer_point_repere.reset ();
    }
}
void
trace_objet (void)
{
}
void
droite (int x, int y, figure_c * selected_object)
{
  figure_c *new_fig;
  char cas;
  cas = creer_droite.inserer_figure (selection, selected_object);
  if (cas != -1)
    {
      switch (cas)
	{
	case 0:
	  // 
	  new_fig = new droite1 (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  liste_figure_libre.ajoute ((void *) new_fig);
	  ((droite_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 1:

	  break;
	case 2:

	  break;
	case 3:

	  break;
	}
      selection.vide ();
      creer_droite.reset ();
    }
}
void
demi_droite (int x, int y, figure_c * selected_object)
{
  figure_c *new_fig;
  char cas;
  cas = creer_demi_droite.inserer_figure (selection, selected_object);
  if (cas == 0)
    {
      new_fig = new demi_droite1 (selection);
      if (fig_existe (new_fig))
	delete (new_fig);
      else
	{
	  liste_figure.ajoute ((void *) new_fig);
	  liste_figure_libre.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  swap ();
	}
      selection.vide ();
      creer_demi_droite.reset ();
    }
}
void
segment (int x, int y, figure_c * selected_object)
{
  figure_c *new_fig;
  char cas;
  cas = creer_segment.inserer_figure (selection, selected_object);
  if (cas == 0)
    {
      new_fig = new segment1 (selection);
      if (fig_existe (new_fig))
	delete (new_fig);
      else
	{
	  liste_figure.ajoute ((void *) new_fig);
	  liste_figure_libre.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  swap ();
	}
      selection.vide ();
      creer_segment.reset ();
    }
}
void
vecteur (int x, int y, figure_c * selected_object)
{
  figure_c *new_fig;
  char cas;
  cas = creer_vecteur.inserer_figure (selection, selected_object);
  if (cas == 0)
    {
      new_fig = new vecteur1 (selection);
      if (fig_existe (new_fig))
	delete (new_fig);
      else
	{
	  liste_figure.ajoute ((void *) new_fig);
	  liste_figure_libre.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  swap ();
	}
      selection.vide ();
      creer_vecteur.reset ();
    }
}
void
cercle (int x, int y, figure_c * selected_object)
{
  figure_c *new_fig;
  char cas;
  cas = creer_cercle.inserer_figure (selection, selected_object);
  if (cas != -1)
    {
      switch (cas)
	{
	case 0:
	  new_fig = new cercle1 (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  liste_figure_libre.ajoute ((void *) new_fig);
	  ((cercle1 *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 1:
	  new_fig = new cercle2 (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  liste_figure_libre.ajoute ((void *) new_fig);
	  ((cercle2 *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 2:
	  new_fig = new cercle3 (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  liste_figure_libre.ajoute ((void *) new_fig);
	  ((cercle2 *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	}
      selection.vide ();
      creer_cercle.reset ();
    }
}
void
arc_cercle (int x, int y, figure_c * selected_object)
{
  figure_c *new_fig;
  char cas;
  cas = creer_arc_cercle.inserer_figure (selection, selected_object);
  if (cas == 0)
    {
      new_fig = new arc_cercle1 (selection);
      if (fig_existe (new_fig))
	delete (new_fig);
      else
	{
	  liste_figure.ajoute ((void *) new_fig);
	  liste_figure_libre.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  swap ();
	}
      selection.vide ();
      creer_arc_cercle.reset ();
    }
}
void
lieu_objet (int x, int y, figure_c * selected_object)
{
  figure_c *new_fig;
  char cas;
  cas = creer_lieu_point.inserer_figure (selection, selected_object);
  if (cas != -1)
    {
      if (cas >= 0 && cas < 17)
	{
	  new_fig = new lieu_point_mobile_sur_droite (selection);
	  if (fig_existe (new_fig))
	    delete (new_fig);
	  else
	    {
	      liste_figure.ajoute ((void *) new_fig);
	      ((lieu_point_mobile_sur_droite *) new_fig)->dessine (current_screen, FALSE);
	      swap ();
	    }
	}
      else if (cas >= 17 & cas < 34)
	{
	  new_fig = new lieu_point_mobile_sur_demi_droite (selection);
	  if (fig_existe (new_fig))
	    delete (new_fig);
	  else
	    {
	      liste_figure.ajoute ((void *) new_fig);
	      ((lieu_point_mobile_sur_demi_droite *) new_fig)->dessine (current_screen, FALSE);
	      swap ();
	    }
	}
      else if (cas >= 34 & cas < 51)
	{
	  new_fig = new lieu_point_mobile_sur_segment (selection);
	  if (fig_existe (new_fig))
	    delete (new_fig);
	  else
	    {
	      liste_figure.ajoute ((void *) new_fig);
	      ((lieu_point_mobile_sur_segment *) new_fig)->dessine (current_screen, FALSE);
	      swap ();
	    }
	}
      else if (cas >= 51 & cas < 68)
	{
	  new_fig = new lieu_point_mobile_sur_cercle (selection);
	  if (fig_existe (new_fig))
	    delete (new_fig);
	  else
	    {
	      liste_figure.ajoute ((void *) new_fig);
	      ((lieu_point_mobile_sur_cercle *) new_fig)->dessine (current_screen, FALSE);
	      swap ();
	    }
	}
      else if (cas >= 68 & cas < 85)
	{
	  new_fig = new lieu_point_mobile_sur_lieu_point (selection);
	  if (fig_existe (new_fig))
	    delete (new_fig);
	  else
	    {
	      liste_figure.ajoute ((void *) new_fig);
	      ((lieu_point_mobile_sur_lieu_point *) new_fig)->dessine (current_screen, FALSE);
	      swap ();
	    }
	}
      selection.vide ();
      creer_lieu_point.reset ();
    }
}

void
droite_parallele (int x, int y, figure_c * selected_object)
{
  figure_c *new_fig;
  char cas;
  cas = creer_droite_parallele.inserer_figure (selection, selected_object);
  if (cas != -1)
    {
      if (cas >= 0 && cas <= 3)
	{
	  // un point et une droite/demi_droite/segment/vecteur
	  new_fig = new droite_parallele1 (selection);
	  if (fig_existe (new_fig))
	    delete (new_fig);
	  else
	    {
	      liste_figure.ajoute ((void *) new_fig);
	      liste_figure_libre.ajoute ((void *) new_fig);
	      ((droite_c *) new_fig)->dessine (current_screen, FALSE);
	      swap ();
	    }
	}
      else
	{
	  // trois points
	  new_fig = new droite_parallele2 (selection);
	  if (fig_existe (new_fig))
	    delete (new_fig);
	  else
	    {
	      liste_figure.ajoute ((void *) new_fig);
	      liste_figure_libre.ajoute ((void *) new_fig);
	      ((droite_c *) new_fig)->dessine (current_screen, FALSE);
	      swap ();
	    }
	}
      selection.vide ();
      creer_droite_parallele.reset ();
    }
}
void
droite_orthogonale (int x, int y, figure_c * selected_object)
{
  figure_c *new_fig;
  char cas;
  cas = creer_droite_orthogonale.inserer_figure (selection, selected_object);
  if (cas != -1)
    {
      if (cas >= 0 && cas <= 3)
	{
	  // un point et une droite/demi_droite/segment/vecteur
	  new_fig = new droite_orthogonale1 (selection);
	  if (fig_existe (new_fig))
	    delete (new_fig);
	  else
	    {
	      liste_figure.ajoute ((void *) new_fig);
	      liste_figure_libre.ajoute ((void *) new_fig);
	      ((droite_c *) new_fig)->dessine (current_screen, FALSE);
	      swap ();
	    }
	}
      else
	{
	  // trois points
	  new_fig = new droite_orthogonale2 (selection);
	  if (fig_existe (new_fig))
	    delete (new_fig);
	  else
	    {
	      liste_figure.ajoute ((void *) new_fig);
	      liste_figure_libre.ajoute ((void *) new_fig);
	      ((droite_c *) new_fig)->dessine (current_screen, FALSE);
	      swap ();
	    }
	}
      selection.vide ();
      creer_droite_orthogonale.reset ();
    }
}
void
reflexion (int x, int y, figure_c * selected_object)
{
  figure_c *new_fig;
  char cas;
  cas = creer_reflexion.inserer_figure (selection, selected_object);
  if (cas != -1)
    {
      switch (cas)
	{
	case 0:
	  // un point
	  new_fig = new reflexion_point (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((point_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 1:
	  // droite
	  new_fig = new reflexion_droite (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((droite_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 2:
	  // demi-droite
	  new_fig = new reflexion_demi_droite (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((demi_droite_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 3:
	  // segment
	  new_fig = new reflexion_segment (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((segment_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 4:
	  // vecteur
	  new_fig = new reflexion_vecteur (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((vecteur_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 5:
	  // cercle
	  new_fig = new reflexion_cercle (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((cercle_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 6:
	  // arc cercle
	  new_fig = new reflexion_arc_cercle (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  swap ();
	  break;
	}
      selection.vide ();
      creer_reflexion.reset ();
    }
}
void
symetrie (int x, int y, figure_c * selected_object)
{
  figure_c *new_fig;
  char cas;
  cas = creer_symetrie.inserer_figure (selection, selected_object);
  if (cas != -1)
    {
      switch (cas)
	{
	case 0:
	  // un point
	  new_fig = new symetrie_point (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((point_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 1:
	  // droite
	  new_fig = new symetrie_droite (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((droite_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 2:
	  // demi-droite
	  new_fig = new symetrie_demi_droite (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((demi_droite_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 3:
	  // segment
	  new_fig = new symetrie_segment (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((segment_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 4:
	  // cercle
	  new_fig = new symetrie_cercle (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((cercle_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 5:
	  // arc cercle
	  new_fig = new symetrie_arc_cercle (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  swap ();
	  break;
	}
      selection.vide ();
      creer_symetrie.reset ();
    }
}
void
translation (int x, int y, figure_c * selected_object)
{
  figure_c *new_fig;
  char cas;
  cas = creer_translation.inserer_figure (selection, selected_object);
  if (cas != -1)
    {
      switch (cas)
	{
	case 0:
	  // un point
	  new_fig = new translation_point (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((point_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 1:
	  // droite
	  new_fig = new translation_droite (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((droite_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 2:
	  // demi-droite
	  new_fig = new translation_demi_droite (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((demi_droite_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 3:
	  // segment
	  new_fig = new translation_segment (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((segment_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 4:
	  // vecteur
	  new_fig = new translation_vecteur (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((vecteur_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 5:
	  // cercle
	  new_fig = new translation_cercle (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((cercle_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 6:
	  // arc cercle
	  new_fig = new translation_arc_cercle (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  swap ();
	  break;
	}
      selection.vide ();
      creer_translation.reset ();
    }
}
void
rotation (int x, int y, figure_c * selected_object)
{
  figure_c *new_fig;
  char cas;
  cas = creer_rotation.inserer_figure (selection, selected_object);
  if (cas != -1)
    {
      switch (cas)
	{
	case 0:
	  // un point
	  new_fig = new rotation_point (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((point_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 1:
	  // droite
	  new_fig = new rotation_droite (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((droite_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 2:
	  // demi-droite
	  new_fig = new rotation_demi_droite (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((demi_droite_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 3:
	  // segment
	  new_fig = new rotation_segment (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((segment_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 4:
	  // vecteur
	  new_fig = new rotation_vecteur (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((vecteur_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 5:
	  // cercle
	  new_fig = new rotation_cercle (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((cercle_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 6:
	  // arc cercle
	  new_fig = new rotation_arc_cercle (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  swap ();
	  break;
	}
      selection.vide ();
      creer_rotation.reset ();
    }
}
void
homothetie (int x, int y, figure_c * selected_object)
{
  figure_c *new_fig;
  char cas;
  cas = creer_homothetie.inserer_figure (selection, selected_object);
  if (cas != -1)
    {
      switch (cas)
	{
	case 0:
	  // un point
	  new_fig = new homothetie_point (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((point_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 1:
	  // droite
	  new_fig = new homothetie_droite (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((droite_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 2:
	  // demi-droite
	  new_fig = new homothetie_demi_droite (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((demi_droite_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 3:
	  // segment
	  new_fig = new homothetie_segment (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((segment_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 4:
	  // vecteur
	  new_fig = new homothetie_vecteur (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((vecteur_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 5:
	  // cercle
	  new_fig = new homothetie_cercle (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  ((cercle_c *) new_fig)->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 6:
	  // arc cercle
	  new_fig = new homothetie_arc_cercle (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  swap ();
	  break;
	}
      selection.vide ();
      creer_homothetie.reset ();
    }
}
void
numerique (int x, int y, figure_c * selected_object)
{
  figure_c *new_fig;
  char cas;

  if (!trouve)
    {
      mx = x;
      my = y;
      gtk_entry_set_text (GTK_ENTRY (value_entry), "");
      gtk_widget_show (value_dialog);	/* modal widget */
      return;
    }
  cas = creer_numerique.inserer_figure (selection, selected_object);
  if (cas != -1)
    {
      switch (cas)
	{
	case 0:
	  // longueur d'un segment
	  new_fig = new longueur_segment (selection, MONx (x), MONy (y));
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  liste_figure_libre.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 1:
	  // norme d'un vecteur
	  new_fig = new norme_vecteur (selection, MONx (x), MONy (y));
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  liste_figure_libre.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 2:
	  // distance point-point
	  new_fig = new distance_pt_pt (selection, MONx (x), MONy (y));
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  liste_figure_libre.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 3:
	  // distance point-cercle
	  new_fig = new distance_point_cercle (selection, MONx (x), MONy (y));
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  liste_figure_libre.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 4:
	  // distance point-droite
	  new_fig = new distance_point_droite (selection, MONx (x), MONy (y));
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  liste_figure_libre.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 5:
	  // perimetre d'un cercle
	  new_fig = new perimetre_cercle (selection, MONx (x), MONy (y));
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  liste_figure_libre.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 6:
	  // pente d'une droite
	  new_fig = new pente_droite (selection, MONx (x), MONy (y));
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  liste_figure_libre.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  swap ();
	  break;
	}

      selection.vide ();
      creer_numerique.reset ();
    }
}
void
angle (int x, int y, figure_c * selected_object)
{
  figure_c *new_fig;
  char cas;
  cas = creer_angle.inserer_figure (selection, selected_object);
  if (cas != -1)
    {
      switch (cas)
	{
	case 0:
	  // angle forme par trois points
	  new_fig = new angle_3points (selection);
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  liste_figure_libre.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 1:
	  // mesure principale de l'angle de deux vecteurs (plan
	  // oritente ds le sens conventionel)
	  new_fig = new angle_2vecteurs (selection, MONx (x), MONy (y));
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  liste_figure_libre.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  swap ();
	  break;
	}
      selection.vide ();
      creer_angle.reset ();
    }
}
void
coordonnees (int x, int y, figure_c * selected_object)
{
  figure_c *new_fig;
  char cas;
  cas = creer_coordonnees.inserer_figure (selection, selected_object);
  if (cas != -1)
    {
      switch (cas)
	{
	case 0:
	  // coordonnees d'un point
	  // abscisse
	  new_fig = new abscisse_point (selection, MONx (x + 5), MONy (y + 5));
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  liste_figure_libre.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  // ordonnees
	  new_fig = new ordonnee_point (selection, MONx (x + 5), MONy (y + 21));
	  liste_figure.ajoute ((void *) new_fig);
	  liste_figure_libre.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 1:
	  // coordonnees d'un vecteur
	  // abscisse
	  new_fig = new abscisse_vecteur (selection, MONx (x + 4), MONy (y + 12));
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  liste_figure_libre.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  // ordonnees
	  new_fig = new ordonnee_vecteur (selection, MONx (x + 4), MONy (y + 12));
	  liste_figure.ajoute ((void *) new_fig);
	  liste_figure_libre.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 2:
	  // equation reduite d'une droite
	  new_fig = new equation_droite (selection, MONx (x), MONy (y));
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  liste_figure_libre.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  swap ();
	  break;
	case 3:
	  // equaqtion d'un cercle
	  new_fig = new equation_cercle (selection, MONx (x), MONy (y));
	  if (fig_existe (new_fig))
	    {
	      delete (new_fig);
	      break;
	    }
	  liste_figure.ajoute ((void *) new_fig);
	  liste_figure_libre.ajoute ((void *) new_fig);
	  new_fig->dessine (current_screen, FALSE);
	  swap ();
	  break;
	}
      selection.vide ();
      creer_coordonnees.reset ();
    }
}
char
macro_enregistre (figure_c * selected_object, char action)
  // action == 0 : input parameter
  // action == 1 : output parameter
  // action == 2 : validate the macro-construction regarding the input ans output parameteres selected
  // return TRUE  or FALSE when a macro is/isn't valided
{
  switch (action)
    {
    case 0:
      // add an object as an input parameter
      // On verfie si l'objet est deja selectionne
      if (liste_i.position ((void *) selected_object) == 0)
	liste_i.ajoute ((void *) selected_object);
      else
	{
	  liste_i.supprime ((void *) selected_object);
	  // we draw it in its normal style as it was blinking
	  selected_object->dessine (figure_drawing_area->window, FALSE);
	}
      break;
    case 1:
      // add an object as an output parameter
      // On verfie si l'objet est deja selectionne
      if (liste_f.position ((void *) selected_object) == 0)
	liste_f.ajoute ((void *) selected_object);
      else
	{
	  liste_f.supprime ((void *) selected_object);
	  // we draw it in its normal style as it was blinking
	  selected_object->dessine (figure_drawing_area->window, FALSE);
	}
      break;
    case 2:
      {
	macro *M;
	figure_c *fig;
	char nom_mac[MACRO_NAME_WIDTH] = "", valide;
	int nb;

	strcpy (nom_mac, gtk_entry_get_text (GTK_ENTRY (macroname_entry)));
	if (strlen (nom_mac) == 0)
	  strcpy (nom_mac, _ ("No name"));

	// macro valide on l'enregistre
	M = new macro (liste_i.nb_elem, liste_f.nb_elem, nom_mac);
	// Inserer en 1er les parametres d'entrees
	liste_i.init_lire ();
	nb = liste_i.nb_elem;
	while (nb != 0)
	  {
	    nb--;
	    fig = (figure_c *) liste_i.lire (0);
	    M->ajoute ((int *) NULL, (int) (fig->type), (void *) fig, TRUE, (int) (fig->signe));
	  }
	// construction du reste de la macro
	nb = liste_f.nb_elem;
	liste_f.init_lire ();
	valide = TRUE;
	while (nb != 0 && valide == TRUE)
	  {
	    if (position_noyau (*M, (figure_c *) liste_f.lire (0), liste_f) == -1)
	      valide = FALSE;
	    nb--;
	  }
	if (!valide)
	  {
	    M->vide ();		// la macro n'est pas valide

	    g_print (_ ("ERROR, when building the macro-construction.\nAn object has no parent and it's not an input parameter.\n"));
	  }
	else
	  liste_macro.ajoute ((void *) M);
	return valide;
      }
    }
  return TRUE;
}
void
macro_play (figure_c * selected_object)
{

  if (selected_macro == NULL)
    return;
  if (selection.position ((void *) selected_object) == 0)
    selection.ajoute ((void *) selected_object);
  if (selected_macro->param_i == selection.nb_elem)
    {
      // we got all the input parameter, we can execute the maro
      play_macro (*(macro *) selected_macro, selection);
      selection.vide ();
      mise_a_jour ();
      dessine_figure ();
      swap ();
    }
}

void
souris_select (int x, int y, figure_c * selected_object)
{
  selected_object->move (x - oldx, y - oldy);
  mise_a_jour ();
  tapisser (current_screen);
  if (mode == MISE_EN_FORME_MODE)
    dessine_tout ();
  else
    dessine_figure ();
  moving_object = TRUE;
  swap ();
}

void
efface_objet (figure_c * selected_object, char action)
{
  // action :
  // 0 : the user just select the object selected_object to erase
  // 1 : the user confirm deletion
  // 2 : the user cancel deletion

  int nb_figure, nb_scan;
  figure_c *fig, *fig_efface;
  liste_elem sous_souris, liste_efface, liste_parent;

  // we can't delete two object on the same time
  if (erasing && action == 0)
    return;

  // pour effacer les noyaus de macro, ce sont des parents
  if (action == 0)
    fig = selected_object;
  else
    fig = erase_object;		// we already wich object to delete, we bypass selected_object

  fig->parents (&liste_parent);
  fig_efface = fig;

  liste_efface.vide ();
  liste_efface.ajoute ((void *) fig);
  liste_efface.init_lire ();
  nb_scan = 1;
  nb_figure = liste_figure.nb_elem;
  // we research all the object who depend on the object 'selelected_object'
  // we must delete these one also
  while (nb_scan != 0)
    {
      int a, pos;
      fig = (figure_c *) liste_efface.lire (0);
      pos = liste_figure.position ((void *) fig) + 1;
      for (a = pos; a <= nb_figure; a++)
	{
	  figure_c *fig1;
	  fig1 = (figure_c *) liste_figure.lire (a);
	  if (fig1->dependance (fig) && liste_efface.position ((void *) fig1) == 0)
	    {
	      // l'objet pointe par fig1 est a effacer
	      liste_efface.ajoute ((void *) fig1);
	      nb_scan++;
	    }
	}
      nb_scan--;
    }

  // How was call the function ?  Value of action ?
  switch (action)
    {
    case 0:
      // we need to display the figure without the objects to delete
      erase_object = selected_object;
      liste_figure.init_lire ();
      tapisser (current_screen);
      while (nb_figure != 0)
	{
	  fig = (figure_c *) liste_figure.lire (0);
	  if (liste_efface.position ((void *) fig) == 0)
	    fig->dessine (current_screen, FALSE);
	  nb_figure--;
	}
      swap ();
      // ask for confirmation
      gtk_widget_show (erase_dialog);
      erasing = TRUE;
      break;
    case 1:
      // the user confirm deletion
      nb_figure = liste_efface.nb_elem;
      liste_efface.init_lire ();
      while (nb_figure != 0)
	{
	  fig = (figure_c *) liste_efface.lire (0);
	  delete (fig);
	  liste_figure.supprime ((void *) fig);
	  liste_figure_libre.supprime ((void *) fig);
	  nb_figure--;
	}
      // on efface les eventuels noyaus de macro pour construire cet objet
      // il ne faut pas les effacer systematiquement : ex. si un noyau sert a
      // la creation d'autres objets
      nb_figure = liste_figure.nb_elem;
      while (nb_figure != 0)
	{
	  fig = (figure_c *) liste_figure.lire (nb_figure);
	  if (!fig_utilisee (fig) && fig->masque == OBJET_MACRO)
	    {
	      liste_figure.supprime (fig);
	    }
	  nb_figure--;
	}
      erasing = FALSE;
      gtk_widget_hide (erase_dialog);
      break;
    case 2:
      // the user cancel deletion, we redisplay the figure
      tapisser (current_screen);
      dessine_figure ();
      swap ();
      erasing = FALSE;
      gtk_widget_hide (erase_dialog);
      break;
    }
}

void
fin (void)
{
  gtk_timeout_remove (tag_clignote);
  exit (0);
}
void
fin_mauvais_parametre (void)
{
  printf ("Dr Geo %s - Copyright 1997-1999 Hilaire Fernandes\n\n", drgeoversion);
  printf (_ ("Command line options:\nTerm under [] are options, || means OR:\n   drgeo [--file geo_file_name || macro_file_name] [geo_file_name] [--help]\n--file    : to load geo file or macro file\n--help    : this help summary\n\nSeveral macro can be loaded using a --file command for each macro file name\n\n"));

  gtk_timeout_remove (tag_clignote);
  exit (0);
}
void
option_drgeo (void)
{
}

// init de parametre initiaux
void
init_parametre (void)
{
  int ret;
  ECHELLE = w_ecran / 64;
  ORIGIN_W = w_ecran / 2;
  ORIGIN_H = h_ecran / 2;
  MON_L = MONx (0);
  MON_R = MONx (w_ecran);
  MON_T = MONy (0);
  MON_B = MONy (h_ecran);

  init_gui ();

  // init the color map
  tab_couleur[BLANC].pixel = (gulong) P_BLANC;
  tab_couleur[NOIR].pixel = (gulong) P_NOIR;
  tab_couleur[GRIS].pixel = (gulong) P_GRIS;
  tab_couleur[GRIS_CLAIR].pixel = (gulong) P_GRIS_CLAIR;
  tab_couleur[BLEU_FONCE].pixel = (gulong) P_BLEU_FONCE;
  tab_couleur[BLEU_CLAIR].pixel = (gulong) P_BLEU_CLAIR;
  tab_couleur[VERT_FONCE].pixel = (gulong) P_VERT_FONCE;
  tab_couleur[VERT_CLAIR].pixel = (gulong) P_VERT_CLAIR;
  tab_couleur[ROUGE].pixel = (gulong) P_ROUGE;
  tab_couleur[BORDEAUX].pixel = (gulong) P_BORDEAUX;
  tab_couleur[JAUNE].pixel = (gulong) P_JAUNE;
  tab_couleur[ORANGE].pixel = (gulong) P_ORANGE;

  for (ret = 0; ret < DRGEO_NUMBER_COLOR; ret++)
    {
      tab_couleur[ret].red = ((tab_couleur[ret].pixel & 0xFF0000) >> 16) +
	((tab_couleur[ret].pixel & 0xFF0000) >> 8);
      tab_couleur[ret].green = ((tab_couleur[ret].pixel & 0xFF00) >> 8) +
	(tab_couleur[ret].pixel & 0xFF00);
      tab_couleur[ret].blue = ((tab_couleur[ret].pixel & 0xFF) << 8) +
	(tab_couleur[ret].pixel & 0xFF);
      gdk_color_alloc (gtk_widget_get_colormap (main_window), &tab_couleur[ret]);
    }

  // build other widget who need color table to be ready
  init_other_widget ();
  // Create the tree window
  create_tree_window ();

  // build a GC for the figure and font on the canvas
  figure_gc = gdk_gc_new (main_window->window);
  font_gc = gdk_gc_new (main_window->window);
  object_gc = gdk_gc_new (main_window->window);
  // set the timeout function to render selected object
  flashing_list = &selection;
  tag_clignote = gtk_timeout_add (10, (GtkFunction) clignote, NULL);
}

void
presente (void)
{
}

int
main (int argc, char *argv[])
{
  int arg;

  /*
     xmlDocPtr doc;
     xmlNodePtr tree;

     doc = xmlParseFile("exemples/test.xml");
     tree = doc->root->childs->next->next;
     printf("%p\n",tree);
     // printf("%s\n",xmlGetProp(tree,"label"));
     if (tree != NULL) printf("%s\n", doc->root->name);
   */

  //bindtextdomain ("DrGeo", "/usr/local/share/locale");
  textdomain ("DrGeo");

  // init GNU Get Text
  gtk_init (&argc, &argv);

  /* 
     Init : - the widget (toolbars, drawing area, ...) - the GUI connect
     event function - the   */
  init_parametre ();

  arg = 1;
  while (arg != argc)
    {
      if (strcasecmp (argv[arg], "--file") == 0)
	{
	  arg++;
	  if (arg == argc)
	    {
	      printf (_ ("\nMiss a filename in --file\n\n"));
	      fin_mauvais_parametre ();
	    }
	  else
	    lire_figure (argv[arg++]);
	}
      else if (strcasecmp (argv[arg], "--help") == 0)
	fin_mauvais_parametre ();
      else if (strcasecmp (argv[arg], "--version") == 0)
	{
	  printf ("Dr Geo %s - Copyright 1997-1999 Hilaire Fernandes\n\n", drgeoversion);
	  fin ();
	}
      else if (strcasecmp (strrchr (argv[arg], '.') + 1, "geo") == 0)
	lire_figure (argv[arg++]);
      else
	{
	  printf (_ ("\nUnknow command: %s\n"), argv[arg++]);
	  fin_mauvais_parametre ();
	}
    }

  // display only now the main window and dialog_style box, now we check the cmd line param
  gtk_widget_show (main_window);
  gtk_widget_show (dialog_style);

  mise_a_jour ();

  gtk_main ();

  gtk_timeout_remove (tag_clignote);
}
