
/*
 *  Dr Geo an interactive geometry software
 * (C) Copyright Hilaire Fernandes  1997-1999
 * hilaire.fernandes@iname.com 
 * 
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "equation.h"

extern liste_elem liste_figure;
extern GdkFont *fontobject;
extern GdkGC *object_gc, *font_gc;
extern GdkColor tab_couleur[];



// Fonctions membres des classes equations
void equation_droite::
init_nom (void)
{
  if (masque == OBJET_MACRO)
    return;
  strcpy (nom_type, _ ("the equation of %1"));
  strcpy (nom, d->nom);
  strinsmsg (nom_type, nom, "%1");
}
char equation_droite::
dependance (figure_c * fig)
{
  return (d == fig);
}
void equation_droite::
dessine (GdkPixmap * ecran, char force)
{
  char out[60];
  double pe, b;
  droite_s co;
  if ((masque == OBJET_MACRO) || (masque == TRUE && force == FALSE) || existe == FALSE)
    return;
  pe = d->pente ();
  co = d->coordonnees ();
  if (fabs (pe) > 1E10)
    {
      if (co.a.x != 0)
	sprintf (out, "x=%.2f", co.a.x);
      else
	sprintf (out, "x=0");
    }
  else
    {
      b = co.a.y - pe * co.a.x;
      if (fabs (pe) < 1E-10)
	{
	  if (b == 0)
	    sprintf (out, "y=0");
	  else
	    sprintf (out, "y=%.2f", b);
	}
      else
	{
	  if (b == 0)
	    sprintf (out, "y=%.2fx", pe);
	  else
	    sprintf (out, "y=%.2fx%+.2f", pe, b);
	}
    }
  gdk_gc_set_foreground (object_gc, &tab_couleur[couleur]);
  gdk_draw_string (ecran, fontobject, object_gc, ECRx (p.x), ECRy (p.y), out);
}
char equation_droite::
appartient (int xm, int ym)
{
  char out[60];
  double pe, xl, yh, mx, my, b;
  droite_s co;
  mx = MONx (xm);
  my = MONy (ym);
  pe = d->pente ();
  co = d->coordonnees ();
  if (fabs (pe) > 1E10)
    {
      if (co.a.x != 0)
	sprintf (out, "x=%.2f", co.a.x);
      else
	sprintf (out, "x=0");
    }
  else
    {
      b = co.a.y - pe * co.a.x;
      if (fabs (pe) < 1E-10)
	{
	  if (b == 0)
	    sprintf (out, "y=0");
	  else
	    sprintf (out, "y=%.2f", b);
	}
      else
	{
	  if (b == 0)
	    sprintf (out, "y=%.2fx", pe);
	  else
	    sprintf (out, "y=%.2fx%+.2f", pe, b);
	}
    }
  xl = gdk_string_width (fontobject, out);
  yh = gdk_string_height (fontobject, out);
  xl = p.x + xl / ECHELLE;
  yh = p.y + yh / ECHELLE;
  if (mx >= p.x && mx <= xl && my <= yh && my >= p.y)
    return TRUE;
  else
    return FALSE;
}
void equation_droite::
move (int mx, int my)
{
  double x = mx, y = my;
  p.x += x / ECHELLE;
  p.y -= y / ECHELLE;
}
liste_elem *equation_droite::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) d);
  return liste_parent;
}
void equation_droite::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  fwrite (&p, 1, sizeof (p), f);
  pos = liste_figure.position ((void *) d);
  fwrite (&pos, 1, sizeof (pos), f);
}
void equation_droite::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&p, 1, sizeof (p), f);
  fread (&pos, 1, sizeof (pos), f);
  d = (droite_c *) liste_figure.lire (pos);
  init_nom ();
}
//
void equation_cercle::
init_nom (void)
{
  if (masque == OBJET_MACRO)
    return;
  strcpy (nom_type, _ ("the equation of %1"));
  strcpy (nom, c->nom);
  strinsmsg (nom_type, nom, "%1");
}
char equation_cercle::
dependance (figure_c * fig)
{
  return (c == fig);
}
void equation_cercle::
dessine (GdkPixmap * ecran, char force)
{
  char out[60];
  double x, y, r;
  point_s ce;
  if ((masque == OBJET_MACRO) || (masque == TRUE && force == FALSE) || existe == FALSE)
    return;
  r = c->rayon ();
  ce = c->centre ();
  x = ce.x;
  y = ce.y;
  if (r == 0)
    {
      if (fabs (x) < 1E-10)
	{
	  if (fabs (y) < 1E-10)
	    sprintf (out, "x+y=0");
	  else
	    sprintf (out, "x+(y%+.2f)=0", -y);
	}
      else
	{
	  if (fabs (y) < 1E-10)
	    sprintf (out, "(x%+.2f)+y=0", -x);
	  else
	    sprintf (out, "(x%+.2f)+(y%+.2f)=0", -x, -y);
	}
    }
  else
    {
      if (fabs (x) < 1E-10)
	{
	  if (fabs (y) < 1E-10)
	    sprintf (out, "x+y=%.2f", r * r);
	  else
	    sprintf (out, "x+(y%+.2f)=0", -y);
	}
      else
	{
	  if (fabs (y) < 1E-10)
	    sprintf (out, "(x%+.2f)+y=%.2f", -x, r * r);
	  else
	    sprintf (out, "(x%+.2f)+(y%+.2f)=%.2f", -x, -y, r * r);
	}
    }
  gdk_gc_set_foreground (object_gc, &tab_couleur[couleur]);
  gdk_draw_string (ecran, fontobject, object_gc, ECRx (p.x), ECRy (p.y), out);
}
char equation_cercle::
appartient (int xm, int ym)
{
  char out[60];
  point_s ce;
  double xl, yh, mx, my, x, y, r;
  r = c->rayon ();
  ce = c->centre ();
  x = ce.x;
  y = ce.y;
  if (r == 0)
    {
      if (fabs (x) < 1E-10)
	{
	  if (fabs (y) < 1E-10)
	    sprintf (out, "x+y=0");
	  else
	    sprintf (out, "x+(y%+.2f)=0", -y);
	}
      else
	{
	  if (fabs (y) < 1E-10)
	    sprintf (out, "(x%+.2f)+y=0", -x);
	  else
	    sprintf (out, "(x%+.2f)+(y%+.2f)=0", -x, -y);
	}
    }
  else
    {
      if (fabs (x) < 1E-10)
	{
	  if (fabs (y) < 1E-10)
	    sprintf (out, "x+y=%.2f", r * r);
	  else
	    sprintf (out, "x+(y%+.2f)=0", -y);
	}
      else
	{
	  if (fabs (y) < 1E-10)
	    sprintf (out, "(x%+.2f)+y=%.2f", -x, r * r);
	  else
	    sprintf (out, "(x%+.2f)+(y%+.2f)=%.2f", -x, -y, r * r);
	}
    }
  mx = MONx (xm);
  my = MONy (ym);
  xl = gdk_string_width (fontobject, out);
  yh = gdk_string_height (fontobject, out);
  xl = p.x + xl / ECHELLE;
  yh = p.y + yh / ECHELLE;
  if (mx >= p.x && mx <= xl && my <= yh && my >= p.y)
    return TRUE;
  else
    return FALSE;
}
void equation_cercle::
move (int mx, int my)
{
  double x = mx, y = my;
  p.x += x / ECHELLE;
  p.y -= y / ECHELLE;
}
liste_elem *equation_cercle::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) c);
  return liste_parent;
}
void equation_cercle::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  fwrite (&p, 1, sizeof (p), f);
  pos = liste_figure.position ((void *) c);
  fwrite (&pos, 1, sizeof (pos), f);
}
void equation_cercle::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&p, 1, sizeof (p), f);
  fread (&pos, 1, sizeof (pos), f);
  c = (cercle_c *) liste_figure.lire (pos);
  init_nom ();
}
