/*
 *  Dr Geo an interactive geometry software
 * (C) Copyright Hilaire Fernandes  1997-1998
 * hilaire.fernandes@iname.com 
 * 
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef define_h
#define define_h

// World to Screen coordinate conversion
#define ECRx(Xm)  ((int)((Xm)*ECHELLE+ORIGIN_W))
#define ECRy(Ym)  ((int)(-(Ym)*ECHELLE+ORIGIN_H))
// Screen to World coordinate conversion
#define MONx(Xe)  ((double)((Xe-ORIGIN_W)/ECHELLE))
#define MONy(Ye)  ((double)((-(Ye)+ORIGIN_H)/ECHELLE))
// Screen to World unit conversion
#define UNIT_ECRtoMON(Ue) ((double)((Ue)/ECHELLE))
// World to Screen unit conversion
#define UNIT_MONtoECR(Um) ((int)((Um)*ECHELLE))

// Max size of a macro name ( not the filename)
#define MACRO_NAME_WIDTH 21
// size of the macro text info buffer
#define MACRO_TEXT_INFO 256

// size of nom and nom_type buffers of the object class
#define LONGUEUR_NOM 10
#define LONGUEUR_NOM_TYPE 50

// type of curseur shape (not yet used!)
#define CRAYON 0
#define TIRER 1

// number version of file
#define GEO_VERSION 0073	// version 00.7.3
#define MAC_VERSION 0073	// version 00.7.3

#define _(String) gettext (String)

#endif
