

/*
 *  Dr Geo an interactive geometry software
 * (C) Copyright Hilaire Fernandes  1997-1999
 * hilaire.fernandes@iname.com 
 * 
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "arc_cercle.h"

extern liste_elem liste_figure;
extern GdkFont *fontobject;
extern GdkGC *font_gc;

// Common method for arc circle object
void arc_cercle_c::
init_nom (void)
{
  if (masque == OBJET_MACRO)
    return;
  strcpy (nom_type, _ ("this arc %1"));
  strinsmsg (nom_type, nom, "%1");
}
void arc_cercle_c::
dessine (GdkPixmap * ecran, char force)
{
  gint x, y, r, o, l;
  if ((masque == OBJET_MACRO) || (masque && !force) || !existe)
    return;
  x = ECRx (center.x);
  y = ECRy (center.y);
  r = UNIT_MONtoECR (radius);
  o = (gint) (180.0 * (origin / PI));
  l = (gint) (180.0 * (length / PI));
  if ((style & 128) == 0)
    {
      switch (epaisseur)
	{
	case 0:
	  dotted_arc_circle (ecran, x, y, r, o, l, couleur, 1);
	  break;
	case 1:
	  dotted_arc_circle (ecran, x, y, r, o, l, couleur, 2);
	  break;
	case 2:
	  garc_circle (ecran, x, y, r, o, l, couleur);
	  break;
	case 3:
	  thick_arc_circle (ecran, x, y, r, o, l, couleur, EPAIS);
	  break;
	}
    }
  else
    arc_circlefilled (ecran, x, y, r, o, l, couleur);
}
char arc_cercle_c::
appartient (int xm, int ym)
{
  double d, am, x, y;
  x = MONx (xm) - center.x;
  y = MONy (ym) - center.y;
  d = fabs (sqrt (x * x + y * y) - radius);
  // Arc AM
  am = atan2 (y, x) - origin;
  if (d <= RI)
    {
      if (length > 0)
	{
	  if (am < 0)
	    am += 2 * PI;
	  return (length >= am);
	}
      else if (length < 0)
	{
	  if (am > 0)
	    am -= 2 * PI;
	  return (length <= am);
	}
    }
  return FALSE;
}
void arc_cercle_c::
move (int xm, int ym)
{
}
// Member function of class 'arc_cercle1', arc circle defined by 3 points, two side points (A, C) and a point on the arc (B) 
void arc_cercle1::
init_nom (void)
{
  if (masque == OBJET_MACRO)
    return;
  strcpy (nom_type, _ ("this arc %1 going throw %2"));
  if ((strlen (A->nom) + strlen (C->nom)) <= LONGUEUR_NOM && strlen (A->nom) != 0 && strlen (C->nom) != 0)
    sprintf (nom, "%s%s", A->nom, C->nom);
  strinsmsg (nom_type, nom, "%1");
  strinsmsg (nom_type, B->nom, "%2");
}
point_s arc_cercle1::
centre (void)
{
  point_s i, a, b, c, *s;
  param_droite d1, d2;

  a = A->coordonnees ();
  b = B->coordonnees ();
  c = C->coordonnees ();

  // parameters of the 1st mediatrice (AB)
  i = (a + b) / 2;
  a = b - a;
  d1.a = a.x;
  d1.b = a.y;
  d1.c = -(d1.a * i.x + d1.b * i.y);
  // parameters of the 2st mediatrice (BC)
  i = (c + b) / 2;
  b = c - b;
  d2.a = b.x;
  d2.b = b.y;
  d2.c = -(d2.a * i.x + d2.b * i.y);

  s = cramer (d1, d2);
  if (s == NULL)
    {
      existe = FALSE;
      return i;
    }
  i = *s;
  delete s;
  return i;
}
double arc_cercle1::
rayon (void)
{
  point_s c;
  // Check if the center really exist
  if (existe == FALSE)
    return -1;
  c = center - A->coordonnees ();
  return sqrt (c * c);
}
double arc_cercle1::
arc_origin (void)
{
  point_s a;
  a = A->coordonnees () - center;
  return atan2 (a.y, a.x);
}
double arc_cercle1::
arc_length (void)
{
  double ab, ac;
  point_s a, b, c;

  a = A->coordonnees () - center;
  b = B->coordonnees () - center;
  c = C->coordonnees () - center;
  ab = atan2 (b.y, b.x) - atan2 (a.y, a.x);
  ac = atan2 (c.y, c.x) - atan2 (a.y, a.x);
  if (ac < 0)
    {
      if (ab < ac)
	ac += 2 * PI;
      else if (ab > 0)
	ac += 2 * PI;
    }
  else
    {
      if (ab > ac)
	ac -= 2 * PI;
      else if (ab < 0)
	ac -= 2 * PI;
    }
  return ac;
}
void arc_cercle1::
move (int xm, int ym)
{
  A->move (xm, ym);
  B->move (xm, ym);
  C->move (xm, ym);
  actualise ();
}
void arc_cercle1::
actualise (void)
{
  if (!A->existe || !B->existe || !C->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
  center = centre ();
  if (existe == FALSE)
    return;
  radius = rayon ();
  origin = arc_origin ();
  length = arc_length ();
}
liste_elem *arc_cercle1::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) A);
  liste_parent->ajoute ((void *) B);
  liste_parent->ajoute ((void *) C);
  return liste_parent;
}
void arc_cercle1::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  pos = liste_figure.position ((void *) A);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) B);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) C);
  fwrite (&pos, 1, sizeof (pos), f);
}
void arc_cercle1::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&pos, 1, sizeof (pos), f);
  A = (point_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  B = (point_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  C = (point_c *) liste_figure.lire (pos);
  init_nom ();
}
char arc_cercle1::
dependance (figure_c * fig)
{
  return (A == fig || B == fig || C == fig);
}
// Transformed arc circle
// By reflexion
char reflexion_arc_cercle::
dependance (figure_c * fig)
{
  return (axe == fig || arc_cercle == fig);
}
void reflexion_arc_cercle::
actualise (void)
{
  if (!arc_cercle->existe || !axe->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
  center = centre ();
  radius = rayon ();
  origin = arc_origin ();
  length = arc_length ();
}
double reflexion_arc_cercle::
rayon ()
{
  return (arc_cercle->radius);
}
point_s reflexion_arc_cercle::
centre ()
{
  return reflexion_p (axe, arc_cercle->center);
}
double reflexion_arc_cercle::
arc_origin (void)
{
  point_s A, trigo;
  trigo.x = cos (arc_cercle->origin);
  trigo.y = sin (arc_cercle->origin);
  A = arc_cercle->center + arc_cercle->radius * trigo;
  A = reflexion_p (axe, A) - centre ();
  return (atan2 (A.y, A.x));
}
double reflexion_arc_cercle::
arc_length (void)
{
  return (-arc_cercle->length);
}
liste_elem *reflexion_arc_cercle::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) axe);
  liste_parent->ajoute ((void *) arc_cercle);
  return liste_parent;
}
void reflexion_arc_cercle::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  pos = liste_figure.position ((void *) axe);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) arc_cercle);
  fwrite (&pos, 1, sizeof (pos), f);
}
void reflexion_arc_cercle::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&pos, 1, sizeof (pos), f);
  axe = (droite_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  arc_cercle = (arc_cercle_c *) liste_figure.lire (pos);
  init_nom ();
}
// By symetry
char symetrie_arc_cercle::
dependance (figure_c * fig)
{
  return (symetrie == fig || arc_cercle == fig);
}
void symetrie_arc_cercle::
actualise (void)
{
  if (!arc_cercle->existe || !symetrie->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
  center = centre ();
  radius = rayon ();
  origin = arc_origin ();
  length = arc_length ();
}
double symetrie_arc_cercle::
rayon ()
{
  return (arc_cercle->radius);
}
point_s symetrie_arc_cercle::
centre ()
{
  return (2 * symetrie->coordonnees () - arc_cercle->center);
}
double symetrie_arc_cercle::
arc_origin (void)
{
  point_s A, trigo;
  trigo.x = cos (arc_cercle->origin);
  trigo.y = sin (arc_cercle->origin);
  A = arc_cercle->center + arc_cercle->radius * trigo;
  A = 2 * symetrie->coordonnees () - A - centre ();
  return (atan2 (A.y, A.x));
}
double symetrie_arc_cercle::
arc_length (void)
{
  return (arc_cercle->length);
}
liste_elem *symetrie_arc_cercle::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) symetrie);
  liste_parent->ajoute ((void *) arc_cercle);
  return liste_parent;
}
void symetrie_arc_cercle::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  pos = liste_figure.position ((void *) symetrie);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) arc_cercle);
  fwrite (&pos, 1, sizeof (pos), f);
}
void symetrie_arc_cercle::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&pos, 1, sizeof (pos), f);
  symetrie = (point_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  arc_cercle = (arc_cercle_c *) liste_figure.lire (pos);
  init_nom ();
}
// By translation
char translation_arc_cercle::
dependance (figure_c * fig)
{
  return (v == fig || arc_cercle == fig);
}
void translation_arc_cercle::
actualise (void)
{
  if (!arc_cercle->existe || !v->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
  center = centre ();
  radius = rayon ();
  origin = arc_origin ();
  length = arc_length ();
}
double translation_arc_cercle::
rayon ()
{
  return (arc_cercle->radius);
}
point_s translation_arc_cercle::
centre ()
{
  return (arc_cercle->center + v->vecteur ());
}
double translation_arc_cercle::
arc_origin (void)
{
  return (arc_cercle->origin);
}
double translation_arc_cercle::
arc_length (void)
{
  return (arc_cercle->length);
}
liste_elem *translation_arc_cercle::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) v);
  liste_parent->ajoute ((void *) arc_cercle);
  return liste_parent;
}
void translation_arc_cercle::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  pos = liste_figure.position ((void *) v);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) arc_cercle);
  fwrite (&pos, 1, sizeof (pos), f);
}
void translation_arc_cercle::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&pos, 1, sizeof (pos), f);
  v = (vecteur_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  arc_cercle = (arc_cercle_c *) liste_figure.lire (pos);
  init_nom ();
}
// By rotation
char rotation_arc_cercle::
dependance (figure_c * fig)
{
  return (v == fig || c == fig || arc_cercle == fig);
}
void rotation_arc_cercle::
actualise (void)
{
  if (!arc_cercle->existe || !v->existe || !c->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
  center = centre ();
  radius = rayon ();
  origin = arc_origin ();
  length = arc_length ();
}
double rotation_arc_cercle::
rayon ()
{
  return (arc_cercle->radius);
}
point_s rotation_arc_cercle::
centre ()
{
  return rotation_p (c, v, arc_cercle->center);
}
double rotation_arc_cercle::
arc_origin (void)
{
  point_s A, trigo;
  trigo.x = cos (arc_cercle->origin);
  trigo.y = sin (arc_cercle->origin);
  A = arc_cercle->center + arc_cercle->radius * trigo;
  A = rotation_p (c, v, A) - centre ();
  return (atan2 (A.y, A.x));
}
double rotation_arc_cercle::
arc_length (void)
{
  return (arc_cercle->length);
}
liste_elem *rotation_arc_cercle::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) v);
  liste_parent->ajoute ((void *) c);
  liste_parent->ajoute ((void *) arc_cercle);
  return liste_parent;
}
void rotation_arc_cercle::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  pos = liste_figure.position ((void *) v);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) arc_cercle);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) c);
  fwrite (&pos, 1, sizeof (pos), f);
}
void rotation_arc_cercle::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&pos, 1, sizeof (pos), f);
  v = (valeur_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  arc_cercle = (arc_cercle_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  c = (point_c *) liste_figure.lire (pos);
  init_nom ();
}
// By homothetie
char homothetie_arc_cercle::
dependance (figure_c * fig)
{
  return (v == fig || c == fig || arc_cercle == fig);
}
void homothetie_arc_cercle::
actualise (void)
{
  if (!arc_cercle->existe || !v->existe || !c->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
  center = centre ();
  radius = rayon ();
  origin = arc_origin ();
  length = arc_length ();
}
double homothetie_arc_cercle::
rayon ()
{
  return (arc_cercle->radius * fabs (v->val));
}
point_s homothetie_arc_cercle::
centre ()
{
  return (c->p + (arc_cercle->center - c->p) * v->val);
}
double homothetie_arc_cercle::
arc_origin (void)
{
  point_s A, trigo;
  trigo.x = cos (arc_cercle->origin);
  trigo.y = sin (arc_cercle->origin);
  A = arc_cercle->center + arc_cercle->radius * trigo;
  A = (c->p + (A - c->p) * v->val) - centre ();
  return (atan2 (A.y, A.x));
}
double homothetie_arc_cercle::
arc_length (void)
{
  return (arc_cercle->length);
}
liste_elem *homothetie_arc_cercle::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) v);
  liste_parent->ajoute ((void *) c);
  liste_parent->ajoute ((void *) arc_cercle);
  return liste_parent;
}
void homothetie_arc_cercle::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  pos = liste_figure.position ((void *) v);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) arc_cercle);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) c);
  fwrite (&pos, 1, sizeof (pos), f);
}
void homothetie_arc_cercle::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&pos, 1, sizeof (pos), f);
  v = (valeur_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  arc_cercle = (arc_cercle_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  c = (point_c *) liste_figure.lire (pos);
  init_nom ();
}
