/*
 *  Dr Geo an interactive geometry software
 * (C) Copyright Hilaire Fernandes  1997-1999
 * hilaire.fernandes@iname.com 
 * 
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "angle.h"

extern liste_elem liste_figure;
extern GdkFont *fontobject;
extern GdkGC *object_gc, *font_gc;
extern GdkColor tab_couleur[];

//
// Members functions of class type angle
// 
void angle_3points::
init_nom (void)
{
  if (masque == OBJET_MACRO)
    return;
  strcpy (nom_type, _ ("this angle %1"));
  if (nom[0] == 0)
    {
      if ((strlen (pt1->nom) + strlen (pt2->nom) + strlen (pt3->nom) + 1) <= LONGUEUR_NOM)
	{
	  strcpy (nom, pt1->nom);
	  strcat (nom, pt2->nom);
	  strcat (nom, pt3->nom);
	}
      else
	{
	  nom[0] = 'a';
	  nom[1] = 0;
	}
    }
  strinsmsg (nom_type, nom, "%1");
}
char angle_3points::
dependance (figure_c * fig)
{
  return (pt1 == fig || pt2 == fig || pt3 == fig);
}
void angle_3points::
actualise (void)
{
  vecteur_s u, v;
  point_s centre;
  double ps, det;
  existe = pt1->existe && pt2->existe && pt3->existe;
  if (!existe)
    return;

  centre = pt2->coordonnees ();
  u = pt1->coordonnees () - centre;
  v = pt3->coordonnees () - centre;
  if ((ECRx (u.x) == 0 && ECRy (u.y) == 0) || (ECRx (v.x) == 0 && ECRy (v.y) == 0))
    {
      existe = FALSE;
      return;
    }

  ps = u * v;
  det = u.x * v.y - v.x * u.y;
  val = fabs (atan2 (det, ps));

  origin = atan2 (u.y, u.x);
  ps = atan2 (v.y, v.x);


  // We want measure in the intervalle [ 0 ; 2PI [
  if (origin < 0)
    origin += 2 * PI;
  if (ps < 0)
    ps += 2 * PI;

  // Get the shortest distance between the two angles
  arc_length = acos (cos (ps - origin));
  // We want a signed distance
  if (ps - origin > PI || (ps - origin < 0 && ps - origin > -PI))
    arc_length = -arc_length;

  p.x = centre.x + UNIT_ECRtoMON (35) * cos (origin + arc_length / 2);
  p.y = centre.y + UNIT_ECRtoMON (35) * sin (origin + arc_length / 2);

}
void angle_3points::
dessine (GdkPixmap * ecran, char force)
{
  char out[20];
  point_s centre;
  double a;
  if ((masque == OBJET_MACRO) || (masque == TRUE && force == FALSE) || existe == FALSE)
    return;
  a = valeur ();
  switch (unite)
    {
    case DEGRES:
      sprintf (out, "%.0f", a * 180 / PI);
      break;
    case RADIAN:
      sprintf (out, "%.2f rad", a);
      break;
    case GRADE:
      sprintf (out, "%.2f grad", a * 200 / PI);
    }
  gdk_gc_set_foreground (object_gc, &tab_couleur[couleur]);
  gdk_draw_string (ecran, fontobject, object_gc, ECRx (p.x), ECRy (p.y), out);

  centre = pt2->coordonnees ();

  if (fabs (a - PI / 2) > 1E-10)
    gdk_draw_arc (ecran, object_gc, FALSE, ECRx (centre.x) - 15, ECRy (centre.y) - 15, 30, 30,
		  (gint) (64 * 180 * origin / PI),
		  (gint) (64 * 180 * arc_length / PI));
  else
    {
      vecteur_s u, v, s;
      u = pt1->coordonnees () - centre;
      u = UNIT_ECRtoMON (10) * u / sqrt (u * u);
      v = pt3->coordonnees () - centre;
      v = UNIT_ECRtoMON (10) * v / sqrt (v * v);
      u = u + centre;
      s = u + v;
      v = v + centre;
      gdk_draw_line (ecran, object_gc, ECRx (u.x), ECRy (u.y), ECRx (s.x), ECRy (s.y));
      gdk_draw_line (ecran, object_gc, ECRx (v.x), ECRy (v.y), ECRx (s.x), ECRy (s.y));
    }
}
liste_elem *angle_3points::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) pt1);
  liste_parent->ajoute ((void *) pt2);
  liste_parent->ajoute ((void *) pt3);
  return liste_parent;
}
void angle_3points::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  fwrite (&p, 1, sizeof (p), f);
  fwrite (&unite, 1, sizeof (unite), f);
  fwrite (&val, 1, sizeof (val), f);
  pos = liste_figure.position ((void *) pt1);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) pt2);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) pt3);
  fwrite (&pos, 1, sizeof (pos), f);
}
void angle_3points::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&p, 1, sizeof (p), f);
  fread (&unite, 1, sizeof (unite), f);
  fread (&val, 1, sizeof (val), f);
  fread (&pos, 1, sizeof (pos), f);
  pt1 = (point_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  pt2 = (point_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  pt3 = (point_c *) liste_figure.lire (pos);
  init_nom ();
}
//
void angle_2vecteurs::
init_nom (void)
{
  if (masque == OBJET_MACRO)
    return;
  strcpy (nom_type, _ ("this angle %1"));
  if (nom[0] == 0)
    {
      if ((strlen (v1->nom) + strlen (v2->nom) + 3 + strlen (nom_type)) <= LONGUEUR_NOM_TYPE)
	sprintf (nom, "(%s,%s)", v1->nom, v2->nom);
      else
	{
	  nom[0] = 'a';
	  nom[1] = 0;
	}
    }
  strinsmsg (nom_type, nom, "%1");
}
char angle_2vecteurs::
dependance (figure_c * fig)
{
  return (v1 == fig || v2 == fig);
}
void angle_2vecteurs::
actualise (void)
{
  vecteur_s u, v;
  existe = v1->existe && v2->existe;
  if (!existe)
    return;
  u = v1->vecteur ();
  v = v2->vecteur ();
  if ((ECRx (u.x) == 0 && ECRy (u.y) == 0) || (ECRx (v.x) == 0 && ECRy (v.y) == 0))
    {
      existe = FALSE;
      return;
    }
  val = atan2 (u.x * v.y - u.y * v.x, u * v);
}
void angle_2vecteurs::
dessine (GdkPixmap * ecran, char force)
{
  char out[20];
  double a;
  if ((masque == OBJET_MACRO) || (masque == TRUE && force == FALSE) || existe == FALSE)
    return;
  switch (unite)
    {
    case DEGRES:
      a = valeur () * 180 / PI;
      sprintf (out, "%.0f", a);
      break;
    case RADIAN:
      sprintf (out, "%.2f rad", valeur ());
      break;
    case GRADE:
      a = valeur () * 200 / PI;
      sprintf (out, "%.2f grad", a);
    }
  gdk_gc_set_foreground (object_gc, &tab_couleur[couleur]);
  gdk_draw_string (ecran, fontobject, object_gc, ECRx (p.x), ECRy (p.y), out);

}
liste_elem *angle_2vecteurs::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) v1);
  liste_parent->ajoute ((void *) v2);
  return liste_parent;
}
void angle_2vecteurs::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  fwrite (&p, 1, sizeof (p), f);
  fwrite (&unite, 1, sizeof (unite), f);
  fwrite (&val, 1, sizeof (val), f);
  pos = liste_figure.position ((void *) v1);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) v2);
  fwrite (&pos, 1, sizeof (pos), f);
}
void angle_2vecteurs::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&p, 1, sizeof (p), f);
  fread (&unite, 1, sizeof (unite), f);
  fread (&val, 1, sizeof (val), f);
  fread (&pos, 1, sizeof (pos), f);
  v1 = (vecteur_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  v2 = (vecteur_c *) liste_figure.lire (pos);
  init_nom ();
}
