/*								-*- C++ -*-
 * $Id: WIN_scrollbar.cpp,v 1.2 1997-02-28 16:04:11+01 mho Exp $
 *
 * Purpose: scrollbar panel item
 *
 * Authors: Mark Newsam, Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Mark)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef __GNUG__
#pragma implementation "WIN_scrollbar.h"
#endif

#define  Uses_XtIntrinsic
#define  Uses_wxScrollBar
#include "wx.h"
#define  Uses_ScrollBarWidget
#include <widgets.h>

//-----------------------------------------------------------------------------
// create and destroy button
//-----------------------------------------------------------------------------

IMPLEMENT_DYNAMIC_CLASS(wxScrollBar, wxItem);

wxScrollBar::wxScrollBar(void) : wxItem()
{
    __type = wxTYPE_SCROLL_BAR;
}


wxScrollBar::wxScrollBar(wxPanel *panel, wxFunction func,
                         int x, int y, int w, int h,
                         long style, Constdata char *name)
    : wxItem()
{
    __type = wxTYPE_SCROLL_BAR;
    Create(panel, func, x,y, w,h, style, name);
}


Bool wxScrollBar::Create(wxPanel *panel, wxFunction function,
                         int x, int y, int w, int h,
                         long style, Constdata char *name)
{
    ChainToPanel(panel, style, name);
   
    HWidget() = FWidget() = XtVaCreateManagedWidget
	(name, xfwfScrollbarWidgetClass, GetParentWidget(parent),
	 XtNvertical,    style == wxHORIZONTAL ? FALSE : TRUE,
	 XtNbackground,  bg.GetPixel(&cmap),
	 XtNforeground,  fg.GetPixel(&cmap),
	 XtNthumbColor,  bg.GetPixel(&cmap),
	 XtNframeWidth,  2,
	 XtNframeType,   XfwfSunken,
	 XtNborderWidth, 0,
	 NULL);
    pos     = 0;
    pLength = 1;
    oLength = 1;
    vLength = 1;
    orientation = style;
    XfwfSetScrollbar(HWidget(), 0.0, 1.0);
    // Initialise callbacks
    callback = function;
    XtAddCallback(HWidget(),XtNscrollCallback, wxScrollBar::EventCallback,
		  (XtPointer)this);

    panel->PositionItem(this, x, y, w, h);
    AddEventHandlers();

    return TRUE;
}


void wxScrollBar::SetValue(int viewStart)
{
    pos = viewStart;
    SetScrollBar();
}

int wxScrollBar::GetValue(void)
{
    return pos;
}

void wxScrollBar::SetPageLength(int pageLength)
{
    pLength = pageLength;
}


void wxScrollBar::SetObjectLength(int objectLength)
{
    oLength = objectLength;
    SetScrollBar();
}


void wxScrollBar::SetViewLength(int viewLength)
{
    vLength = viewLength;
    SetScrollBar();
}


void wxScrollBar::GetValues(int *viewStart, int *viewLength, int *objectLength,
                            int *pageLength)
{
    *viewStart    = pos;
    *viewLength   = vLength;
    *objectLength = oLength;
    *pageLength   = pLength;
}


char *wxScrollBar::GetLabel()
{
    char *label = NULL;
    XtVaGetValues(HWidget(), XtNlabel, &label, NULL);
    return label;
}


void wxScrollBar::SetLabel(char *label)
{
    XtVaSetValues(HWidget(), XtNlabel,  label, NULL);
}


//-----------------------------------------------------------------------------
// do the same as if button was clicked
//-----------------------------------------------------------------------------

void wxScrollBar::Command(wxCommandEvent &event)
{
    wxItem::Command(event);
}

//-----------------------------------------------------------------------------
// callback for commandWidgetClass
//-----------------------------------------------------------------------------

void wxScrollBar::EventCallback(Widget WXUNUSED(w), XtPointer clientData,
                                XtPointer sinfo)
{
    wxScrollBar *bar = (wxScrollBar*)clientData;

    if (bar->HandleCallback(sinfo)) {
	wxCommandEvent event(wxEVENT_TYPE_SCROLLBAR_COMMAND);

	event.eventObject = bar;
	event.commandInt  = bar->pos;
	bar->ProcessCommand(event);
    }
}

Bool wxScrollBar::HandleCallback(XtPointer scroll_info)
{
    if (vLength == oLength)
	return FALSE;

    XfwfScrollInfo* sinfo = (XfwfScrollInfo*)scroll_info;
    int		    step  = 0;

    switch(sinfo->reason) {
    case XfwfSNotify: case XfwfSMove: case XfwfSDrag:
	// get position (depending on vertical/horizontal scrollbar)
	// no redrawing necessary
	if ((orientation == wxVERTICAL) && (sinfo->flags & XFWF_VPOS))
	    pos = int(sinfo->vpos * (oLength-vLength) + 0.5);
	else if((orientation == wxHORIZONTAL) && (sinfo->flags & XFWF_HPOS))
	    pos = int(sinfo->hpos * (oLength-vLength) + 0.5);
	return TRUE;
    case XfwfSRight: case XfwfSDown:
	step = 1;
	break;
    case XfwfSLeft: case XfwfSUp:
	step = -1;
	break;
    case XfwfSPageRight: case XfwfSPageDown:
	step = pLength;
	break;
    case XfwfSPageLeft:
    case XfwfSPageUp:
	step = -pLength;
	break;
    default: // The remaining events are not handled
	cout << "wxScrollBar::handle_callback: Event not handled\n";
	break;
    }

    if (step == 0)
	return FALSE; // no handling necessary

    // compute new position, min=0, max=oLength-vLength
    // and redraw scrollbar
    pos += step;
    if (pos < 0)
	pos = 0;
    if (pos > oLength - vLength)
	pos = oLength - vLength;
    SetScrollBar();
    return TRUE;
}


void wxScrollBar::SetScrollBar(void)
{
    double p = double(pos)     / double(oLength-vLength);
    double s = double(vLength) / double(oLength);

    // secure 0.0 <= p,s <= 1.0
    p = wxMax(0.0, p); p = wxMin(p, 1.0);
    s = wxMax(0.0, s); s = wxMin(s, 1.0);

//     cerr << (orientation == wxHORIZONTAL ? "wxHScrollBar(" : "wxVScrollBar(")
// 	 << GetName()
// 	 << ") pos="     << pos
// 	 << ", pLength=" << pLength
// 	 << ", vLength=" << vLength
// 	 << ", oLength=" << oLength
// 	 << endl;

    XfwfSetScrollbar(HWidget(), p, s);
}
