/* $Id: progname.c,v 1.4 1998/07/05 16:57:03 sverrehu Exp $ */
/**************************************************************************
 *
 *  FILE            progname.c
 *  MODULE OF       shhmsg - library for displaying messages.
 *
 *  DESCRIPTION     Routines for handling the name of the program.
 *                  This is used when displaying error messages,
 *                  according to the Unix tradition.
 *
 *  WRITTEN BY      Sverre H. Huseby <sverrehu@online.no>
 *
 **************************************************************************/

#include <string.h>

#include "internal.h"
#include "shhmsg.h"

/**************************************************************************
 *                                                                        *
 *                       P R I V A T E    D A T A                         *
 *                                                                        *
 **************************************************************************/

static char *Argv0 = NULL;      /* the name of the program. */



/**************************************************************************
 *                                                                        *
 *                        P U B L I C    D A T A                          *
 *                                                                        *
 **************************************************************************/

int _msgShowNameAlways = 0;     /* show program name always */



/**************************************************************************
 *                                                                        *
 *                    P U B L I C    F U N C T I O N S                    *
 *                                                                        *
 **************************************************************************/

/*-------------------------------------------------------------------------
 *
 *  NAME          msgSetName
 *
 *  FUNCTION      Specify the name of this program (from argv[0]).
 *
 *  SYNOPSIS      #include "shhmsg.h"
 *                void msgSetName(const char *name);
 *
 *  INPUT         name   Name of this program, possibly including path.
 *
 *  DESCRIPTION   The program name specified is used by the errorfunctions
 *                to identify this program.
 */
void
msgSetName(const char *name)
{
    Argv0 = (char *) name;
}



/*-------------------------------------------------------------------------
 *
 *  NAME          msgGetName
 *
 *  FUNCTION      Return the name of this program.
 *
 *  SYNOPSIS      #include "shhmsg.h"
 *                char *msgGetName(void);
 *
 *  RETURNS       Pointer to the name of this program, without any path.
 *
 *  DESCRIPTION   The name depends on the string passed to msgSetName().
 */
char *
msgGetName(void)
{
    char *ret;

  #ifdef __MSDOS__
    static char name[15];
    #define PATHSEP '\\'
  #else
    #define PATHSEP '/'
  #endif

    if (!Argv0)
        return("!!!");

  #ifdef __MSDOS__
    if ((ret = strrchr(Argv0, PATHSEP)) == NULL)
        ret = Argv0;
    else
        ++ret;
    strcpy(name, ret);
    if ((ret = strchr(name, '.')) != NULL)
        *ret = '\0';
    strlwr(name);
    ret = name;

  #else
    if ((ret = strrchr(Argv0, PATHSEP)) == NULL)
        ret = Argv0;
    else
        ++ret;
  #endif

    return ret;
}



/*-------------------------------------------------------------------------
 *
 *  NAME          msgSetShowNameAlways
 *
 *  FUNCTION      Enable or disable the name of the program in all output.
 *
 *  SYNOPSIS      #include "shhmsg.h"
 *                void msgSetShowNameAlways(int onoff);
 *
 *  INPUT         onoff   1 or 0, 1 to show name always.
 *
 *  DESCRIPTION   This enables or disables the forcing of the name to show
 *                in all output.
 */
void
msgSetShowNameAlways(int onoff)
{
    _msgShowNameAlways = onoff;
}
