#!/bin/sh
#
# Prompt the user for the install directory, and install everything

# Set some sane defaults for the install directory
target=`uname`
case $target in
  BeOS)
	# BeOS standard add-ons location
	lib_dir=/boot/develop/lib
	if [ "`uname -m`" = "BePC" ]; then
	    lib_dir="$lib_dir/x86"
        else
	    lib_dir="$lib_dir/ppc"
        fi
	hdr_dir=/boot/develop/headers/SDL
	;;
  *)
	# Default to UNIX standard
	base=/usr/local
	;;
esac

# Echo a line without a trailing newline:
prompt()
{
	line="`echo '1\n2'`"
	if [ "$line" = '1\n2' ]; then
		echo -n "$*"
	else
		echo "$*\c"
	fi
}

# Prompt the user to change the default directory
if [ "$lib_dir" = "" -o "$hdr_dir" = "" ]; then
	prompt "Enter installation directory: [$base] "
	read newbase
	if [ "$newbase" != "" ]; then
		base=$newbase
	fi
	if [ "$lib_dir" = "" ]; then
		lib_dir="$base/lib"
	fi
	if [ "$hdr_dir" = "" ]; then
		hdr_dir="$base/include/SDL"
	fi
fi

# Final installation prompting
okay="n"
while [ "$okay" = "n" -o "$okay" = "N" ]; do
	echo "SDL library files will be installed in"
	echo "	$lib_dir"
	echo "SDL header files will be installed in"
	echo "	$hdr_dir"
	echo ""
	prompt "Is that okay?  [Y/n] "
	read okay
	if [ "$okay" = "n" -o "$okay" = "N" ]; then
		prompt \
"Enter library installation directory:
[$lib_dir] "
		read new_dir
		if [ "$new_dir" != "" ]; then
			lib_dir=$new_dir
		fi
		prompt \
"Enter header installation directory:
[$hdr_dir] "
		read new_dir
		if [ "$new_dir" != "" ]; then
			hdr_dir=$new_dir
		fi
	fi
done

# Functions to do their duty verbosely
echo_mkdir()
{
	echo mkdir $*
	mkdir $*
}
echo_cp()
{
	flist=""
	while [ $# -gt 1 ]; do
		flist="$flist $1"
		shift
	done
	dest=$1
	for full_file in $flist
	do file=`basename $full_file`
	   if [ "$file" = "CVS" ]; then
		continue;
	   fi
	   echo "$full_file -> $dest/$file"
	   if [ -f "$dest/$file" ]; then
		rm -f "$dest/$file"
	   fi
	   if [ -h $full_file ]; then # symbolic link
	   	(cd `dirname $full_file`;
			tar cpf - $file | (cd $dest; tar xpf -)
		) 2>/dev/null
	   else
		cp $full_file $dest/$file || exit 1
	   fi
	done
}
echo_mktree()
{
	tree=""
	_IFS=$IFS
	IFS="/"
	set -- $1
	IFS=$_IFS
	while [ $# -gt 0 ]; do
		tree="$tree/$1"
		shift
		if [ ! -d $tree ]; then
			echo_mkdir $tree || exit 1
		fi
	done
}

# Perform the installation
echo_mktree $lib_dir
echo_cp lib/* $lib_dir
echo_mktree $hdr_dir
echo_cp include/* $hdr_dir

# Give instructions for final cleanup
echo ""
case $target in
  BeOS)
	# BeOS uses ADDON_PATH
	echo "You may need to set the ADDON_PATH environment variable to:"
	echo "	$lib_dir"
	;;
  Linux)
	# Linux uses /etc/ld.so.conf and LD_LIBRARY_PATH
	echo "You may need to run ldconfig as root"
	echo "or"
	echo "You may need to set the LD_LIBRARY_PATH environment variable to:"
	echo "	$lib_dir"
	;;
  *)
	# Default UNIX uses LD_LIBRARY_PATH
	echo "You may need to set the LD_LIBRARY_PATH environment variable to:"
	echo "	$lib_dir"
	;;
esac

# We're done!
exit 0
