/*
 * spinmodule.c - written in 1998 by Andreas Beck   becka@ggi-project.org
 *
 * This is a demonstration of LibGGI's functions and can be used as a
 * reference programming example.
 *
 *   This software is placed in the public domain and can be used freely
 *   for any purpose. It comes without any kind of warranty, either
 *   expressed or implied, including, but not limited to the implied
 *   warranties of merchantability or fitness for a particular purpose.
 *   Use it at your own risk. the author is not responsible for any damage
 *   or consequences raised by use or inability to use this program.
 */

#include <stdlib.h>
#include <ggi/ggi.h>

#define __C_ASM_H /* Workaround for retarded Digital Unix headers */
#include <pthread.h>

void *module_main(ggi_visual_t *myvis)
{
	int x,y,dx,dy,c,cnt;

	ggi_mode mode;
	int xmax, ymax;

	ggiSetFlags(myvis, GGIFLAG_ASYNC);

	ggiGetMode(myvis, &mode);
	xmax = mode.virt.x;
	ymax = mode.virt.y;

	ggiSetGCForeground(myvis,0);
	ggiFillscreen(myvis);

	/* Set a colorful palette for the tests.
	   Please note that GGI always uses 16 bit color components,
	   so stretch the values accordingly when porting from DOS 
	   or other libs that make assumptions about palette size.

	   On some fixed-palette modes the ggiSetColorfulPalette()
	   call will fail.  We silently ignore that.
	 */
	 
	if (GT_SCHEME(mode.graphtype) == GT_PALETTE) {
		ggiSetColorfulPalette(myvis);
	}

	x=y=0;dx=dy=1;c=0;cnt=6000;

	do {
		ggiSetGCForeground(myvis,c++);
		ggiDrawBox(myvis,x,y,10,10);
		ggiFlushRegion(myvis,x-1,y-1,12,12);	/* tricky - eh ?*/
		usleep(10000);
		ggiSetGCForeground(myvis,0);
		ggiDrawBox(myvis,x,y,10,10);
		x+=dx;y+=dy;
		if (x+10>xmax) dx=-1;
		if (y+10>ymax) dy=-1;
		if (x<1) dx=1;
		if (y<1) dy=1;
		pthread_testcancel();
	} while(cnt--);
	return NULL;
}
