/* $Id: hline.c,v 1.10 1998/11/19 01:06:30 marcus Exp $
******************************************************************************

   SVGAlib target vgagl helper: horizontal lines

   Copyright (C) 1998 Marcus Sundberg   [marcus@ggi-project.org]
   Copyright (C) 1997 Jason McMullan    [jmcc@ggi-project.org]
   Copyright (C) 1995 Andreas Beck      [becka@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <ggi/internal/ggi-dl.h>
#include "vgaglvis.h"

/**********************************/
/* draw/get/put a horizontal line */
/**********************************/

int GGI_vgagl_drawhline(ggi_visual *vis,int x,int y,int width)
{
	/* Clipping */
	if (y<(LIBGGI_GC(vis)->cliptl.y) || y>=(LIBGGI_GC(vis)->clipbr.y)) return 0;
	if (x< (LIBGGI_GC(vis)->cliptl.x)) {
		int diff=(LIBGGI_GC(vis)->cliptl.x)-x;
		x+=diff;
		width-=diff;
	}
	if (x+width>(LIBGGI_GC(vis)->clipbr.x)) {
		width=(LIBGGI_GC(vis)->clipbr.x)-x;
	}
	if (width>0) {
		gl_hline(x,y,x+width-1,LIBGGI_GC_FGCOLOR(vis));
	}
	return 0;
}

int GGI_vgagl_drawhline_nc(ggi_visual *vis,int x,int y,int width)
{
	gl_hline(x,y,x+width-1,LIBGGI_GC_FGCOLOR(vis));
	return 0;
}

int GGI_vgagl_puthline(ggi_visual *vis,int x,int y,int width,void *buffer)
{ 
	/* Clipping */
	if (y<(LIBGGI_GC(vis)->cliptl.y) || y>=(LIBGGI_GC(vis)->clipbr.y)) return 0;
	if (x< (LIBGGI_GC(vis)->cliptl.x)) {
		int diff=(LIBGGI_GC(vis)->cliptl.x)-x;
		x+=diff;
		width-=diff;
		buffer=((char *)buffer)+diff;
	}
	if (x+width>(LIBGGI_GC(vis)->clipbr.x)) {
		width=(LIBGGI_GC(vis)->clipbr.x)-x;
	}
	if (width>0) {
        gl_putbox(x, y, width, 1, buffer);
	}
	return 0;
}

int GGI_vgagl_gethline(ggi_visual *vis,int x,int y,int width,void *buffer)
{ 
	gl_getbox(x, y, width, 1, buffer);
	
	return 0;
}
