/* $Id: visual.c,v 1.32 1999/02/24 22:37:07 marcus Exp $
******************************************************************************

   AAlib target for GGI.

   Copyright (C) 1997 Andreas Beck    [becka@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdlib.h>

#include <ggi/internal/ggi-dl.h>
#include <ggi/display/aa.h>


void _GGI_aa_freedbs(ggi_visual *vis) {
	int i;

	for (i=LIBGGI_APPLIST(vis)->num-1; i >= 0; i--) {
		_ggi_db_free(LIBGGI_APPBUFS(vis)[i]);
		_ggi_db_del_buffer(LIBGGI_APPLIST(vis), i);
	}
}

int GGIdlinit(ggi_visual *vis,const char *args,void *argptr)
{
	struct AAhooks *priv;
	void *lock;

	GGIDPRINT_LIBS("display-aa: Starting\n");
	
	if ((lock = ggLockCreate()) == NULL) {
		return GGI_DL_ERROR;
	}

	priv = _ggi_malloc(sizeof(struct AAhooks));
	priv->aalock = lock;
	priv->context = 0;
	priv->lx = 0;
	priv->ly = 0;
	priv->lb = 0;
	priv->lastkey = 0;
	priv->lastkeyticks = 0;
	priv->haverelease = 0;
	priv->opmansync = _ggi_malloc(sizeof(_ggi_opmansync));
	
	/* Get options from environment variable AAOPTS */
	if (!aa_parseoptions(NULL, NULL, NULL, NULL)) {
		fprintf(stderr,
			"display-aa: warning: parsing AAOPTS failed\n");
	}

	if (!_ggiAddDL(vis, "helper-mansync", NULL, priv->opmansync, 0)) {
		fprintf(stderr, 
			"display-aa: Cannot load required helper-mansync!\n");
		free(priv->opmansync);
		free(priv);
		ggLockDestroy(lock);
		return GGI_DL_ERROR;
	}

	LIBGGI_PRIVATE(vis) = priv;

	MANSYNC_init(vis);

	LIBGGI_GC(vis) = _ggi_malloc(sizeof(ggi_gc));

	{
		gii_input *inp;
		GGIDPRINT_MISC("display-aa: gii starting\n");

		/* First allocate a new gii_input descriptor. */
		inp = _giiInputAlloc();
		if (inp == NULL) {
			GGIDPRINT_MISC("display-aa: _giiInputAlloc failed\n");
			GGIdlcleanup(vis);
			return GGI_DL_ERROR;
		}
		GGIDPRINT_MISC("display-aa: gii inp=%p\n",inp);

		/* Now fill in the blanks. */
		inp->priv = priv; /* We need that in GII_aa_poll() */

		inp->maxfd = 0;
		inp->flags = GII_FLAGS_HASPOLLED;

		/* What events _can_  we create at all ?
		   Save useless polling time. */
		inp->curreventmask = inp->targetcan = emKey |
			emPtrButtonPress | emPtrButtonRelease |	emPtrAbsolute ;

		/* We only need the "poll" function. For all others,
		   defaults are fine. */
		inp->GIIeventpoll = GII_aa_poll;

		/* Now join the new event source in. */
		vis->input = giiJoinInputs(vis->input,inp);
		
		GGIDPRINT_MISC("display-aa: input joined into %p\n",
			       vis->input);
	}

	/* Has mode management */
	vis->opdisplay->flush=GGI_aa_flush;
	vis->opdisplay->getmode=GGI_aa_getmode;
	vis->opdisplay->setmode=GGI_aa_setmode;
	vis->opdisplay->checkmode=GGI_aa_checkmode;
	vis->opdisplay->getapi =GGI_aa_getapi;
	vis->opdisplay->setflags=GGI_aa_setflags;

	return GGI_DL_OPDISPLAY;
}

int GGIdlcleanup(ggi_visual *vis)
{
	struct AAhooks *priv;

	MANSYNC_deinit(vis);

	_GGI_aa_freedbs(vis);

	/* FIXME !!!
	   How? //Marcus */
	if ((priv = LIBGGI_PRIVATE(vis)) != NULL) {
		if (priv->context) {
			aa_uninitmouse(priv->context);
			aa_uninitkbd(priv->context);
			aa_close(priv->context);
		}
		free(priv->opmansync);		
		ggLockDestroy(priv->aalock);
		free(LIBGGI_PRIVATE(vis));
	}
	if(vis->palette) free(vis->palette);
	free(LIBGGI_GC(vis));

	return 0;
}

#include <ggi/internal/ggidlinit.h>
