/* $Id: visual.c,v 1.18 1999/04/12 21:59:33 marcus Exp $
******************************************************************************

   Banked Access Graphics library for GGI.

   Copyright (C) 1995 Andreas Beck     [becka@ggi-project.org]
   Copyright (C) 1997 Jason McMullan   [jmcc@ggi-project.org]
   Copyright (C) 1997 Brian S. Julin   [bri@calyx.com]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/mman.h>
#include <asm/page.h>

#include <ggi/internal/ggi-dl.h>
#include <kgi/kgi_commands.h>

#ifndef MAP_FAILED
#define MAP_FAILED ((void*)-1)
#endif

#define BANKFB __localafb
#define BANKFB_LEN __localafb_len

/* 
 * We are guaranteed to have been checked already...
 */

#define BANK_PAGE_SIZE (32 * 1024) /* Later get from new ioctl */
#define MMAP_PAGE_SIZE ((PAGE_SIZE > BANK_PAGE_SIZE) ? PAGE_SIZE : BANK_PAGE_SIZE)

uint8 *__localrfb=NULL;  /* Read only bank */
uint8 *__localwfb=NULL;  /* Write-only bank */
uint8 *__localafb=NULL;  /* Bank that anticipate ascending access */
uint8 *__localdfb=NULL;  /* Bank that anticipates descending access */
static int __localafb_len;
static int __localdfb_len;
static int __localrfb_len;
static int __localwfb_len;

int GGIdlinit(ggi_visual *visual,const char *version,void *argptr)
{
  
  if (LIBGGI_MODE(visual)) {

    __localafb_len =
    __localdfb_len =
    __localrfb_len =
    __localwfb_len =
      (((LIBGGI_MODE(visual)->virt.x * LIBGGI_MODE(visual)->virt.y) 
		    & ~(MMAP_PAGE_SIZE - 1)) + MMAP_PAGE_SIZE);

    GGIDPRINT("afb is this big: %d\n",__localafb_len);
    GGIDPRINT("dfb is this big: %d\n",__localdfb_len);
    GGIDPRINT("rfb is this big: %d\n",__localrfb_len);
    GGIDPRINT("wfb is this big: %d\n",__localwfb_len);
  }
  else {
    printf("(fatal) NULL mode provided...\n");
    return(-1);
  };


  __localafb=(uint8 *)mmap(NULL,
				   __localafb_len,
				   PROT_READ | PROT_WRITE,
				   MAP_SHARED,
				   LIBGGI_FD(visual),
				   MMAP_TYPE_MMIO |
				   MMAP_PER_REGION_TYPE| 
				   MMAP_PRIVATE | 4);
  if ((long)(__localafb) == MAP_FAILED) { __localafb = (uint8 *)NULL; }; 


  __localdfb=(uint8 *)mmap(NULL,
				   __localdfb_len,
				   PROT_READ | PROT_WRITE,
				   MAP_SHARED,
				   LIBGGI_FD(visual),
				   MMAP_TYPE_MMIO |
				   MMAP_PER_REGION_TYPE| 
				   MMAP_PRIVATE | 8);
  if ((long)(__localdfb) == MAP_FAILED) { __localdfb = (uint8 *)NULL; }; 
  
  
  __localrfb=(uint8 *)mmap(NULL,
				   __localrfb_len,
				   PROT_READ,
				   MAP_SHARED,
				   LIBGGI_FD(visual),
				   MMAP_TYPE_MMIO |
				   MMAP_PER_REGION_TYPE| 
				   MMAP_PRIVATE | 16);
  if ((long)(__localrfb) == MAP_FAILED) { __localrfb = (uint8 *)NULL; }; 
  
  
  __localwfb=(uint8 *)mmap(NULL,
				   __localwfb_len,
				   PROT_WRITE,
				   MAP_SHARED,
				   LIBGGI_FD(visual),
				   MMAP_TYPE_MMIO |
				   MMAP_PER_REGION_TYPE| 
				   MMAP_PRIVATE | 32);
  if ((long)(__localwfb) == MAP_FAILED) { __localwfb = (uint8 *)NULL; }; 
  

  /* Now attempt make-do with whatever the graphics hardware provided. */
  if (!__localrfb) {
    /* Must provide Bank1 */
    if (!__localafb) { printf("No banks\n"); return(-1); };
    /* Use Ascending Bank in leiu of real RO bank, if it exists that is. */
    __localrfb = __localafb;
  }

  if (!__localwfb) {
    /* Must provide Bank1 */
    if (!__localafb) { printf("No banks\n"); return(-1); };
    /* Use Ascending Bank in leiu of real WO bank, if it exists that is. */
    __localwfb = __localafb;
  }

  if (!__localdfb) { 
    /* Must provide Ascending Bank */
    if (!__localafb) { printf("No banks\n"); return(-1); };
    __localdfb = __localafb;  /* This won't be used often if at all */
  } 
  
  
  GGIDPRINT("afb=%p, dfb=%p, rfb=%p, wfb=%p\n",
	 __localafb, __localdfb, __localrfb, __localwfb);

	/* Linear framebuffer setup */
	if (LIBGGI_CURWRITE(visual) != NULL) {
		munmap(LIBGGI_CURWRITE(visual), LIBGGI_FB_SIZE(LIBGGI_MODE(visual)));
	}
	LIBGGI_CURREAD(visual) = LIBGGI_CURWRITE(visual) = BANKFB;
/*	LIBGGI_FB_LINEAR_SIZE(visual) = BANKFB_LEN; */


	/* Generic drawing
	 */

	/* visual->opdraw->fillscreen=GGIfillscreen; */
        /* visual->opdraw->putc=GGIputc; */
        /* visual->opdraw->getcharsize=GGIgetcharsize; */

	visual->opdraw->drawpixel_nc=GGIdrawpixel_nc;
	visual->opdraw->drawpixel=GGIdrawpixel;
	visual->opdraw->putpixel_nc=GGIputpixel_nc;
	visual->opdraw->putpixel=GGIputpixel;
	visual->opdraw->getpixel=GGIgetpixel;
	
	visual->opdraw->drawhline_nc=GGIdrawhline_nc;
	visual->opdraw->drawhline=GGIdrawhline;
	visual->opdraw->puthline=GGIputhline;
	visual->opdraw->gethline=GGIgethline;

	visual->opdraw->drawvline_nc=GGIdrawvline_nc;
	visual->opdraw->drawvline=GGIdrawvline;
	visual->opdraw->putvline=GGIputvline;
	visual->opdraw->getvline=GGIgetvline;
	/*
	visual->opdraw->drawbox=GGIdrawbox; 
	visual->opdraw->putbox=GGIputbox;
	visual->opdraw->getbox=GGIgetbox;
	*/
	/*
	visual->opdraw->drawline=GGIdrawline;
	*/

	return GGI_DL_OPCOLOR|GGI_DL_OPDRAW;
}

int GGIdlcleanup(ggi_visual *visual)
{
	if (__localafb!=NULL) {
	  munmap((char *)__localafb,__localafb_len);
	};
	if (__localdfb!=NULL && __localdfb!=__localafb) {
	  munmap((char *)__localdfb,__localdfb_len);
	};
	if (__localrfb!=NULL && __localrfb!=__localafb) {
	  munmap((char *)__localrfb,__localrfb_len);
	};
	if (__localwfb!=NULL && __localwfb!=__localafb
	    && __localwfb!=__localdfb) {
	  munmap((char *)__localwfb,__localwfb_len); 
	};
	
	return 0;
}
		
#include <ggi/internal/ggidlinit.h>
