/* $Id: visual.c,v 1.6 1999/04/12 21:59:33 marcus Exp $
******************************************************************************

   LibGGI - kgicon specific overrides for fbcon
   Initialization

   Copyright (C) 1998 Marcus Sundberg	[marcus@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdlib.h>
#include "genkgi.h"


int GGIdlinit(ggi_visual *vis, const char *args, void *argptr)
{
	struct genkgi_priv *priv;
	
	priv = malloc(sizeof(struct genkgi_priv));
	if (priv == NULL) {
		return GGI_DL_ERROR;
	}

	priv->fd = LIBGGI_FD(vis);
		
	if ((priv->mapped_gc = (ggi_gc *) mmap(NULL, 4096,
					       PROT_READ|PROT_WRITE,
					       MAP_SHARED, priv->fd,
					       MMAP_TYPE_GC))
	    == MAP_FAILED) {
		/* Can't mmap() GC - assume we are not on a KGI driver */
		free(priv);
		return GGI_DL_ERROR;
	}

	GGIDPRINT_MISC("gengki: Mapped GC at %p\n", priv->mapped_gc);
	
	LIBGGI_GC(vis) = priv->mapped_gc;
	
	priv->drawline = vis->opdraw->drawline;
	priv->drawbox = vis->opdraw->drawbox;
	priv->copybox = vis->opdraw->copybox;
	priv->fillscreen = vis->opdraw->fillscreen;

	GENKGI_PRIV(vis) = priv;
	
	vis->opdraw->drawline = GGI_genkgi_drawline;
	vis->opdraw->drawbox = GGI_genkgi_drawbox;
	vis->opdraw->copybox = GGI_genkgi_copybox;
	vis->opdraw->fillscreen = GGI_genkgi_fillscreen;

	return GGI_DL_OPDRAW;
}

int GGIdlcleanup(ggi_visual *vis)
{
	munmap((void*) GENKGI_PRIV(vis)->mapped_gc, 4096);

	GGIDPRINT_MISC("gengki: Unmapped GC\n");
	
	free(GENKGI_PRIV(vis));
	GENKGI_PRIV(vis) = NULL;
                
	return 0;
}
		
#include <ggi/internal/ggidlinit.h>
