/* $Id: visual.c,v 1.5 1999/05/12 21:14:52 marcus Exp $
******************************************************************************

   LibGGI - fbdev mga2164w acceleration

   Copyright (C) 1999 Marcus Sundberg	[marcus@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include "m2164w.h"


static int m2164w_acquire(ggi_resource *res, uint32 actype)
{
	ggi_visual *vis;

	if (actype & ~(GGI_ACTYPE_READ | GGI_ACTYPE_WRITE)) {
		return GGI_EARGINVAL;
	}

	res->count++;
	res->curactype |= actype;
	if (res->count > 1) return 0;

	vis = res->priv;
	LIBGGIIdleAccel(vis);

	return 0;
}

static int m2164w_release(ggi_resource *res)
{
	if (res->count < 1) return GGI_ENOTALLOC;

	res->count--;
	if (res->count == 0) {
		res->curactype = 0;
	}

	return 0;
}

static int
m2164w_idleaccel(ggi_visual *vis)
{
	GGIDPRINT_DRAW("m2164w_idleaccel(%p) called \n", vis);

	mga_waitidle(FBDEV_PRIV(vis)->mmioaddr);
	
	vis->accelactive = 0;

	return 0;
}


int GGIdlinit(ggi_visual *vis, const char *args, void *argptr)
{
	struct fbdev_hook  *fbdevpriv = FBDEV_PRIV(vis);
	struct m2164w_priv *priv;
	int fd = LIBGGI_FD(vis);
	int i;

	if (GT_SIZE(LIBGGI_MODE(vis)->graphtype) % 8 != 0 ||
	    GT_SIZE(LIBGGI_MODE(vis)->graphtype) > 32 ||
	    GT_SIZE(LIBGGI_MODE(vis)->graphtype) < 8) {
		/* Unsupported mode */
		return GGI_DL_ERROR;
	}

	priv = malloc(sizeof(struct m2164w_priv));
	if (priv == NULL) {
		return GGI_DL_ERROR;
	}

	fbdevpriv->mmioaddr = mmap(NULL, fbdevpriv->orig_fix.mmio_len,
				   PROT_READ | PROT_WRITE, MAP_SHARED,
				   fd, fbdevpriv->orig_fix.smem_len);
	if (fbdevpriv->mmioaddr == MAP_FAILED) {
		/* Can't mmap() MMIO region - bail out */
		fbdevpriv->mmioaddr = NULL;
		free(priv);
		return GGI_DL_ERROR;
	}

	GGIDPRINT_MISC("mga-2164w: Mapped MMIO region at %p\n",
		       fbdevpriv->mmioaddr);

	/* Set up DirectBuffers */
	for (i=0; i < LIBGGI_MODE(vis)->frames; i++) {
		ggi_directbuffer *buf = LIBGGI_APPBUFS(vis)[i];
		ggi_resource *res;
		
		res = malloc(sizeof(ggi_resource));
		if (res == NULL) {
			GGIdlcleanup(vis);
			return GGI_DL_ERROR;
		}
		buf->resource = res;
		buf->resource->acquire = m2164w_acquire;
		buf->resource->release = m2164w_release;
		buf->resource->self = buf;
		buf->resource->priv = vis;
		buf->resource->count = 0;
		buf->resource->curactype = 0;
	}

	priv->drawboxcmd
		= BOP_COPY | SHFTZERO | SGNZERO | ARZERO | SOLID | OP_TRAP;
	if (GT_SIZE(LIBGGI_MODE(vis)->graphtype) != 24) {
		switch (fbdevpriv->orig_fix.accel) {	
		case FB_ACCEL_MATROX_MGA2064W:
		case FB_ACCEL_MATROX_MGA1064SG:
		case FB_ACCEL_MATROX_MGA2164W:
		case FB_ACCEL_MATROX_MGA2164W_AGP:
			/* Use block mode */
			priv->drawboxcmd |= ATYPE_BLK;
			break;
		default:
			/* For now - assume SDRAM for other cards */
			break;
		}
	}
	priv->oldfgcol = LIBGGI_GC(vis)->fg_color - 1;
	priv->oldtl.x = -1;
	priv->oldtl.y = -1;
	priv->oldbr.x = -1;
	priv->oldbr.y = -1;
	priv->oldyadd = -1;
	fbdevpriv->idleaccel = m2164w_idleaccel;

	M2164W_PRIV(vis) = priv;
	
	vis->opdraw->putc	= GGI_m2164w_putc;
	vis->opdraw->puts	= GGI_m2164w_puts;
	vis->opdraw->getcharsize= GGI_m2164w_getcharsize;
	vis->opdraw->drawhline = GGI_m2164w_drawhline;
	vis->opdraw->drawvline = GGI_m2164w_drawvline;
	vis->opdraw->drawline = GGI_m2164w_drawline;
	vis->opdraw->drawbox = GGI_m2164w_drawbox;
	vis->opdraw->copybox = GGI_m2164w_copybox;
	vis->opdraw->fillscreen = GGI_m2164w_fillscreen;

	return GGI_DL_OPDRAW;
}


int GGIdlcleanup(ggi_visual *vis)
{
	struct fbdev_hook  *fbdevpriv = FBDEV_PRIV(vis);

	munmap((void*)fbdevpriv->mmioaddr, fbdevpriv->orig_fix.mmio_len);

	GGIDPRINT_MISC("mga-2164w: Unmapped MMIO\n");
	
	free(M2164W_PRIV(vis));
	M2164W_PRIV(vis) = NULL;

	return 0;
}

#include <ggi/internal/ggidlinit.h>
