#!/bin/sh
#
# anytopnm - attempt to convert an unknown type of image file to a P?M file.
#
# Copyright 1998 Vectaport Inc.
# Copyright (C) 1991 by Jef Poskanzer.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies and that both that
# copyright notice and this permission notice appear in supporting
# documentation.  This software is provided "as is" without express or
# implied warranty.

if [ ! $# = 1 ] ; then
    echo "usage: $0 <file>" 1>&2
    exit 1
fi

origfile="$1"
file="$origfile"
tmpfiles=""

while true ; do

    filetype=`file "$file"`

    case "$filetype" in

	*PBM* | *PGM* | *PPM* )
	cat "$file"
	break
	;;

	*compress* )
	newfile="/tmp/atn.comp.$origfile"
	rm -f "$newfile"
	zcat < "$file" > "$newfile"
	file="$newfile"
	tmpfiles="$tmpfiles $newfile"
	;;

	*btoa* )
	newfile="/tmp/atn.btoa.$origfile"
	rm -f "$newfile"
	atob < "$file" > "$newfile"
	file="$newfile"
	tmpfiles="$tmpfiles $newfile"
	;;

	*Sun* | *rasterfile* )
	rasttopnm "$file"
	break
	;;

	*GIF* )
	giftopnm "$file"
	break
	;;

	*TIFF* )
	tifftopnm "$file"
	break
	;;

	*IFF*ILBM* )
	ilbmtoppm "$file"
	break
	;;

	*Lisp* )
	lispmtopgm "$file"
	break
	;;

	*PC*Paintbrush* )
	pcxtoppm "$file"
	break
	;;

	*Bennet* )
	ybmtopbm "$file"
	break
	;;

	*JPEG* )
	cmapfile=`tmpnam`
	stdcmapppm >$cmapfile
	djpeg -map $cmapfile -dither fs -pnm "$file"
	rm $cmapfile
	break
	;;

	*PC*bitmap*data* )
	bmptoppm "$file"
	break
	;;

	*PPM*rawbits* )
	cat "$file"
	break
	;;

	*PGM*rawbits* )
	cat "$file"
	break
	;;

	*PBM*rawbits* )
	cat "$file"
	break
	;;

	*PPM*image* )
	cat "$file"
	break
	;;

	*PGM*image* )
	cat "$file"
	break
	;;

	*PBM*image* )
	cat "$file"
	break
	;;

	* )
	# Can't figure out the file type from the magic number,
	# try the extension.
	case "$file" in

	    *.pbm | *.pbm.* | *.pgm | *.pgm.* | *.ppm | *.ppm.* )
	    cat "$file"
	    ;;
	    *.x | *.x.* | *.xbm | *.xbm.* | *.x10bm | *.x10bm.* | *.x11bm | *.x11bm.* | *.bitmap | *.bitmap.* )
	    xbmtopbm "$file"
	    ;;
	    *.r | *.r.* | *.rast | *.rast.* )
	    rasttopnm "$file"
	    ;;
	    *.mac | *.mac.* | *.macp | *.macp.* )
	    macptopbm "$file"
	    ;;
	    *.g3 | *.g3.* | *.fax | *.fax.* )
	    g3topbm "$file"
	    ;;
	    *.xwd | *.xwd.* | *.x10wd | *.x10wd.* | *.x11wd | *.x11wd.* )
	    xwdtopnm "$file"
	    ;;
	    *.brush | *.brush.* )
	    brushtopbm "$file"
	    ;;
	    *.img | *.img.* )
	    gemtopbm "$file"
	    ;;
	    *.pcx | *.pcx.* )
	    pcxtoppm "$file"
	    ;;
	    *.pic | *.pic.* | *.pict | *.pict.* | *.pict2 | *.pict2.* )
	    picttoppm "$file"
	    ;;
	    *.tif | *.tif.* | *.tiff | *.tiff.* )
	    tifftopnm "$file"
	    ;;
	    *.fs | *.fs.* | *.face | *.face.* )
	    fstopgm "$file"
	    ;;
	    *.hips | *.hips.* )
	    hipstopgm "$file"
	    ;;
	    *.fits | *.fits.* )
	    fitstopgm "$file"
	    ;;
	    *.gif | *.gif.* )
	    giftoppm "$file"
	    ;;
	    *.iff | *.iff.* | *.ilbm | *.ilbm.* )
	    ilbmtoppm "$file"
	    ;;
	    *.lispm | *.lispm.* )
	    lispmtopgm "$file"
	    ;;
	    *.mtv | *.mtv.* )
	    mtvtoppm "$file"
	    ;;
	    *.qrt | *.qrt.* )
	    qrttoppm "$file"
	    ;;
	    *.tga | *.tga.* | *.targa | *.targa.* )
	    tgatoppm "$file"
	    ;;
	    *.xim | *.xim.* )
	    ximtoppm "$file"
	    ;;
	    *.xpm | *.xpm.* | *.xpm2 | *.xpm2.* )
	    xpmtoppm "$file"
	    ;;
	    *.pi1 | *.pi1.* )
	    pi1toppm "$file"
	    ;;
	    *.pi3 | *.pi3.* )
	    pi3topbm "$file"
	    ;;
	    *.spu | *.spu.* )
	    sputoppm "$file"
	    ;;
	    *.spc | *.spc.* )
	    spctoppm "$file"
	    ;;
	    *.ybm | *.ybm.* | *.face | *.face.* )
	    ybmtopbm "$file"
	    ;;
	    * )
	    echo "$0: unknown file type" 1>&2
	    exit 1
	    ;;

	esac
	break
	;;

    esac

done

if [ "$tmpfiles" ] ; then
    rm -f $tmpfiles
fi
exit 0
