'\"
'\" Copyright 1991-1997 by Bell Labs Innovations for Lucent Technologies.
'\"
'\" Permission to use, copy, modify, and distribute this software and its
'\" documentation for any purpose and without fee is hereby granted, provided
'\" that the above copyright notice appear in all copies and that both that the
'\" copyright notice and warranty disclaimer appear in supporting documentation,
'\" and that the names of Lucent Technologies any of their entities not be used
'\" in advertising or publicity pertaining to distribution of the software
'\" without specific, written prior permission.
'\"
'\" Lucent Technologies disclaims all warranties with regard to this software,
'\" including all implied warranties of merchantability and fitness.  In no event
'\" shall Lucent Technologies be liable for any special, indirect or
'\" consequential damages or any damages whatsoever resulting from loss of use,
'\" data or profits, whether in an action of contract, negligence or other
'\" tortuous action, arising out of or in connection with the use or performance
'\" of this software.  
'\"
'\" Spline command created by George Howlett.
'\"
.so man.macros
.HS spline BLT
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
spline \-  Fit curves with spline interpolation
.SH SYNOPSIS
.sp
\fBspline natural \fIx y sx sy\fR
.sp
\fBspline quadratic \fIx y sx sy\fR
.BE
.SH DESCRIPTION
The \fBspline\fR command computes a spline fitting a set of data
points (x and y vectors) and produces a vector of the interpolated
images (y-coordinates) at a given set of x-coordinates.
.SH INTRODUCTION
Curve fitting has many applications.  In graphs, curve fitting can
be useful for displaying curves which are aesthetically pleasing to the
eye.  Another advantage is that you can quickly generate arbitrary points 
on the curve from a small set of data points.
.PP
A spline is a device used in drafting to produce smoothed curves.  The
points of the curve, known as \fIknots\fR, are fixed and the
\fIspline\fR, typically a thin strip of wood or metal, is bent around
the knots to create the smoothed curve.  Spline interpolation is the
mathematical equivalent.  The curves between adjacent knots are
piecewise functions such that the resulting spline runs exactly
through all the knots.  The order and coefficients of the polynominal
determine the "looseness" or "tightness" of the curve fit from the
line segments formed by the knots.
.PP
The \fBspline\fR command performs spline interpolation using cubic
("natural") or quadratic polynomial functions.  It computes the spline
based upon the knots, which are given as x and y vectors.  The
interpolated new points are determined by another vector which
represents the abscissas (x-coordinates) or the new points.  The
ordinates (y-coordinates) are interpolated using the spline and 
written to another vector.
.SH EXAMPLE
Before we can use the \fBspline\fR command, we need to create two BLT
vectors which will represent the knots (x and y coordinates) of the
data that we're going to fit.  Obviously, both vectors must be the
same length.
.DS
# Create sample data of ten points. 
vector x(10) y(10)

for {set i 10} {$i > 0} {incr i -1} {
    set x($i-1) [expr $i*$i]
    set y($i-1) [expr sin($i*$i*$i)]
}
.DE
We now have two vectors \f(CWx\fR and \f(CWy\fR representing the ten data
points we're trying to fit.  The order of the values of \f(CWx\fR must
be monotonically increasing.  We can use the vector's \fBsort\fR operation 
to sort the vectors.
.DS
x sort y
.DE
The components of \f(CWx\fR are sorted in increasing order.  The
components of \f(CWy\fR are rearranged so that the original x,y
coordinate pairings are retained.
.PP
A third vector is needed to indicate the abscissas (x-coordinates) of
the new points to be interpolated by the spline.  Like the x vector,
the vector of abscissas must be monotonically increasing.  All the
abscissas must lie between the first and last knots (x vector)
forming the spline.
.PP
How the abscissas are picked is arbitrary.  But if we are going to
plot the spline, we will want to include the knots too.  Since both
the quadratic and natural splines preserve the knots (an abscissa from
the x vector will always produce the corresponding ordinate from the y
vector), we can simply make the new vector a superset of \f(CWx\fR.
It will contain the same coordinates as \f(CWx\fR, but also the
abscissas of the new points we want interpolated.  A simple way is to
use the vector's \fBpopulate\fR operation.
.DS
x populate sx 10
.DE
This creates a new vector \f(CWsx\fR.  It contains the abscissas of
\f(CWx\fR, but in addition \f(CWsx\fR will have ten evenly distributed
values between each abscissa.  You can interpolate any points you
wish, simply by setting the vector values.
.PP
Finally, we generate the ordinates (the images of the spline) using
the \fBspline\fR command.  The ordinates are stored in a fourth
vector.
.DS
spline natural x y sx sy
.DE
This creates a new vector \f(CWsy\fR.  It will have the same length as
\f(CWsx\fR.  The vectors \f(CWsx\fR and \f(CWsy\fR represent the smoothed
curve which we can now plot.
.DS 
graph .graph
\&.graph element create original -x x -y x -color blue
\&.graph element create spline -x sx -y sy -color red
table . .graph
.DE
The \fBnatural\fR operation employs a cubic interpolant when forming
the spline.  In terms of the draftmen's spline, a \fInatural spline\fR
requires the least amount of energy to bend the spline (strip of
wood), while still passing through each knot.  In mathematical terms,
the second derivatives of the first and last points are zero.
.PP
Alternatively, you can generate a spline using the \fBquadratic\fR
operation.  Quadratic interpolation produces a spline which follows 
the line segments of the data points much more closely.  
.DS
spline quadratic x y sx sy 
.DE
.SH OPERATIONS
.TP
\fBspline natural \fIx y sx sy\fR 
Computes a cubic spline from the data points represented by the
vectors \fIx\fR and \fIy\fR and interpolates new points using vector
\fIsx\fR as the x-coordinates.  The resulting y-coordinates are
written to a new vector \fIsy\fR. The vectors \fIx\fR and \fIy\fR must
be the same length and contain at least three components.  The order
of the components of \fIx\fR must be monotonically increasing.
\fISx\fR is the vector containing the x-coordinates of the points to
be interpolated.  No component of \fIsx\fR can be less than first
component of \fIx\fR or greater than the last component.  The order
of the components of \fIsx\fR must be monotonically increasing.
\fISy\fR is the name of the vector where the calculated y-coordinates
will be stored.  If \fIsy\fR does not already exist, a new vector will be
created.
.TP
\fBspline quadratic \fIx y sx sy\fR 
Computes a quadratic spline from the data points represented by the
vectors \fIx\fR and \fIy\fR and interpolates new points using vector
\fIsx\fR as the x-coordinates.  The resulting y-coordinates are
written to a new vector \fIsy\fR.  The vectors \fIx\fR and \fIy\fR must
be the same length and contain at least three components.  The order
of the components of \fIx\fR must be monotonically increasing.
\fISx\fR is the vector containing the x-coordinates of the points to
be interpolated. No component of \fIsx\fR can be less than first
component of \fIx\fR or greater than the last component.  The order of
the components of \fIsx\fR must be monotonically increasing.  \fISy\fR
is the name of the vector where the calculated y-coordinates are
stored.  If \fIsy\fR does not already exist, a new vector will be
created.
.SH REFERENCES
.nf
.sp
Numerical Analysis
by R. Burden, J. Faires and A. Reynolds.	
Prindle, Weber & Schmidt, 1981, pp. 112
.sp
Shape Preserving Quadratic Splines 
by D.F.Mcallister & J.A.Roulier
Coded by S.L.Dodd & M.Roulier N.C.State University.
.sp
.fi
The original code for the quadratric spline can be found in TOMS #574.
.SH KEYWORDS
spline, vector, graph

