#include "Python.h"
#include <orb/orbit.h>

/*#define checkCORBA(ev) \
  if (ev._major != CORBA_NO_EXCEPTION) {\
  fprintf(stderr, "Exception: %s\n", CORBA_exception_id(&(ev)));\
  }*/

/* the CORBA_exception_init bit is a bit of a hack -- it should be performed
 * by each routine before they run anything */
#define checkCORBA(ev) \
  if (ev._major != CORBA_NO_EXCEPTION) { \
    PyErr_SetString(ErrorObject, CORBA_exception_id(&(ev))); \
    CORBA_exception_init(&(ev)); \
    return NULL; \
  }

static PyObject *ErrorObject;
static PyObject *ModuleDict;

/* Begin InterfaceDef object */

static PyObject *ErrorObject;

typedef struct {
	PyObject_HEAD
	CORBA_InterfaceDef	ob;
	CORBA_Environment	ev;
} InterfaceDefObject;

staticforward PyTypeObject InterfaceDef_Type;

#define InterfaceDefObject_Check(v)	((v)->ob_type == &InterfaceDef_Type)

static InterfaceDefObject *
InterfaceDef2Object(
	CORBA_InterfaceDef object
) {
	InterfaceDefObject *self;

	self = PyObject_NEW(InterfaceDefObject, &InterfaceDef_Type);
	if (self == NULL)
		return NULL;
	/* ORBit stuff */
	CORBA_exception_init(&(self->ev));
	self->ob = object;
	return self;
}

static void
InterfaceDef_dealloc(self)
	InterfaceDefObject *self;
{
	PyMem_DEL(self);
	/* XXX corba free */
}

static PyObject *
InterfaceDef_describe_interface(self, args)
	InterfaceDefObject *self;
	PyObject *args;
{
	CORBA_InterfaceDef_FullInterfaceDescription *desc;
	PyObject	*retList, *item;

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	desc = CORBA_InterfaceDef_describe_interface(self->ob, &(self->ev));
	checkCORBA(self->ev);
	/* XXX check exception */
	if (desc == CORBA_OBJECT_NIL) {
	  Py_INCREF(Py_None);
	  return Py_None;
	}
	return Py_BuildValue("(sss)",
			     (const char *)desc->name,
			     (const char *)desc->id,
			     (const char *)desc->version);
	/*
	  retList = PyTuple_New(3);
	item = PyString_FromString((const char *) desc->name);
	/ * XXX Check exception * /
	PyTuple_SetItem(retList, 0, item);
	/ * XXX Check exception * /
	item = PyString_FromString((const char *) desc->id);
	/ * XXX Check exception * /
	PyTuple_SetItem(retList, 1, item);
	/ * XXX Check exception * /
	item = PyString_FromString((const char *) desc->version);
	/ * XXX Check exception * /
	PyTuple_SetItem(retList, 2, item);
	/ * XXX Check exception * /
	/ * for (x = 0; x < (int) theList->_length; x++) { * /
	return (retList); */
}

static PyMethodDef InterfaceDef_methods[] = {
	{"describe_interface",	(PyCFunction)InterfaceDef_describe_interface,	1},
	{NULL,		NULL}		/* sentinel */
};

static PyObject *
InterfaceDef_getattr(self, name)
	InterfaceDefObject *self;
	char *name;
{
	return Py_FindMethod(InterfaceDef_methods, (PyObject *)self, name);
}

static int
InterfaceDef_setattr(self, name, v)
	InterfaceDefObject *self;
	char *name;
	PyObject *v;
{
	return -1;
}

statichere PyTypeObject InterfaceDef_Type = {
	/* The ob_type field must be initialized in the module init function
	 * to be portable to Windows without using C++. */
	PyObject_HEAD_INIT(NULL)
	0,			/*ob_size*/
	"InterfaceDef",			/*tp_name*/
	sizeof(InterfaceDefObject),	/*tp_basicsize*/
	0,			/*tp_itemsize*/
	/* methods */
	(destructor)InterfaceDef_dealloc, /*tp_dealloc*/
	0,			/*tp_print*/
	(getattrfunc)InterfaceDef_getattr, /*tp_getattr*/
	(setattrfunc)InterfaceDef_setattr, /*tp_setattr*/
	0,			/*tp_compare*/
	0,			/*tp_repr*/
	0,			/*tp_as_number*/
	0,			/*tp_as_sequence*/
	0,			/*tp_as_mapping*/
	0,			/*tp_hash*/
};

/* End InterfaceDef object */

/* Begin CORBA.Object */

typedef struct {
	PyObject_HEAD
	CORBA_Object	ob;
	CORBA_Environment	ev;
} ObjectObject;

staticforward PyTypeObject Object_Type;

#define ObjectObject_Check(v)	((v)->ob_type == &Object_Type)

static ObjectObject *
Object2Object(
	CORBA_Object object
) {
	ObjectObject *self;
	PyTypeObject *type;

	if (object == NULL) {
fprintf(stderr, "object2object: Null object\n");
		return NULL;
	}
	type = (PyTypeObject *) PyDict_GetItemString(ModuleDict, object->object_id);
	if (type != NULL) {
	} else {
		/* XXX clear exception */
		type = &Object_Type;
	}
	self = PyObject_NEW(ObjectObject, type);
	if (self == NULL)
		return NULL;
	/* ORBit stuff */
	CORBA_exception_init(&(self->ev));
	self->ob = object;
	return self;
}

static ObjectObject *
Object2Object_old(
	CORBA_Object object
) {
	ObjectObject *self;
	PyTypeObject *type;

	if (object == NULL) {
		return NULL;
	}
	self = PyObject_NEW(ObjectObject, &Object_Type);
	if (self == NULL)
		return NULL;
	/* ORBit stuff */
	CORBA_exception_init(&(self->ev));
	self->ob = object;
	return self;
}

static void
Object_dealloc(
	ObjectObject *self
) {
	/* XXX free Object? */
	PyMem_DEL(self);
}

static PyObject *
Object_get_interface(
	ObjectObject *self,
	PyObject *args
) {
	CORBA_InterfaceDef def;

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	def = CORBA_Object_get_interface(self->ob, &(self->ev));
	checkCORBA(self->ev);
	/* XXX check exception */

	if (def == CORBA_OBJECT_NIL) {
	  Py_INCREF(Py_None);
	  return Py_None;
	}
	return (PyObject *)InterfaceDef2Object(def);
}

static PyObject *
Object_is_nil(
	ObjectObject *self,
	PyObject *args
) {
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (CORBA_Object_is_nil(self->ob, &(self->ev))) {
		Py_INCREF(Py_True);
		return Py_True;
	} else {
		Py_INCREF(Py_False);
		return Py_False;
	}
}

static PyMethodDef Object_methods[] = {
	{"is_nil",	(PyCFunction)Object_is_nil,	1},
	{"get_interface",	(PyCFunction)Object_get_interface,	1},
	{NULL,		NULL}		/* sentinel */
};

static PyObject *
Object_getattr(
	ObjectObject *self,
	char *name 
) {
	return Py_FindMethod(Object_methods, (PyObject *)self, name);
}

static int
Object_setattr(self, name, v)
	ObjectObject *self;
	char *name;
	PyObject *v;
{
	return -1;
}

statichere PyTypeObject Object_Type = {
	/* The ob_type field must be initialized in the module init function
	 * to be portable to Windows without using C++. */
	PyObject_HEAD_INIT(NULL)
	0,			/*ob_size*/
	"CORBA.Object",			/*tp_name*/
	sizeof(ObjectObject),	/*tp_basicsize*/
	0,			/*tp_itemsize*/
	/* methods */
	(destructor)Object_dealloc, /*tp_dealloc*/
	0,			/*tp_print*/
	(getattrfunc)Object_getattr, /*tp_getattr*/
	(setattrfunc)Object_setattr, /*tp_setattr*/
	0,			/*tp_compare*/
	0,			/*tp_repr*/
	0,			/*tp_as_number*/
	0,			/*tp_as_sequence*/
	0,			/*tp_as_mapping*/
	0,			/*tp_hash*/
};

/* End CORBA.Object */

/* Begin CORBA.ORB */

typedef struct {
	PyObject_HEAD
	CORBA_ORB	ob;
	CORBA_Environment	ev;
} ORBObject;

staticforward PyTypeObject ORB_Type;

#define ORBObject_Check(v)	((v)->ob_type == &ORB_Type)

int argv_convert(
	PyObject	*arglist,
	int		*init_argc,
	char	***init_argv
) {
	PyObject	*item;
	PyTypeObject	*list_type;
	int 	x;
	list_type = arglist->ob_type;
	if (list_type == NULL)
		return 0; /* should this be -1 or 0 (was originally NULL) -JB */
	if (PySequence_Check(arglist)) {
		*init_argc = PySequence_Length(arglist);
		*init_argv = (char **) calloc((*init_argc)+1, sizeof(char*));
		for(x=0; x < *init_argc; x++) {
			item = PyObject_Str(PySequence_GetItem(arglist, x));
			if (item == NULL)
				goto argv_convert_cleanup;
			(*init_argv)[x] = strdup(PyString_AsString(item));
			Py_DECREF(item);
		}
	} else {
		PyErr_SetString(PyExc_TypeError,"Argument must be a sequence");
		return -1;
	}
	(*init_argv)[*init_argc] = NULL;
	return (*init_argc);
argv_convert_cleanup:
	argv_free(*init_argc, *init_argv);
	return (-1);
}

argv_free(
	int		argc,
	char	**argv
) {
	int x;

	for (x = 0; x < argc; x++) {
		if (argv[x] != NULL) {
			free(argv[x]);
		}
	}
	free(argv);
}


static ORBObject *
newORBObject(
	PyObject *arg
) {
	ORBObject *self;
	char	*orb_id;
	PyObject	*arglist = NULL;
	static char	**init_argv;
	static int	init_argc;

	if (!PyArg_ParseTuple(arg, "Os", &arglist, &orb_id))
		return NULL;
	if (argv_convert(arglist, &init_argc, &init_argv) == -1)
		return NULL;
	self = PyObject_NEW(ORBObject, &ORB_Type);
	if (self == NULL)
		return NULL;
	/* ORBit stuff */
	CORBA_exception_init(&(self->ev));
	self->ob = CORBA_ORB_init(&init_argc, init_argv, orb_id, &(self->ev));
	checkCORBA(self->ev);
	/* XXX Check exception? */
	/*argv_free(init_argc, init_argv);*/
	return self;
}

/* ORB methods */

static void
ORB_dealloc(
	ORBObject *self
) {
	PyMem_DEL(self);
	/* XXX free ORB? */
}

static PyObject *
ORB_list_initial_services(
	ORBObject *self,
	PyObject *args
) {
	CORBA_ORB_ObjectIdList *theList;
	PyObject	*retList, *item;
	int x;

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	theList = CORBA_ORB_list_initial_services(self->ob, &(self->ev));
	checkCORBA(self->ev);
	/* XXX Check exception */
	retList = PyTuple_New((int) theList->_length); /* XXX good cast? */
	for (x = 0; x < (int) theList->_length; x++) {
		item = PyString_FromString((const char *) theList->_buffer[x]);
		/* XXX Check exception */
		PyTuple_SetItem(retList, x, item);
		/* XXX Check exception */
		/* Py_DECREF(item); */
	}
	/* XXX free theList? */
	return (retList);
}

static PyObject *
ORB_resolve_initial_references(
	ORBObject *self,
	PyObject *args
) {
	CORBA_Object ntvObject;
	ObjectObject *wrapObject;
	char *id;

	if (!PyArg_ParseTuple(args, "s", &id))
		return NULL;
	ntvObject = CORBA_ORB_resolve_initial_references(self->ob, id, &(self->ev));
	checkCORBA(self->ev);
	if (ntvObject == CORBA_OBJECT_NIL) {
	  Py_INCREF(Py_None);
	  return Py_None;
	}
	wrapObject = Object2Object(ntvObject);
	return (PyObject *)wrapObject;
}

static PyObject *
ORB_object_to_string(
	ORBObject *self,
	PyObject *args
) {
	ObjectObject *obj;
	char *string;
	if (!PyArg_ParseTuple(args, "O", &obj))
		return NULL;
	/* XXX Check object somehow */
	string = CORBA_ORB_object_to_string(self->ob, obj->ob, &(self->ev));
	checkCORBA(self->ev);
	/* XXX Check exception */
	return PyString_FromString(string);
}

static PyObject *
ORB_string_to_object(
	ORBObject *self,
	PyObject *args
) {
	CORBA_Object obj;
	char *string;
	if (!PyArg_ParseTuple(args, "s", &string))
		return NULL;
	/* XXX Check object somehow */
	obj = CORBA_ORB_string_to_object(self->ob, string, &(self->ev));
	checkCORBA(self->ev);
	/* XXX Check exception */
	if (obj == CORBA_OBJECT_NIL) {
	  Py_INCREF(Py_None);
	  return Py_None;
	}
	return ((PyObject *) Object2Object(obj));
}
static PyObject *
ORB_run(
	ORBObject *self,
	PyObject *args
) {
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	CORBA_ORB_run(self->ob, &(self->ev));
	checkCORBA(self->ev);
	/* XXX Check exception */
	Py_INCREF(Py_None);
	return (Py_None);
}

static PyMethodDef ORB_methods[] = {
	{"list_initial_services",	(PyCFunction)ORB_list_initial_services,	1},
	{"resolve_initial_references",	(PyCFunction)ORB_resolve_initial_references,	1},
	{"object_to_string",	(PyCFunction)ORB_object_to_string,	1},
	{"string_to_object",	(PyCFunction)ORB_string_to_object,	1},
	{"run",	(PyCFunction)ORB_run,	1},
	{NULL,		NULL}		/* sentinel */
};

static PyObject *
ORB_getattr(
	ORBObject *self,
	char *name 
) {
	return Py_FindMethod(ORB_methods, (PyObject *)self, name);
}

static int
ORB_setattr(self, name, v)
	ORBObject *self;
	char *name;
	PyObject *v;
{
	return -1;
}

statichere PyTypeObject ORB_Type = {
	/* The ob_type field must be initialized in the module init function
	 * to be portable to Windows without using C++. */
	PyObject_HEAD_INIT(NULL)
	0,			/*ob_size*/
	"CORBA.ORB",			/*tp_name*/
	sizeof(ORBObject),	/*tp_basicsize*/
	0,			/*tp_itemsize*/
	/* methods */
	(destructor)ORB_dealloc, /*tp_dealloc*/
	0,			/*tp_print*/
	(getattrfunc)ORB_getattr, /*tp_getattr*/
	(setattrfunc)ORB_setattr, /*tp_setattr*/
	0,			/*tp_compare*/
	0,			/*tp_repr*/
	0,			/*tp_as_number*/
	0,			/*tp_as_sequence*/
	0,			/*tp_as_mapping*/
	0,			/*tp_hash*/
};

/* End CORBA.ORB */

static PyObject *
ORB_init(
	PyObject *self, /* Not used */
	PyObject *args
) {
	ORBObject *orb;
	
	orb = newORBObject(args);
	if (orb == NULL)
	    return NULL;
	return (PyObject *)orb;
}

static PyObject *
Object_cast(
	PyObject	*self,
	PyObject	*args
) {
	PyObject	*object;
	if (!PyArg_ParseTuple(args, "O", &object))
		return NULL;
	return ((PyObject *) Object2Object_old(((ObjectObject *) object)->ob));
}


/* List of functions defined in the module */

static PyMethodDef CORBA_methods[] = {
	{"ORB_init",		ORB_init,		1},
	{"Object_cast",		Object_cast,		1},
	{NULL,		NULL}		/* sentinel */
};

#ifndef DL_EXPORT
#define DL_EXPORT(x) x
#endif

DL_EXPORT(void)
initCORBA()
{
	PyObject *m;

	/* Initialize the type of the new type object here; doing it here
	 * is required for portability to Windows without requiring C++. */
	ORB_Type.ob_type = &PyType_Type;
	Object_Type.ob_type = &PyType_Type;
	InterfaceDef_Type.ob_type = &PyType_Type;

	/* Create the module and add the functions */
	m = Py_InitModule("CORBA", CORBA_methods);

	/* Add some symbolic constants to the module */
	ModuleDict = PyModule_GetDict(m);
	ErrorObject = PyErr_NewException("CORBA.error", NULL, NULL);
	PyDict_SetItemString(ModuleDict, "error", ErrorObject);
}
