/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1995  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.14 of 01-November-95
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	sunsite.unc.edu:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	ftp.cygnus.com:/pub/forth/pfe-VERSION.tar.gz
 *
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * term-emx.c ---     Terminal driver for DOS and OS/2 with EMX,
 *                      there is almost nothing to do.
 * (duz 24Feb94)
 */

#include "forth.h"
#include "term.h"

#include <stdlib.h>		/* _read_kbd() */
#include <sys/video.h>		/* all those v_...() functions */

#include "missing.h"

char *
  rawkey_string[NO_OF_KEYS] =	/* what function keys send */
{
  "\377;", "\377<", "\377=", "\377>", "\377?",
  "\377@", "\377A", "\377B", "\377C", "\377D",
  "\377T", "\377U", "\377V", "\377W", "\377X",
  "\377Y", "\377Z", "\377[", "\377\\", "\377]",
  "\377K", "\377M", "\377H", "\377P",
  "\377G", "\377O", "\377Q", "\377I",
  NULL, "\377S", NULL, "\377R",
  NULL, NULL, NULL, NULL,	/*"\r" */
};

/* *INDENT-OFF* */
int tty_interrupt_key (char ch)		{ return 0; }
void interactive_terminal (void)	{ v_init (); }
void system_terminal (void)		{}
void query_winsize (void)		{}
/* *INDENT-ON* */

int
prepare_terminal (void)
{
  v_init ();
  v_dimen (&cols, &rows);
  return 1;
}

#define NOCH 0x789ABCDE
static int nxch = NOCH;

int
c_keypressed (void)
{
  int c;

  if (nxch != NOCH)
    return 1;
  c = _read_kbd (0, 0, 0);
  if (c == -1)
    return 0;
  nxch = c;
  return 1;
}

static int
getch0 (void)
{
  if (nxch != NOCH)
    {
      int ch = nxch;

      nxch = NOCH;
      return ch;
    }
  for (;;)
    {
      int c = _read_kbd (0, 1, 0);

      if (c != -1)
	return c;
    }
}

int				/* return '\377' instead of DOS' '\0' */
c_getkey (void)			/* for function keys. */
{
  int c = getch0 ();

  return c == 0 ? '\377' : c;
}

void
c_putc_noflush (char c)
{
  int x, y;

  switch (c)			/* v_putc doesn't interpret some */
    {				/* very common control codes */
    case '\r':
      v_getxy (&x, &y);
      v_gotoxy (0, y);
      break;
    case '\b':
      c_goleft ();
      break;
    case '\t':
      do
      {
	v_putc (' ');
	v_getxy (&x, &y);
      }
      while (x % 8);
      break;
    default:
      v_putc (c);
    }
}

void 
c_flush (void)
{
}

void
c_putc (char c)
{
  c_putc_noflush (c);
}

void
c_puts (const char *s)
{
  while (*s)
    c_putc_noflush (*s++);
}

void 
c_gotoxy (int x, int y)
{
  v_gotoxy (x, y);
}
void 
c_wherexy (int *x, int *y)
{
  v_getxy (x, y);
}

static void			/* move cursor in x and y */
addxy (int x, int y)
{
  int col, row;

  v_getxy (&col, &row);
  col += x;
  row += y;
  v_gotoxy (col, row);
}

/* *INDENT-OFF* */
void c_goleft (void)		{ addxy (-1,  0); }
void c_goright (void)		{ addxy ( 1,  0); }
void c_goup (void)		{ addxy ( 0, -1); }
void c_godown (void)		{ addxy ( 0,  1); }

#if 0
void c_clrscr (void)		{ v_clear (); }
#else
void c_clrscr (void)		{ c_home (); c_clrdown (); }
#endif
void c_home (void)		{ v_gotoxy (0, 0); }
void c_clreol (void)		{ v_clreol (); }
/* *INDENT-ON* */

void
c_clrdown (void)
{
  int i, row, col;

  v_getxy (&col, &row);
  v_clreol ();
  for (i = row + 1; i < rows; i++)
    {
      v_gotoxy (0, i);
      v_clreol ();
    }
  v_gotoxy (col, row);
}
/* *INDENT-OFF* */
void c_bell (void)		{ putchar ('\a'); }

void c_standout_on (void)	{ v_attrib (v_getattr () | INTENSITY); }
void c_standout_off (void)	{ v_attrib (v_getattr () & ~INTENSITY); }
void c_bright (void)		{ c_standout_on (); }
void c_reverse (void)		{ v_attrib (BW_REVERSE); }
void c_blinking (void)		{ v_attrib (v_getattr () | BLINK); }
void c_normal (void)		{ v_attrib (BW_NORMAL); }
void c_underline_on (void)	{ v_attrib (BW_UNDERLINE); }
void c_underline_off (void)	{ v_attrib (BW_NORMAL); }
