#include "global.h"

/*
 * Container
 */
static VALUE
cont_set_bwidth(self, width)
    VALUE self, width;
{
    gtk_container_border_width(GTK_CONTAINER(get_widget(self)),
			       NUM2INT(width));
    return self;
}

static VALUE
cont_get_bwidth(self)
    VALUE self;
{
    return INT2NUM(GTK_CONTAINER(get_widget(self))->border_width);
}

static VALUE
cont_bwidth(argc, argv, self)
    int argc;
    VALUE *argv, self;
{
    VALUE width;
    rb_scan_args(argc, argv, "01", &width);

    return NIL_P(width)
	? cont_get_bwidth(self)
	: cont_set_bwidth(self, width);
}

static VALUE
cont_add(self, other)
    VALUE self, other;
{
    gtk_container_add(GTK_CONTAINER(get_widget(self)), get_widget(other));
    return self;
}

static VALUE
cont_remove(self, other)
    VALUE self, other;
{
    gtk_container_remove(GTK_CONTAINER(get_widget(self)), get_widget(other));
    return self;
}
/* 1.2.x
static VALUE
cont_disable_resize(self)
    VALUE self;
{
    gtk_container_disable_resize(GTK_CONTAINER(get_widget(self)));
    return self;
}

static VALUE
cont_enable_resize(self)
    VALUE self;
{
    gtk_container_enable_resize(GTK_CONTAINER(get_widget(self)));
    return self;
}

static VALUE
cont_block_resize(self)
    VALUE self;
{
    gtk_container_block_resize(GTK_CONTAINER(get_widget(self)));
    return self;
}

static VALUE
cont_unblock_resize(self)
    VALUE self;
{
    gtk_container_unblock_resize(GTK_CONTAINER(get_widget(self)));
    return self;
}

static VALUE
cont_need_resize(self)
    VALUE self;
{
    gtk_container_need_resize(GTK_CONTAINER(get_widget(self)));
    return self;
}
*/
static VALUE
cont_foreach(argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
    VALUE callback;

    rb_scan_args(argc, argv, "01", &callback);
    if (NIL_P(callback)) {
	callback = rb_f_lambda();
    }
    gtk_container_foreach(GTK_CONTAINER(get_widget(self)), 
			  exec_callback, (gpointer)callback);
    return self;
}

static void
yield_callback(widget)
    GtkWidget *widget;
{
    rb_yield(get_value_from_gobject(GTK_OBJECT(widget)));
}

static VALUE
cont_each(self)
    VALUE self;
{
    gtk_container_foreach(GTK_CONTAINER(get_widget(self)), 
			  yield_callback, 0);
    return self;
}

static VALUE
cont_focus(self, direction)
    VALUE self, direction;
{
    gtk_container_focus(GTK_CONTAINER(get_widget(self)),
			(GtkDirectionType)NUM2INT(direction));
    return self;
}

static VALUE
cont_set_focus_child(self, child)
    VALUE self, child;
{
    gtk_container_set_focus_child(GTK_CONTAINER(get_widget(self)),
                                  GTK_WIDGET(get_widget(child)));
    return self;
}

static VALUE
cont_set_focus_vadjustment(self, adjustment)
    VALUE self, adjustment;
{
    gtk_container_set_focus_vadjustment(GTK_CONTAINER(get_widget(self)),
                                        GTK_ADJUSTMENT(get_gobject(adjustment)));
    return self;
}

static VALUE
cont_set_focus_hadjustment(self, adjustment)
    VALUE self, adjustment;
{
    gtk_container_set_focus_hadjustment(GTK_CONTAINER(get_widget(self)),
                                        GTK_ADJUSTMENT(get_gobject(adjustment)));
    return self;
}

static void
cont_children_callback(widget, data)
    GtkWidget *widget;
    gpointer data;
{
    VALUE ary = (VALUE)data;

    rb_ary_push(ary, get_value_from_gobject(GTK_OBJECT(widget)));
}

static VALUE
cont_children(self, direction)
    VALUE self, direction;
{
    VALUE ary = rb_ary_new();

    gtk_container_foreach(GTK_CONTAINER(get_widget(self)),
			  cont_children_callback,
			  (gpointer)ary);
    return ary;
}

void Init_gtk_container()
{
    gContainer = rb_define_class_under(mGtk, "Container", gWidget);

    rb_define_const(gContainer, "SIGNAL_ADD", rb_str_new2("add"));
    rb_define_const(gContainer, "SIGNAL_REMOVE", rb_str_new2("remove"));
    rb_define_const(gContainer, "SIGNAL_NEED_RESIZE", rb_str_new2("need_resize"));
    rb_define_const(gContainer, "SIGNAL_FOREACH", rb_str_new2("foreach"));
    rb_define_const(gContainer, "SIGNAL_FOCUS", rb_str_new2("focus"));

    rb_define_method(gContainer, "border_width", cont_bwidth, -1);
    rb_define_method(gContainer, "border_width=", cont_set_bwidth, 1);
    rb_define_method(gContainer, "add", cont_add, 1);
    rb_define_method(gContainer, "remove", cont_remove, 1);
    /* 1.2.x
       rb_define_method(gContainer, "disable_resize", cont_disable_resize, 0);
       rb_define_method(gContainer, "enable_resize", cont_enable_resize, 0);
       rb_define_method(gContainer, "block_resize", cont_block_resize, 0);
       rb_define_method(gContainer, "unblock_resize", cont_unblock_resize, 0);
       rb_define_method(gContainer, "need_resize", cont_need_resize, 0);
    */
    rb_define_method(gContainer, "foreach", cont_foreach, -1);
    rb_define_method(gContainer, "each", cont_each, 0);
    rb_define_method(gContainer, "focus", cont_focus, 1);
    rb_define_method(gContainer, "children", cont_children, 0);
    rb_define_method(gContainer, "set_focus_child", cont_set_focus_child, 1);
    rb_define_method(gContainer, "set_focus_vadjustment", cont_set_focus_vadjustment, 1);
    rb_define_method(gContainer, "set_focus_hadjustment", cont_set_focus_hadjustment, 1);
}

/*
 * Bin
 */
static VALUE
bin_child(self)
    VALUE self;
{
    GtkWidget *child = GTK_BIN(get_widget(self))->child;
    return (child == NULL) ? Qnil : make_gobject_auto_type(GTK_OBJECT(child));
}

void Init_gtk_bin()
{
    gBin = rb_define_class_under(mGtk, "Bin", gContainer);

    /* rb_define_const(   gBin, "SIGNAL_", rb_str_new2("")); */

    rb_define_method(gBin, "child", bin_child, 0);
}

/*
 * Alignment
 */
static VALUE
align_initialize(self, xalign, yalign, xscale, yscale)
    VALUE self, xalign, yalign, xscale, yscale;
{
    set_widget(self, gtk_alignment_new(NUM2DBL(xalign),
				       NUM2DBL(yalign),
				       NUM2DBL(xscale),
				       NUM2DBL(yscale)));
    return Qnil;
}

static VALUE
align_set(self, xalign, yalign, xscale, yscale)
    VALUE self, xalign, yalign, xscale, yscale;
{
    gtk_alignment_set(GTK_ALIGNMENT(get_widget(self)),
		      NUM2DBL(xalign), NUM2DBL(yalign),
		      NUM2DBL(xscale), NUM2DBL(yscale));
    return self;
}

void Init_gtk_alignment()
{
    gAlignment = rb_define_class_under(mGtk, "Alignment", gBin);

    rb_define_method(gAlignment, "initialize", align_initialize, 4);
    rb_define_method(gAlignment, "set", align_set, 4);
}

/*
 * EventBox
 */
static VALUE
eventbox_initialize(self)
    VALUE self;
{
    set_widget(self, gtk_event_box_new());
    return Qnil;
}

void Init_gtk_eventbox()
{
    gEventBox = rb_define_class_under(mGtk, "EventBox", gBin);

    rb_define_method(gEventBox, "initialize", eventbox_initialize, 0);
}

/*
 * Viewport
 */
static VALUE
vport_initialize(argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
    VALUE arg1, arg2;
    GtkAdjustment *h_adj = NULL;
    GtkAdjustment *v_adj = NULL;

    rb_scan_args(argc, argv, "02", &arg1, &arg2);
    if (!NIL_P(arg1)) h_adj = GTK_ADJUSTMENT(get_gobject(arg1));
    if (!NIL_P(arg2)) v_adj = GTK_ADJUSTMENT(get_gobject(arg2));

    set_widget(self, gtk_viewport_new(h_adj, v_adj));
    return Qnil;
}

static VALUE
vport_get_hadj(self)
    VALUE self;
{
    GtkAdjustment *adj = gtk_viewport_get_hadjustment(GTK_VIEWPORT(get_widget(self)));

    return make_gobject(gAdjustment, GTK_OBJECT(adj));
}

static VALUE
vport_get_vadj(self)
    VALUE self;
{
    GtkWidget *widget = get_widget(self);
    GtkAdjustment *adj = gtk_viewport_get_vadjustment(GTK_VIEWPORT(widget));

    return make_gobject(gAdjustment, GTK_OBJECT(adj));
}

static VALUE
vport_set_vadj(self, adj)
    VALUE self, adj;
{
    gtk_viewport_set_vadjustment(GTK_VIEWPORT(get_widget(self)),
				 GTK_ADJUSTMENT(get_gobject(adj)));

    return self;
}

static VALUE
vport_set_hadj(self, adj)
    VALUE self, adj;
{
    gtk_viewport_set_hadjustment(GTK_VIEWPORT(get_widget(self)),
				 GTK_ADJUSTMENT(get_gobject(adj)));

    return self;
}

static VALUE
vport_set_shadow(self, type)
    VALUE self, type;
{
    gtk_viewport_set_shadow_type(GTK_VIEWPORT(get_widget(self)),
				 (GtkShadowType)NUM2INT(type));

    return self;
}

void Init_gtk_viewport()
{
    gViewport = rb_define_class_under(mGtk, "Viewport", gBin);

    rb_define_method(gViewport, "initialize", vport_initialize, -1);
    rb_define_method(gViewport, "get_hadjustment", vport_get_hadj, 0);
    rb_define_method(gViewport, "get_vadjustment", vport_get_vadj, 0);
    rb_define_method(gViewport, "set_hadjustment", vport_set_hadj, 1);
    rb_define_method(gViewport, "set_vadjustment", vport_set_vadj, 1);
    rb_define_method(gViewport, "set_shadow_type", vport_set_shadow, 1);
}

/*
 * Fixed
 */
static VALUE
fixed_initialize(self)
    VALUE self;
{
    set_widget(self, gtk_fixed_new());
    return Qnil;
}

static VALUE
fixed_put(self, win, x, y)
    VALUE self, win, x, y;
{
    gtk_fixed_put(GTK_FIXED(get_widget(self)), get_widget(win), NUM2INT(x), NUM2INT(y));
    return self;
}

static VALUE
fixed_move(self, win, x, y)
    VALUE self, win, x, y;
{
    gtk_fixed_move(GTK_FIXED(get_widget(self)), get_widget(win), NUM2INT(x), NUM2INT(y));
    return self;
}

void Init_gtk_fixed()
{
    gFixed = rb_define_class_under(mGtk, "Fixed", gContainer);

    rb_define_method(gFixed, "initialize", fixed_initialize, 0);
    rb_define_method(gFixed, "put", fixed_put, 3);
    rb_define_method(gFixed, "move", fixed_move, 3);
}

/*
 * MenuShell
 */
static VALUE
mshell_append(self, child)
    VALUE self, child;
{
    gtk_menu_shell_append(GTK_MENU_SHELL(get_widget(self)),
			  get_widget(child));
    return self;
}

static VALUE
mshell_prepend(self, child)
    VALUE self, child;
{
    gtk_menu_shell_prepend(GTK_MENU_SHELL(get_widget(self)),
			   get_widget(child));
    return self;
}

static VALUE
mshell_insert(self, child, pos)
    VALUE self, child, pos;
{
    gtk_menu_shell_insert(GTK_MENU_SHELL(get_widget(self)),
			  get_widget(child),
			  NUM2INT(pos));
    return self;
}

static VALUE
mshell_deactivate(self)
    VALUE self;
{
    gtk_menu_shell_deactivate(GTK_MENU_SHELL(get_widget(self)));
    return self;
}

void Init_gtk_menu_shell()
{
    gMenuShell = rb_define_class_under(mGtk, "MenuShell", gContainer);

    rb_define_const(gMenuShell, "SIGNAL_DEACTIVATE", rb_str_new2("deactivate"));

    rb_define_method(gMenuShell, "append", mshell_append, 1);
    rb_define_method(gMenuShell, "prepend", mshell_prepend, 1);
    rb_define_method(gMenuShell, "insert", mshell_insert, 2);
    rb_define_method(gMenuShell, "deactivate", mshell_deactivate, 0);
}

/*
 * Menu
 */
static VALUE
menu_initialize(self)
    VALUE self;
{
    set_widget(self, gtk_menu_new());
    return Qnil;
}

static VALUE
menu_append(self, child)
    VALUE self, child;
{
    gtk_menu_append(GTK_MENU(get_widget(self)), get_widget(child));
    return self;
}

static VALUE
menu_prepend(self, child)
    VALUE self, child;
{
    gtk_menu_prepend(GTK_MENU(get_widget(self)), get_widget(child));
    return self;
}

static VALUE
menu_insert(self, child, pos)
    VALUE self, child, pos;
{
    gtk_menu_insert(GTK_MENU(get_widget(self)),
		    get_widget(child), NUM2INT(pos));
    return self;
}

static void
menu_pos_func(menu, x, y, data)
    GtkMenu *menu;
    gint x, y;
    gpointer data;
{
    VALUE m = get_value_from_gobject(GTK_OBJECT(menu));

    rb_funcall((VALUE)data, 3, m, INT2FIX(x), INT2FIX(y));
}

static VALUE
menu_popup(self, pshell, pitem, func, button, activate_time)
    VALUE self, pshell, pitem, func, button, activate_time;
{
    GtkMenuPositionFunc pfunc = NULL;
    gpointer data = NULL;

    if (!NIL_P(func)) {
	pfunc = menu_pos_func;
	data = (gpointer)func;
	add_relative(self, func);
    }
    gtk_menu_popup(GTK_MENU(get_widget(self)),
		   get_widget(pshell), get_widget(pitem),
		   pfunc,
		   data,
		   NUM2INT(button),
		   NUM2INT(activate_time));
    return self;
}

static VALUE
menu_popdown(self)
    VALUE self;
{
    gtk_menu_popdown(GTK_MENU(get_widget(self)));
    return self;
}

static VALUE
menu_get_active(self)
    VALUE self;
{
    GtkWidget *mitem = gtk_menu_get_active(GTK_MENU(get_widget(self)));

    return (mitem == NULL) ? Qnil : make_gobject_auto_type(GTK_OBJECT(mitem));
}

static VALUE
menu_set_active(self, active)
    VALUE self, active;
{
    gtk_menu_set_active(GTK_MENU(get_widget(self)), NUM2INT(active));
    return self;
}
/* 1.2.x
static VALUE
menu_set_acceltbl(self, table)
    VALUE self, table;
{
    gtk_menu_set_accelerator_table(GTK_MENU(get_widget(self)),
				   get_gtkacceltbl(table));
    return self;
}
*/

void Init_gtk_menu()
{
    gMenu = rb_define_class_under(mGtk, "Menu", gMenuShell);

    rb_define_method(gMenu, "initialize", menu_initialize, 0);
    rb_define_method(gMenu, "append", menu_append, 1);
    rb_define_method(gMenu, "prepend", menu_prepend, 1);
    rb_define_method(gMenu, "insert", menu_insert, 2);
    rb_define_method(gMenu, "popup", menu_popup, 6);
    rb_define_method(gMenu, "popdown", menu_popdown, 0);
    rb_define_method(gMenu, "get_active", menu_get_active, 0);
    rb_define_method(gMenu, "set_active", menu_set_active, 1);
    /* 1.2.x
       rb_define_method(gMenu, "set_accelerator_table", menu_set_acceltbl, 1);
    */
}

/*
 * MenuBar
 */
static VALUE
mbar_initialize(self)
    VALUE self;
{
    set_widget(self, gtk_menu_bar_new());
    return Qnil;
}

static VALUE
mbar_append(self, child)
    VALUE self, child;
{
    gtk_menu_bar_append(GTK_MENU_BAR(get_widget(self)), get_widget(child));
    return self;
}

static VALUE
mbar_prepend(self, child)
    VALUE self, child;
{
    gtk_menu_bar_prepend(GTK_MENU_BAR(get_widget(self)), get_widget(child));
    return self;
}

static VALUE
mbar_insert(self, child, pos)
    VALUE self, child, pos;
{
    gtk_menu_bar_insert(GTK_MENU_BAR(get_widget(self)),
			get_widget(child), NUM2INT(pos));
    return self;
}

void Init_gtk_menu_bar()
{
    gMenuBar = rb_define_class_under(mGtk, "MenuBar", gMenuShell);

    rb_define_method(gMenuBar, "initialize", mbar_initialize, 0);
    rb_define_method(gMenuBar, "append", mbar_append, 1);
    rb_define_method(gMenuBar, "prepend", mbar_prepend, 1);
    rb_define_method(gMenuBar, "insert", mbar_insert, 2);
}

/*
 * Paned
 */
static VALUE
paned_add1(self, child)
    VALUE self, child;
{
    gtk_paned_add1(GTK_PANED(get_widget(self)), get_widget(child));
    return self;
}

static VALUE
paned_add2(self, child)
    VALUE self, child;
{
    gtk_paned_add2(GTK_PANED(get_widget(self)), get_widget(child));
    return self;
}

static VALUE
paned_handle_size(self, size)
    VALUE self, size;
{
    gtk_paned_handle_size(GTK_PANED(get_widget(self)), NUM2INT(size));
    return self;
}

static VALUE
paned_gutter_size(self, size)
    VALUE self, size;
{
    gtk_paned_gutter_size(GTK_PANED(get_widget(self)), NUM2INT(size));
    return self;
}

void Init_gtk_paned()
{
    gPaned = rb_define_class_under(mGtk, "Paned", gContainer);

    rb_define_method(gPaned, "add1", paned_add1, 1);
    rb_define_method(gPaned, "add2", paned_add2, 1);
    rb_define_method(gPaned, "handle_size", paned_handle_size, 1);
    rb_define_method(gPaned, "gutter_size", paned_gutter_size, 1);
}

/*
 * HPane
 */
static VALUE
hpaned_initialize(self)
    VALUE self;
{
    set_widget(self, gtk_hpaned_new());
    return Qnil;
}

void Init_gtk_hpaned()
{
    gHPaned = rb_define_class_under(mGtk, "HPaned", gPaned);

    rb_define_method(gHPaned, "initialize", hpaned_initialize, 0);
}

/*
 * VPane
 */
static VALUE
vpaned_initialize(self)
    VALUE self;
{
    set_widget(self, gtk_vpaned_new());
    return Qnil;
}

void Init_gtk_vpaned()
{
    gVPaned = rb_define_class_under(mGtk, "VPaned", gPaned);

    rb_define_method(gVPaned, "initialize", vpaned_initialize, 0);
}

/*
 * ScrolledWindow
 */
static VALUE
scwin_initialize(argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
    VALUE arg1, arg2;
    GtkAdjustment *h_adj = NULL;
    GtkAdjustment *v_adj = NULL;

    rb_scan_args(argc, argv, "02", &arg1, &arg2);

    if (!NIL_P(arg1)) h_adj = GTK_ADJUSTMENT(get_gobject(arg1));
    if (!NIL_P(arg2)) v_adj = GTK_ADJUSTMENT(get_gobject(arg2));

    set_widget(self, gtk_scrolled_window_new(h_adj, v_adj));
    return Qnil;
}

static VALUE
scwin_set_policy(self, hpolicy, vpolicy)
    VALUE self, hpolicy, vpolicy;
{
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(get_widget(self)),
				   (GtkPolicyType)NUM2INT(hpolicy),
				   (GtkPolicyType)NUM2INT(vpolicy));
    return self;
}

static VALUE
scwin_add_with_viewport(self, other)
    VALUE self, other;
{
    gtk_scrolled_window_add_with_viewport(
				   GTK_SCROLLED_WINDOW(get_widget(self)),
				   get_widget(other));
    return self;
}

static VALUE
scwin_get_hadjustment(self)
    VALUE self;
{
    GtkAdjustment *adj =
	gtk_scrolled_window_get_hadjustment(
	    GTK_SCROLLED_WINDOW(get_widget(self)));
    return make_gobject(gAdjustment, GTK_OBJECT(adj));
}

static VALUE
scwin_get_vadjustment(self)
    VALUE self;
{
    GtkAdjustment *adj =
	gtk_scrolled_window_get_vadjustment(
	    GTK_SCROLLED_WINDOW(get_widget(self)));
    return make_gobject(gAdjustment, GTK_OBJECT(adj));
}

void Init_gtk_scrolled_window()
{
    gScrolledWin = rb_define_class_under(mGtk, "ScrolledWindow", gContainer);

    rb_define_method(gScrolledWin, "initialize", scwin_initialize, -1);
    rb_define_method(gScrolledWin, "set_policy", scwin_set_policy, 2);
    rb_define_method(gScrolledWin, "add_with_viewport", scwin_add_with_viewport, 1);
    rb_define_method(gScrolledWin, "hadjustment", scwin_get_hadjustment, 0);
    rb_define_method(gScrolledWin, "get_hadjustment", scwin_get_hadjustment, 0);
    rb_define_method(gScrolledWin, "vadjustment", scwin_get_vadjustment, 0);
    rb_define_method(gScrolledWin, "get_vadjustment", scwin_get_vadjustment, 0);
}

/*
 * Table
 */
static VALUE
tbl_initialize(argc, argv, self)
    int argc;
    VALUE *argv;
{
    VALUE row, col, homogeneous;

    rb_scan_args(argc, argv, "21", &row, &col, &homogeneous);
    set_widget(self, gtk_table_new(NUM2INT(row),
					   NUM2INT(col),
					   RTEST(homogeneous)));
    return Qnil;
}

static VALUE
tbl_attach(argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
    VALUE child, left, right, top, bottom;
    VALUE arg0, arg1, arg2, arg3;
    int xopt, yopt, xspc, yspc;

    xopt = yopt = GTK_EXPAND | GTK_FILL;
    xspc = yspc = 0;
    rb_scan_args(argc, argv, "54",
		 &child, &left, &right, &top, &bottom,
		 &arg0, &arg1, &arg2, &arg3);
    if (!NIL_P(arg0)) xopt = NUM2INT(arg0);
    if (!NIL_P(arg1)) yopt = NUM2INT(arg1);
    if (!NIL_P(arg2)) xspc = NUM2INT(arg2);
    if (!NIL_P(arg3)) yspc = NUM2INT(arg3);

    gtk_table_attach(GTK_TABLE(get_widget(self)),
		     get_widget(child),
		     NUM2INT(left),NUM2INT(right),
		     NUM2INT(top),NUM2INT(bottom),
		     xopt, yopt, xspc, yspc);

    return self;
}

static VALUE
tbl_set_row_spacing(self, row, spc)
    VALUE self, row, spc;
{
    gtk_table_set_row_spacing(GTK_TABLE(get_widget(self)),
			      NUM2INT(row), NUM2INT(spc));
    return self;
}

static VALUE
tbl_set_col_spacing(self, col, spc)
    VALUE self, col, spc;
{
    gtk_table_set_col_spacing(GTK_TABLE(get_widget(self)),
			      NUM2INT(col), NUM2INT(spc));
    return self;
}

static VALUE
tbl_set_row_spacings(self, spc)
    VALUE self, spc;
{
    gtk_table_set_row_spacings(GTK_TABLE(get_widget(self)), NUM2INT(spc));
    return self;
}

static VALUE
tbl_set_col_spacings(self, spc)
    VALUE self, spc;
{
    gtk_table_set_col_spacings(GTK_TABLE(get_widget(self)), NUM2INT(spc));
    return self;
}

void Init_gtk_table()
{
    gTable = rb_define_class_under(mGtk, "Table", gContainer);

    rb_define_method(gTable, "initialize", tbl_initialize, -1);
    rb_define_method(gTable, "attach", tbl_attach, -1);
    rb_define_method(gTable, "set_row_spacing", tbl_set_row_spacing, 2);
    rb_define_method(gTable, "set_col_spacing", tbl_set_col_spacing, 2);
    rb_define_method(gTable, "set_row_spacings", tbl_set_row_spacings, 1);
    rb_define_method(gTable, "set_col_spacings", tbl_set_col_spacings, 1);
}

/*
 * Tree
 */
static VALUE
tree_initialize(self)
    VALUE self;
{
    set_widget(self, gtk_tree_new());
    return Qnil;
}

static VALUE
tree_append(self, child)
    VALUE self, child;
{
    gtk_tree_append(GTK_TREE(get_widget(self)), get_widget(child));
    return self;
}

static VALUE
tree_prepend(self, child)
    VALUE self, child;
{
    gtk_tree_prepend(GTK_TREE(get_widget(self)), get_widget(child));
    return self;
}

static VALUE
tree_insert(self, child, pos)
    VALUE self, child, pos;
{
    gtk_tree_insert(GTK_TREE(get_widget(self)), get_widget(child),
		    NUM2INT(pos));
    return self;
}

static VALUE
tree_set_sel_mode(self, mode)
    VALUE self, mode;
{
    gtk_tree_set_selection_mode(GTK_TREE(get_widget(self)),
								(GtkSelectionMode)NUM2INT(mode));
    return self;
}

static VALUE
tree_set_view_lines(self, lines)
    VALUE self, lines;
{
    gtk_tree_set_view_lines(GTK_TREE(get_widget(self)),
			    RTEST(lines));
    return self;
}

static VALUE
tree_set_view_mode(self, mode)
    VALUE self, mode;
{
    gtk_tree_set_selection_mode(GTK_TREE(get_widget(self)),
				(GtkTreeViewMode)NUM2INT(mode));
    return self;
}

/*
static VALUE
tree_selection(self)
    VALUE self;
{
}
*/

void Init_gtk_tree()
{
    gTree = rb_define_class_under(mGtk, "Tree", gContainer);

    rb_define_const(gTree, "VIEW_LINE", INT2FIX(GTK_TREE_VIEW_LINE));
    rb_define_const(gTree, "VIEW_ITEM", INT2FIX(GTK_TREE_VIEW_ITEM));

    rb_define_const(gTree, "SIGNAL_SELECTION_CHANGED", rb_str_new2("selection_changed"));
    rb_define_const(gTree, "SIGNAL_SELECT_CHILD", rb_str_new2("select_child"));
    rb_define_const(gTree, "SIGNAL_UNSELECT_CHILD", rb_str_new2("unselect_child"));

    rb_define_method(gTree, "initialize", tree_initialize, 0);
    rb_define_method(gTree, "append", tree_append, 1);
    rb_define_method(gTree, "prepend", tree_prepend, 1);
    rb_define_method(gTree, "insert", tree_insert, 2);
    rb_define_method(gTree, "set_selection_mode", tree_set_sel_mode, 1);
    rb_define_method(gTree, "set_view_lines", tree_set_view_lines, 1);
    rb_define_method(gTree, "set_view_mode", tree_set_view_mode, 1);
    /* rb_define_method(gTree, "selection", tree_selection, 0); */
}
