#include "global.h"

/*
 * Gdk::Rgb
 */

VALUE mGdkRgb;

static VALUE
rgb_get_cmap(self)
    VALUE self;
{
    GdkColormap *cmap;
    cmap = gdk_rgb_get_cmap();
    return make_gdkcmap(cmap);
}

static VALUE
rgb_get_visual(self)
    VALUE self;
{
    GdkVisual *visual;
    visual = gdk_rgb_get_visual();
    return make_gdkvisual(visual);
}

void
Init_gtk_gdk_rgb()
{
    mGdkRgb = rb_define_module_under(mGdk, "Rgb");

    rb_define_module_function(mGdkRgb, "get_cmap", rgb_get_cmap, 0);
    rb_define_module_function(mGdkRgb, "get_visual", rgb_get_visual, 0);
}
