// ---------------------------------------------------------------------------
// - cdl.cxx                                                                 -
// - standard system library - c dynamic library implementation              -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "cdl.hxx"
#include "cstring.hxx"
#include <dlfcn.h>

namespace aleph {

  // Open a dynamic library by name
 
  void* c_dlopen (const char* name) {
    // standard check
    if ((!name) || (c_strlen (name) == 0)) return 0;
    
    // add the extension flag
    char* lname = new char[c_strlen (name) + 4];
    c_strcpy (lname,name);
    c_strcat (lname,".so");
    
    // try to open library and return
    void* library = dlopen (lname,RTLD_LAZY);
    
    // clean and return
    delete [] lname;
    return library;
  }
  
  // query a symbol by name
  
  void* c_dlsym (const char* name, void* lptr) {
    // standard check as usual
    if ((!name) || (c_strlen (name) == 0) || (!lptr)) return 0;
    return dlsym (lptr,name);
  }
  
  // close the library
  
  void c_dlclose (void* lptr) {
    // standard chech again
    if (!lptr) return;
    
    // close library
    dlclose (lptr);
  }
}

// define a symbol for test purpose only
extern "C" {
  int cdl_test_symbol = 0;
}
