// ---------------------------------------------------------------------------
// - OutputString.cpp                                                        -
// - standard object library - output string stream class implementation     -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "cstring.hxx"
#include "Exception.hpp"
#include "OutputString.hpp"

namespace aleph {

  // create a new default output string stream. 

  OutputString::OutputString (void)  {
    d_buffer.reset ();
  }

  // return the class name

  String OutputString::repr (void) const {
    return "OutputString";
  }

  // write one character to the output stream
  
  void OutputString::write (const char value) {
    d_buffer.add (value);
  }

  // write a character string to the output stream
  
  void OutputString::write (const char* value) {
    long size = String::length (value);
    if (size == 0) return;
    // write the string
    char c;
    while ((c = *value++) != nilc) d_buffer.add (c);
  }

  // write an integer to the output stream
  
  void  OutputString::write (const long value) {
    char* data = c_ltoa (value);
    write (data);
    delete [] data;
  }

  // return the length of the output string

  long OutputString::length (void) const {
    return d_buffer.length ();
  }
  
  // return a string in this output string and flush the buffer

  String OutputString::toString (void) {
    String result = d_buffer.toString ();
    d_buffer.reset ();
    return result;
  }

  // flush this output string buffer
  
  void OutputString::flush (void) {
    d_buffer.reset ();
  }
}
