// ---------------------------------------------------------------------------
// - Literal.hpp                                                             -
// - standard object library - literal abstract class definition             -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_LITERAL_HPP
#define  ALEPH_LITERAL_HPP

#ifndef  ALEPH_OBJECT_HPP
#include "Object.hpp"
#endif

namespace aleph {

  // forward declaration of the string class
  class String;

  /// The Literal class is an abstract class which is used by object which
  /// have a constant literal representation. such object includes boolean,
  /// interger, float, character and string. The Literal class defines the
  /// toLiteral method as the representation method.
  /// @author amaury darsch

  class Literal : public virtual Object {
  public:
    /// @return a literal representation of this object
    virtual String toLiteral (void) const =0;
    /// @return a printable representation of this literal
    virtual String toString (void) const =0;
  };
}

#endif
