// ---------------------------------------------------------------------------
// - Libasys.cpp                                                             -
// - aleph:sys library - declaration & implementation                        -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Interp.hpp"
#include "Syscalls.hpp"
#include "Function.hpp"

extern "C" {
  aleph::Object* initialize (aleph::Interp* interp, aleph::Nameset* nset, 
			     aleph::Cons* args) {
    using namespace aleph;

    // make sure we are not called from something crazy
    if ((interp == nilp) || (nset == nilp)) return nilp;

    // create the aleph:sys nameset
    Nameset* aset = interp->mknset ("aleph", interp->getnset ());
    Nameset* asys = interp->mknset ("sys",   aset);

    // bind all symbols in the aleph.sio nameset
    asys->symcst ("exit",          new Function (asys_exit));
    asys->symcst ("sleep",         new Function (asys_sleep));

    // not used but needed
    return nilp;
  }
}
