// ---------------------------------------------------------------------------
// - Meta.cpp                                                                -
// - aleph engine - meta class implementation                                -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Meta.hpp"
#include "Interp.hpp"

namespace aleph {
  // create an empty meta class
  Meta::Meta (void) {
    p_func = nilp;
  }

  // create a new meta class

  Meta::Meta (t_meta func) {
    p_func = func;
  }

  // return the class name

  String Meta::repr (void) const {
    return "Meta";
  }

  // generate a new object

  Object* Meta::apply (Interp* interp, Nameset* nset, Cons* args) {
    // check for a function to apply
    if (p_func == nilp) 
      throw Exception ("apply-error", "trying to apply a nil meta class");
    // evaluate the arguments and call the function
    Vector* argv = Vector::eval (interp,nset,args);
    Object::iref (argv);
    Object* result = nilp;
    try {
      result = p_func (argv);
      Object::dref (argv);
    } catch (...) {
      Object::dref (argv);
      throw;
    }
    return result;
  }
}
