#ifndef GIF_H
#define GIF_H   1

#include "utilEndian.h"        /* Data type definitions */

/************************************************************************/
/*  The header of a GIF file:						*/
/************************************************************************/
typedef struct GifHeader
{
    unsigned char	ghSignature[3];		/*  ID Signature	*/
    unsigned char	ghVersion[3];		/*  Version Number	*/
    unsigned short int	ghScreenWidth;		/*  Logical Screen Width*/
    unsigned short int	ghScreenHeight;		/*  Logical Screen Height*/ 
    unsigned char	ghPacked;		/*  Color Information	*/
    unsigned char	ghBackgroundColor;	/*  # of Background Color*/
    unsigned char	ghAspectRatio;
    RGB8Color		ghPalette[256];
} GifHeader;                      


/************************************************************************/
/*  The Header of an image.						*/
/************************************************************************/
typedef struct GifImageDescriptor
    {
    unsigned char	gidSeparator;	/* identifier			*/
    unsigned short int	gidLeft;	/* X on the display		*/
    unsigned short int	gidTop;		/* Y on the display		*/
    unsigned short int	gidWidth;	/* Width image in pixels	*/
    unsigned short int	gidHeight;	/* Height image in pixels	*/
    unsigned char	gidPacked;	/* Image and Color Table Data	*/
					/* Information			*/
    RGB8Color		gidPalette[256];
    } GifImageDescriptor;


/************************************************************************/
/*  GIF 89a Graphic Control Extension Block				*/
/************************************************************************/
typedef struct GifGraphicControlExtension
{
    unsigned char    ggceIntroducer;	/* Extension Introducer (21h!)	*/
    unsigned char    ggceLabel;		/* Extension Label (F9h!)	*/
    unsigned char    ggceBlockSize;	/* Size of Block (04h!)		*/
    unsigned char    ggcePacked;	/* Graphic Data Information	*/
    unsigned short   ggceDelayTime;	/* Delay time in seconds/100	*/
    unsigned char    ggceTransparentColor;
					/* Transparent Color Index	*/
    unsigned char    ggceTerminator;	/* Block Terminator (0 !)	*/
} GifGraphicsControlExtension;


/*
**  GIF 89a Plain Text Extension Block
*/
typedef struct GifPlainTextExtension
{
    unsigned char	Introducer;	/* Introducer (always 21h)    */
    unsigned char	Label;		/* Label (always 01h)         */
    unsigned char	BlockSize;	/* Size of Block (always 0Ch) */
    unsigned short int	TextGridLeft;	/* X pos of text grid in pixels    */
    unsigned short int	TextGridTop;	/* Y pos of text grid in pixels    */
    unsigned short int	TextGridWidth;	/* Width of text grid in pixels     */
    unsigned short int	TextGridHeight;	/* Height of text grid in pixels    */
    unsigned char	CellWidth;	/* Width of a grid cell in pixels   */
    unsigned char	CellHeight;	/* Height of a grid cell in pixels   */
    unsigned char	TextFgColorIndex;/* Text foreground color index value */
    unsigned char	TextBgColorIndex;/* Text background color index value */
    unsigned char *	PlainTextData;	/* Plain Text data sub-blocks         */
    unsigned char	Terminator;	/* Block Terminator (always 0)    */
} GifPlainTextExtension;


/*
**  GIF 89a Application Extension Block
*/
typedef struct _GifApplicationExtension
{
    unsigned char    Introducer;         /* Extension Introducer (always 21h)    */
    unsigned char    Label;              /* Extension Label (always FFh)         */
    unsigned char    BlockSize;          /* Size of Extension Block (always 0Bh) */
    unsigned char    Identifier[8];      /* Application Identifier               */
    unsigned char    AuthentCode[3];     /* Application Authentication Code      */
    unsigned char   *ApplicationData;    /* Application data sub-blocks          */
    unsigned char    Terminator;         /* Block Terminator (always 0)          */
} GIFAPPLICATION;


/*
**  GIF 89a Comment Extension Block
*/
typedef struct _GifCommentExtension
{
    unsigned char    Introducer;         /* Extension Introducer (always 21h)    */
    unsigned char    Label;              /* Comment Label (always FEh)           */
    unsigned char   *CommentData;        /* Comment data sub-blocks              */
    unsigned char    Terminator;         /* Block Terminator (always 0)          */
} GIFCOMMENT;


/*
**  Function Prototypes
*/
/* GIFREAD.C */
int ReadGifGraphicControl(GifGraphicsControlExtension *, FILE *);
int ReadGifPlainText(GifPlainTextExtension *, FILE *);
int ReadGifApplication(GIFAPPLICATION *, FILE *);
int ReadGifComment(GIFCOMMENT *, FILE *);

#endif  /* GIF_H */
