/************************************************************************/
/*									*/
/*  sioSmtp.[ch]:	Send an e-mail message using the SMTP protocol.	*/
/*  Author:		Robert A. Vonk (rvonk@knoware.nl)		*/
/*			( Adapted by Mark de Does to fit in the sio	*/
/*			framework. )					*/
/*									*/
/*									*/
/*  SimpleOutputStream * sioOutSmtpOpen(	char *	smtpServer,	*/
/*						char *	From,		*/
/*						char *	To,		*/
/*						char *	Cc,		*/
/*						char *	Bcc,		*/
/*						char *	Subject,	*/
/*						char *	mimeType,	*/
/*						char *	mimeSubtype )	*/
/*	ARGUMENTS:							*/
/*	  smtpServer:	The name of the SMTP server.			*/
/*			DEFAULT: "mailhost".				*/
/*	  From:		The e-mail address of the sender.		*/
/*			DEFAULT: no default, obligatory.		*/
/*	  To:		The e-mail address(es) of the recipient(s).	*/
/*			DEFAULT: no default, obligatory.		*/
/*	  Cc:		The e-mail address(es) of the persons that are	*/
/*			carbon copied.					*/
/*			DEFAULT: none.					*/
/*	  Bcc:		The e-mail address(es) of the persons that are	*/
/*			blind carbon copied (do not appear in mail	*/
/*			headers).					*/
/*			DEFAULT: none.					*/
/*	  Subject:	The subject of the mail message			*/
/*			DEFAULT: none.					*/
/*	  mimeType:	The MIME type of the mail message		*/
/*			DEFAULT: none.					*/
/*	  mimeSubtype:	The MIME sub-type of the mail message		*/
/*			DEFAULT: none.					*/
/*	RETURN VALUES:							*/
/*	  (void *)0:	On failure.					*/
/*	  (void *)ptr:	On success.					*/
/*									*/
/*									*/
/************************************************************************/

#   ifndef	SIO_SMTP_H
#   define	SIO_SMTP_H

/************************************************************************/
/*									*/
/*  Error numbers. (Can be transtaled to strings by the caller.)	*/
/*									*/
/************************************************************************/

#	define SIO_SMTPeNOERROR		0
#	define SIO_SMTPeNOMEM		1
#	define SIO_SMTPeFROM		2
#	define SIO_SMTPeRCPT		3
#	define SIO_SMTPeSMTP		4
#	define SIO_SMTPeWRITE		5
#	define SIO_SMTPeREAD		6
#	define SIO_SMTPeUNAME		7
#	define SIO_SMTPeHOST		8
#	define SIO_SMTPeSERV		9
#	define SIO_SMTPeSOCK		10
#	define SIO_SMTPeCONN		11

#	define SIO_SMTPeCOUNT		12

#   include     <sioGeneral.h>

typedef int (*SIO_SMTP_COMPLAIN)(	void *		through,
					int		errorId,
					const char *	errorSubject );

extern SimpleOutputStream * sioOutSmtpOpen(	const char *	relay,
						const char *	from,
						const char *	to,
						const char *	cc,
						const char *	bcc,
						const char *	subject,
						const char *	type,
						const char *	subtype,
						void *		through,
						SIO_SMTP_COMPLAIN complain );

extern char *	sioSmtpGuessMailAddress( void );

#   endif
