/************************************************************************/
/*									*/
/*  Various definitions relating to document geometry.			*/
/*									*/
/************************************************************************/

#   ifndef	APP_GEO_H
#   define	APP_GEO_H

typedef struct DocumentRectangle
    {
    int		drX0;
    int		drY0;
    int		drX1;
    int		drY1;
    } DocumentRectangle;

typedef struct DocumentGeometry
    {
    int			dgPaperWideTwips;
    int			dgPaperHighTwips;

    int			dgLeftMarginTwips;
    int			dgTopMarginTwips;
    int			dgRightMarginTwips;
    int			dgBottomMarginTwips;
    } DocumentGeometry;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void docInitRectangle(	DocumentRectangle *		dr );

extern void docUnionRectangle(	DocumentRectangle *		dr,
				const DocumentRectangle *	dr1,
				const DocumentRectangle *	dr2	);

extern int docIntersectRectangle(	DocumentRectangle *		dr,
					const DocumentRectangle *	dr1,
					const DocumentRectangle *	dr2 );

extern void appInitDocumentGeometry(	DocumentGeometry *	dg );

extern void appSetDocumentGeometry(	DocumentGeometry *		dgTo,
					const DocumentGeometry *	dgFrom,
					int *				pCh );

#   endif
