#   include	"config.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<debugon.h>

#   include	<X11/Xatom.h>
#   include	<X11/IntrinsicP.h>
#   include	<Xm/RowColumn.h>
#   include	<Xm/PushB.h>
#   include	<Xm/PushBG.h>
#   include	<Xm/Form.h>
#   include	<Xm/Label.h>
#   include	<Xm/Text.h>
#   include	<Xm/ToggleB.h>
#   include	<Xm/Frame.h>
#   include	<Xm/PanedW.h>
#   include	<Xm/MwmUtil.h>
#   include	<Xm/Protocols.h>
#   include	<Xm/DialogS.h>

#   include	"appFrame.h"
#   include	"appUtil.h"
#   include	<appGeoString.h>

/************************************************************************/
/*  Get around Motif's ridiculous resize behavior.			*/
/************************************************************************/

void appPulldownSetWidth(	Widget		menu,
				Dimension	newWidth	)
    {
    Dimension		marginWidth= 0;

    Widget		pulldown;
    Widget		buttonGadget;

    XtWidgetGeometry	xwg;

    XtVaGetValues( XtParent( menu ),
			XmNmarginWidth,		&marginWidth,
			NULL );

    XtVaGetValues( menu,
			XmNsubMenuId,		&pulldown,
			NULL );

    XtVaSetValues( pulldown,
			XmNwidth,		newWidth-
						2* marginWidth,
			NULL );

    buttonGadget= XmOptionButtonGadget( menu );

    XtQueryGeometry( buttonGadget, NULL, &xwg );

#   if 0
    {
    XmFontList		fontList= (XmFontList)0;
    XmString		labelString= (XmString)0;

    Dimension		width;
    Dimension		height;

    XtVaGetValues( buttonGadget,
			XmNfontList,		&fontList,
			XmNlabelString,		&labelString,
			NULL );

    XmStringExtent( fontList, labelString, &width, &height );

    if  ( xwg.height < height )
	{ xwg.height=  height;	}

    XmStringFree( labelString );
    }
#   endif

    XtResizeWidget( buttonGadget, newWidth, xwg.height, xwg.border_width );
    }

/************************************************************************/
/*									*/
/*  Create a pulldown that is usable as a child of a form.		*/
/*									*/
/************************************************************************/
static void appMenuConfigure(	Widget		w,
				void *		through,
				XEvent *	event,
				Boolean *	pRefused )
    {
    XConfigureEvent *		cevent= &(event->xconfigure);

    if  ( cevent->type != ConfigureNotify )
	{ return;	}

    appPulldownSetWidth( w, cevent->width );

    *pRefused= 1;

    return;
    }

void appMakePulldownList(	Widget *	pPulldown,
				Widget *	pMenu,
				Widget		parentForm )
    {
    Widget			pulldown;
    Widget			menu;

    Widget			labelGadget;
    Widget			buttonGadget;

    Arg				al[20];
    int				ac= 0;

    ac= 0;
    XtSetArg( al[ac], XmNresizeWidth,		False ); ac++;
    XtSetArg( al[ac], XmNtopAttachment,		XmATTACH_FORM ); ac++;
    XtSetArg( al[ac], XmNleftAttachment,	XmATTACH_FORM ); ac++;
    XtSetArg( al[ac], XmNrightAttachment,	XmATTACH_FORM ); ac++;
    XtSetArg( al[ac], XmNbottomAttachment,	XmATTACH_FORM ); ac++;

    pulldown= XmCreatePulldownMenu( parentForm, WIDGET_NAME, al, ac );

    ac= 0;
    XtSetArg( al[ac], XmNsubMenuId,		pulldown ); ac++;

    XtSetArg( al[ac], XmNmarginHeight,		0 ); ac++;
    XtSetArg( al[ac], XmNmarginWidth,		0 ); ac++;
    XtSetArg( al[ac], XmNspacing,		0 ); ac++;

    XtSetArg( al[ac], XmNtopAttachment,		XmATTACH_FORM ); ac++;
    XtSetArg( al[ac], XmNleftAttachment,	XmATTACH_FORM ); ac++;
    XtSetArg( al[ac], XmNrightAttachment,	XmATTACH_FORM ); ac++;

    XtSetArg( al[ac], XmNtopOffset,		0 ); ac++;
    XtSetArg( al[ac], XmNleftOffset,		5 ); ac++;
    XtSetArg( al[ac], XmNrightOffset,		5 ); ac++;

    menu= XmCreateOptionMenu( parentForm, WIDGET_NAME, al, ac );
    XtAddEventHandler( menu, StructureNotifyMask, False,
					appMenuConfigure, (void *)0 );

    labelGadget= XmOptionLabelGadget( menu );
    buttonGadget= XmOptionButtonGadget( menu );

    XtUnmanageChild( labelGadget );
    XtManageChild( buttonGadget );

    XtVaSetValues( buttonGadget,
			XmNalignment,		XmALIGNMENT_BEGINNING,
			NULL );

    *pPulldown= pulldown; *pMenu= menu; return;
    }

/************************************************************************/
/*									*/
/*  Empty a pulldown list.						*/
/*									*/
/************************************************************************/

void appEmptyPulldownList(	Widget	pulldown	)
    {
    WidgetList		children;
    WidgetList		save;
    Cardinal		childCount;

    XtVaGetValues( pulldown,
			XmNchildren,		&children,
			XmNnumChildren,		&childCount,
			NULL );

    if  ( childCount == 0 )
	{ return;	}

    save= (WidgetList)malloc( childCount* sizeof(Widget) );
    if  ( save )
	{
	unsigned int	i;

	for ( i= 0; i < childCount; i++ )
	    { save[i]= children[i];	}

	for ( i= 0; i < childCount; i++ )
	    { XtDestroyWidget( save[i] );	}

	free( save );
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Add an option to a pulldown.					*/
/*									*/
/************************************************************************/

Widget appPulldownMakeOption(	Widget		pulldown,
				const char *	label,
				int		width,
				XtCallbackProc	callBack,
				void *		target )
    {
    Widget	fresh;

    fresh= XmCreatePushButtonGadget( pulldown, (char *)label, NULL, 0 );

    XtVaSetValues( fresh, XmNwidth, width, NULL );

    XtAddCallback( fresh, XmNactivateCallback, callBack, target );
    XtManageChild( fresh );

    return fresh;
    }

/************************************************************************/
/*									*/
/*  Use the text of an option and the name of the application as a	*/
/*  widget title.							*/
/*									*/
/************************************************************************/

void appSetShellTitle(	Widget			shell,
			Widget			option,
			const char *		applicationName )
    {
    char *	title;

    if  ( option )
	{
	XmString	string= (XmString)0;
	char *		s;

	XtVaGetValues( option,
			XmNlabelString,		&string,
			NULL );

	XmStringGetLtoR( string, XmSTRING_DEFAULT_CHARSET, &s );
	title= (char *)malloc( strlen( applicationName )+ 1+ strlen( s )+ 1 );
	sprintf( title, "%s %s", applicationName, s );

	XmStringFree( string ); XtFree( s );
	}
    else{ title= strdup( applicationName );	}

    XtVaSetValues( shell,
		    XmNtitle, title,
		    NULL );

    free( title );
    }

/************************************************************************/
/*  Remember te initial size of a shell as its minimum size.		*/
/************************************************************************/
void appSetSizeAsMinimum(	Widget			w,
				void *			through,
				XEvent *		event,
				Boolean *		pRefused )
    {
    XConfigureEvent *		cevent= &(event->xconfigure);

    if  ( cevent->type != ConfigureNotify )
	{ return;	}

    XtVaSetValues( w,	XmNminWidth,	cevent->width,
			XmNminHeight,	cevent->height,
			NULL );

    XtRemoveEventHandler( w, StructureNotifyMask, False,
					    appSetSizeAsMinimum, through );

    *pRefused= 1;

    return;
    }

void appFixSize(	Widget			w,
			void *			through,
			XEvent *		event,
			Boolean *		pRefused )
    {
    XConfigureEvent *		cevent= &(event->xconfigure);

    if  ( cevent->type != ConfigureNotify )
	{ return;	}

    XtVaSetValues( w,	XmNminWidth,	cevent->width,
			XmNmaxWidth,	cevent->width,
			XmNminHeight,	cevent->height,
			XmNmaxHeight,	cevent->height,
			NULL );

    XtRemoveEventHandler( w, StructureNotifyMask, False,
					    appFixSize, through );

    *pRefused= 1;

    return;
    }

/************************************************************************/
/*									*/
/*  Names of the X11 events.						*/
/*									*/
/************************************************************************/

char * APP_X11EventNames[]=
    {
    "0", "1", "KeyPress", "KeyRelease", "ButtonPress", "ButtonRelease",
    "MotionNotify", "EnterNotify", "LeaveNotify", "FocusIn", "FocusOut",
    "KeymapNotify", "Expose", "GraphicsExpose", "NoExpose", "VisibilityNotify",
    "CreateNotify", "DestroyNotify", "UnmapNotify", "MapNotify", "MapRequest",
    "ReparentNotify", "ConfigureNotify", "ConfigureRequest", "GravityNotify",
    "ResizeRequest", "CirculateNotify", "CirculateRequest", "PropertyNotify",
    "SelectionClear", "SelectionRequest", "SelectionNotify", "ColormapNotify",
    "ClientMessage", "MappingNotify"
    };

/************************************************************************/
/*									*/
/*  Attach a dialog to a particular widget.				*/
/*									*/
/************************************************************************/

int appSetRelativeArgs(	Arg *		al,
			Widget		relative )
    {
    Dimension		x;
    Dimension		y;
    Dimension		width;
    Dimension		height;

    int			ac= 0;

    XtVaGetValues( relative,
			    XmNx,	&x,
			    XmNy,	&y,
			    XmNwidth,	&width,
			    XmNheight,	&height,
			    NULL );


    XtSetArg( al[ac],	XmNx,			x+ width/5 ); ac++;
    XtSetArg( al[ac],	XmNy,			y+ height/ 5 ); ac++;

    return ac;
    }

void appDialogRelative(	Widget		relative,
			Widget		dialog )
    {
    Dimension		x;
    Dimension		y;
    Dimension		width;
    Dimension		height;

    XtVaGetValues( relative,
			    XmNx,	&x,
			    XmNy,	&y,
			    XmNwidth,	&width,
			    XmNheight,	&height,
			    NULL );

    XtVaSetValues( dialog,
			    XmNx,		x+ width/5,
			    XmNy,		y+ height/ 5,
			    NULL );

    XtVaSetValues( XtParent( dialog ),
			    XmNtransientFor,	relative,
			    XmNx,		x+ width/5,
			    XmNy,		y+ height/ 5,
			    NULL );

    }

static void appRelativeMapCallback(	Widget		w,
					XtPointer	voidRelative,
					XtPointer	voidcbs )
    {
    Widget		relative= (Widget)voidRelative;

    appDialogRelative( relative, w );

    XtRemoveCallback( w, XmNmapCallback, appRelativeMapCallback, voidRelative );
    }

void appSetRelativeCallback(		Widget		relative,
					Widget		dialog )
    {
    XtAddCallback( dialog, XmNmapCallback,
				appRelativeMapCallback, (void *)relative );
    }

/************************************************************************/
/*									*/
/*  Force keyboard focus to a modal dialog.				*/
/*									*/
/************************************************************************/

static void appDialogSetFocus(		Widget			w,
					XtPointer		voidqc,
					XEvent *		event,
					Boolean *		pRefused )
    {
    if  ( event->type == MapNotify )
	{
	XSetInputFocus( XtDisplay( w ), XtWindow( w ),
					    RevertToNone, CurrentTime );

	XtRemoveEventHandler( w, StructureNotifyMask, False,
						appDialogSetFocus, voidqc );
	}

    *pRefused= 1; return;
    }

void appSetFocusCallback(		Widget		dialog )
    {
    XtAddEventHandler( XtParent( dialog ), StructureNotifyMask, False,
					    appDialogSetFocus, (void *)0 );
    }

/************************************************************************/
/*									*/
/*  Make a in a form containing a row of buttons.			*/
/*									*/
/************************************************************************/

Widget appMakeRowButton(	Widget		buttonRow,
				const char *	text,
				XtCallbackProc	callback,
				void *		through,
				int		position,
				Dimension	showAsDefault )
    {
    Arg		al[20];
    int		ac= 0;

    XmString	labelString;
    Widget	button;

    labelString= XmStringCreateLocalized( (char *)text );

    ac= 0;
    XtSetArg( al[ac], XmNlabelString,		labelString ); ac++;
    XtSetArg( al[ac], XmNtopAttachment,		XmATTACH_FORM ); ac++;
    XtSetArg( al[ac], XmNbottomAttachment,	XmATTACH_FORM ); ac++;
    XtSetArg( al[ac], XmNleftAttachment,	XmATTACH_POSITION ); ac++;
    XtSetArg( al[ac], XmNleftPosition,		position ); ac++;
    XtSetArg( al[ac], XmNrightAttachment,	XmATTACH_POSITION ); ac++;
    XtSetArg( al[ac], XmNrightPosition,		position+ 1 ); ac++;

    XtSetArg( al[ac], XmNtopOffset,		0 ); ac++;
    XtSetArg( al[ac], XmNbottomOffset,		0 ); ac++;
    XtSetArg( al[ac], XmNleftOffset,		0 ); ac++;
    XtSetArg( al[ac], XmNrightOffset,		0 ); ac++;

    if  ( showAsDefault )
	{
	XtSetArg( al[ac], XmNdefaultButtonShadowThickness, 1 ); ac++;
	XtSetArg( al[ac], XmNshowAsDefault, showAsDefault != 0 ); ac++;
	}
    else{
	XtSetArg( al[ac], XmNdefaultButtonShadowThickness, 0 ); ac++;
	}

    button= XmCreatePushButton( buttonRow, WIDGET_NAME, al, ac );

    XmStringFree( labelString );

    if  ( callback )
	{ XtAddCallback( button, XmNactivateCallback, callback, through ); }

    XtManageChild( button );

    if  ( showAsDefault )
	{
	XtVaSetValues( buttonRow,
			XmNdefaultButton,	button,
			NULL );
	}

    return button;
    }

Widget appMakeRowToggle(	Widget		buttonRow,
				const char *	text,
				XtCallbackProc	callback,
				void *		through,
				int		position )
    {
    Arg		al[20];
    int		ac= 0;

    XmString	labelString;
    Widget	button;

    labelString= XmStringCreateLocalized( (char *)text );

    ac= 0;
    XtSetArg( al[ac], XmNlabelString,		labelString ); ac++;
    XtSetArg( al[ac], XmNtopAttachment,		XmATTACH_FORM ); ac++;
    XtSetArg( al[ac], XmNbottomAttachment,	XmATTACH_FORM ); ac++;
    XtSetArg( al[ac], XmNleftAttachment,	XmATTACH_POSITION ); ac++;
    XtSetArg( al[ac], XmNleftPosition,		position ); ac++;
    XtSetArg( al[ac], XmNrightAttachment,	XmATTACH_POSITION ); ac++;
    XtSetArg( al[ac], XmNrightPosition,		position+ 1 ); ac++;
 
    XtSetArg( al[ac], XmNtopOffset,		0 ); ac++;
    XtSetArg( al[ac], XmNbottomOffset,		0 ); ac++;
    XtSetArg( al[ac], XmNleftOffset,		0 ); ac++;
    XtSetArg( al[ac], XmNrightOffset,		0 ); ac++;

    XtSetArg( al[ac], XmNalignment,		XmALIGNMENT_BEGINNING ); ac++;

    button= XmCreateToggleButton( buttonRow, WIDGET_NAME, al, ac );

    if  ( callback )
	{ XtAddCallback( button, XmNvalueChangedCallback, callback, through ); }

    XmStringFree( labelString );

    XtManageChild( button );

    return button;
    }

Widget appMakeButtonRow(	Widget		parent,
				int		buttonCount )
    {
    Arg			al[20];
    int			ac= 0;

    Widget		buttonRow;

    ac= 0;
    XtSetArg( al[ac],	XmNfractionBase,	buttonCount ); ac++;
    XtSetArg( al[ac],	XmNallowResize,		True ); ac++;
    XtSetArg( al[ac],	XmNskipAdjust,		True ); ac++;

    buttonRow= XmCreateForm( parent, WIDGET_NAME, al, ac );

    return buttonRow;
    }

/************************************************************************/
/*									*/
/*  Make a row with a label and a text widget.				*/
/*									*/
/************************************************************************/

void appMakeRowLabel(		Widget *		pLabel,
				Widget			row,
				const char *		labelText )
    {
    Widget		label;

    XmString		labelString;

    Arg			al[20];
    int			ac= 0;

    labelString= XmStringCreateLocalized( (char *)labelText );

    ac= 0;
    XtSetArg( al[ac], XmNtopAttachment,		XmATTACH_FORM ); ac++;
    XtSetArg( al[ac], XmNtopOffset,		0 ); ac++;

    XtSetArg( al[ac], XmNleftAttachment,	XmATTACH_POSITION ); ac++;
    XtSetArg( al[ac], XmNleftPosition,		0 ); ac++;

    XtSetArg( al[ac], XmNrightAttachment,	XmATTACH_POSITION ); ac++;
    XtSetArg( al[ac], XmNrightPosition,		1 ); ac++;

    XtSetArg( al[ac], XmNrecomputeSize,		True ); ac++;
    XtSetArg( al[ac], XmNalignment,		XmALIGNMENT_BEGINNING ); ac++;
    XtSetArg( al[ac], XmNlabelString,		labelString ); ac++;

    XtSetArg( al[ac], XmNmarginHeight,		8 ); ac++;

    label= XmCreateLabel( row, WIDGET_NAME, al, ac );

    XmStringFree( labelString );

    XtManageChild( label );

    *pLabel= label;
    }

static char *	APP_PasteTranlationString=
    "Ctrl <Key>v: copy-primary()\n"	/*  PASTE	*/
    ;

static XtTranslations APP_PasteTranlations= (XtTranslations)0;

void appMakeRowText(		Widget *		pText,
				Widget			row,
				int			textColumns,
				int			textEnabled )
    {
    Display *		display= XtDisplay( row );
    int			screen= DefaultScreen( display );
    Pixel		whitePixel= WhitePixel( display, screen );

    Widget		text;

    Arg			al[20];
    int			ac= 0;

    if  ( ! APP_PasteTranlations )
	{
	APP_PasteTranlations=
		    XtParseTranslationTable( APP_PasteTranlationString );
	}

    ac= 0;
    XtSetArg( al[ac], XmNtopAttachment,		XmATTACH_FORM ); ac++;
    XtSetArg( al[ac], XmNtopOffset,		0 ); ac++;

    XtSetArg( al[ac], XmNleftAttachment,	XmATTACH_POSITION ); ac++;
    XtSetArg( al[ac], XmNleftPosition,		1 ); ac++;

    XtSetArg( al[ac], XmNrightAttachment,	XmATTACH_POSITION ); ac++;
    XtSetArg( al[ac], XmNrightPosition,		2 ); ac++;

    if  ( textColumns > 0 )
	{ XtSetArg( al[ac], XmNcolumns,		textColumns ); ac++;	}

    XtSetArg( al[ac], XmNmarginHeight,		3 ); ac++;

    if  ( textEnabled )
	{
	XtSetArg( al[ac], XmNbackground,		whitePixel ); ac++;
	}
    else{
	XtSetArg( al[ac], XmNeditable,			False ); ac++;
	XtSetArg( al[ac], XmNtraversalOn,		False ); ac++;
	XtSetArg( al[ac], XmNcursorPositionVisible,	False ); ac++;
	}

    text= XmCreateText( row, WIDGET_NAME, al, ac );

    if  ( APP_PasteTranlations )
	{ XtOverrideTranslations( text, APP_PasteTranlations ); }

    *pText= text;
    }

void appMakeLabelAndTextRow(	Widget *		pRow,
				Widget *		pLabel,
				Widget *		pText,
				Widget			parent,
				char *			labelText,
				int			textColumns,
				int			textEnabled )
    {
    Arg			al[20];
    int			ac= 0;

    Widget		label;
    Widget		text;
    Widget		row;

    ac= 0;
    XtSetArg( al[ac],	XmNfractionBase,	2 ); ac++;
    XtSetArg( al[ac],	XmNallowResize,		True ); ac++;
    XtSetArg( al[ac],	XmNskipAdjust,		True ); ac++;

    row= XmCreateForm( parent, WIDGET_NAME, al, ac );

    appMakeRowLabel( &label, row, labelText );
    appMakeRowText( &text, row, textColumns, textEnabled );

    XtManageChild( label );
    XtManageChild( text );
    XtManageChild( row );

    *pRow= row; *pLabel= label; *pText= text; return;
    }

void appMakeToggleAndTextRow(	Widget *		pRow,
				Widget *		pToggle,
				Widget *		pText,
				Widget			parent,
				char *			labelText,
				XtCallbackProc		callback,
				void *			through,
				int			textColumns,
				int			textEnabled )
    {
    Arg			al[20];
    int			ac= 0;

    Widget		toggle;
    Widget		text;
    Widget		row;

    ac= 0;
    XtSetArg( al[ac],	XmNfractionBase,	2 ); ac++;
    XtSetArg( al[ac],	XmNallowResize,		True ); ac++;
    XtSetArg( al[ac],	XmNskipAdjust,		True ); ac++;

    row= XmCreateForm( parent, WIDGET_NAME, al, ac );

    toggle= appMakeRowToggle( row, labelText, callback, through, 0 );
    appMakeRowText( &text, row, textColumns, textEnabled );

    XtManageChild( toggle );
    XtManageChild( text );
    XtManageChild( row );

    *pRow= row; *pToggle= toggle; *pText= text; return;
    }

/************************************************************************/
/*									*/
/*  Make a frame, possibly with a title.				*/
/*									*/
/************************************************************************/

void appMakeFrame(	Widget *	pFrame,
			Widget		parent,
			char *		title )
    {
    Arg			al[20];
    int			ac= 0;

    Widget		frame;

    ac= 0;
    frame= XmCreateFrame( parent, WIDGET_NAME, al, ac );

    if  ( title )
	{
	XmString	labelString;
	Widget		titleWidget;

	labelString= XmStringCreateLocalized( title );

	ac= 0;
	XtSetArg( al[ac], XmNchildType,		XmFRAME_TITLE_CHILD ); ac++;
	XtSetArg( al[ac], XmNlabelString,	labelString ); ac++;
	XtSetArg( al[ac], XmNchildHorizontalAlignment,
						XmALIGNMENT_CENTER ); ac++;

	titleWidget= XmCreateLabel( frame, WIDGET_NAME, al, ac );

	XmStringFree( labelString );

	XtManageChild( titleWidget );
	}

    *pFrame= frame; return;
    }

/************************************************************************/
/*									*/
/*  Make a frame that is to be filled with a vertical series of widgets	*/
/*									*/
/************************************************************************/

void appMakeVerticalFrame(	Widget *	pFrame,
				Widget *	pBboard,
				Widget *	pPaned,
				Widget		parent,
				char *		title )
    {
    Widget		frame;
    Widget		bboard;
    Widget		paned;

    Arg			al[20];
    int			ac= 0;

    appMakeFrame( &frame, parent, title );

    ac= 0;
    XtSetArg( al[ac],	XmNmarginWidth,		0 ); ac++;
    XtSetArg( al[ac],	XmNmarginHeight,	0 ); ac++;
    bboard= XmCreateForm( frame, WIDGET_NAME, al, ac );

    ac= 0;
    XtSetArg( al[ac],	XmNleftAttachment,	XmATTACH_FORM ); ac++;
    XtSetArg( al[ac],	XmNrightAttachment,	XmATTACH_FORM ); ac++;
    XtSetArg( al[ac],	XmNtopAttachment,	XmATTACH_FORM ); ac++;
    XtSetArg( al[ac],	XmNbottomAttachment,	XmATTACH_FORM ); ac++;

    XtSetArg( al[ac],	XmNsashWidth,		1 ); ac++;
    XtSetArg( al[ac],	XmNsashHeight,		1 ); ac++;
    XtSetArg( al[ac],	XmNseparatorOn,		False ); ac++;
    XtSetArg( al[ac],	XmNmarginWidth,		5 ); ac++;
    XtSetArg( al[ac],	XmNmarginHeight,	5 ); ac++;
    XtSetArg( al[ac],	XmNspacing,		5 ); ac++;
    paned= XmCreatePanedWindow( bboard, WIDGET_NAME, al, ac );

    *pFrame= frame, *pBboard= bboard; *pPaned= paned; return;
    }

/************************************************************************/
/*									*/
/*  Create a text widget that is contained in a column of widgets	*/
/*									*/
/************************************************************************/
void appMakeColumnText(		Widget *	pText,
				Widget		column,
				int		textColumns,
				int		textEnabled )
    {
    Display *		display= XtDisplay( column );
    int			screen= DefaultScreen( display );
    Pixel		whitePixel= WhitePixel( display, screen );

    Widget		text;

    Arg			al[20];
    int			ac= 0;

    if  ( ! APP_PasteTranlations )
	{
	APP_PasteTranlations=
		    XtParseTranslationTable( APP_PasteTranlationString );
	}

    ac= 0;
    XtSetArg( al[ac], XmNnavigationType,	XmTAB_GROUP ); ac++;
    XtSetArg( al[ac], XmNskipAdjust,		True ); ac++;

    XtSetArg( al[ac], XmNmarginHeight,		3 ); ac++;

    if  ( textColumns > 0 )
	{ XtSetArg( al[ac], XmNcolumns,		textColumns ); ac++;	}

    if  ( textEnabled )
	{
	XtSetArg( al[ac], XmNbackground,		whitePixel ); ac++;
	}
    else{
	XtSetArg( al[ac], XmNeditable,			False ); ac++;
	XtSetArg( al[ac], XmNtraversalOn,		False ); ac++;
	XtSetArg( al[ac], XmNcursorPositionVisible,	False ); ac++;
	}

    text= XmCreateText( column, WIDGET_NAME, al, ac );

    if  ( APP_PasteTranlations )
	{ XtOverrideTranslations( text, APP_PasteTranlations ); }

    XtManageChild( text );

    *pText= text;
    }

void appMakeColumnLabel(	Widget *		pLabel,
				Widget			column,
				const char *		labelText )
    {
    Widget		label;

    XmString		labelString;

    Arg			al[20];
    int			ac= 0;

    labelString= XmStringCreateLocalized( (char *)labelText );

    ac= 0;
    XtSetArg( al[ac], XmNrecomputeSize,		True ); ac++;
    XtSetArg( al[ac], XmNalignment,		XmALIGNMENT_BEGINNING ); ac++;
    XtSetArg( al[ac], XmNlabelString,		labelString ); ac++;

    XtSetArg( al[ac], XmNmarginHeight,		8 ); ac++;

    label= XmCreateLabel( column, WIDGET_NAME, al, ac );

    XmStringFree( labelString );

    XtManageChild( label );

    *pLabel= label;
    }

/************************************************************************/
/*									*/
/*  Make two columns to contain the label and text widgets in a		*/
/*  quesionaire like widget.						*/
/*									*/
/************************************************************************/
void appMakeLabelAndTextColumns(	Widget *	pLabelColumn,
					Widget *	pTextColumn,
					Widget *	pColumns,
					Widget		parent )
    {
    Widget		columns;
    Widget		labelColumn;
    Widget		textColumn;

    Arg			al[20];
    int			ac= 0;

    ac= 0;
    XtSetArg( al[ac],	XmNsashWidth,		1 ); ac++;
    XtSetArg( al[ac],	XmNsashHeight,		1 ); ac++;
    XtSetArg( al[ac],	XmNseparatorOn,		False ); ac++;
    /*
    XtSetArg( al[ac],	XmNmarginWidth,		5 ); ac++;
    XtSetArg( al[ac],	XmNmarginHeight,	5 ); ac++;
    XtSetArg( al[ac],	XmNspacing,		5 ); ac++;
    */
    XtSetArg( al[ac],	XmNorientation,		XmHORIZONTAL ); ac++;
    columns= XmCreatePanedWindow( parent, WIDGET_NAME, al, ac );

    ac= 0;
    XtSetArg( al[ac],	XmNsashWidth,		1 ); ac++;
    XtSetArg( al[ac],	XmNsashHeight,		1 ); ac++;
    XtSetArg( al[ac],	XmNseparatorOn,		False ); ac++;
    XtSetArg( al[ac],	XmNmarginWidth,		5 ); ac++;
    XtSetArg( al[ac],	XmNmarginHeight,	5 ); ac++;
    XtSetArg( al[ac],	XmNspacing,		5 ); ac++;
    XtSetArg( al[ac],	XmNskipAdjust,		True ); ac++;
    labelColumn= XmCreatePanedWindow( columns, WIDGET_NAME, al, ac );

    ac= 0;
    XtSetArg( al[ac],	XmNsashWidth,		1 ); ac++;
    XtSetArg( al[ac],	XmNsashHeight,		1 ); ac++;
    XtSetArg( al[ac],	XmNseparatorOn,		False ); ac++;
    XtSetArg( al[ac],	XmNmarginWidth,		5 ); ac++;
    XtSetArg( al[ac],	XmNmarginHeight,	5 ); ac++;
    XtSetArg( al[ac],	XmNspacing,		5 ); ac++;
    XtSetArg( al[ac],	XmNskipAdjust,		False ); ac++;
    textColumn= XmCreatePanedWindow( columns, WIDGET_NAME, al, ac );

    *pLabelColumn= labelColumn;
    *pTextColumn= textColumn;
    *pColumns= columns;

    return;
    }

/************************************************************************/
/*									*/
/*  Make a dialog with a vertical organisation.				*/
/*									*/
/************************************************************************/

void appMakeVerticalDialog(	Widget *			pShell,
				Widget *			pDialog,
				Widget *			pPaned,
				EditApplication *		ea,
				XtCallbackProc			closeCallback,
				void *				through,
				Pixmap				iconPixmap,
				int				withSeparator,
				char *				widgetName )
    {
    Widget		shell;
    Widget		dialog;
    Widget		paned;

    Arg			al[20];
    int			ac= 0;

    MwmHints		hints;

    hints.flags=	MWM_HINTS_FUNCTIONS	|
			MWM_HINTS_DECORATIONS	;
    hints.functions=	MWM_FUNC_MOVE		|
			MWM_FUNC_MINIMIZE	;
    if  ( closeCallback )
	{ hints.functions |= MWM_FUNC_CLOSE;	}

    hints.decorations=	MWM_DECOR_BORDER	|
			MWM_DECOR_TITLE		|
			MWM_DECOR_MENU		|
			MWM_DECOR_MINIMIZE	;

    ac= 0;
    if  ( through )
	{ XtSetArg( al[ac], XmNuserData,	through ); ac++;	}
    XtSetArg( al[ac], XmNdeleteResponse,	XmDO_NOTHING ); ac++;
    XtSetArg( al[ac], XmNallowShellResize,	True );
    if  ( hints.flags & MWM_HINTS_FUNCTIONS )
	{ XtSetArg( al[ac], XmNmwmFunctions,	hints.functions ); ac++; }
    if  ( hints.flags & MWM_HINTS_DECORATIONS )
	{ XtSetArg( al[ac], XmNmwmDecorations,	hints.decorations ); ac++; }
    if  ( iconPixmap )
	{ XtSetArg( al[ac], XmNiconPixmap,	iconPixmap ); ac++;	}

    shell= XmCreateDialogShell( ea->eaTopWidget, widgetName, al, ac );

    /*  Equivalent?
    shell= XtCreatePopupShell( widgetName, xmDialogShellWidgetClass,
						ea->eaTopWidget, al, ac );
    */

    if  ( closeCallback && ea->eaCloseAtom > 0 )
	{
	XmAddWMProtocolCallback( shell, ea->eaCloseAtom,
						    closeCallback, through );
	}

    ac= 0;
    if  ( through )
	{ XtSetArg( al[ac], XmNuserData,	through ); ac++;	}
    XtSetArg( al[ac], XmNmarginWidth,		0 ); ac++;
    XtSetArg( al[ac], XmNmarginHeight,		0 ); ac++;
    XtSetArg( al[ac], XmNallowResize,		True ); ac++;
    XtSetArg( al[ac], XmNdialogStyle,		XmDIALOG_APPLICATION_MODAL );
									ac++;

    dialog= XmCreateForm( shell, WIDGET_NAME, al, ac );

    ac= 0;
    XtSetArg( al[ac], XmNleftAttachment,	XmATTACH_FORM ); ac++;
    XtSetArg( al[ac], XmNrightAttachment,	XmATTACH_FORM ); ac++;
    XtSetArg( al[ac], XmNtopAttachment,		XmATTACH_FORM ); ac++;
    XtSetArg( al[ac], XmNbottomAttachment,	XmATTACH_FORM ); ac++;

    XtSetArg( al[ac], XmNsashWidth,		1 ); ac++;
    XtSetArg( al[ac], XmNsashHeight,		1 ); ac++;
    XtSetArg( al[ac], XmNseparatorOn,		withSeparator != 0 ); ac++;
    XtSetArg( al[ac], XmNmarginWidth,		5 ); ac++;
    XtSetArg( al[ac], XmNmarginHeight,		5 ); ac++;
    XtSetArg( al[ac], XmNspacing,		5 ); ac++;
    paned= XmCreatePanedWindow( dialog, WIDGET_NAME, al, ac );

    *pShell= shell, *pDialog= dialog; *pPaned= paned; return;
    }

/************************************************************************/
/*									*/
/*  Make a popup with a vertical organisation.				*/
/*									*/
/************************************************************************/

void appMakeVerticalPopup(	Widget *			pShell,
				Widget *			pDialog,
				Widget *			pPaned,
				EditApplication *		ea,
				void *				through,
				int				withSeparator,
				char *				widgetName )
    {
    Widget		shell;
    Widget		dialog;
    Widget		paned;

    Arg			al[20];
    int			ac= 0;

    ac= 0;
    if  ( through )
	{ XtSetArg( al[ac], XmNuserData,	through ); ac++;	}
    XtSetArg( al[ac], XmNdeleteResponse,	XmDO_NOTHING ); ac++;
    XtSetArg( al[ac], XmNallowShellResize,	True );

    shell= XtCreatePopupShell( ea->eaMessageDialogName,
					transientShellWidgetClass,
					ea->eaTopWidget, al, ac );

    ac= 0;
    if  ( through )
	{ XtSetArg( al[ac], XmNuserData,	through ); ac++;	}
    XtSetArg( al[ac], XmNmarginWidth,		0 ); ac++;
    XtSetArg( al[ac], XmNmarginHeight,		0 ); ac++;
    XtSetArg( al[ac], XmNallowResize,		True ); ac++;

    dialog= XmCreateForm( shell, WIDGET_NAME, al, ac );

    ac= 0;
    XtSetArg( al[ac], XmNleftAttachment,	XmATTACH_FORM ); ac++;
    XtSetArg( al[ac], XmNrightAttachment,	XmATTACH_FORM ); ac++;
    XtSetArg( al[ac], XmNtopAttachment,		XmATTACH_FORM ); ac++;
    XtSetArg( al[ac], XmNbottomAttachment,	XmATTACH_FORM ); ac++;

    XtSetArg( al[ac], XmNsashWidth,		1 ); ac++;
    XtSetArg( al[ac], XmNsashHeight,		1 ); ac++;
    XtSetArg( al[ac], XmNseparatorOn,		withSeparator != 0 ); ac++;
    XtSetArg( al[ac], XmNmarginWidth,		5 ); ac++;
    XtSetArg( al[ac], XmNmarginHeight,		5 ); ac++;
    XtSetArg( al[ac], XmNspacing,		5 ); ac++;
    XtSetArg( al[ac], XmNallowResize,		True ); ac++;
    paned= XmCreatePanedWindow( dialog, WIDGET_NAME, al, ac );

    *pShell= shell, *pDialog= dialog; *pPaned= paned; return;
    }

/************************************************************************/
/*									*/
/*  For debugging purposes: Give widgets a name of the form file(line)	*/
/*  for where they are made.						*/
/*									*/
/************************************************************************/

char * appWidgetName(	char *	file,
			int	line )
    {
    static char **	names;
    static int		nameCount;

    char **		freshNames;
    char *		freshName;

    int			i;

    freshNames= (char **)realloc( names, ( nameCount+ 1 )* sizeof(char *) );
    if  ( ! freshNames )
	{ XDEB(freshNames); return file;	}
    names= freshNames;

    freshName= (char *)malloc( strlen( file )+ 11 );
    if  ( ! freshName )
	{ XDEB(freshName); return file;	}

    sprintf( freshName, "%s(%d)", file, line );

    for ( i= 0; i < nameCount; freshNames++, i++ )
	{
	if  ( ! strcmp( freshNames[0], freshName ) )
	    { free( freshName ); return freshNames[0];	}
	}

    names[nameCount++]= freshName;

    return freshName;
    }

/************************************************************************/
/*									*/
/*  Get a 'Length' from a text widget.					*/
/*									*/
/************************************************************************/

int appGetLengthFromTextWidget(		Widget		w,
					int *		pValue,
					int *		pChanged,
					int		defaultUnit,
					int		requirePositive )
    {
    int		value;

    char	scratch[50];
    char *	s;

    s= XmTextGetString( w );
    if  ( appGeoLengthFromString( s, defaultUnit, &value )	||
	  ( requirePositive && value < 0 )			)
	{
	XmTextSetSelection( w, 0, strlen( s ),
			    XtLastTimestampProcessed( XtDisplay( w ) ) );
	XtFree( s );
	XmProcessTraversal( w, XmTRAVERSE_CURRENT );

	return -1;
	}

    appGeoLengthToString( scratch, *pValue, defaultUnit );
    if  ( ! strcmp( scratch, s ) )
	{ value= *pValue;	}

    XtFree( s );

    *pChanged= ( value != *pValue );
    *pValue= value;

    return 0;
    }

void appRefuseTextValue(	Widget		w )
    {
    char *	s;

    s= XmTextGetString( w );
    XmTextSetSelection( w, 0, strlen( s ),
			    XtLastTimestampProcessed( XtDisplay( w ) ) );
    XtFree( s );
    XmProcessTraversal( w, XmTRAVERSE_CURRENT );

    return;
    }

/************************************************************************/
/*									*/
/*  Turn a text widget on or off.					*/
/*									*/
/************************************************************************/

void appEnableText(		Widget		text,
				int		enabled )
    {
    if  ( enabled )
	{
	Display *	display= XtDisplay( text );
	int		screen= DefaultScreen( display );

	XtVaSetValues( text,
		    XmNbackground,		WhitePixel( display, screen ),
		    XmNeditable,		True,
		    XmNtraversalOn,		True,
		    XmNcursorPositionVisible,	True,
		    NULL );
	}
    else{
	Pixel		background;

	XtVaGetValues( XtParent( text ),
			XmNbackground,			&background,
			NULL );

	XtVaSetValues( text,
			    XmNbackground,		background,
			    XmNeditable,		False,
			    XmNtraversalOn,		False,
			    XmNcursorPositionVisible,	False,
			    NULL );
	}
    }
