/************************************************************************/
/*  A Page Layout tool.							*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<debugon.h>

#   include	<X11/Xatom.h>
#   include	<X11/IntrinsicP.h>
#   include	<Xm/Text.h>
#   include	<Xm/MainW.h>
#   include	<Xm/Form.h>
#   include	<Xm/Label.h>
#   include	<Xm/Frame.h>
#   include	<Xm/DrawingA.h>
#   include	<Xm/ToggleB.h>
#   include	<Xm/RowColumn.h>
#   include	<Xm/PanedW.h>

#   include	<Xm/MwmUtil.h>

#   include	<Xm/Protocols.h>


#   include	<appFrame.h>
#   include	"appUnit.h"
#   include	<appGeoString.h>
#   include	"appPaper.h"

#   include	"appUtil.h"

#   define	DRH_CM	4.5

/************************************************************************/
/*  Represents a print tool.						*/
/************************************************************************/
#   define	FILEL	400

typedef struct AppPageToolResources
    {
    char *	aptrUnitType;

    char *	aptrPaper;
    char *	aptrCustom;
    char *	aptrPortrait;
    char *	aptrLandscape;
    char *	aptrMargins;
    char *	aptrLeftMargin;
    char *	aptrTopMargin;
    char *	aptrRightMargin;
    char *	aptrBottomMargin;
    char *	aptrRevert;
    char *	aptrSet;
#   if 0
    For use as a dialog.
    char *	aptrOk;
    char *	aptrCancel;
#   endif
    } AppPageToolResources;

typedef struct AppPageTool
    {
    GC				aptGc;

    Widget			aptTopWidget;
    Widget			aptMainWidget;

    Widget			aptPageDrawing;

    Widget			aptPagePulldown;
    Widget			aptPageMenu;

    Widget			aptSizeText;

    Widget			aptPortraitRadio;
    Widget			aptLandscapeRadio;

    Widget			aptLeftMarginText;
    Widget			aptTopMarginText;
    Widget			aptRightMarginText;
    Widget			aptBottomMarginText;

    AppToolDestroy		aptDestroy;
    PageToolSetProperties	aptSetProperties;

    int				aptSizeChosen;
    int				aptSizeSet;

    DocumentGeometry		aptGeometryChosen;
    DocumentGeometry		aptGeometrySet;

    int				aptLandscapeChosen;

    int				aptUnitType;
    int				aptCustomPaperSize;
    void *			aptTarget;
    } AppPageTool;


# define xx(x)	x,x

static XtResource APP_PageToolresourceTable[]=
    {
	{ xx("unit"), XtRString, sizeof(char *),
		    offsetof(AppPageToolResources,aptrUnitType),
		    XtRString, "inch" },
	{ xx("pageToolPaper"), XtRString, sizeof(char *),
		    offsetof(AppPageToolResources,aptrPaper),
		    XtRString, "Paper" },
	{ xx("pageToolCustom"), XtRString, sizeof(char *),
		    offsetof(AppPageToolResources,aptrCustom),
		    XtRString, "Custom" },
	{ xx("pageToolPortrait"), XtRString, sizeof(char *),
		    offsetof(AppPageToolResources,aptrPortrait),
		    XtRString, "Portrait" },
	{ xx("pageToolLandscape"), XtRString, sizeof(char *),
		    offsetof(AppPageToolResources,aptrLandscape),
		    XtRString, "Landscape" },
	{ xx("pageToolMargins"), XtRString, sizeof(char *),
		    offsetof(AppPageToolResources,aptrMargins),
		    XtRString, "Margins" },
	{ xx("pageToolLeftMargin"), XtRString, sizeof(char *),
		    offsetof(AppPageToolResources,aptrLeftMargin),
		    XtRString, "Left" },
	{ xx("pageToolTopMargin"), XtRString, sizeof(char *),
		    offsetof(AppPageToolResources,aptrTopMargin),
		    XtRString, "Top" },
	{ xx("pageToolRightMargin"), XtRString, sizeof(char *),
		    offsetof(AppPageToolResources,aptrRightMargin),
		    XtRString, "Right" },
	{ xx("pageToolBottomMargin"), XtRString, sizeof(char *),
		    offsetof(AppPageToolResources,aptrBottomMargin),
		    XtRString, "Bottom" },
	{ xx("pageToolRevert"), XtRString, sizeof(char *),
		    offsetof(AppPageToolResources,aptrRevert),
		    XtRString, "Revert" },
	{ xx("pageToolSet"), XtRString, sizeof(char *),
		    offsetof(AppPageToolResources,aptrSet),
		    XtRString, "Set" },
#	if 0
	For use as a Dialog.
	{ xx("pageToolOk"), XtRString, sizeof(char *),
		    offsetof(AppPageToolResources,aptrOk),
		    XtRString, "Ok" },
	{ xx("pageToolCancel"), XtRString, sizeof(char *),
		    offsetof(AppPageToolResources,aptrCancel),
		    XtRString, "Cancel" },
#	endif
    };

/************************************************************************/
/*  Show the size of the paper in the Text.				*/
/************************************************************************/
static void appPageToolShowMargins(	AppPageTool *	apt )
    {
    char			scratch[50];
    int				unitInt= apt->aptUnitType;
    const DocumentGeometry *	dg= &(apt->aptGeometryChosen);

    appGeoLengthToString( scratch, dg->dgLeftMarginTwips, unitInt );
    XmTextSetString( apt->aptLeftMarginText, scratch );

    appGeoLengthToString( scratch, dg->dgTopMarginTwips, unitInt );
    XmTextSetString( apt->aptTopMarginText, scratch );

    appGeoLengthToString( scratch, dg->dgRightMarginTwips, unitInt );
    XmTextSetString( apt->aptRightMarginText, scratch );

    appGeoLengthToString( scratch, dg->dgBottomMarginTwips, unitInt );
    XmTextSetString( apt->aptBottomMarginText, scratch );

    return;
    }

static void appPageToolShowWidthHeight(	AppPageTool *	apt )
    {
    char			scratch[50];
    int				unitInt= apt->aptUnitType;
    const DocumentGeometry *	dg= &(apt->aptGeometryChosen);

    appGeoRectangleToString( scratch,
		    dg->dgPaperWideTwips, dg->dgPaperHighTwips, unitInt );

    XmTextSetString( apt->aptSizeText, scratch );

    return;
    }

static void appPageToolShowPaperSize(	AppPageTool *	apt )
    {
    WidgetList		children;
    Cardinal		childCount= 0;

    XtVaGetValues( apt->aptPagePulldown,
		    XmNchildren,	&children,
		    XmNnumChildren,	&childCount,
		    NULL );

    if  ( apt->aptSizeChosen >= 0 && apt->aptSizeChosen < (int)childCount )
	{
	XtVaSetValues( apt->aptPageMenu,
			    XmNmenuHistory,	children[apt->aptSizeChosen],
			    NULL );
	}
    else{
	XtVaSetValues( apt->aptPageMenu,
			    XmNmenuHistory,	(Widget)0,
			    NULL );
	}

    return;
    }

/************************************************************************/
/*  Draw a schematic view of the page.					*/
/************************************************************************/
static void appPageToolDrawPage(	Widget		w,
					XtPointer	voidapt,
					XtPointer	voidcbs	)
    {
    AppPageTool *		apt= (AppPageTool *)voidapt;
    const DocumentGeometry *	dg= &(apt->aptGeometryChosen);

    Display *			display= XtDisplay( w );
    int				screen= DefaultScreen( display );
    Window			win= XtWindow( w );
    GC				gc= apt->aptGc;

    Dimension			width;
    Dimension			height;

    double			wideCm;
    double			highCm;

    int				x0;
    int				x1;
    int				y0;
    int				y1;

    int				y;
	
    Pixel			backPixel;

    XtVaGetValues( w,
			XmNwidth,	&width,
			XmNheight,	&height,
			XmNbackground,	&backPixel,
			NULL );

    XSetForeground( display, gc, backPixel );
    XFillRectangle( display, win, gc, 0, 0, width, height );

    wideCm= ( 2.54* dg->dgPaperWideTwips )/ ( 20.0* 72.27 );
    highCm= ( 2.54* dg->dgPaperHighTwips )/ ( 20.0* 72.27 );

#   define	FAC	(DRH_CM*10)

    x0= (int)( width/2- ( wideCm* height )/ (2*FAC) );
    x1= (int)( width/2+ ( wideCm* height )/ (2*FAC) );
    y0= (int)( height/2- ( highCm* height )/ (2*FAC) );
    y1= (int)( height/2+ ( highCm* height )/ (2*FAC) );

    XSetForeground( display, gc, WhitePixel( display, screen ) );
    XFillRectangle( display, win, gc, x0, y0, x1- x0, y1- y0 );

    XSetForeground( display, gc, BlackPixel( display, screen ) );
    XDrawRectangle( display, win, gc, x0- 1, y0- 1, x1- x0+ 1, y1- y0+ 1 );

    x0= dg->dgPaperWideTwips/2- dg->dgLeftMarginTwips;
    wideCm= ( 2.54* x0 )/ ( 20.0* 72.27 );
    x0= (int)( width/2- ( wideCm* height )/ FAC );

    x1= dg->dgPaperWideTwips/2- dg->dgRightMarginTwips;
    wideCm= ( 2.54* x1 )/ ( 20.0* 72.27 );
    x1= (int)( width/2+ ( wideCm* height )/ FAC );

    y0= dg->dgPaperHighTwips/2- dg->dgTopMarginTwips;
    highCm= ( 2.54* y0 )/ ( 20.0* 72.27 );
    y0= (int)( height/2- ( highCm* height )/ FAC );

    y1= dg->dgPaperHighTwips/2- dg->dgBottomMarginTwips;
    highCm= ( 2.54* y1 )/ ( 20.0* 72.27 );
    y1= (int)( height/2+ ( highCm* height )/ FAC );

    XSetForeground( display, gc, backPixel );
    XDrawRectangle( display, win, gc, x0- 1, y0- 1, x1- x0+ 1, y1- y0+ 1 );

    XSetForeground( display, gc, BlackPixel( display, screen ) );

    y= y0+ 2;
    while( y < y1- 1 )
	{
	int	x= x0+ 1;
	int	c;

	c= (int)( 5+ (75.0* rand() )/ (RAND_MAX+ 1.0 ) );

	while( c > 0 )
	    {
	    int	l;

	    l= (int) ( (1.0* (x1- x0)* rand() )/ (RAND_MAX+ 1.0 ) );
	    l= 2+ l/10;

	    if  ( x+ l >= x1- 1 )
		{
		y += 2; x= x0+ 1;

		if  ( y >= y1- 1 )
		    { break;	}
		}

	    XDrawRectangle( display, win, gc, x, y, l, 0 );

	    x += l+ 2; c--;
	    }

	y += 4;
	}

    return;
    }

/************************************************************************/
/*  Show the orientation in the radiogroup.				*/
/************************************************************************/
static void appPageToolShowOrientation(	AppPageTool *	apt )
    {
    if  ( apt->aptLandscapeChosen )
	{
	XmToggleButtonSetState( apt->aptPortraitRadio,  0, False );
	XmToggleButtonSetState( apt->aptLandscapeRadio, 1, False );
	}
    else{
	XmToggleButtonSetState( apt->aptPortraitRadio,  1, False );
	XmToggleButtonSetState( apt->aptLandscapeRadio, 0, False );
	}

    return;
    }

/************************************************************************/
/*  Extract a paper size from the Text widget.				*/
/************************************************************************/
static int appPageToolGetPapersize(	Widget			w,
					AppPageTool *		apt,
					DocumentGeometry *	dg )
    {
    char *	s;

    s= XmTextGetString( w );

    if  ( appGeoRectangleFromString( s, apt->aptUnitType,
		    &(dg->dgPaperWideTwips), &(dg->dgPaperHighTwips) )	||
	  dg->dgPaperWideTwips <= 0					||
	  dg->dgPaperHighTwips <= 0					)
	{
	XmTextSetSelection( w, 0, strlen( s ),
			XtLastTimestampProcessed( XtDisplay( w ) ) );

	XtFree( s );
	XmProcessTraversal( w, XmTRAVERSE_CURRENT );
	return -1;
	}

    XtFree( s );
    return 0;
    }

/************************************************************************/
/*									*/
/*  A paper size was chosen.						*/
/*									*/
/************************************************************************/
static void appPapersizeChosen(		Widget		w,
					XtPointer	voidapt,
					XtPointer	voidpbcs	 )
    {
    short		sizeChosen= -1;
    AppPageTool *	apt= (AppPageTool *)voidapt;

    int			width;
    int			height;

    XtVaGetValues( w,
			XmNpositionIndex,	&sizeChosen,
			NULL );

    apt->aptSizeChosen= sizeChosen;

    if  ( appPaperGetInformation( sizeChosen,
					&width, &height, (const char **)0 ) )
	{ return;	}

    if  ( apt->aptLandscapeChosen )
	{
	apt->aptGeometryChosen.dgPaperWideTwips= height;
	apt->aptGeometryChosen.dgPaperHighTwips= width;
	}
    else{
	apt->aptGeometryChosen.dgPaperWideTwips= width;
	apt->aptGeometryChosen.dgPaperHighTwips= height;
	}

    appPageToolShowWidthHeight( apt );

    XClearArea( XtDisplay( apt->aptPageDrawing ),
				    XtWindow( apt->aptPageDrawing ),
				    0, 0, 0, 0, True );

    return;
    }

static void appPageToolPaperSizeChanged(	Widget		w,
						XtPointer	voidapt,
						XtPointer	voidcbs	 )
    {
    AppPageTool *			apt= (AppPageTool *)voidapt;

    DocumentGeometry			dg;

    dg= apt->aptGeometryChosen;

    if  ( appPageToolGetPapersize( apt->aptSizeText, apt, &dg ) )
	{ LDEB(1); return;	}

    if  ( apt->aptLandscapeChosen )
	{
	apt->aptGeometryChosen.dgPaperWideTwips= dg.dgPaperHighTwips;
	apt->aptGeometryChosen.dgPaperHighTwips= dg.dgPaperWideTwips;
	}
    else{
	apt->aptGeometryChosen.dgPaperWideTwips= dg.dgPaperWideTwips;
	apt->aptGeometryChosen.dgPaperHighTwips= dg.dgPaperHighTwips;
	}

    apt->aptSizeChosen= apt->aptCustomPaperSize;
    appPageToolShowPaperSize( apt );

    XClearArea( XtDisplay( apt->aptPageDrawing ),
				    XtWindow( apt->aptPageDrawing ),
				    0, 0, 0, 0, True );

    return;
    }

/************************************************************************/
/*  The buttons have been pushed.					*/
/************************************************************************/
static void appPageToolRevertPushed(	Widget		w,
					XtPointer	voidapt,
					XtPointer	voidpbcs	 )
    {
    AppPageTool *	apt= (AppPageTool *)voidapt;

    apt->aptSizeChosen= apt->aptSizeSet;
    appPageToolShowPaperSize( apt );

    apt->aptGeometryChosen.dgPaperWideTwips=
					apt->aptGeometrySet.dgPaperWideTwips;
    apt->aptGeometryChosen.dgPaperHighTwips=
					apt->aptGeometrySet.dgPaperHighTwips;
    appPageToolShowWidthHeight( apt );

    apt->aptLandscapeChosen=
			apt->aptGeometryChosen.dgPaperWideTwips >
			apt->aptGeometryChosen.dgPaperHighTwips;
    appPageToolShowOrientation( apt );

    apt->aptGeometryChosen.dgLeftMarginTwips=
					apt->aptGeometrySet.dgLeftMarginTwips;
    apt->aptGeometryChosen.dgTopMarginTwips=
					apt->aptGeometrySet.dgTopMarginTwips;
    apt->aptGeometryChosen.dgRightMarginTwips=
					apt->aptGeometrySet.dgRightMarginTwips;
    apt->aptGeometryChosen.dgBottomMarginTwips=
					apt->aptGeometrySet.dgBottomMarginTwips;
    appPageToolShowMargins( apt );

    XClearArea( XtDisplay( apt->aptPageDrawing ),
				    XtWindow( apt->aptPageDrawing ),
				    0, 0, 0, 0, True );
    return;
    }

/************************************************************************/
/*									*/
/*  Get one/all margins from the text widgets.				*/
/*									*/
/************************************************************************/

static int appPageToolGetMargins(	AppPageTool *		apt,
					DocumentGeometry *	dg )
    {
    int		changed;
    const int	requirePositive= 1;

    if  ( appGetLengthFromTextWidget( apt->aptLeftMarginText,
				    &dg->dgLeftMarginTwips, &changed,
				    apt->aptUnitType, requirePositive ) )
	{ return -1;	}

    if  ( appGetLengthFromTextWidget( apt->aptTopMarginText,
				    &dg->dgTopMarginTwips, &changed,
				    apt->aptUnitType, requirePositive ) )
	{ return -1;	}

    if  ( appGetLengthFromTextWidget( apt->aptRightMarginText,
				    &dg->dgRightMarginTwips, &changed,
				    apt->aptUnitType, requirePositive ) )
	{ return -1;	}

    if  ( appGetLengthFromTextWidget( apt->aptBottomMarginText,
				    &dg->dgBottomMarginTwips, &changed,
				    apt->aptUnitType, requirePositive ) )
	{ return -1;	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Check margins.							*/
/*									*/
/************************************************************************/

static int appPageToolCheckMargins(	DocumentGeometry *	dg )
    {
    if  ( dg->dgLeftMarginTwips+ dg->dgRightMarginTwips >= 
						    dg->dgPaperWideTwips )
	{ return -1;	}

    if  ( dg->dgTopMarginTwips+ dg->dgBottomMarginTwips >= 
						    dg->dgPaperWideTwips )
	{ return -1;	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  The 'Set' button has been pushed:					*/
/*									*/
/*	Retrieve the margins and the paper size.			*/
/*	Check the values						*/
/*	If things are ok, report the values back to the application.	*/
/*									*/
/************************************************************************/

static void appPageToolSetPushed(	Widget		w,
					XtPointer	voidapt,
					XtPointer	voidpbcs	 )
    {
    AppPageTool *	apt= (AppPageTool *)voidapt;

    DocumentGeometry	dg;

    if  ( appPageToolGetMargins( apt, &dg ) )
	{ return;	}

    if  ( appPageToolGetPapersize( apt->aptSizeText, apt, &dg ) )
	{ return;	}

    if  ( appPageToolCheckMargins( &dg ) )
	{ return;	}

    if  ( ! apt->aptSetProperties )
	{ XDEB(apt->aptSetProperties); return;	}

    appPageToolSetProperties( (void *)apt, &dg );

    (*apt->aptSetProperties)( apt->aptTarget, &dg );

    return;
    }

/************************************************************************/
/*  Fill the list of paper sizes.					*/
/************************************************************************/
static void appPageToolFillPagesizeMenu(	AppPageToolResources *	aptr,
						AppPageTool *		apt )
    {
    Dimension		width;
    const char *	label;
    int			i;
    Widget		child0= (Widget)0;
    Widget		fresh;

    XtVaGetValues( apt->aptPageMenu,
			XmNwidth,		&width,
			NULL );

    appEmptyPulldownList( apt->aptPagePulldown );

    i= 0;
    while( ! appPaperGetInformation( i, (int *)0, (int *)0, &label ) )
	{
	fresh= appPulldownMakeOption( apt->aptPagePulldown,
			    label, width, appPapersizeChosen, (void *)apt );

	if  ( i == 0 )
	    { child0= fresh;	}

	i++;
	}

    apt->aptCustomPaperSize= i;
    fresh= appPulldownMakeOption( apt->aptPagePulldown,
		aptr->aptrCustom, width, appPapersizeChosen, (void *)apt );
    if  ( i == 0 )
	{ child0= fresh;	}

    if  ( child0 )
	{
	XtVaSetValues( apt->aptPageMenu,
			    XmNmenuHistory,		child0,
			    NULL );

	apt->aptSizeChosen= 0;
	}

    appPulldownSetWidth( apt->aptPageMenu, width );
    }

/************************************************************************/
/*  A find tool must be destroyed.					*/
/************************************************************************/
static void appClosePageTool(		Widget		w,
					XtPointer	voidapt,
					XtPointer	voidlcs	 )
    {
    AppPageTool *	apt= (AppPageTool *)voidapt;

    if  ( apt->aptDestroy )
	{ (*apt->aptDestroy)( apt->aptTarget );	}

    if  ( apt->aptGc )
	{ XFreeGC( XtDisplay( w ), apt->aptGc );	}

    XtDestroyWidget( w );

    free( apt );

    return;
    }

/************************************************************************/
/*									*/
/*  One of the margins has been changed by the user.			*/
/*									*/
/************************************************************************/
static void appPageToolMarginChanged(	Widget		w,
					XtPointer	voidapt,
					XtPointer	voidcbs	 )
    {
    AppPageTool *			apt= (AppPageTool *)voidapt;

    DocumentGeometry			dg;

    dg= apt->aptGeometryChosen;

    if  ( appPageToolGetMargins( apt, &dg ) )
	{ return;	}

    if  ( appPageToolCheckMargins( &dg ) )
	{ return;	}

    apt->aptGeometryChosen.dgLeftMarginTwips= dg.dgLeftMarginTwips;
    apt->aptGeometryChosen.dgTopMarginTwips= dg.dgTopMarginTwips;
    apt->aptGeometryChosen.dgRightMarginTwips= dg.dgRightMarginTwips;
    apt->aptGeometryChosen.dgBottomMarginTwips= dg.dgBottomMarginTwips;

    XClearArea( XtDisplay( apt->aptPageDrawing ),
				    XtWindow( apt->aptPageDrawing ),
				    0, 0, 0, 0, True );

    return;
    }

/************************************************************************/
/*  One of the orientation toggle buttons has been pushed.		*/
/************************************************************************/
static void appPageToolOrientationChosen(	Widget		w,
						XtPointer	voidapt,
						XtPointer	voidtbcs  )
    {
    AppPageTool *			apt= (AppPageTool *)voidapt;
    XmToggleButtonCallbackStruct *	tbcs;
    int					swap= 0;

    tbcs= (XmToggleButtonCallbackStruct *)voidtbcs;

    if  ( w == apt->aptPortraitRadio )
	{
	if  ( apt->aptLandscapeChosen )
	    {
	    XmToggleButtonSetState( apt->aptLandscapeRadio, 0, False );
	    apt->aptLandscapeChosen= 0;
	    swap= 1;
	    }
	else{
	    XmToggleButtonSetState( apt->aptPortraitRadio, 1, False );
	    }
	}

    if  ( w == apt->aptLandscapeRadio )
	{
	if  ( apt->aptLandscapeChosen )
	    {
	    XmToggleButtonSetState( apt->aptLandscapeRadio, 1, False );
	    }
	else{
	    XmToggleButtonSetState( apt->aptPortraitRadio, 0, False );
	    apt->aptLandscapeChosen= 1;
	    swap= 1;
	    }
	}

    if  ( swap )
	{
	swap= apt->aptGeometryChosen.dgPaperWideTwips;

	apt->aptGeometryChosen.dgPaperWideTwips=
		  apt->aptGeometryChosen.dgPaperHighTwips;

	apt->aptGeometryChosen.dgPaperHighTwips= swap;

	appPageToolShowWidthHeight( apt );

	XClearArea( XtDisplay( apt->aptPageDrawing ),
				    XtWindow( apt->aptPageDrawing ),
				    0, 0, 0, 0, True );
	}

    return;
    }

/************************************************************************/
/*  Make the frame for the margins.					*/
/************************************************************************/
static Widget appPageToolMakeMarginFrame( XtAppContext		appContext,
					Widget			parentForm,
					Display *		display,
					AppPageToolResources *	aptr,
					AppPageTool *		apt )
    {
    Widget	marginFrame;

    Widget	insideWidget;
    Widget	leftColumn;
    Widget	rightColumn;

    Widget	label;
    Widget	row;

    Arg		al[20];
    int		ac;

    appMakeFrame( &marginFrame, parentForm, aptr->aptrMargins );

    ac= 0;
    XtSetArg( al[ac],	XmNfractionBase,	2 ); ac++;
    XtSetArg( al[ac],	XmNallowResize,		True ); ac++;
    XtSetArg( al[ac],	XmNskipAdjust,		True ); ac++;
    insideWidget= XmCreateForm( marginFrame, WIDGET_NAME, al, ac );

    ac= 0;
    XtSetArg( al[ac],	XmNtopAttachment,	XmATTACH_FORM ); ac++;
    XtSetArg( al[ac],	XmNbottomAttachment,	XmATTACH_FORM ); ac++;
    XtSetArg( al[ac],	XmNleftAttachment,	XmATTACH_POSITION ); ac++;
    XtSetArg( al[ac],	XmNrightAttachment,	XmATTACH_POSITION ); ac++;
    XtSetArg( al[ac],	XmNleftPosition,	0 ); ac++;
    XtSetArg( al[ac],	XmNrightPosition,	1 ); ac++;

    XtSetArg( al[ac],	XmNsashWidth,		1 ); ac++;
    XtSetArg( al[ac],	XmNsashHeight,		1 ); ac++;
    XtSetArg( al[ac],	XmNseparatorOn,		False ); ac++;
    XtSetArg( al[ac],	XmNmarginWidth,		5 ); ac++;
    XtSetArg( al[ac],	XmNmarginHeight,	5 ); ac++;
    XtSetArg( al[ac],	XmNspacing,		5 ); ac++;
    XtSetArg( al[ac],	XmNallowResize,		True ); ac++;
    leftColumn= XmCreatePanedWindow( insideWidget, WIDGET_NAME, al, ac );

    ac= 0;
    XtSetArg( al[ac],	XmNtopAttachment,	XmATTACH_FORM ); ac++;
    XtSetArg( al[ac],	XmNbottomAttachment,	XmATTACH_FORM ); ac++;
    XtSetArg( al[ac],	XmNleftAttachment,	XmATTACH_POSITION ); ac++;
    XtSetArg( al[ac],	XmNrightAttachment,	XmATTACH_POSITION ); ac++;
    XtSetArg( al[ac],	XmNleftPosition,	1 ); ac++;
    XtSetArg( al[ac],	XmNrightPosition,	2 ); ac++;

    XtSetArg( al[ac],	XmNsashWidth,		1 ); ac++;
    XtSetArg( al[ac],	XmNsashHeight,		1 ); ac++;
    XtSetArg( al[ac],	XmNseparatorOn,		False ); ac++;
    XtSetArg( al[ac],	XmNmarginWidth,		5 ); ac++;
    XtSetArg( al[ac],	XmNmarginHeight,	5 ); ac++;
    XtSetArg( al[ac],	XmNspacing,		5 ); ac++;
    XtSetArg( al[ac],	XmNallowResize,		True ); ac++;
    rightColumn= XmCreatePanedWindow( insideWidget, WIDGET_NAME, al, ac );

    /**********************/

    appMakeLabelAndTextRow( &row, &label, &(apt->aptLeftMarginText),
			    leftColumn, aptr->aptrLeftMargin, 8, True );
    appMakeLabelAndTextRow( &row, &label, &(apt->aptRightMarginText),
			    leftColumn, aptr->aptrRightMargin, 8, True );

    appMakeLabelAndTextRow( &row, &label, &(apt->aptTopMarginText),
			    rightColumn, aptr->aptrTopMargin, 8, True );
    appMakeLabelAndTextRow( &row, &label, &(apt->aptBottomMarginText),
			    rightColumn, aptr->aptrBottomMargin, 8, True );

    XtAddCallback( apt->aptLeftMarginText, XmNactivateCallback,
				    appPageToolMarginChanged, (void *)apt );

    XtAddCallback( apt->aptTopMarginText, XmNactivateCallback,
				    appPageToolMarginChanged, (void *)apt );

    XtAddCallback( apt->aptRightMarginText, XmNactivateCallback,
				    appPageToolMarginChanged, (void *)apt );

    XtAddCallback( apt->aptBottomMarginText, XmNactivateCallback,
				    appPageToolMarginChanged, (void *)apt );

    XtManageChild( leftColumn );
    XtManageChild( rightColumn );
    XtManageChild( insideWidget );
    XtManageChild( marginFrame );

    return marginFrame;
    }

/************************************************************************/
/*  Make the frame for paper size and orientation.			*/
/************************************************************************/
static Widget appPageToolMakePaperFrame( Widget			parentForm,
					Display *		display,
					AppPageToolResources *	aptr,
					AppPageTool *		apt )
    {
    Widget	paperFrame;
    Widget	insideWidget;

    Widget	toggleRow;

    Arg		al[20];
    int		ac;

    appMakeFrame( &paperFrame, parentForm, aptr->aptrPaper );

    /**********************/
    ac= 0;
    XtSetArg( al[ac],	XmNsashWidth,		1 ); ac++;
    XtSetArg( al[ac],	XmNsashHeight,		1 ); ac++;
    XtSetArg( al[ac],	XmNseparatorOn,		False ); ac++;
    XtSetArg( al[ac],	XmNmarginWidth,		5 ); ac++;
    XtSetArg( al[ac],	XmNmarginHeight,	5 ); ac++;
    XtSetArg( al[ac],	XmNspacing,		5 ); ac++;
    insideWidget= XmCreatePanedWindow( paperFrame, WIDGET_NAME, al, ac );

    /**********************/
    appMakePulldownList( &apt->aptPagePulldown,
					&apt->aptPageMenu, insideWidget );

    /**********************/
    appMakeColumnText( &(apt->aptSizeText), insideWidget, 0, True );

    XtAddCallback( apt->aptSizeText, XmNactivateCallback,
				    appPageToolPaperSizeChanged, (void *)apt );

    /**********************/

    toggleRow= appMakeButtonRow( insideWidget, 2 );

    apt->aptPortraitRadio= appMakeRowToggle( toggleRow,
	    aptr->aptrPortrait, appPageToolOrientationChosen, (void *)apt, 0 );

    apt->aptLandscapeRadio= appMakeRowToggle( toggleRow,
	    aptr->aptrLandscape, appPageToolOrientationChosen, (void *)apt, 1 );

    /**********************/

    XtManageChild( apt->aptPageMenu );
    XtManageChild( toggleRow );

    XtManageChild( insideWidget );
    XtManageChild( paperFrame );

    return paperFrame;
    }

/************************************************************************/
/*  Make the location for the schematic drawing of the page.		*/
/************************************************************************/
static Widget appPageToolMakeDrawing(	Widget		parentForm,
					Display *	display,
					AppPageTool *	apt )
    {
    Widget	drawing;

    Arg		al[20];
    int		ac= 0;

    int		screen= DefaultScreen( display );
    int		pixPerCM;

    pixPerCM= ( 10* DisplayHeight( display, screen ) )/
					DisplayHeightMM( display, screen );

    XtSetArg( al[ac],	XmNheight,		(int)(DRH_CM* pixPerCM) ); ac++;
    XtSetArg( al[ac],	XmNtraversalOn,		False ); ac++;
    XtSetArg( al[ac],	XmNsensitive,		False ); ac++;
    XtSetArg( al[ac],	XmNnavigationType,	XmNONE ); ac++;

    drawing= XmCreateDrawingArea( parentForm, WIDGET_NAME, al, ac );

    XtAddCallback( drawing, XmNexposeCallback,
					appPageToolDrawPage, (void *)apt );

    XtManageChild( drawing );

    return drawing;
    }

/************************************************************************/
/*									*/
/*  Make the form with the two buttons.					*/
/*									*/
/************************************************************************/
static Widget appPageToolMakeButtonRow( Widget			parent,
					AppPageToolResources *	aptr,
					AppPageTool *		apt )
    {
    Widget	row;
    Widget	revertButton;
    Widget	setButton;

    row= appMakeButtonRow( parent, 2 );

    /**********************/

    revertButton= appMakeRowButton( row, aptr->aptrRevert,
			    appPageToolRevertPushed, (void *)apt, 0, False );

    /**********************/

    setButton= appMakeRowButton( row, aptr->aptrSet,
			    appPageToolSetPushed, (void *)apt, 1, False );

    /**********************/

    XtManageChild( row );

    return row;
    }

/************************************************************************/
/*  The page tool has been closed, remember so.				*/
/************************************************************************/
static void appPageToolClosed(		void *		voidea	)
    {
    EditApplication *	ea=	(EditApplication *)voidea;

    ea->eaPageTool= (void *)0;
    }

/************************************************************************/
/*									*/
/*  make a page tool.							*/
/*									*/
/************************************************************************/

void * appMakePageTool(	EditApplication *	ea,
			Widget			pageOption,
			const char *		pixmapName,
			PageToolSetProperties	setProperties )
    {
    Display *		display= XtDisplay( pageOption );
    AppPageTool *	apt;
    
    Arg			al[20];
    int			ac= 0;

    Widget		paperFrame;
    Widget		marginFrame;
    Widget		buttonForm;

    Dimension		width;

    MwmHints		hints;

    Pixmap		iconPixmap= (Pixmap)0;

    static int			gotResources= 0;
    static AppPageToolResources	aptr;

    if  ( ! gotResources )
	{
	XtGetApplicationResources( ea->eaTopWidget, &aptr,
				    APP_PageToolresourceTable,
				    XtNumber(APP_PageToolresourceTable),
				    NULL, 0 );

	gotResources= 1;
	}

    if  ( appGetImagePixmap( ea, pixmapName, &iconPixmap )  )
	{ SDEB(pixmapName); return (void *)0;	}

    hints.flags= MWM_HINTS_FUNCTIONS|MWM_HINTS_DECORATIONS;
    hints.functions=	MWM_FUNC_MOVE		|
			MWM_FUNC_MINIMIZE	|
			MWM_FUNC_CLOSE		;
    hints.decorations=	MWM_DECOR_BORDER	|
			MWM_DECOR_TITLE		|
			MWM_DECOR_MENU		|
			MWM_DECOR_MINIMIZE	;

    apt= (AppPageTool *)malloc( sizeof(AppPageTool) );
    if  ( ! apt )
	{ XDEB(apt); return (void *)0;	}

    apt->aptUnitType= appUnitTypeInt( aptr.aptrUnitType );
    if  ( apt->aptUnitType < 0 )
	{ SDEB(aptr.aptrUnitType); apt->aptUnitType= UNITtyINCH;	}

    apt->aptDestroy= appPageToolClosed;
    apt->aptSetProperties= setProperties;
    apt->aptTarget= (void *)ea;
    apt->aptCustomPaperSize= -1;

    apt->aptSizeChosen= -1;
    apt->aptSizeSet= -1;
    apt->aptGc= (GC)0;
    
    XtSetArg( al[ac], XmNuserData,	(void *)apt ); ac++;
    XtSetArg( al[ac], XmNdeleteResponse, XmDO_NOTHING ); ac++;
    XtSetArg( al[ac], XmNmwmDecorations, hints.decorations ); ac++;
    XtSetArg( al[ac], XmNmwmFunctions,	hints.functions ); ac++;
    XtSetArg( al[ac], XmNinput,		True ); ac++;

    if  ( iconPixmap )
	{ XtSetArg( al[ac], XmNiconPixmap,	iconPixmap ); ac++; }

    XtSetArg( al[ac], XmNwidth, 275 ); ac++;

    apt->aptTopWidget= XtAppCreateShell( ea->eaApplicationName,
					    ea->eaPageToolName,
					    applicationShellWidgetClass,
					    ea->eaDisplay, al, ac );


    appSetShellTitle( apt->aptTopWidget, pageOption, ea->eaApplicationName );

    XtAddEventHandler( apt->aptTopWidget, StructureNotifyMask, False,
					appFixSize, (void *)apt );


    if  ( ea->eaCloseAtom > 0 )
	{
	XmAddWMProtocolCallback( apt->aptTopWidget, ea->eaCloseAtom,
					appClosePageTool, (XtPointer)apt );
	}

    ac= 0;
    XtSetArg( al[ac], XmNuserData, (void *)apt ); ac++;

    ac= 0;
    XtSetArg( al[ac],	XmNuserData,		(void *)apt ); ac++;
    XtSetArg( al[ac],	XmNsashWidth,		1 ); ac++;
    XtSetArg( al[ac],	XmNsashHeight,		1 ); ac++;
    XtSetArg( al[ac],	XmNseparatorOn,		False ); ac++;
    XtSetArg( al[ac],	XmNmarginWidth,		5 ); ac++;
    XtSetArg( al[ac],	XmNmarginHeight,	5 ); ac++;
    XtSetArg( al[ac],	XmNspacing,		5 ); ac++;
    apt->aptMainWidget= XmCreatePanedWindow( apt->aptTopWidget, WIDGET_NAME, al, ac );

    apt->aptPageDrawing= appPageToolMakeDrawing( apt->aptMainWidget,
								display, apt );

    paperFrame= appPageToolMakePaperFrame( apt->aptMainWidget,
							display, &aptr, apt );
    marginFrame= appPageToolMakeMarginFrame( ea->eaContext, apt->aptMainWidget,
							display, &aptr, apt );
    buttonForm= appPageToolMakeButtonRow( apt->aptMainWidget, &aptr, apt );

    XtManageChild( apt->aptMainWidget );

    appPageToolFillPagesizeMenu( &aptr, apt );

    XtRealizeWidget( apt->aptTopWidget );
    XtMapWidget( apt->aptTopWidget );

    XtVaGetValues( apt->aptPageMenu,
			    XmNwidth,		&width,
			    NULL );
    appPulldownSetWidth( apt->aptPageMenu, width );

    apt->aptGc= XCreateGC( XtDisplay( apt->aptPageDrawing ),
				    XtWindow( apt->aptPageDrawing ), 0, NULL );

    return (void *)apt;
    }

/************************************************************************/
/*									*/
/*  make a page tool.							*/
/*									*/
/************************************************************************/

# if 0
static int appMakePageLayoutDialog(	EditApplication *	ea,
					AppPageTool **		pApt,
					Widget			pageOption,
					const char *		pixmapName,
					PageToolSetProperties	setProperties )
    {
    Display *		display= XtDisplay( pageOption );
    AppPageTool *	apt;
    
    Arg			al[20];
    int			ac= 0;

    Widget		paperFrame;
    Widget		marginFrame;
    Widget		buttonForm;

    Dimension		width;

    MwmHints		hints;

    Pixmap		iconPixmap= (Pixmap)0;

    static int			gotResources= 0;
    static AppPageToolResources	aptr;

    if  ( ! gotResources )
	{
	XtGetApplicationResources( ea->eaTopWidget, &aptr,
				    APP_PageToolresourceTable,
				    XtNumber(APP_PageToolresourceTable),
				    NULL, 0 );

	gotResources= 1;
	}

    if  ( appGetImagePixmap( ea, pixmapName, &iconPixmap )  )
	{ SDEB(pixmapName); return -1;	}

    hints.flags= MWM_HINTS_FUNCTIONS|MWM_HINTS_DECORATIONS;
    hints.functions=	MWM_FUNC_MOVE		|
			MWM_FUNC_MINIMIZE	|
			MWM_FUNC_CLOSE		;
    hints.decorations=	MWM_DECOR_BORDER	|
			MWM_DECOR_TITLE		|
			MWM_DECOR_MENU		|
			MWM_DECOR_MINIMIZE	;

    apt= (AppPageTool *)malloc( sizeof(AppPageTool) );
    if  ( ! apt )
	{ XDEB(apt); return -1;	}

    apt->aptUnitType= appUnitTypeInt( aptr.aptrUnitType );
    if  ( apt->aptUnitType < 0 )
	{ SDEB(aptr.aptrUnitType); apt->aptUnitType= UNITtyINCH;	}

    apt->aptDestroy= appPageToolClosed;
    apt->aptSetProperties= setProperties;
    apt->aptTarget= (void *)ea;
    apt->aptCustomPaperSize= -1;

    apt->aptSizeChosen= -1;
    apt->aptSizeSet= -1;
    apt->aptGc= (GC)0;
    
    XtSetArg( al[ac], XmNuserData,	(void *)apt ); ac++;
    XtSetArg( al[ac], XmNdeleteResponse, XmDO_NOTHING ); ac++;
    XtSetArg( al[ac], XmNmwmDecorations, hints.decorations ); ac++;
    XtSetArg( al[ac], XmNmwmFunctions,	hints.functions ); ac++;
    XtSetArg( al[ac], XmNinput,		True ); ac++;

    if  ( iconPixmap )
	{ XtSetArg( al[ac], XmNiconPixmap,	iconPixmap ); ac++; }

    XtSetArg( al[ac], XmNwidth, 275 ); ac++;

    apt->aptTopWidget= XtAppCreateShell( ea->eaApplicationName,
					    ea->eaPageToolName,
					    applicationShellWidgetClass,
					    ea->eaDisplay, al, ac );


    appSetShellTitle( apt->aptTopWidget, pageOption, ea->eaApplicationName );

    XtAddEventHandler( apt->aptTopWidget, StructureNotifyMask, False,
					appFixSize, (void *)apt );


    if  ( ea->eaCloseAtom > 0 )
	{
	XmAddWMProtocolCallback( apt->aptTopWidget, ea->eaCloseAtom,
					appClosePageTool, (XtPointer)apt );
	}

    ac= 0;
    XtSetArg( al[ac], XmNuserData, (void *)apt ); ac++;

    ac= 0;
    XtSetArg( al[ac],	XmNuserData,		(void *)apt ); ac++;
    XtSetArg( al[ac],	XmNsashWidth,		1 ); ac++;
    XtSetArg( al[ac],	XmNsashHeight,		1 ); ac++;
    XtSetArg( al[ac],	XmNseparatorOn,		False ); ac++;
    XtSetArg( al[ac],	XmNmarginWidth,		5 ); ac++;
    XtSetArg( al[ac],	XmNmarginHeight,	5 ); ac++;
    XtSetArg( al[ac],	XmNspacing,		5 ); ac++;
    apt->aptMainWidget= XmCreatePanedWindow( apt->aptTopWidget, WIDGET_NAME, al, ac );

    apt->aptPageDrawing= appPageToolMakeDrawing( apt->aptMainWidget,
								display, apt );

    paperFrame= appPageToolMakePaperFrame( apt->aptMainWidget,
							display, &aptr, apt );
    marginFrame= appPageToolMakeMarginFrame( ea->eaContext, apt->aptMainWidget,
							display, &aptr, apt );
    buttonForm= appPageToolMakeButtonRow( apt->aptMainWidget, &aptr, apt );

    XtManageChild( apt->aptMainWidget );

    appPageToolFillPagesizeMenu( &aptr, apt );

    XtRealizeWidget( apt->aptTopWidget );
    XtMapWidget( apt->aptTopWidget );

    XtVaGetValues( apt->aptPageMenu,
			    XmNwidth,		&width,
			    NULL );
    appPulldownSetWidth( apt->aptPageMenu, width );

    apt->aptGc= XCreateGC( XtDisplay( apt->aptPageDrawing ),
				    XtWindow( apt->aptPageDrawing ), 0, NULL );

    *pApt= apt; return 0;
    }
# endif

/************************************************************************/
/*  Draw a find tool to front.						*/
/************************************************************************/
void appShowPageTool(		void *	voidapt	)
    {
    AppPageTool *		apt= (AppPageTool *)voidapt;

    XtVaSetValues( apt->aptTopWidget, XmNinitialState, NormalState, NULL );
    XtMapWidget( apt->aptTopWidget );
    XRaiseWindow( XtDisplay( apt->aptTopWidget ),
					    XtWindow( apt->aptTopWidget ) );
    }

/************************************************************************/
/*  Set the properties in a print tool.					*/
/************************************************************************/
void appPageToolSetProperties(	void *				voidapt,
				const DocumentGeometry *	dg )
    {
    AppPageTool *	apt= (AppPageTool *)voidapt;

    int			i;

    apt->aptGeometryChosen= apt->aptGeometrySet= *dg;

    appPageToolShowWidthHeight( apt );

    if  ( apt->aptGeometryChosen.dgPaperWideTwips	>
	  apt->aptGeometryChosen.dgPaperHighTwips	)
	{
	i= appPaperGetBySize( apt->aptGeometryChosen.dgPaperHighTwips,
			      apt->aptGeometryChosen.dgPaperWideTwips );

	apt->aptLandscapeChosen= 1;
	}
    else{
	i= appPaperGetBySize( apt->aptGeometryChosen.dgPaperWideTwips,
			      apt->aptGeometryChosen.dgPaperHighTwips );

	apt->aptLandscapeChosen= 0;
	}

    if  ( i < 0 )
	{ i= apt->aptCustomPaperSize;	}

    apt->aptSizeSet= apt->aptSizeChosen= i;
    appPageToolShowPaperSize( apt );
    appPageToolShowOrientation( apt );
    appPageToolShowMargins( apt );

    XClearArea( XtDisplay( apt->aptPageDrawing ),
				    XtWindow( apt->aptPageDrawing ),
				    0, 0, 0, 0, True );

    return;
    }

void appEnablePageTool(		void *	voidapt,
				int	enabled )
    {
    AppPageTool *	apt= (AppPageTool *)voidapt;

    XtSetSensitive( apt->aptMainWidget, enabled != 0 );

    return;
    }
