/************************************************************************/
/*  Basic structures for a Motif document manipulator application.	*/
/************************************************************************/

#   ifndef	APP_FRAME_H
#   define	APP_FRAME_H

#   include	<stdio.h>

#   include	<Xm/Xm.h>
#   include	"appColor.h"
#   include	"appGeo.h"
#   include	"utilPrinter.h"
#   include	"utilMailContent.h"
#   include	<appIcons.h>
#   include	<appTool.h>
#   include	<appFont.h>
#   include	<appDraw.h>

#   if 1
#	define	WIDGET_NAME	""
#   else
#	define	WIDGET_NAME	appWidgetName( __FILE__, __LINE__ )
#   endif


/************************************************************************/
/*  For configuring texts of 'Really' dialogs.				*/
/************************************************************************/
typedef struct AppFileMessageResources
    {
					/********************************/
					/*  Format for 'New' title	*/
					/********************************/
    char *	afmrNamelessTitleFormat;
					/********************************/
					/*  Really Close? Dialog.	*/
					/********************************/
    char *	afmrReallyCloseQuestion;
    char *	afmrReallyCloseSaveIt;
    char *	afmrReallyCloseDontSave;
    char *	afmrReallyCloseCancel;
					/********************************/
					/*  Really Quit? Dialog.	*/
					/********************************/
    char *	afmrReallyQuitQuestion;
    char *	afmrReallyQuitReview;
    char *	afmrReallyQuitAnyway;
    char *	afmrReallyQuitCancel;
					/********************************/
					/*  Messages about  a file.	*/
					/********************************/
    char *	afmrFileNoAccess;
    char *	afmrFileReadOnly;
    char *	afmrNoSuchFileMessage;
    char *	afmrFileNotWritable;
    char *	afmrMakeItQuestion;
    } AppFileMessageResources;

/************************************************************************/
/*  A menu, menu item in an application.				*/
/************************************************************************/

typedef enum MenuItemType
    {
    ITEMtyOPTION= 0,
    ITEMtyTOGGLE_OFF,
    ITEMtyTOGGLE_ON,
    ITEMtySEPARATOR
    } MenuItemType;

typedef struct AppMenuItem
    {
    char *		amiTextResName;
    char *		amiItemText;

    char *		amiKeyResName;
    char *		amiKey;

    char *		amiKeyTextResName;
    char *		amiKeyText;

    MenuItemType	amiItemType;
    XtCallbackProc	amiCallback;
    Widget		amiOptionWidget;
    } AppMenuItem;

/************************************************************************/
/*  Kinds of files that an application can open.			*/
/************************************************************************/

#   define	APPFILE_CAN_OPEN	0x01
#   define	APPFILE_CAN_SAVE	0x02
#   define	APPFILE_IS_BASIC_TYPE	0x04

typedef struct AppFileExtension
    {
    char *		afeId;
    char *		afeFilter;
    char *		afeDescription;
    char *		afeExtension;
    unsigned int	afeUseFlags;
    } AppFileExtension;

/************************************************************************/
/*  Describes a document generically.					*/
/************************************************************************/
typedef struct EditDocument
    {
    struct EditApplication *	edApplication;

    char *			edFilename;
    char *			edTitle;
    int				edFormat;
    int				edFileReadOnly;

    Widget			edTopWidget;
    Widget			edMenuBar;
    Widget			edMainWindow;
    Widget				edFileMenu;
    Widget				edFileMenuButton;
    Widget				edEditMenu;
    Widget				edEditMenuButton;
    Widget				edWindowMenu;
    Widget				edWindowMenuButton;
    Widget				edHelpMenu;
    Widget				edHelpMenuButton;

    Widget			edMainForm;
    Widget			edToolbar;
    Widget			edScrolledWindow;
    Widget				edVerticalScrollbar;
    Widget				edHorizontalScrollbar;
    Widget				edDocumentWidget;

    Widget				edLeftRulerWidget;
    Widget				edTopRulerWidget;
    Widget				edRightRulerWidget;
    Widget				edBottomRulerWidget;

    void *				edLeftRuler;
    void *				edTopRuler;
    void *				edRightRuler;
    void *				edBottomRuler;

    int					edLeftRulerWidth;
    int					edTopMargin;
    int					edRightRulerWidth;
    int					edBottomMargin;

    int				edShellExtraWidth;
    int				edShellExtraHeight;

    AppColors			edColors;

    GC				edGc;
    XIC				edInputContext;

    int				edHasBeenChanged;
    int				edIsReadonly;
    int				edIsVisible;

    AppDrawingData		edDrawingData;
    DocumentRectangle		edVisibleRect;

    void *			edPrivateData;

    struct AppDocSelectionTargetType *
				edTargetTypes;
    int				edTargetTypeCount;

    int				edMapped;	/*  Struggle with fvwm	*/
    } EditDocument;

/************************************************************************/
/*									*/
/*  Describes the application.						*/
/*									*/
/*  1)  Descriptive members.						*/
/*  2)  Allocated at run time.						*/
/*									*/
/************************************************************************/
typedef struct EditApplication
    {
    /*  1  */
    char *		eaApplicationName;
    char *		eaNameAndVersion;
    char *		eaReference;

    char *		eaDocumentWidgetName;
    char *		eaPageToolName;
    char *		eaPrintDialogName;
    char *		eaMailDialogName;
    char *		eaMessageDialogName;
    char *		eaMainIcon;
    char *		eaMainPicture;
    AppFileExtension *	eaFileExtensions;
    int			eaFileExtensionCount;
    char *		eaDefaultFileFilter;
    char *		eaDocumentIcon;
    void *		eaResourceData;
    XtResource *	eaResourceTable;
    int			eaResourceCount;
    XtResource *	eaFileMessageResourceTable;
    int			eaFileMessageResourceCount;
    int			eaCreateNewFromCommand;

    int			eaScreenPixelsWide;
    int			eaScreenPixelsHigh;
    float		eaMagnification;
    double		eaMagnifiedPixelsPerTwip;

    char *		eaUnitString;
    char *		eaPaperString;
    char *		eaLeftMarginString;
    char *		eaTopMarginString;
    char *		eaRightMarginString;
    char *		eaBottomMarginString;
    int			eaUnitInt;
    DocumentGeometry	eaDefaultDocumentGeometry;

    char **		eaAppFileMenuText;
    AppMenuItem *	eaAppFileMenuItems;
    int			eaAppFileMenuItemCount;

    char **		eaAppWinMenuText;
    AppMenuItem *	eaAppWinMenuItems;
    int			eaAppWinMenuItemCount;

    char **		eaDocFileMenuText;
    AppMenuItem *	eaDocFileMenuItems;
    int			eaDocFileMenuItemCount;

    char **		eaDocEditMenuText;
    AppMenuItem *	eaDocEditMenuItems;
    int			eaDocEditMenuItemCount;

    char **		eaDocWindowMenuText;
    AppMenuItem *	eaDocWindowMenuItems;
    int			eaDocWindowMenuItemCount;

    char **		eaDocHelpMenuText;
    AppMenuItem *	eaDocHelpMenuItems;
    int			eaDocHelpMenuItemCount;

    char **		eaAppHelpMenuText;
    AppMenuItem *	eaAppHelpMenuItems;
    int			eaAppHelpMenuItemCount;

    int			(*eaSetPrivateData)(
				struct EditApplication *	ea,
				EditDocument *			ed );
    int			(*eaMakeDocumentWidget)(
				struct EditApplication *	ea,
				EditDocument *			ed,
				Widget				scrollw );
    int			(*eaOpenDocument)(
				struct EditApplication *	ea,
				EditDocument *			ed,
				Widget				relative,
				Widget				option,
				const char *			filename );
    int			(*eaNewDocument)(
				struct EditApplication *	ea,
				EditDocument *			ed,
				const char *			filename );
    int			(*eaSetupDocument)(
				struct EditApplication *	ea,
				EditDocument *			ed );
    int			(*eaFinishDocumentSetup)(
				struct EditApplication *	ea,
				EditDocument *			ed );
    int			(*eaCanSaveDocument)(
				const struct EditApplication *	ea,
				const EditDocument *		ed,
				int				format );
    int			(*eaSaveDocument)(
				const struct EditApplication *	ea,
				const EditDocument *		ed,
				int				format,
				const char *			filename );
    int			(*eaPrintDocument)(
				FILE *				f,
				EditDocument *			ed );
    void		(*eaDrawRectangle)(
				Widget				w,
				EditDocument *			ed,
				DocumentRectangle *		drClip,
				int				ox,
				int				oy,
				Window				win,
				GC				gc );

    void		(*eaVisibleDocumentCountChanged)(
				    struct EditApplication *	ea,
				    int				from,
				    int				to );

    void		(*eaMakePrivateApplicationMenus)(
				    struct EditApplication *	ea,
				    Widget			menubar );

    void		(*eaMakePrivateDocumentMenus)(
				    struct EditApplication *	ea,
				    EditDocument *		ed,
				    Widget			menubar );

    void		(*eaDocCopy)( EditDocument *, XEvent * );
    void		(*eaDocCut)( EditDocument *, XEvent * );
    void		(*eaDocSelAll)( EditDocument *, XEvent * );

    XtCallbackProc	eaDocHorizontalScrollbarCallback;
    XtCallbackProc	eaDocVerticalScrollbarCallback;

    void		(*eaScrollHorizontalRuler) (void *, Widget, int );
    void		(*eaSetHorizontalRulerRange)(
						void *		voidtr,
						Widget		w,
						int		docVisX0,
						int		docVisX1,
						int		docBackX1 );

    void		(*eaScrollVerticalRuler) (void *, Widget, int );
    void		(*eaSetVerticalRulerRange)(
						void *		voidtr,
						Widget		w,
						int		docVisY0,
						int		docVisY1,
						int		docBackY1 );

    struct AppDocSelectionType *	eaDocSelectionTypes;
    int					eaDocSelectionTypeCount;

    struct AppAppSelectionType *	eaAppSelectionTypes;
    int					eaAppSelectionTypeCount;

    PrintDestination *	eaPrintDestinations;
    int			eaPrintDestinationCount;
    int			eaDefaultPrintDestination;

    MailContent *	eaMailContents;
    int			eaMailContentCount;
    int			eaDefaultMailContent;

    NamedPicture *	eaNamedPictures;
    int			eaNamedPictureCount;

    /*  2  */
    XtAppContext	eaContext;
    Widget		eaTopWidget;
	Display *	eaDisplay;
	int		eaScreen;
	XIM		eaInputMethod;
	Cursor		eaDocumentCursor;
    Widget		eaMainWindow;
    Widget		eaMenuBar;
    Widget			eaFileMenu;
    Widget			eaFileMenuButton;
    Widget			eaWinMenu;
    Widget			eaWinMenuButton;
    Widget			eaHelpMenu;
    Widget			eaHelpMenuButton;
    Widget		eaOpenChooser;
    Widget		eaSaveChooser;
    Widget		eaPrintToFileChooser;

    void *		eaFontsTool;
    void *		eaSpellTool;
    void *		eaFindTool;
    void *		eaPageTool;
    void *		eaSymbolPicker;

    Bool		eaSessionManagement;
    Atom		eaCloseAtom;
    Atom		eaSaveAtom;
    int			eaArgc;
    char **		eaArgv;

    EditDocument *	eaCurrentDocument;
    EditDocument **	eaOpenDocuments;
    int			eaOpenCount;
    int			eaVisibleDocumentCount;
    int			eaMainVisibleAsAbout;

    Pixel		eaCurrentDocMenuPixel;
    Pixel		eaOtherDocMenuPixel;

    char *			eaAfmDirectory;
    char *			eaDefaultFont;
    char *			eaFaxCommand;
    char *			eaAuthor;

    int				eaGotPaste;
    AppFileMessageResources	eaFileMessageResources;
    } EditApplication;

typedef int (*APP_OPEN_DOCUMENT)(	void *		through,
					Widget		relative,
					Widget		option,
					const char *	filename );

/************************************************************************/
/*									*/
/*  Describes types of content for Copy/Paste.				*/
/*  The order is the order of desirability for the application.		*/
/*									*/
/************************************************************************/

typedef void (*APPDOC_PASTE)(	Widget			w,
				EditDocument *		ed,
				XSelectionEvent *	selEvent );

typedef int (*APPDOC_COPY)(	Widget				w,
				EditDocument *			ed,
				Window				requestor,
				Atom				property,
				Atom				target );

typedef void (*APPDOC_LOST)(	Widget				w,
				EditDocument *			ed,
				XSelectionClearEvent *		clrEvent );

typedef void (*APPAPP_PASTE)(	Widget			w,
				EditApplication *	ea,
				XSelectionEvent *	selEvent );

typedef struct AppDocSelectionTargetType
    {
    char *		adsttTargetString;
    Atom		adsttTargetAtom;
    APPDOC_PASTE	adsttPaste;
    APPDOC_COPY		adsttCopy;
    } AppDocSelectionTargetType;

typedef struct AppDocSelectionType
    {
    char *			adstSelectionString;
    Atom			adstSelectionAtom;

    AppDocSelectionTargetType *	adstTargetTypes;
    int				adstTargetTypeCount;

    APPDOC_LOST			adstLost;
    } AppDocSelectionType;

typedef struct AppAppSelectionTargetType
    {
    char *		aasttTargetString;
    Atom		aasttTargetAtom;
    APPAPP_PASTE	aasttPaste;
    } AppAppSelectionTargetType;

typedef struct AppAppSelectionType
    {
    char *			aastSelectionString;
    Atom			aastSelectionAtom;

    AppAppSelectionTargetType *	aastTargetTypes;
    int				aastTargetTypeCount;
    } AppAppSelectionType;

/************************************************************************/
/*  Possible responses in one of Question dialogs.			*/
/************************************************************************/
#   define	AQDrespFAILURE		-1
#   define	AQDrespNONE		0
#   define	AQDrespYES		1
#   define	AQDrespNO		2
#   define	AQDrespCANCEL		3
#   define	AQDrespOK		4

typedef void (*PageToolSetProperties) (	void *				voidapt,
					const DocumentGeometry *	dg );

/************************************************************************/
/*  Routine declarations.						*/
/************************************************************************/

extern Widget appMakeMenu(		Widget *		pButton,
					EditApplication *	ea,
					Widget			parent,
					char *			itemText,
					int			isHelp,
					AppMenuItem *		items,
					int			itemCount,
					void *			through );

extern EditDocument * appOpenDocument(	EditApplication *	ea,
					Widget			relative,
					Widget			option,
					int			readonly,
					const char *		filename );

extern int appNewDocument(	EditApplication *	ea,
				const char *		filename );

extern int appMain(	EditApplication *	ea,
			int			argc,
			char *			argv[]	);

extern void appSetDocument(	EditApplication *	ea,
				EditDocument *		ed,
				const char *		title	);

extern void appRemoveDocument(	EditApplication *	ea,
				EditDocument *		ed	);

extern void appCloseDocument(	EditApplication *	ea,
				EditDocument *		ed	);

extern void appSetCurrentDocument(	EditApplication *	ea,
					EditDocument *		ed	);

extern void appDocToFront(	Widget		option,
				XtPointer	voided,
				XtPointer	call_data	 );

extern void appDocumentChanged(	EditApplication *	ea,
					EditDocument *		ed,
					int			changed	);

void appQuitApplication(	Widget			option,
				Widget			relative,
				EditApplication *	ea,
				XtPointer		call_data	 );

extern void appAppFileQuit(	Widget		option,
				XtPointer	voidea,
				XtPointer	call_data	 );

extern void appDocVisible(	EditApplication *	ea,
				EditDocument *		ed,
				int			visible	);

extern void appAppFileOpen(	Widget		option,
				XtPointer	voidea,
				XtPointer	call_data	 );

extern void appAppFileNew(	Widget		option,
				XtPointer	voidea,
				XtPointer	call_data	 );

extern void appDocSetScrollbarValues(	EditDocument *	ed );

extern void appDocFileSaveAs(	Widget		option,
				XtPointer	voided,
				XtPointer	call_data	 );

extern void appDocFileSaveTo(	Widget		option,
				XtPointer	voided,
				XtPointer	call_data	 );

extern void appSetShellConstraints(	EditDocument *		ed );

extern void appAppFileMini(	Widget		option,
				XtPointer	voidea,
				XtPointer	call_data	 );

extern void appAppFileHide(	Widget		option,
				XtPointer	voidea,
				XtPointer	call_data	 );

extern void appDocFileNew(	Widget		option,
				XtPointer	voided,
				XtPointer	call_data	 );

extern void appDocFileOpen(	Widget		option,
				XtPointer	voided,
				XtPointer	call_data	 );

extern void appDocFileSave(	Widget		option,
				XtPointer	voided,
				XtPointer	call_data	 );

extern void appDocFilePrint(	Widget		option,
				XtPointer	voided,
				XtPointer	call_data	 );

extern void appDocFileMini(	Widget		option,
				XtPointer	voided,
				XtPointer	call_data	 );

extern void appDocFileHide(	Widget		option,
				XtPointer	voided,
				XtPointer	call_data	 );

extern void appDocFileClose(	Widget		option,
				XtPointer	voided,
				XtPointer	call_data	 );

extern void appDocFileQuit(	Widget		option,
				XtPointer	voided,
				XtPointer	call_data	 );

extern void appDocEditCopy(	Widget		option,
				XtPointer	voided,
				XtPointer	voidpbcs	 );

extern void appDocEditCut(	Widget		option,
				XtPointer	voided,
				XtPointer	voidpbcs	 );

extern void appDocEditPaste(	Widget		option,
				XtPointer	voided,
				XtPointer	voidpbcs	 );

extern void appDocEditSelAll(	Widget		option,
				XtPointer	voided,
				XtPointer	voidpbcs	 );

extern void appRunReallyCloseDialog(	Widget			option,
					EditApplication *	ea,
					EditDocument *		ed,
					XtPointer		call_data );

extern int appRunReallyQuitDialog(	Widget			option,
					Widget			relative,
					EditApplication *	ea,
					XtPointer		call_data );

extern void appMakeDocVisible(	EditApplication *	ea,
				EditDocument *		ed );

extern void appShowDefaultsEditor(	Widget		prefOption,
					void *		voidea );

extern int appGetImagePixmap(	EditApplication *	ea,
				const char *		name,
				Pixmap *		pPixmap );

extern void appDiscardImagePixmaps(	EditApplication *	ea );

extern void appFreeDocument(		EditApplication *	ea,
					EditDocument *		ed );

extern int appSetDocumentFilename(	EditDocument *		ed,
					char *			filename );

extern int appSetDocumentTitle(	EditDocument *		ed,
					char *			filename );

extern void appGetFactors(	EditApplication *	ea,
				double *		pHorPixPerMM,
				double *		pVerPixPerMM,
				double *		pXfac,
				double *		pYfac );

extern int appFinishDocumentSetup(	EditApplication *	ea,
					EditDocument *		ed );

extern int appMakeDocumentWindow(	EditDocument **		pEd,
					EditApplication *	ea,
					int			readonly,
					const char *		title,
					const char *		filename );

extern int appSetupDocument(	EditApplication *	ea,
				EditDocument *		ed	);

extern void appRenameDocumentOptions(	EditApplication *	ea,
					EditDocument *		ed,
					char *			title );

extern int appQuestionRunSubjectYesNoCancelDialog( EditApplication *	ea,
						Widget		relative,
						Widget		option,
						const char *	subject,
						const char *	question,
						const char *	yesText,
						const char *	noText,
						const char *	cancelText );

extern int appQuestionRunYesNoCancelDialog(	EditApplication *	ea,
						Widget		relative,
						Widget		option,
						const char *	question,
						const char *	yesText,
						const char *	noText,
						const char *	cancelText );

extern void appQuestionRunSubjectErrorDialog(	EditApplication *	ea,
						Widget		relative,
						Widget		option,
						const char *	subject,
						const char *	message );

extern void appQuestionRunErrorDialog(	EditApplication *	ea,
					Widget			relative,
					Widget			option,
					const char *		message );

extern int appQuestionRunOkCancelDialog(	EditApplication * ea,
						Widget		relative,
						Widget		option,
						const char *	question,
						const char *	okText,
						const char *	cancelText );

extern int appQuestionRunSubjectOkCancelDialog( EditApplication * ea,
					Widget			relative,
					Widget			option,
					const char *		subject,
					const char *		question,
					const char *		okText,
					const char *		cancelText );

extern int appQuestionRunSubjectYesNoDialog( EditApplication *	ea,
					Widget			relative,
					Widget			option,
					const char *		subject,
					const char *		message,
					const char *		yesText,
					const char *		noText );

extern void * appMakePageTool(	EditApplication *	ea,
				Widget			printOption,
				const char *		pixmapName,
				PageToolSetProperties	setProperties );

extern void appShowPageTool(		void *	voidapt	);

extern void appPageToolSetProperties(	void *				voidapt,
					const DocumentGeometry *	dg );

extern void appEnablePageTool(		void *		voidapt,
					int		enabled );

extern void appRunPrintDialog(		EditApplication *	ea,
					EditDocument *		ed,
					Widget			printOption,
					const char *		pixmapName );

extern int appRunMailDialog(		EditApplication *	ea,
					EditDocument *		ed,
					Widget			mailOption,
					const char *		pixmapName,
					const unsigned char *	subject,
					void *			voiddoc );

extern int appPrintDocument(	EditApplication *	ea,
				EditDocument *		ed,
				int			printer );

extern int appFaxDocument(	EditApplication *	ea,
				EditDocument *		ed,
				const char *		faxNumber );

extern void appDocPrintToFile(	Widget			option,
				Widget			panel,
				EditApplication *	ea,
				EditDocument *		ed );

extern void appDocAbout(	Widget		option,
				XtPointer	voided,
				XtPointer	call_data	 );

extern void appRunOpenChooser(	Widget *		pChooser,
				Widget			option,
				Widget			relative,
				int			openExtensionCount,
				AppFileExtension *	openExtensions,
				char *			defaultFilter,
				void *			through,
				APP_OPEN_DOCUMENT	openDocument,
				EditApplication *	ea	);

extern void appDocSelectionInput(	Widget		w,
					void *		voided,
					XEvent *	event,
					Boolean *	pRefused	);

extern void appAppSelectionInput(	Widget		w,
					void *		voidea,
					XEvent *	event,
					Boolean *	pRefused	);

extern int appDocOwnSelection(	EditDocument *			ed,
				const char *			selection,
				AppDocSelectionTargetType * 	targets,
				int				targetCount,
				Time				eventTime );

extern int appDocAskForPaste(	EditDocument *		ed,
				const char *		selection,
				Time			eventTime );

extern int appAppAskForPaste(	EditApplication *	ea,
				const char *		selection,
				Time			eventTime );

extern void appDocHorizontalScrollbarCallback(	Widget		w,
						XtPointer	voided,
						XtPointer	voidscbs );

extern void appDocVerticalScrollbarCallback(	Widget		w,
						XtPointer	voided,
						XtPointer	voidscbs );
extern void * appMakeFontsTool(	Widget			fontsOption,
				Widget			topWidget,
				const char *		applicationName,
				const char *		widgetName,
				Pixmap			iconPixmap,
				Atom			closeAtom,
				AppToolDestroy		destroy,
				FontChooserSetFont	setFont,
				double			magnifiedPixelsPerTwip,
				EditApplication * 	ea	);

extern Widget appMakeRowButton(	Widget		buttonRow,
				const char *	text,
				XtCallbackProc	callback,
				void *		through,
				int		position,
				Dimension	showAsDefault );

extern Widget appMakeButtonRow(	Widget		parent,
				int		buttonCount );

extern void appMakeRowLabel(		Widget *		pLabel,
					Widget			row,
					const char *		labelText );

extern void appMakeRowText(		Widget *		pText,
					Widget			row,
					int			textColumns,
					int			textEnabled );

extern void appMakeLabelAndTextRow(	Widget *	pRow,
					Widget *	pLabel,
					Widget *	pText,
					Widget		parent,
					char *		labelText,
					int		textColumns,
					int		textEnabled );

extern Widget appMakeRowToggle(		Widget		buttonRow,
					const char *	text,
					XtCallbackProc	callback,
					void *		through,
					int		position );

extern void appMakeToggleAndTextRow(	Widget *		pRow,
					Widget *		pToggle,
					Widget *		pText,
					Widget			parent,
					char *			labelText,
					XtCallbackProc		callback,
					void *			through,
					int			textColumns,
					int			textEnabled );

extern void appMakeFrame(		Widget *	pFrame,
					Widget		parent,
					char *		title );

extern void appReportSaveFailure(	EditApplication *	ea,
					Widget			option,
					Widget			relative,
					const char *		filename );

extern void appMakeVerticalFrame(	Widget *	pFrame,
					Widget *	pBboard,
					Widget *	pPaned,
					Widget		parent,
					char *		title );

extern void appMakeColumnLabel(		Widget *	pLabel,
					Widget		row,
					const char *	labelText );

extern void appMakeColumnText(		Widget *	pText,
					Widget		column,
					int		textColumns,
					int		textEnabled );

extern void appMakeLabelAndTextColumns(	Widget *	pLabelColumn,
					Widget *	pTextColumn,
					Widget *	pColumns,
					Widget		parent );

extern void appMakeVerticalDialog(	Widget *		pShell,
					Widget *		pDialog,
					Widget *		pPaned,
					EditApplication *	ea,
					XtCallbackProc		closeCallback,
					void *			through,
					Pixmap			iconPixmap,
					int			withSeparator,
					char *			widgetName );

extern void appMakeVerticalPopup(	Widget *		pShell,
					Widget *		pDialog,
					Widget *		pPaned,
					EditApplication *	ea,
					void *			through,
					int			withSeparator,
					char *			widgetName );

extern char * 	appWidgetName(		char *			file,
					int			line );

extern int appGetLengthFromTextWidget(	Widget		w,
					int *		pValue,
					int *		pChanged,
					int		defaultUnit,
					int		requirePositive );

extern void appEnableText(		Widget		text,
					int		enabled );

extern void appRefuseTextValue(		Widget		w );

#   endif
