/************************************************************************/
/*									*/
/*  A Format Tool.							*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<debugon.h>

#   include	<Xm/Text.h>

#   include	<appUtil.h>
#   include	<appGeoString.h>
#   include	<appUnit.h>

#   include	"tedApp.h"
#   include	"tedFormatTool.h"

/************************************************************************/
/*									*/
/*  Refresh the 'Table' page of the format tool.			*/
/*									*/
/************************************************************************/

void tedFormatToolRefreshTablePage(	TableTool *	tt )
    {
    RowProperties *	rp= &(tt->ttPropertiesChosen);

    char		scratch[50];

    appGeoLengthToString( scratch, rp->rpHalfGapWidthTwips, UNITtyPOINTS );
    XmTextSetString( tt->ttCellMarginText, scratch );

    appGeoLengthToString( scratch, rp->rpLeftIndentTwips, UNITtyPOINTS );
    XmTextSetString( tt->ttLeftIndentText, scratch );
    }


/************************************************************************/
/*  Set/Revert buttons have been pushed.				*/
/************************************************************************/

static void tedTableChangeTablePushed(	Widget		w,
					XtPointer	voidtt,
					XtPointer	voidpbcs	 )
    {
    TableTool *		tt= (TableTool *)voidtt;
    RowProperties *	rp= &(tt->ttPropertiesChosen);

    int			width;
    int			res;

    res= tedFormatToolGetRowLeftIndent( rp, tt->ttPageLeftMargin,
					    &width, tt->ttLeftIndentText );
    if  ( res != 0 )
	{ return;	}
    rp->rpLeftIndentTwips= width;

    res= tedFormatToolGetGapWidth( rp, &width, tt->ttCellMarginText );
    if  ( res != 0 )
	{ return;	}
    rp->rpHalfGapWidthTwips= width;

    tedSetTableProperties( tt->ttApplication,
				0,
				tt->ttPropertiesSet.rpCellCount- 1,
				tt->ttRow00, tt->ttRow11, rp );

    return;
    }

static void tedFormatRevertTablePushed(	Widget		w,
					XtPointer	voidtt,
					XtPointer	voidpbcs )
    {
    TableTool *	tt= (TableTool *)voidtt;

    docCopyRowProperties( &(tt->ttPropertiesChosen), &(tt->ttPropertiesSet) );

    tedFormatToolRefreshTablePage( tt );

    return;
    }

/************************************************************************/
/*									*/
/*  Check the cell margin that was entered on the 'Table' page of the	*/
/*  format tool.							*/
/*									*/
/************************************************************************/

static void tedTableCellMarginChanged(	Widget		w,
					XtPointer	voidtt,
					XtPointer	voidpbcs )
    {
    TableTool *		tt= (TableTool *)voidtt;
    RowProperties *	rp= &(tt->ttPropertiesChosen);

    int			value;

    if  ( ! tedFormatToolGetGapWidth( rp, &value, tt->ttCellMarginText ) )
	{
	char	scratch[50];

	appGeoLengthToString( scratch, value, UNITtyPOINTS );
	XmTextSetString( tt->ttCellMarginText, scratch );
	}
    }

/************************************************************************/
/*									*/
/*  Check the left indent that was entered on the 'Table' page of the	*/
/*  format tool.							*/
/*									*/
/************************************************************************/

static void tedTableLeftIndentChanged(	Widget		w,
					XtPointer	voidtt,
					XtPointer	voidpbcs )
    {
    TableTool *		tt= (TableTool *)voidtt;
    RowProperties *	rp= &(tt->ttPropertiesChosen);

    int			value;

    if  ( ! tedFormatToolGetRowLeftIndent( rp, tt->ttPageLeftMargin, &value,
						    tt->ttLeftIndentText ) )
	{
	char	scratch[50];

	appGeoLengthToString( scratch, value, UNITtyPOINTS );
	XmTextSetString( tt->ttLeftIndentText, scratch );
	}
    }

/************************************************************************/
/*									*/
/*  Delete/Select Table buttons have been pushed.			*/
/*									*/
/************************************************************************/

static void tedTableDeleteTable(	Widget		w,
					XtPointer	voidtt,
					XtPointer	voidpbcs	 )
    {
    TableTool *		tt= (TableTool *)voidtt;
    EditApplication *	ea= tt->ttApplication;
    EditDocument *	ed= ea->eaCurrentDocument;

    if  ( tedDeleteRowsFromTable( ed, tt->ttRow00, tt->ttRow11 ) )
	{ LLDEB(tt->ttRow00,tt->ttRow11); return;	}

    appDocumentChanged( ea, ed, 1 );

    return;
    }

static void tedTableSelectTable(	Widget		w,
					XtPointer	voidtt,
					XtPointer	voidpbcs	 )
    {
    TableTool *		tt= (TableTool *)voidtt;
    EditApplication *	ea= tt->ttApplication;
    EditDocument *	ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    tedAppSetTableSelection( ed, 0,
			    tt->ttPropertiesChosen.rpCellCount -1,
			    tt->ttRow00, tt->ttRow11 );
    }

/************************************************************************/
/*									*/
/*  Make the 'Table' page of the format tool.				*/
/*									*/
/************************************************************************/

void tedFormatMakeTablePage(	TableTool *		tt,
				Widget			pageParent,
				TablePageResources *	tpr,
				ToolSubject *		ts,
				FormatPageResources *	fpr )
    {
    Widget	pageWidget;
    Widget	widthLabel;
    Widget	leftLabel;

    Widget	row= (Widget )0;

    const int	textColumns= 10;

    /**************/
    tt->ttCol0= -1;
    tt->ttCol1= -1;
    tt->ttRow00= -1;
    tt->ttRow0= -1;
    tt->ttRow1= -1;
    tt->ttRow11= -1;

    docInitRowProperties( &(tt->ttPropertiesSet) );
    docInitRowProperties( &(tt->ttPropertiesChosen) );

    /**************/
    pageWidget= tedFormatMakePage( ts, pageParent );

    /**************/
    appMakeLabelAndTextRow( &row, &leftLabel, &(tt->ttLeftIndentText),
			pageWidget, tpr->tprLeftIndent, textColumns, 1 );

    XtAddCallback( tt->ttLeftIndentText, XmNactivateCallback,
				tedTableLeftIndentChanged, (void *)tt );

    /**************/
    appMakeLabelAndTextRow( &row, &widthLabel, &(tt->ttCellMarginText),
		    pageWidget, tpr->tprCellMargin, textColumns, 1 );

    XtAddCallback( tt->ttCellMarginText, XmNactivateCallback,
				tedTableCellMarginChanged, (void *)tt );

    /**************/
    tedFormatMakeButtonRow( &row, pageWidget,
		&(ts->tsSelectButton), &(ts->tsDeleteButton),
		fpr->fprSelectButtonText, fpr->fprDeleteButtonText,
		tedTableSelectTable, tedTableDeleteTable, (void *)tt );

    tedFormatMakeButtonRow( &row, pageWidget,
		&(ts->tsRevertButton), &(ts->tsApplyButton),
		fpr->fprRevert, fpr->fprApplyToSubject,
		tedFormatRevertTablePushed, tedTableChangeTablePushed,
		(void *)tt );

    XtManageChild( pageWidget );
    XtManageChild( ts->tsPage );

    return;
    }
