/************************************************************************/
/*									*/
/*  A Format Tool.							*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<debugon.h>

#   include	<Xm/Text.h>

#   include	<appUtil.h>
#   include	<appGeoString.h>
#   include	<appUnit.h>

#   include	"tedApp.h"
#   include	"tedFormatTool.h"

/************************************************************************/
/*									*/
/*  Refresh the row page.						*/
/*									*/
/************************************************************************/

void tedFormatToolRefreshRowPage(	RowTool *	rt )
    {
    RowProperties *	rp= &(rt->rtPropertiesChosen);
    CellProperties *	cp;

    char		scratch[50];

    sprintf( scratch, "%d", rt->rtRow0- rt->rtRow00+ 1 );
    XmTextSetString( rt->rtNumberText, scratch );

    tedFormatRefreshHeightChooser( &(rt->rtHeightChooser),
							rp->rpHeightTwips );

    appGeoLengthToString( scratch, rp->rpHalfGapWidthTwips, UNITtyPOINTS );
    XmTextSetString( rt->rtCellMarginText, scratch );

    appGeoLengthToString( scratch, rp->rpLeftIndentTwips, UNITtyPOINTS );
    XmTextSetString( rt->rtLeftIndentText, scratch );

    cp= rp->rpCells;
    tedFormatReflectBorder( rt->rtTopBorderToggle,
					&(cp[rt->rtCol0].cpTopBorder) );
    tedFormatReflectBorder( rt->rtBottomBorderToggle,
					&(cp[rt->rtCol0].cpBottomBorder) );
    }

/************************************************************************/
/*									*/
/*  The 'Change' button of the row tool has been pushed.		*/
/*									*/
/************************************************************************/

static void tedFormatChangeRowPushed(	Widget		w,
					XtPointer	voidrt,
					XtPointer	voidpbcs )
    {
    RowTool *		rt= (RowTool *)voidrt;
    RowProperties *	rp= &(rt->rtPropertiesChosen);

    int			width;
    int			changed;

    int			res;

    if  ( tedFormatToolGetHeight( &(rp->rpHeightTwips),
						&(rt->rtHeightChooser) ) )
	{ return;	}

    width= rp->rpHalfGapWidthTwips;
    if  ( appGetLengthFromTextWidget( rt->rtCellMarginText, &width, &changed,
							UNITtyPOINTS, 1 ) )
	{ return;	}
    rp->rpHalfGapWidthTwips= width;

    res= tedFormatToolGetRowLeftIndent( rp, rt->rtPageLeftMargin, &width,
							rt->rtLeftIndentText );
    if  ( res != 0 )
	{ return;	}
    rp->rpLeftIndentTwips= width;

    tedSetTableProperties( rt->rtApplication,
				0, rt->rtPropertiesSet.rpCellCount- 1,
				rt->rtRow0, rt->rtRow1,
				rp );

    return;
    }

/************************************************************************/
/*									*/
/*  The row height changed, check it.					*/
/*									*/
/************************************************************************/

static void tedRowHeightChanged(	Widget		w,
					XtPointer	voidrt,
					XtPointer	voidpbcs )
    {
    RowTool *		rt= (RowTool *)voidrt;
    int			value;

    if  ( ! tedFormatToolGetHeight( &value, &(rt->rtHeightChooser) ) )
	{
	tedFormatRefreshHeightChooser( &(rt->rtHeightChooser), value );
	}
    }

static void tedRowCellMarginChanged(	Widget		w,
					XtPointer	voidrt,
					XtPointer	voidpbcs )
    {
    RowTool *		rt= (RowTool *)voidrt;
    RowProperties *	rp= &(rt->rtPropertiesChosen);

    int			width;

    if  ( ! tedFormatToolGetGapWidth( rp, &width, rt->rtCellMarginText ) )
	{
	char	scratch[50];

	appGeoLengthToString( scratch, width, UNITtyPOINTS );
	XmTextSetString( rt->rtCellMarginText, scratch );
	}
    }

static void tedRowLeftIndentChanged(	Widget		w,
					XtPointer	voidrt,
					XtPointer	voidpbcs )
    {
    RowTool *		rt= (RowTool *)voidrt;
    RowProperties *	rp= &(rt->rtPropertiesChosen);

    int			value;

    if  ( ! tedFormatToolGetRowLeftIndent( rp, rt->rtPageLeftMargin, &value,
						    rt->rtLeftIndentText ) )
	{
	char	scratch[50];

	appGeoLengthToString( scratch, value, UNITtyPOINTS );
	XmTextSetString( rt->rtLeftIndentText, scratch );
	}
    }

/************************************************************************/
/*									*/
/*  The 'Revert' button of the row tool has been pushed.		*/
/*									*/
/************************************************************************/

static void tedFormatRevertRowPushed(	Widget		w,
					XtPointer	voidrt,
					XtPointer	voidpbcs	 )
    {
    RowTool *	rt= (RowTool *)voidrt;

    docCopyRowProperties( &(rt->rtPropertiesChosen), &(rt->rtPropertiesSet) );

    tedFormatToolRefreshRowPage( rt );

    return;
    }

static void tedFormatPreviousRow(	Widget		w,
					XtPointer	voidrt,
					XtPointer	voidpbcs	 )
    {
    RowTool *		rt= (RowTool *)voidrt;
    EditApplication *	ea= rt->rtApplication;
    EditDocument *	ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    tedAppSetTableSelection( ed, rt->rtCol0, rt->rtCol1,
					    rt->rtRow0- 1, rt->rtRow1- 1 );
    }

static void tedFormatSelectRow(		Widget		w,
					XtPointer	voidrt,
					XtPointer	voidpbcs	 )
    {
    RowTool *		rt= (RowTool *)voidrt;
    EditApplication *	ea= rt->rtApplication;
    EditDocument *	ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    tedAppSetTableSelection( ed, 0,
			    rt->rtPropertiesChosen.rpCellCount -1,
			    rt->rtRow0, rt->rtRow1 );
    }

static void tedFormatNextRow(		Widget		w,
					XtPointer	voidrt,
					XtPointer	voidpbcs	 )
    {
    RowTool *		rt= (RowTool *)voidrt;
    EditApplication *	ea= rt->rtApplication;
    EditDocument *	ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    tedAppSetTableSelection( ed, rt->rtCol0, rt->rtCol1,
					    rt->rtRow0+ 1, rt->rtRow1+ 1 );
    }

/************************************************************************/
/*									*/
/*  The 'Delete' button of the row tool has been pushed.		*/
/*									*/
/************************************************************************/

static void tedFormatDeleteRow(		Widget		w,
					XtPointer	voidrt,
					XtPointer	voidpbcs	 )
    {
    RowTool *		rt= (RowTool *)voidrt;
    EditApplication *	ea= rt->rtApplication;
    EditDocument *	ed= ea->eaCurrentDocument;

    if  ( tedDeleteRowsFromTable( ed, rt->rtRow0, rt->rtRow1 ) )
	{ LLDEB(rt->rtRow0,rt->rtRow1); return;	}

    appDocumentChanged( ea, ed, 1 );

    return;
    }

/************************************************************************/
/*									*/
/*  Insert/Append Row buttons have been pushed.				*/
/*									*/
/************************************************************************/

static void tedFormatInsertRow(	Widget		w,
				XtPointer	voidrt,
				XtPointer	voidpbcs	 )
    {
    RowTool *		rt= (RowTool *)voidrt;
    EditApplication *	ea= rt->rtApplication;

    EditDocument *	ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    tedInsertRowInTable( ed->edDocumentWidget, ed );

    appDocumentChanged( ea, ed, 1 );
    }

static void tedFormatAppendRow(	Widget		w,
				XtPointer	voidrt,
				XtPointer	voidpbcs	 )
    {
    RowTool *		rt= (RowTool *)voidrt;
    EditApplication *	ea= rt->rtApplication;
    EditDocument *	ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    tedAppendRowToTable( ed->edDocumentWidget, ed );

    appDocumentChanged( ea, ed, 1 );
    }

static void tedRowHeightChosen(	Widget		w,
				XtPointer	voidrt,
				XtPointer	voidtbcs )
    {
    RowTool *		rt= (RowTool *)voidrt;

    int			defaultValue;

    defaultValue= rt->rtPropertiesChosen.rpHeightTwips;
    if  ( defaultValue == 0 )
	{ defaultValue= rt->rtPropertiesSet.rpHeightTwips;	}
    if  ( defaultValue == 0 )
	{ defaultValue= 240;	}

    tedFormatHeightChosen( w, &(rt->rtHeightChooser), defaultValue );

    return;
    }

/************************************************************************/
/*									*/
/*  One of the 'Row Border' toggles has been activated.			*/
/*									*/
/************************************************************************/

static void tedRowToggleBorder(	Widget		w,
				XtPointer	voidrt,
				XtPointer	voidtbcs )
    {
    RowTool *				rt= (RowTool *)voidrt;
    RowProperties *			rp= &(rt->rtPropertiesChosen);
    CellProperties *			cp;
    XmToggleButtonCallbackStruct *	tbcs;
    int					col;

    tbcs= (XmToggleButtonCallbackStruct *)voidtbcs;

    if  ( w == rt->rtTopBorderToggle )
	{
	cp= rp->rpCells;
	for ( col= 0; col < rp->rpCellCount; cp++, col++ )
	    { tedFormatToggleBorder( &(cp->cpTopBorder), tbcs->set ); }

	return;
	}

    if  ( w == rt->rtBottomBorderToggle )
	{
	cp= rp->rpCells;
	for ( col= 0; col < rp->rpCellCount; cp++, col++ )
	    { tedFormatToggleBorder( &(cp->cpBottomBorder), tbcs->set ); }

	return;
	}

    XDEB(w); return;
    }

/************************************************************************/
/*									*/
/*  Make a row tool. I.E. the 'Row' page of the format tool.		*/
/*									*/
/************************************************************************/

void tedFormatMakeRowPage(	RowTool *			rt,
				Widget				pageParent,
				const RowPageResources *	rpr,
				ToolSubject *			ts,
				const FormatPageResources *	fpr )
    {
    Widget	pageWidget;
    Widget	rowLabel;
    Widget	widthLabel;
    Widget	leftLabel;

    Widget	row;

    const int	textColumns= 10;

    /**************/
    rt->rtCol0= -1;
    rt->rtCol1= -1;
    rt->rtRow00= -1;
    rt->rtRow0= -1;
    rt->rtRow1= -1;
    rt->rtRow11= -1;

    docInitRowProperties( &(rt->rtPropertiesSet) );
    docInitRowProperties( &(rt->rtPropertiesChosen) );

    /**************/
    pageWidget= tedFormatMakePage( ts, pageParent );

    /**************/
    appMakeLabelAndTextRow( &row, &rowLabel, &(rt->rtNumberText),
			    pageWidget, fpr->fprSubjectName, textColumns, 0 );

    /**************/
    tedFormatMakeHeightRow( &row, rt, pageWidget,
			&(rt->rtHeightChooser), tedRowHeightChanged );

    /**************/
    appMakeLabelAndTextRow( &row, &leftLabel, &(rt->rtLeftIndentText),
			    pageWidget, rpr->rprLeftIndent, textColumns, 1 );

    XtAddCallback( rt->rtLeftIndentText, XmNactivateCallback,
				tedRowLeftIndentChanged, (void *)rt );

    /**************/
    appMakeLabelAndTextRow( &row, &widthLabel, &(rt->rtCellMarginText),
			    pageWidget, rpr->rprCellMargin, textColumns, 1 );

    XtAddCallback( rt->rtCellMarginText, XmNactivateCallback,
				tedRowCellMarginChanged, (void *)rt );

    /**************/
    tedFormatMakeToggleRow( &row, pageWidget,
	    &(rt->rtTopBorderToggle), &(rt->rtBottomBorderToggle),
	    rpr->rprTopBorder, rpr->rprBottomBorder,
	    tedRowToggleBorder, tedRowToggleBorder, (void *)rt );

    tedFormatMakeButtonRow( &row, pageWidget,
	    &(ts->tsPrevButton), &(ts->tsNextButton),
	    fpr->fprPrevButtonText, fpr->fprNextButtonText,
	    tedFormatPreviousRow, tedFormatNextRow, (void *)rt );

    tedFormatMakeButtonRow( &row, pageWidget,
	    &(ts->tsSelectButton), &(ts->tsDeleteButton),
	    fpr->fprSelectButtonText, fpr->fprDeleteButtonText,
	    tedFormatSelectRow, tedFormatDeleteRow, (void *)rt );

    tedFormatMakeButtonRow( &row, pageWidget,
	    &(ts->tsInsertButton), &(ts->tsAppendButton),
	    fpr->fprInsertButtonText, fpr->fprAppendButtonText,
	    tedFormatInsertRow, tedFormatAppendRow, (void *)rt );

    tedFormatMakeButtonRow( &row, pageWidget,
	    &(ts->tsRevertButton), &(ts->tsApplyButton),
	    fpr->fprRevert, fpr->fprApplyToSubject,
	    tedFormatRevertRowPushed, tedFormatChangeRowPushed, (void *)rt );

    XtManageChild( pageWidget );
    XtManageChild( ts->tsPage );

    return;
    }

void tedFormatFillRowChoosers(		RowTool *			rt,
					const RowPageResources *	rpr )
    {
    tedFormatFillHeightChooser( &(rt->rtHeightChooser),
					    tedRowHeightChosen, (void *)rt,
					    rpr->rprHeightFree,
					    rpr->rprHeightAtLeast,
					    rpr->rprHeightExactly );
    }

void tedFormatFinishRowPage( 	RowTool *			rt,
				const RowPageResources *	rpr )
    {
    Dimension		width;

    XtVaGetValues( rt->rtHeightChooser.hcMenu,
			    XmNwidth,		&width,
			    NULL );

    appPulldownSetWidth( rt->rtHeightChooser.hcMenu, width );
    }
