/************************************************************************/
/*									*/
/*  A Format Tool.							*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<debugon.h>

#   include	<X11/Xatom.h>
#   include	<X11/IntrinsicP.h>
#   include	<Xm/Text.h>
#   include	<Xm/Form.h>
#   include	<Xm/ToggleB.h>
#   include	<Xm/Frame.h>
#   include	<Xm/ScrolledW.h>
#   include	<Xm/Label.h>
#   include	<Xm/RowColumn.h>
#   include	<Xm/PanedW.h>

#   include	<Xm/MwmUtil.h>
#   include	<Xm/Protocols.h>

#   include	<appUtil.h>
#   include	<appGeoString.h>
#   include	<appUnit.h>

#   include	"tedApp.h"
#   include	"tedFormatTool.h"

/************************************************************************/
/*									*/
/*  The different pages in a Format tool:				*/
/*									*/
/************************************************************************/

typedef enum ToolSubjectIndex
    {
    TEDtsiTABLE= 0,
    TEDtsiROW,
    TEDtsiCOLUMN,
#   if 0
    TEDtsiCELL,
#   endif
    TEDtsiPARA,

    TEDtsiCOUNT

    } ToolSubjectIndex;

/************************************************************************/
/*									*/
/*  Resources for the spell tool.					*/
/*									*/
/************************************************************************/

typedef struct TedFormatToolResources
    {
    FormatPageResources	tttrSubjectResources[TEDtsiCOUNT];

				/****************************************/
				/*  Table				*/
				/****************************************/
    TablePageResources		tttrTablePageResources;

				/****************************************/
				/*  Row					*/
				/****************************************/
    RowPageResources		tttrRowPageResources;

				/****************************************/
				/*  Column				*/
				/****************************************/
    ColumnPageResources		tttrColumnPageResources;

				/****************************************/
				/*  Paragraph				*/
				/****************************************/
    ParagraphPageResources	tttrParaPageResources;

    } TedFormatToolResources;

# define xx(x)	x,x

static XtResource TED_TedFormatToolResourceTable[]=
    {
	/****************************************************************/
	/*  'Table' page.						*/
	/****************************************************************/
	{ xx("tableToolTable"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiTABLE].fprSubjectName),
		    XtRString, "Table" },
	{ xx("tableToolChangeTable"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiTABLE].fprApplyToSubject),
		    XtRString, "Apply to Table" },
	{ xx("tableToolRevert"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiTABLE].fprRevert),
		    XtRString, "Revert" },
	/*  no Next Table */
	/*  no Prev Table */
	{ xx("tableToolSelectTable"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiTABLE].fprSelectButtonText),
		    XtRString, "Select Table" },
	{ xx("tableToolDeleteTable"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiTABLE].fprDeleteButtonText),
		    XtRString, "Delete Table" },
	/*  no Insert Table */
	/*  no Append Table */
	/**/
	{ xx("tableToolCellMargin"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrTablePageResources.tprCellMargin),
		    XtRString, "Cell Margin" },
	{ xx("tableToolLeftIndent"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrTablePageResources.tprLeftIndent),
		    XtRString, "Left Margin" },


	/****************************************************************/
	/*  'Row' page.							*/
	/****************************************************************/
	{ xx("tableToolRow"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiROW].fprSubjectName),
		    XtRString, "Row" },
	{ xx("tableToolChangeRow"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiROW].fprApplyToSubject),
		    XtRString, "Apply to Row" },
	{ xx("tableToolRevert"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiROW].fprRevert),
		    XtRString, "Revert" },
	{ xx("tableToolNextRow"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiROW].fprNextButtonText),
		    XtRString, "Next Row" },
	{ xx("tableToolPreviousRow"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiROW].fprPrevButtonText),
		    XtRString, "Previous Row" },
	{ xx("tableToolSelectRow"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiROW].fprSelectButtonText),
		    XtRString, "Select Row" },
	{ xx("tableToolDeleteRow"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiROW].fprDeleteButtonText),
		    XtRString, "Delete Row" },
	{ xx("tableToolInsertRow"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiROW].fprInsertButtonText),
		    XtRString, "Insert Row" },
	{ xx("tableToolAppendRow"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiROW].fprAppendButtonText),
		    XtRString, "Append Row" },
	/**/
	{ xx("tableToolHeightFree"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrRowPageResources.rprHeightFree),
		    XtRString, "Height Free" },
	{ xx("tableToolHeightExactly"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrRowPageResources.rprHeightExactly),
		    XtRString, "Height Exactly" },
	{ xx("tableToolHeightAtLeast"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrRowPageResources.rprHeightAtLeast),
		    XtRString, "Height at Least" },
	/**/
	{ xx("tableToolCellMargin"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrRowPageResources.rprCellMargin),
		    XtRString, "Cell Margin" },
	{ xx("tableToolLeftIndent"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrRowPageResources.rprLeftIndent),
		    XtRString, "Left Margin" },
	/**/
	{ xx("tableToolRowTopBorder"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrRowPageResources.rprTopBorder),
		    XtRString, "Top Border" },
	{ xx("tableToolRowBottomBorder"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrRowPageResources.rprBottomBorder),
		    XtRString, "Bottom Border" },


	/****************************************************************/
	/*  'Column' page.						*/
	/****************************************************************/
	{ xx("tableToolColumn"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiCOLUMN].fprSubjectName),
		    XtRString, "Column" },
	{ xx("tableToolChangeColumn"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiCOLUMN].fprApplyToSubject),
		    XtRString, "Apply to Column" },
	{ xx("tableToolRevert"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiCOLUMN].fprRevert),
		    XtRString, "Revert" },
	{ xx("tableToolNextColumn"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiCOLUMN].fprNextButtonText),
		    XtRString, "Next Column" },
	{ xx("tableToolPreviousColumn"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiCOLUMN].fprPrevButtonText),
		    XtRString, "Previous Column" },
	{ xx("tableToolSelectColumn"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiCOLUMN].fprSelectButtonText),
		    XtRString, "Select Column" },
	{ xx("tableToolDeleteColumn"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiCOLUMN].fprDeleteButtonText),
		    XtRString, "Delete Column" },
	{ xx("tableToolInsertColumn"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiCOLUMN].fprInsertButtonText),
		    XtRString, "Insert Column" },
	{ xx("tableToolAppendColumn"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiCOLUMN].fprAppendButtonText),
		    XtRString, "Append Column" },
	/**/
	{ xx("tableToolWidth"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrColumnPageResources.cprWidth),
		    XtRString, "Width" },
	/**/
	{ xx("tableToolColumnLeftBorder"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrColumnPageResources.cprLeftBorder),
		    XtRString, "Left Border" },
	{ xx("tableToolColumnRightBorder"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrColumnPageResources.cprRightBorder),
		    XtRString, "Right Border" },


	/****************************************************************/
	/*  'Paragraph' page.						*/
	/****************************************************************/
	{ xx("formatToolPara"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiPARA].fprSubjectName),
		    XtRString, "Paragraph" },
	{ xx("formatToolChangePara"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiPARA].fprApplyToSubject),
		    XtRString, "Apply to Paragraph" },
	{ xx("tableToolRevert"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiPARA].fprRevert),
		    XtRString, "Revert" },
	{ xx("formatToolNextPara"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiPARA].fprNextButtonText),
		    XtRString, "Next Paragraph" },
	{ xx("formatToolPreviousPara"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiPARA].fprPrevButtonText),
		    XtRString, "Previous Paragraph" },
	{ xx("formatToolSelectPara"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiPARA].fprSelectButtonText),
		    XtRString, "Select Paragraph" },
	{ xx("formatToolDeletePara"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiPARA].fprDeleteButtonText),
		    XtRString, "Delete Paragraph" },
	{ xx("formatToolInsertPara"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiPARA].fprInsertButtonText),
		    XtRString, "Insert Paragraph" },
	{ xx("formatToolAppendPara"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiPARA].fprAppendButtonText),
		    XtRString, "Append Paragraph" },
	/**/
	{ xx("formatToolParaFirstIndent"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrParaPageResources.pprParaFirstIndent),
		    XtRString, "First Line Indent" },
	{ xx("formatToolParaLeftIndent"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrParaPageResources.pprParaLeftIndent),
		    XtRString, "Left Indent" },
	{ xx("formatToolParaRightIndent"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrParaPageResources.pprParaRightIndent),
		    XtRString, "Right Indent" },
	/**/
	{ xx("formatToolParaSpaceAbove"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrParaPageResources.pprParaSpaceAbove),
		    XtRString, "Space Above" },
	{ xx("formatToolParaSpaceBelow"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrParaPageResources.pprParaSpaceBelow),
		    XtRString, "Space Below" },
	/**/
	{ xx("formatToolParaTopBorder"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrParaPageResources.pprTopBorder),
		    XtRString, "Top Border" },
	{ xx("formatToolParaBottomBorder"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrParaPageResources.pprBottomBorder),
		    XtRString, "Bottom Border" },
	/**/
	{ xx("formatToolParaOnNewPage"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrParaPageResources.pprOnNewPage),
		    XtRString, "Start on New Page" },
	{ xx("formatToolParaOnOnePage"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrParaPageResources.pprOnOnePage),
		    XtRString, "Keep on One Page" },
	/**/
	{ xx("formatToolLineDistFree"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrParaPageResources.pprParaLineDistFree),
		    XtRString, "Spacing Free" },
	{ xx("formatToolLineDistExactly"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrParaPageResources.pprParaLineDistExactly),
		    XtRString, "Spacing Exactly" },
	{ xx("formatToolLineDistAtLeast"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrParaPageResources.pprParaLineDistAtLeast),
		    XtRString, "Spacing at Least" },
	/**/
	{ xx("formatToolParaAlignment"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrParaPageResources.pprParaAlignment),
		    XtRString, "Alignment" },
	{ xx("formatToolParaAlignLeft"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrParaPageResources.pprParaAlignLeft),
		    XtRString, "Left" },
	{ xx("formatToolParaAlignRight"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrParaPageResources.pprParaAlignRight),
		    XtRString, "Right" },
	{ xx("formatToolParaAlignCentered"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrParaPageResources.pprParaAlignCentered),
		    XtRString, "Centered" },
	{ xx("formatToolParaAlignJustified"), XtRString, sizeof(char *),
		    offsetof(TedFormatToolResources,
		    tttrParaPageResources.pprParaAlignJustified),
		    XtRString, "Justified" },
    };

/************************************************************************/
/*									*/
/*  Represents a format tool.						*/
/*									*/
/************************************************************************/

typedef struct TedFormatTool
    {
    Widget			tttTopWidget;
    Widget			tttMainWidget;

    Widget			tttSubjectPulldown;
    Widget			tttSubjectMenu;
    ToolSubject			tftSubjects[TEDtsiCOUNT];
    int				tftCurrentSubject;

					/********************************/
					/*  'Table'			*/
					/********************************/
    TableTool			tftTableTool;

					/********************************/
					/*  'Column'			*/
					/********************************/
    ColumnTool			tftColumnTool;

					/********************************/
					/*  'Row'			*/
					/********************************/
    RowTool			tftRowTool;

					/********************************/
					/*  'Paragraph'			*/
					/********************************/
    ParagraphTool		tftParagraphTool;

    } TedFormatTool;

void *	TED_FormatTool;

/************************************************************************/
/*									*/
/*  Update a 'HasBorder' toggle.					*/
/*									*/
/************************************************************************/

void tedFormatReflectBorder(	Widget				toggle,
				const BorderProperties *	bp )
    {
    int		set= False;

    if  ( bp->bpWidthTwips > 0	&&
	  bp->bpIsSet		)
	{ set= True;	}

    XmToggleButtonSetState( toggle, set, False );

    return;
    }

/************************************************************************/
/*									*/
/*  Refresh a height chooser.						*/
/*									*/
/************************************************************************/

void tedFormatRefreshHeightChooser(	HeightChooser *	hc,
					int		height )
    {
    char		scratch[50];

    if  ( height == 0 )
	{
	appEnableText( hc->hcText, 0 );

	XtVaSetValues( hc->hcMenu,
			XmNmenuHistory,		hc->hcFreeItem,
			NULL );

	XmTextSetString( hc->hcText, "" );
	}
    else{
	appEnableText( hc->hcText, 1 );

	if  ( height > 0 )
	    {
	    XtVaSetValues( hc->hcMenu,
			XmNmenuHistory,		hc->hcAtLeastItem,
			NULL );

	    appGeoLengthToString( scratch,  height, UNITtyPOINTS );
	    }
	else{
	    XtVaSetValues( hc->hcMenu,
			XmNmenuHistory,		hc->hcExactlyItem,
			NULL );

	    appGeoLengthToString( scratch, -height, UNITtyPOINTS );
	    }

	XmTextSetString( hc->hcText, scratch );
	}
    }

int tedFormatToolGetHeight(	int *		pHeight,
				HeightChooser *	hc )
    {
    Widget		item= (Widget)0;

    int			sign;

    int			height;
    int			changed;
    const int		requirePositive= 1;

    XtVaGetValues( hc->hcMenu,
			    XmNmenuHistory,		&item,
			    NULL );

    if  ( item == hc->hcFreeItem )
	{ sign= height= 0;	}
    else{
	if  ( item == hc->hcAtLeastItem )
	    { sign= 1;	}
	else{
	    if  ( item == hc->hcExactlyItem )
		{ sign= -1;			}
	    else{ XDEB(item); return -1;	}
	    }
	}

    height= *pHeight;
    height *= sign;

    if  ( sign != 0 )
	{
	if  ( appGetLengthFromTextWidget( hc->hcText,
			&height, &changed, UNITtyPOINTS, requirePositive ) )
	    { return -1; }

	height *= sign;
	}

    *pHeight= height;

    return 0;
    }

int tedFormatToolGetGapWidth(		const RowProperties *	rp,
					int *			pValue,
					Widget			w )
    {
    int				value;
    int				changed;

    int				minWidth;
    const CellProperties *	cp;
    int				col;

    value= rp->rpHalfGapWidthTwips;
    if  ( appGetLengthFromTextWidget( w, &value, &changed, UNITtyPOINTS, 1 ) )
	{ return -1;	}

    cp= rp->rpCells;
    minWidth= cp->cpRightBoundaryTwips- rp->rpLeftIndentTwips;

    for ( col= 1; col < rp->rpCellCount; cp++, col++ )
	{
	int	cellWidth;

	cellWidth= cp[1].cpRightBoundaryTwips- cp[0].cpRightBoundaryTwips;

	if  ( minWidth > cellWidth )
	    { minWidth=  cellWidth;	}
	}

    if  ( 2* value >= minWidth )
	{
	char		scratch[50];

	value= minWidth/3;

	appGeoLengthToString( scratch, value, UNITtyPOINTS );
	XmTextSetString( w, scratch );
	appRefuseTextValue( w );
	return 1;
	}

    return 0;
    }

int tedFormatToolGetRowLeftIndent(	const RowProperties *	rp,
					const int		pageLeftMargin,
					int *			pValue,
					Widget			w )
    {
    int				value;
    int				changed;

    char			scratch[50];

    const int			requirePositive= 0;

    value= rp->rpLeftIndentTwips;
    if  ( appGetLengthFromTextWidget( w, &value, &changed,
					    UNITtyPOINTS, requirePositive ) )
	{ return -1;	}

    if  ( value < -pageLeftMargin )
	{
	value= -pageLeftMargin+ 10;

	appGeoLengthToString( scratch, value, UNITtyPOINTS );
	XmTextSetString( w, scratch );
	appRefuseTextValue( w );
	return 1;
	}

    if  ( value+ 2* rp->rpHalfGapWidthTwips >=
					rp->rpCells[0].cpRightBoundaryTwips )
	{
	value= rp->rpCells[0].cpRightBoundaryTwips- 3* rp->rpHalfGapWidthTwips;

	if  ( value < -pageLeftMargin )
	    { appRefuseTextValue( w ); return -1;	}

	appGeoLengthToString( scratch, value, UNITtyPOINTS );
	XmTextSetString( w, scratch );
	appRefuseTextValue( w );
	return 1;
	}

    *pValue= value; return 0;
    }

/************************************************************************/
/*									*/
/*  One of the border on/off toggles has been activated by a user.	*/
/*									*/
/************************************************************************/

void tedFormatToggleBorder(	BorderProperties *	bp,
				int			set )
    {
    if  ( set )
	{
	bp->bpIsSet= 1;

	if  ( bp->bpWidthTwips == 0 )
	    { bp->bpWidthTwips= 15;	}
	}
    else{ bp->bpIsSet= 0;		}
    }

/************************************************************************/
/*									*/
/*  Pull a particular subject of the table tool to front.		*/
/*									*/
/************************************************************************/

static void tedSelectSubject(	TedFormatTool *	tft,
				int		andMenu,
				int		subject )
    {
    ToolSubject *	ts;

    if  ( tft->tftCurrentSubject == subject )
	{ return;	}

    if  ( tft->tftCurrentSubject >= 0 )
	{
	ts= tft->tftSubjects+ tft->tftCurrentSubject;

	XtVaSetValues( ts->tsPage,
				XmNmappedWhenManaged,	False,
				NULL );
	}

    if  ( subject >= 0 )
	{
	ts= tft->tftSubjects+ subject;

	XtVaSetValues( ts->tsPage,
				XmNmappedWhenManaged,	True,
				NULL );

	if  ( andMenu )
	    {
	    XtVaSetValues( tft->tttSubjectMenu,
			    XmNmenuHistory,		ts->tsItem,
			    NULL );
	    }
	}
    else{
	if  ( andMenu )
	    {
	    XtVaSetValues( tft->tttSubjectMenu,
			    XmNmenuHistory,		(Widget)0,
			    NULL );
	    }
	}

    tft->tftCurrentSubject= subject;

    return;
    }

static void tedSubjectChosen(	Widget		w,
				XtPointer	voidtft,
				XtPointer	voidtbcs )
    {
    TedFormatTool *			tft= (TedFormatTool *)voidtft;

    ToolSubject *			ts;
    int					subject;
    const int				andMenu= 0;

    ts= tft->tftSubjects;
    for ( subject= 0; subject < TEDtsiCOUNT; ts++, subject++ )
	{
	if  ( ts->tsItem == w )
	    { tedSelectSubject( tft, andMenu, subject ); return; }
	}

    XDEB(w); return;
    }

/************************************************************************/
/*  Make the form with the two buttons.					*/
/************************************************************************/

void tedFormatHeightChosen(	Widget			w,
				HeightChooser *		hc,
				int			defaultValue )
    {
    char		scratch[50];
    int			val;

    if  ( w == hc->hcFreeItem )
	{
	appEnableText( hc->hcText, 0 );

	XmTextSetString( hc->hcText, "" );

	return;
	}

    if  ( w == hc->hcAtLeastItem )
	{
	appEnableText( hc->hcText, 1 );

	val= defaultValue;

	if  ( val < 0 )
	    { val= -val;	}

	appGeoLengthToString( scratch, val, UNITtyPOINTS );

	XmTextSetString( hc->hcText, scratch );

	return;
	}

    if  ( w == hc->hcExactlyItem )
	{
	appEnableText( hc->hcText, 1 );

	val= defaultValue;

	appGeoLengthToString( scratch, val, UNITtyPOINTS );

	XmTextSetString( hc->hcText, scratch );

	return;
	}

    LDEB(1);
    }

/************************************************************************/
/*  Make the form with the two buttons.					*/
/************************************************************************/
Widget tedFormatMakePage(	ToolSubject *		ts,
				Widget			pageParent )
    {
    Widget	pageFrame;
    Widget	insideWidget;

    Arg		al[20];
    int		ac= 0;

    XtSetArg( al[ac],	XmNleftAttachment,	XmATTACH_FORM ); ac++;
    XtSetArg( al[ac],	XmNrightAttachment,	XmATTACH_FORM ); ac++;
    XtSetArg( al[ac],	XmNtopAttachment,	XmATTACH_FORM ); ac++;
    XtSetArg( al[ac],	XmNbottomAttachment,	XmATTACH_FORM ); ac++;

    XtSetArg( al[ac],	XmNleftOffset,		5 ); ac++;
    XtSetArg( al[ac],	XmNrightOffset,		5 ); ac++;
    XtSetArg( al[ac],	XmNtopOffset,		5 ); ac++;
    XtSetArg( al[ac],	XmNbottomOffset,	5 ); ac++;

    XtSetArg( al[ac],	XmNmappedWhenManaged,	False ); ac++;

    pageFrame= XmCreateFrame( pageParent, WIDGET_NAME, al, ac );

    /**********************/

    ac= 0;
    XtSetArg( al[ac],	XmNsashWidth,		1 ); ac++;
    XtSetArg( al[ac],	XmNsashHeight,		1 ); ac++;
    XtSetArg( al[ac],	XmNseparatorOn,		False ); ac++;
    XtSetArg( al[ac],	XmNmarginWidth,		5 ); ac++;
    XtSetArg( al[ac],	XmNmarginHeight,	5 ); ac++;
    XtSetArg( al[ac],	XmNspacing,		5 ); ac++;

    insideWidget= XmCreatePanedWindow( pageFrame, WIDGET_NAME, al, ac );

    ts->tsPage= pageFrame;

    return insideWidget;
    }

void tedFormatMakeButtonRow(	Widget *		pRow,
				Widget			parent,
				Widget *		pLeftButton,
				Widget *		pRightButton,
				char *			leftLabel,
				char *			rightLabel,
				XtCallbackProc		leftCallback,
				XtCallbackProc		rightCallback,
				void *			through )
    {
    Widget	row= appMakeButtonRow( parent, 2 );

    Widget	leftButton;
    Widget	rightButton;

    leftButton= appMakeRowButton( row, leftLabel, leftCallback, through,
								    0, False );
    rightButton= appMakeRowButton( row, rightLabel,rightCallback, through,
								    1, False );

    XtManageChild( leftButton );
    XtManageChild( rightButton );
    XtManageChild( row );

    *pRow= row;
    *pLeftButton= leftButton;
    *pRightButton= rightButton;

    return;
    }

void tedFormatMakeHeightRow(	Widget *		pRow,
				void *			through,
				Widget			parent,
				HeightChooser *		hc,
				XtCallbackProc		callback )
{
    Arg		al[20];
    int		ac= 0;

    Widget	row;
    Widget	menuForm;
    Widget	pulldown;
    Widget	menu;
    Widget	text;

    row= appMakeButtonRow( parent, 2 );

    /**************/
    ac= 0;
    XtSetArg( al[ac], XmNtopAttachment,		XmATTACH_FORM ); ac++;

    XtSetArg( al[ac], XmNleftAttachment,	XmATTACH_POSITION ); ac++;
    XtSetArg( al[ac], XmNleftPosition,		0 ); ac++;

    XtSetArg( al[ac], XmNrightAttachment,	XmATTACH_POSITION ); ac++;
    XtSetArg( al[ac], XmNrightPosition,		1 ); ac++;

    menuForm= XmCreateForm( row, WIDGET_NAME, al, ac );

    appMakePulldownList( &pulldown, &menu, menuForm );

    XtVaSetValues( pulldown,
			XmNresizeWidth,		True,
			NULL );

    XtVaSetValues( menu,
			XmNleftOffset,		0,
			XmNrightOffset,		3,
			NULL );
    /**************/
    appMakeRowText( &text, row, 10, 0 );

    if  ( callback )
	{ XtAddCallback( text, XmNactivateCallback, callback, through ); }

    /* NO: XtManageChild( pulldown ); */

    XtManageChild( menu );
    XtManageChild( menuForm );
    XtManageChild( text );
    XtManageChild( row );

    *pRow= row;
    hc->hcMenu= menu;
    hc->hcPulldown= pulldown;
    hc->hcText= text;

    return;
    }

void tedFormatMakeToggleRow(	Widget *		pRow,
				Widget			parent,
				Widget *		pLeftToggle,
				Widget *		pRightToggle,
				char *			leftText,
				char *			rightText,
				XtCallbackProc		leftCallback,
				XtCallbackProc		rightCallback,
				void *			through )
    {
    Widget	row= appMakeButtonRow( parent, 2 );

    Widget	leftToggle;
    Widget	rightToggle;


    leftToggle= appMakeRowToggle( row, leftText, leftCallback, through, 0 );
    rightToggle= appMakeRowToggle( row, rightText, rightCallback, through, 1 );

    XtManageChild( leftToggle );
    XtManageChild( rightToggle );
    XtManageChild( row );

    *pRow= row;
    *pLeftToggle= leftToggle;
    *pRightToggle= rightToggle;

    return;
    }

static Widget tedTableMakePages(	Widget			parent,
					TedFormatToolResources *	tftr,
					TedFormatTool *		tft )
    {
    Arg		al[20];
    int		ac= 0;

    Widget	pageParent;

    ac= 0;
    XtSetArg( al[ac],	XmNallowResize,		True ); ac++;
    XtSetArg( al[ac],	XmNskipAdjust,		True ); ac++;
    pageParent= XmCreateForm( parent, WIDGET_NAME, al, ac );

    tedFormatMakeTablePage( &(tft->tftTableTool),
			    pageParent, &(tftr->tttrTablePageResources),
			    &(tft->tftSubjects[TEDtsiTABLE]),
			    &(tftr->tttrSubjectResources[TEDtsiTABLE]) );

    tedFormatMakeRowPage( &(tft->tftRowTool),
			    pageParent, &(tftr->tttrRowPageResources),
			    &(tft->tftSubjects[TEDtsiROW]),
			    &(tftr->tttrSubjectResources[TEDtsiROW]) );

    tedFormatMakeColumnPage( &(tft->tftColumnTool),
			    pageParent, &(tftr->tttrColumnPageResources),
			    &(tft->tftSubjects[TEDtsiCOLUMN]),
			    &(tftr->tttrSubjectResources[TEDtsiCOLUMN]) );

    tedFormatMakeParagraphPage( &(tft->tftParagraphTool),
			    pageParent, &(tftr->tttrParaPageResources),
			    &(tft->tftSubjects[TEDtsiPARA]),
			    &(tftr->tttrSubjectResources[TEDtsiPARA]) );

    XtManageChild( pageParent );

    return pageParent;
    }

/************************************************************************/
/*  Fill the menu for the pages.					*/
/************************************************************************/

static Widget tedTableMakePageMenu(	Widget			parent,
					TedFormatToolResources *	tftr,
					TedFormatTool *		tft )
    {
    Widget	menuForm;

    Arg		al[20];
    int		ac;

    ac= 0;
    XtSetArg( al[ac],	XmNallowResize,		True ); ac++;
    XtSetArg( al[ac],	XmNskipAdjust,		True ); ac++;
    menuForm= XmCreateForm( parent, WIDGET_NAME, al, ac );

    appMakePulldownList( &tft->tttSubjectPulldown, &tft->tttSubjectMenu,
								menuForm );

    XtManageChild( tft->tttSubjectMenu );
    XtManageChild( menuForm );

    return menuForm;
    }

static void tedFormatFillPageMenu(	TedFormatToolResources *	tftr,
					TedFormatTool *			tft )
    {
    Dimension			width;
    Widget			first= (Widget)0;

    int				subject;
    FormatPageResources *	fpr;
    ToolSubject *		ts;

    XtVaGetValues( tft->tttSubjectMenu,
			XmNwidth,		&width,
			NULL );

    appEmptyPulldownList( tft->tttSubjectPulldown );

    ts= tft->tftSubjects;
    fpr= tftr->tttrSubjectResources;
    for ( subject= 0; subject < TEDtsiCOUNT; ts++, fpr++, subject++ )
	{
	ts->tsItem= appPulldownMakeOption( tft->tttSubjectPulldown,
				fpr->fprSubjectName,
				width, tedSubjectChosen, (void *)tft );
	if  ( ! first )
	    { first= ts->tsItem;	}
	}

    if 	( first )
	{
	XtVaSetValues( tft->tttSubjectMenu,
		XmNmenuHistory,		first,
		NULL );
	}

    appPulldownSetWidth( tft->tttSubjectMenu, width );
    }

/************************************************************************/
/*  Fill the menu in a height chooser.					*/
/************************************************************************/

void tedFormatFillHeightChooser(	HeightChooser *		hc,
					XtCallbackProc		callback,
					void *			voidtft,
					const char *		freeText,
					const char *		atLeastText,
					const char *		exactlyText )
    {
    Dimension		width;

    XtVaGetValues( hc->hcMenu,
			XmNwidth,		&width,
			NULL );

    appEmptyPulldownList( hc->hcPulldown );

    hc->hcFreeItem= appPulldownMakeOption( hc->hcPulldown,
				    freeText, width, callback, voidtft );

    hc->hcAtLeastItem= appPulldownMakeOption( hc->hcPulldown,
				    atLeastText, width, callback, voidtft );

    hc->hcExactlyItem= appPulldownMakeOption( hc->hcPulldown,
				    exactlyText, width, callback, voidtft );

    XtVaSetValues( hc->hcMenu,
			    XmNmenuHistory,	hc->hcFreeItem,
			    NULL );

    appPulldownSetWidth( hc->hcMenu, width );
    }

/************************************************************************/
/*  The user destroys the table tool.					*/
/************************************************************************/

static void appCloseFormatTool(	Widget		w,
				XtPointer	voidtft,
				XtPointer	voidlcs	 )
    {
    TedFormatTool *	tft= (TedFormatTool *)voidtft;
    ParagraphTool *	pt= &(tft->tftParagraphTool);
    RowTool *		rt= &(tft->tftRowTool);
    ColumnTool *	ct= &(tft->tftColumnTool);
    TableTool *		tt= &(tft->tftTableTool);

    XtDestroyWidget( w );

    docCleanParagraphProperties( &(pt->ptPropertiesSet) );
    docCleanParagraphProperties( &(pt->ptPropertiesChosen) );

    docCleanRowProperties( &(rt->rtPropertiesSet) );
    docCleanRowProperties( &(rt->rtPropertiesChosen) );

    docCleanRowProperties( &(ct->ctPropertiesSet) );
    docCleanRowProperties( &(ct->ctPropertiesChosen) );

    docCleanRowProperties( &(tt->ttPropertiesSet) );
    docCleanRowProperties( &(tt->ttPropertiesChosen) );

    free( tft );

    TED_FormatTool= (void *)0;

    return;
    }

/************************************************************************/
/*  make/show the table picker tool.					*/
/************************************************************************/
void tedShowFormatTool(	Widget			symbolOption,
			EditApplication *	ea,
			const char *		widgetName,
			const char *		pixmapName )
    {
    TedFormatTool *			tft;
   	 
    Arg					al[20];
    int					ac= 0;

    Widget				paned;
    Widget				pageParent;
    Widget				menuForm;

    MwmHints				hints;

    Dimension				width;

    Pixmap				iconPixmap;

    static TedFormatToolResources	tftr;
    static int				gotResources;

    if  ( TED_FormatTool )
	{
	tft= (TedFormatTool *)TED_FormatTool;

	XtVaSetValues( tft->tttTopWidget, XmNinitialState, NormalState, NULL );
	XtMapWidget( tft->tttTopWidget );
	XRaiseWindow( XtDisplay( tft->tttTopWidget ),
					    XtWindow( tft->tttTopWidget ) );
	return;
	}

    if  ( ! gotResources )
	{
	XtGetApplicationResources( ea->eaTopWidget, (void *)&tftr,
	    TED_TedFormatToolResourceTable,
	    XtNumber(TED_TedFormatToolResourceTable),
	    NULL, 0 );

	gotResources= 1;
	}

    if  ( appGetImagePixmap( ea, pixmapName, &iconPixmap )  )
	{ SDEB(pixmapName); return; }

    tft= (TedFormatTool *)malloc( sizeof(TedFormatTool) );
    if  ( ! tft )
	{ XDEB(tft); return;	}

    tft->tftCurrentSubject= -1;

    tft->tftParagraphTool.ptApplication= ea;
    tft->tftColumnTool.ctApplication= ea;
    tft->tftRowTool.rtApplication= ea;
    tft->tftTableTool.ttApplication= ea;

    hints.flags= MWM_HINTS_FUNCTIONS|MWM_HINTS_DECORATIONS;
    hints.functions=	MWM_FUNC_MOVE		|
			MWM_FUNC_MINIMIZE	|
			MWM_FUNC_CLOSE		;
    hints.decorations=	MWM_DECOR_BORDER	|
			MWM_DECOR_TITLE		|
			MWM_DECOR_MENU		|
			MWM_DECOR_MINIMIZE	;

    XtSetArg( al[ac], XmNuserData,		(void *)tft ); ac++;
    XtSetArg( al[ac], XmNdeleteResponse,	 XmDO_NOTHING ); ac++;
    XtSetArg( al[ac], XmNinput,			True ); ac++;
    XtSetArg( al[ac], XmNallowShellResize,	True );
    XtSetArg( al[ac], XmNmwmDecorations,	hints.decorations ); ac++;
    XtSetArg( al[ac], XmNmwmFunctions,		hints.functions ); ac++;

    if  ( iconPixmap )
	{ XtSetArg( al[ac], XmNiconPixmap,	iconPixmap ); ac++; }

    tft->tttTopWidget= XtAppCreateShell( ea->eaApplicationName,
					    widgetName,
					    applicationShellWidgetClass,
					    ea->eaDisplay, al, ac );

    appSetShellTitle( tft->tttTopWidget, symbolOption, ea->eaApplicationName );

    if  ( ea->eaCloseAtom != None )
	{
	XmAddWMProtocolCallback( tft->tttTopWidget, ea->eaCloseAtom,
				    appCloseFormatTool, (XtPointer)tft );
	}

    ac= 0;
    XtSetArg( al[ac], XmNuserData,	(void *)tft ); ac++;
    XtSetArg( al[ac], XmNallowResize,	True ); ac++;
    tft->tttMainWidget= XmCreateForm( tft->tttTopWidget, WIDGET_NAME, al, ac );

    ac= 0;
    XtSetArg( al[ac],	XmNleftAttachment,	XmATTACH_FORM ); ac++;
    XtSetArg( al[ac],	XmNrightAttachment,	XmATTACH_FORM ); ac++;
    XtSetArg( al[ac],	XmNtopAttachment,	XmATTACH_FORM ); ac++;
    XtSetArg( al[ac],	XmNbottomAttachment,	XmATTACH_FORM ); ac++;

    XtSetArg( al[ac],	XmNsashWidth,		1 ); ac++;
    XtSetArg( al[ac],	XmNsashHeight,		1 ); ac++;
    XtSetArg( al[ac],	XmNseparatorOn,		False ); ac++;
    XtSetArg( al[ac],	XmNmarginWidth,		5 ); ac++;
    XtSetArg( al[ac],	XmNmarginHeight,	5 ); ac++;
    XtSetArg( al[ac],	XmNspacing,		5 ); ac++;
    paned= XmCreatePanedWindow( tft->tttMainWidget, WIDGET_NAME, al, ac );

    menuForm= tedTableMakePageMenu( paned, &tftr, tft );
    pageParent= tedTableMakePages( paned, &tftr, tft );

    tedFormatFillPageMenu( &tftr, tft );

    tedFormatFillRowChoosers( &(tft->tftRowTool),
					    &(tftr.tttrRowPageResources) );

    tedFormatFillParagraphChoosers( &(tft->tftParagraphTool),
					    &(tftr.tttrParaPageResources) );

    XtManageChild( paned );
    XtManageChild( tft->tttMainWidget );

    XtRealizeWidget( tft->tttTopWidget );
    XtMapWidget( tft->tttTopWidget );

    XtVaGetValues( tft->tttSubjectMenu,
			    XmNwidth,		&width,
			    NULL );
    appPulldownSetWidth( tft->tttSubjectMenu, width );

    tedFormatFinishRowPage( &(tft->tftRowTool),
					    &(tftr.tttrRowPageResources) );

    tedFormatFinishParagraphPage( &(tft->tftParagraphTool),
					    &(tftr.tttrParaPageResources) );

    TED_FormatTool= (void *)tft;
    return;
    }

/************************************************************************/
/*  Ask the table tool to adapt itself to the selection.		*/
/************************************************************************/

static void tedFormatToolEnableSubject(	TedFormatTool *		tft,
					int			subject ,
					int			enabled )
    {
    ToolSubject *	ts= tft->tftSubjects+ subject;

    XtSetSensitive( ts->tsPage, enabled );
    XtSetSensitive( ts->tsItem, enabled );

    return;
    }

static int tedFormatSaveRowProperties(	TedFormatTool *		tft,
					const BufferItem *	sectBi,
					int			row0 )
    {
    const RowProperties *	rp;

    rp= &(sectBi->biGroupChildren[row0]->biRowProperties);

    if  ( docCopyRowProperties( &(tft->tftRowTool.rtPropertiesChosen), rp ) )
	{ LDEB(1); return -1;	}
    if  ( docCopyRowProperties( &(tft->tftRowTool.rtPropertiesSet), rp ) )
	{ LDEB(1); return -1;	}

    if  ( docCopyRowProperties( &(tft->tftColumnTool.ctPropertiesChosen), rp ) )
	{ LDEB(1); return -1;	}
    if  ( docCopyRowProperties( &(tft->tftColumnTool.ctPropertiesSet), rp ) )
	{ LDEB(1); return -1;	}

    if  ( docCopyRowProperties( &(tft->tftTableTool.ttPropertiesChosen), rp ) )
	{ LDEB(1); return -1;	}
    if  ( docCopyRowProperties( &(tft->tftTableTool.ttPropertiesSet), rp ) )
	{ LDEB(1); return -1;	}

    return 0;
    }

void tedFormatToolAdaptToSelection( void *			voidtft,
				const BufferSelection *		bs,
				int				fileReadonly,
				const DocumentGeometry *	dg )
    {
    TedFormatTool *	tft= (TedFormatTool *)voidtft;
    const int		andMenu= 1;

    int			col0;
    int			col1;
    int			col11;
    int			row0;
    int			row1;
    int			row00;
    int			row11;
    BufferItem *	sectBi;

    Boolean		tableRectangle= False;

    ToolSubject *	ts;
    int			subject;

    int			pageRight;
    int			pageLeftMargin;

    pageRight= dg->dgPaperWideTwips-
			    dg->dgLeftMarginTwips- dg->dgRightMarginTwips;
    pageLeftMargin= dg->dgLeftMarginTwips;

    tft->tftRowTool.rtPageRight= pageRight;
    tft->tftRowTool.rtPageLeftMargin= pageLeftMargin;

    tft->tftColumnTool.ctPageRight= pageRight;
    tft->tftColumnTool.ctPageLeftMargin= pageLeftMargin;

    tft->tftTableTool.ttPageRight= pageRight;
    tft->tftTableTool.ttPageLeftMargin= pageLeftMargin;

    if  ( ! bs->bsBegin.bpBi )
	{
	tedEnableFormatTool( voidtft, False );
	return;
	}
    else{
	const ParagraphProperties *	pp;
	ParagraphTool *			pt= &(tft->tftParagraphTool);

	ts= tft->tftSubjects+ TEDtsiPARA;

	pp= &(bs->bsBegin.bpBi->biParaProperties);

	if  ( docCopyParagraphProperties( &(pt->ptPropertiesChosen), pp ))
	    { LDEB(1); return ;	}

	if  ( docCopyParagraphProperties( &(pt->ptPropertiesSet), pp ) )
	    { LDEB(1); return ;	}

	XtSetSensitive( ts->tsPrevButton,
		docPrevParagraph( bs->bsBegin.bpBi ) != (BufferItem *)0 );
	XtSetSensitive( ts->tsNextButton,
		docNextParagraph( bs->bsBegin.bpBi ) != (BufferItem *)0 );

	tedFormatToolRefreshParagraphPage( pt );

	if  ( fileReadonly )
	    { tedEnableFormatTool( voidtft, False );	}
	else{ tedEnableFormatTool( voidtft, True );	}
	}

    ts= tft->tftSubjects;
    for ( subject= 0; subject < TEDtsiCOUNT; ts++, subject++ )
	{ XtSetSensitive( ts->tsPage, fileReadonly == 0 );	}

    if  ( ! tedGetTableRectangle( bs, &sectBi, &col0, &col1, &col11,
					    &row00, &row0, &row1, &row11 ) )
	{ tableRectangle= True;	}

    if  ( tableRectangle )
	{
	TableTool *	tt= &(tft->tftTableTool);
	ColumnTool *	ct= &(tft->tftColumnTool);
	RowTool *	rt= &(tft->tftRowTool);

	ct->ctCol0=	rt->rtCol0=	tt->ttCol0=	col0;
	ct->ctCol1=	rt->rtCol1=	tt->ttCol1=	col1;
	ct->ctRow00=	rt->rtRow00=	tt->ttRow00=	row00;
	ct->ctRow0=	rt->rtRow0=	tt->ttRow0=	row0;
	ct->ctRow1=	rt->rtRow1=	tt->ttRow1=	row1;
	ct->ctRow11=	rt->rtRow11=	tt->ttRow11=	row11;

	if  ( tedFormatSaveRowProperties( tft, sectBi, row0 ) )
	    { LDEB(1); return;	}

	tedFormatToolRefreshTablePage( tt );

	tedFormatToolEnableSubject( tft, TEDtsiTABLE, True );

	if  ( col1 == col0 )
	    {
	    ts= tft->tftSubjects+ TEDtsiCOLUMN;

	    tedFormatToolRefreshColumnPage( ct );

	    tedFormatToolEnableSubject( tft, TEDtsiCOLUMN, True );

	    XtSetSensitive( ts->tsPrevButton, col0 > 0 );
	    XtSetSensitive( ts->tsNextButton, col1 < col11 );
	    }
	else{
	    tedFormatToolEnableSubject( tft, TEDtsiCOLUMN, False );
	    }

	if  ( row1 == row0 )
	    {
	    ts= tft->tftSubjects+ TEDtsiROW;

	    tedFormatToolEnableSubject( tft, TEDtsiROW, True );

	    tedFormatToolRefreshRowPage( rt );

	    XtSetSensitive( ts->tsPrevButton, row0 > row00 );
	    XtSetSensitive( ts->tsNextButton, row1 < row11 );
	    }
	else{
	    tedFormatToolEnableSubject( tft, TEDtsiROW, False );
	    }

	if  ( tft->tftCurrentSubject < 0 )
	    { tedSelectSubject( tft, andMenu, TEDtsiTABLE );	}
	else{
	    ts= tft->tftSubjects+ tft->tftCurrentSubject;

	    if  ( ! XtIsSensitive( ts->tsItem ) )
		{ tedSelectSubject( tft, andMenu, TEDtsiTABLE );	}
	    }
	}
    else{
	tedFormatToolEnableSubject( tft, TEDtsiTABLE, False );
	tedFormatToolEnableSubject( tft, TEDtsiROW, False );
	tedFormatToolEnableSubject( tft, TEDtsiCOLUMN, False );

	tedSelectSubject( tft, andMenu, TEDtsiPARA );
	}
    }

void tedEnableFormatTool(	void *	voidtft,
				int	enabled )
    {
    TedFormatTool *	tft= (TedFormatTool *)voidtft;

    XtSetSensitive( tft->tttMainWidget, enabled != 0 );

    return;
    }
