/************************************************************************/
/*  Ted: Interface to the find tool.					*/
/************************************************************************/

#   include	"config.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	"tedApp.h"

#   include	<appFindTool.h>
#   include	<appSpellTool.h>
#   include	"docFind.h"
#   include	"docSpell.h"

#   include	<debugon.h>

static void tedFindToolClosed(		void *		voidea	)
    {
    EditApplication *	ea=	(EditApplication *)voidea;

    ea->eaFindTool= (void *)0;
    }

static int tedFindToolFindNext(		void *		voidea,
					regProg *	prog	)
    {
    EditApplication *	ea= (EditApplication *)voidea;
    EditDocument *	ed= ea->eaCurrentDocument;
    TedDocument *	td;
    BufferDocument *	bd;

    int			ret;
    BufferPosition	bpFrom;
    BufferSelection	bs;

    if  ( ! ed )
	{ XDEB(ed); return -1;	}

    td= (TedDocument *)ed->edPrivateData;
    bd= td->tdDocument;
    bpFrom= td->tdSelection.bsEnd;

    if  ( ! bpFrom.bpBi )
	{
	if  ( docFirstPosition( &(bd->bdItem), &bpFrom ) )
	    { LDEB(1); return -1;	}
	}

    docInitSelection( &bs );
    ret= docFindFindNext( &bpFrom, &bs, prog );

    if  ( ret )
	{
	if  ( docFirstPosition( &(bd->bdItem), &bpFrom ) )
	    { LDEB(1); return -1;	}

	docInitSelection( &bs );
	ret= docFindFindNext( &bpFrom, &bs, prog );
	}

    if  ( ! ret )
	{
	bs.bsDirection= 1;
	bs.bsAnchor= bs.bsBegin;

	tedSetSelection( ed, td, &bs );

	tedAdaptToolsToSelection( ed );
	}

    return ret;
    }

static int tedFindToolFindPrev(		void *		voidea,
					regProg *	prog	)
    {
    EditApplication *	ea= (EditApplication *)voidea;
    EditDocument *	ed= ea->eaCurrentDocument;
    TedDocument *	td;
    BufferDocument *	bd;

    int			ret;
    BufferPosition	bpFrom;
    BufferSelection	bs;

    if  ( ! ed )
	{ XDEB(ed); return -1;	}

    td= (TedDocument *)ed->edPrivateData;
    bd= td->tdDocument;
    bpFrom= td->tdSelection.bsBegin;

    if  ( ! bpFrom.bpBi )
	{
	if  ( docLastPosition( &(bd->bdItem), &bpFrom ) )
	    { LDEB(1); return -1;	}
	}

    docInitSelection( &bs );
    ret= docFindFindPrev( &bpFrom, &bs, prog );

    if  ( ret )
	{
	if  ( docLastPosition( &(bd->bdItem), &bpFrom ) )
	    { LDEB(1); return -1;	}

	docInitSelection( &bs );
	ret= docFindFindPrev( &bpFrom, &bs, prog );
	}

    if  ( ! ret )
	{
	bs.bsDirection= -1;
	bs.bsAnchor= bs.bsEnd;

	tedSetSelection( ed, td, &bs );

	tedAdaptToolsToSelection( ed );
	}

    return ret;
    }

void tedDocToolFind(			Widget			findOption,
					void *			voided,
					XtPointer		voidcbs )
    {
    EditDocument *	ed= (EditDocument *)voided;
    EditApplication *	ea= ed->edApplication;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    if  ( ! ea->eaFindTool )
	{
	char *	pixmapName= "tedfind";
	Pixmap	iconPixmap= (Pixmap)0;

	if  ( appGetImagePixmap( ea, pixmapName, &iconPixmap )  )
	    { SDEB(pixmapName); return;	}

	ea->eaFindTool= appMakeFindTool( findOption,
			    ea->eaTopWidget, ea->eaContext,
			    ea->eaApplicationName, "tedFindTool",
			    iconPixmap, ea->eaCloseAtom,
			    tedFindToolClosed,
			    tedFindToolFindNext,
			    tedFindToolFindPrev,
			    tedAppReplace,
			    (void *)ea );
	if  ( ! ea->eaFindTool )
	    { XDEB(ea->eaFindTool); return;	}
	}

    appShowFindTool( ed->edTopWidget, ea->eaFindTool );
    appFindToolTextReadonly( ea->eaFindTool, ed->edIsReadonly );

    return;
    }

static int tedSpellFindNext(	void *			voidea,
				SpellCheckContext *	scc )
    {
    EditApplication *	ea= (EditApplication *)voidea;
    EditDocument *	ed= ea->eaCurrentDocument;
    TedDocument *	td;
    BufferDocument *	bd;

    int			ret;
    BufferPosition	bpFrom;

    BufferSelection	bs;

    if  ( ! ed )
	{ XDEB(ed); return -1;	}

    td= (TedDocument *)ed->edPrivateData;
    bd= td->tdDocument;
    bpFrom= td->tdSelection.bsEnd;

    if  ( ! bpFrom.bpBi )
	{
	if  ( docFirstPosition( &(bd->bdItem), &bpFrom ) )
	    { LDEB(1); return -1;	}
	}

    docInitSelection( &bs );
    ret= docSpellFindNext( &bpFrom, &bs, scc );

    if  ( ret )
	{
	if  ( docFirstPosition( &(bd->bdItem), &bpFrom ) )
	    { LDEB(1); return -1;	}

	docInitSelection( &bs );
	ret= docSpellFindNext( &bpFrom, &bs, scc );
	}

    if  ( ret == 0 )
	{
	bs.bsDirection= 1;
	bs.bsAnchor= bs.bsBegin;
	tedSetSelection( ed, td, &bs );

	tedAdaptToolsToSelection( ed );

	if  ( ea->eaSpellTool )
	    {
	    unsigned char	save;

	    save= bs.bsEnd.bpBi->biParaString[bs.bsEnd.bpStroff];
	    bs.bsEnd.bpBi->biParaString[bs.bsEnd.bpStroff]= '\0';

	    appSpellMakeGuesses( ea->eaSpellTool,
			bs.bsBegin.bpBi->biParaString+ bs.bsBegin.bpStroff );

	    bs.bsEnd.bpBi->biParaString[bs.bsEnd.bpStroff]= save;
	    }
	}

    return ret;
    }

/************************************************************************/
/*									*/
/*  Show or create a spelling tool.					*/
/*									*/
/************************************************************************/

static void tedSpellToolClosed(		void *		voidea	)
    {
    EditApplication *	ea= (EditApplication *)voidea;

    ea->eaSpellTool= (void *)0;
    }

void tedDocToolSpell(		Widget		spellOption,
				XtPointer	voided,
				XtPointer	voidcbs	 )
    {
    EditDocument *	ed=	(EditDocument *)voided;
    EditApplication *	ea=	ed->edApplication;

    if  ( ! ea->eaSpellTool )
	{
	char *	pixmapName= "tedspell";
	Pixmap	iconPixmap= (Pixmap)0;

	if  ( appGetImagePixmap( ea, pixmapName, &iconPixmap )  )
	    { SDEB(pixmapName); return;	}

	ea->eaSpellTool= appMakeSpellTool( spellOption, ea,
			    "tedSpellTool",
			    iconPixmap, ea->eaCloseAtom,
			    tedSpellToolClosed, tedSpellFindNext,
			    tedAppReplace,
			    (void *)ea );
	}
    else{ appShowSpellTool( ea->eaSpellTool ); }

    return;
    }
