
/*
 * Computer Algebra Kit (c) 1993,98 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: idespolc.h,v 1.2 1999/07/06 19:48:09 stes Exp $
 */

#ifndef __bigintobj_vardnsexpdegsps_polynomial_header__
#define __bigintobj_vardnsexpdegsps_polynomial_header__

#include "despolc.h"

typedef struct bigintobj_vardnsexpdegspsterm
  {
    struct bigintobj_vardnsexpdegspsterm *nlink;
    struct bigintobj_vardnsexpdegspsterm *plink;
    /* stes - mar31, 1997 - for DEC alpha alignment, put scalar in front */
    bigintobj_c scal;		/* can't be variable sized */
    vardnsmonom_c data;		/* variable sized */
  }
 *bigintobj_vardnsexpdegspsterm_t;

typedef struct
  {
    bigintobj_args sargs;
    vardnsmonom_args margs;
  }
bigintobj_vardnsexpdegspsterm_args;

typedef struct bigintobj_vardnsexpdegspsterm *bigintobj_vardnsexpdegspspol_t;
typedef struct bigintobj_vardnsexpdegspsterm bigintobj_vardnsexpdegspspol_c;
typedef bigintobj_vardnsexpdegspsterm_args bigintobj_vardnsexpdegspspol_args;

typedef struct bigintobj_vardnsexpdegspspol_ix
  {
    bigintobj_vardnsexpdegspsterm_t ix;
    bigintobj_vardnsexpdegspsterm_t head;
  }
 *bigintobj_vardnsexpdegspspol_ixt;

#define bigintobj_vardnsexpdegspspol_isvalue	0
#define bigintobj_vardnsexpdegspspol_pervalue	0

@interface bigintobj_vardnsexpdegsps_polynomial : vardnsexpdegsps_polynomial
{
  id scalarZero;
  id termZero;
  id monomialZero;
  id symbols;
  bigintobj_vardnsexpdegspspol_c value;
}

- (bigintobj_vardnsexpdegspspol_t)bigintobj_vardnsexpdegspspol_value;
- bigintobj_vardnsexpdegspspol_value:(bigintobj_vardnsexpdegspspol_t)aValue;
- (bigintobj_vardnsexpdegspspol_t)bigintobj_vardnsexpdegspspol_reference;
- bigintobj_vardnsexpdegspspol_reference:(bigintobj_vardnsexpdegspspol_c *)aReference;

- copy;
- deepCopy;
- (BOOL) isEmpty;
- (BOOL) isOne;
- (BOOL) isMinusOne;
- (unsigned) hash;
- (BOOL) isEqual:b;
- (BOOL) notEqual:b;
- (BOOL) isZero;
- (BOOL) notZero;
- (BOOL) isOpposite:b;
- (BOOL) notOpposite:b;
- negate;
- negateSelf;
- _double:(int)v;
- _doubleSelf:(int)v;
- double;
- doubleSelf;
- _add:(int)v:b:(int)w;
- _addSelf:(int)v:b:(int)w;
- add:b;
- addSelf:b;
- subtract:b;
- subtractSelf:b;
- (int) leadingDegree;
- (int) lastDegree;
- (int) maxDegree;
- (int) minDegree;
- asScalar;
- asSymbol;
- check;
- _setUpScalarZero:aScalar symbols:aCltn;
+ scalarZero:aScalar symbols:aCltn;
- release;
- empty;
- (int) numMonomials;
- eachMonomial;
- elt_bigintobj_vardnsexpdegspspol_ix:(bigintobj_vardnsexpdegspspol_ixt)ix;
- removeMonomial;
- insertMonomial:aMonomial;
- multiplyScalar:s;
- multiplySelfScalar:s;
- divideScalar:s;
- divideSelfScalar:s;
- _add:(int)v:B multiplyScalar:b:(int)w;
- _addSelf:(int)v:B multiplyScalar:b:(int)w;
- _multiplyScalar:a:(int)v add:B:(int)w;
- _multiplySelfScalar:a:(int)v add:B:(int)w;
- _multiplyScalar:a:(int)v add:B multiplyScalar:b:(int)w;
- _multiplySelfScalar:a:(int)v add:B multiplyScalar:b:(int)w;
- multiplyMonomial:aMonomial;
- multiplySelfMonomial:aMonomial;
- _multiplyMonomial:aMonomial:(int)v;
- _multiplySelfMonomial:aMonomial:(int)v;
- divideMonomial:aMonomial;
- divideSelfMonomial:aMonomial;
- _add:(int)v:B multiplyMonomial:b:(int)w;
- _addSelf:(int)v:B multiplyMonomial:b:(int)w;
- _multiplyScalar:a:(int)v add:B multiplyMonomial:b:(int)w;
- _multiplySelfScalar:a:(int)v add:B multiplyMonomial:b:(int)w;

- fileOutOn:aFiler;
- fileInFrom:aFiler;
@end

#endif /* __bigintobj_vardnsexpdegsps_polynomial_header__ */
 
