
/*
 * Computer Algebra Kit (c) 1993,98 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: ccltnsq.m,v 1.2 1999/07/06 19:48:08 stes Exp $
 */

#include "cakit.h"

@implementation CACollectionSequence
- _setUpContent:aCollection
{
  content = aCollection;
  size = [content size];
  return self;
}

+ content:aCollection
{
  return [[super new] _setUpContent:aCollection];
}

- copy
{
  self = [super copy];
  assert (-1 <= index && index <= size);
  return self;
}

- (unsigned) size
{
  return size;
}

- (BOOL) isEmpty
{
  return size == 0;
}

- toFirst
{
  index = -1;
  return self;
}

- toLast
{
  index = size;
  return self;
}

- toElementAt:(int)i
{
  index = i - 1;
  return self;
}

- next
{
  index = (index > size) ? size : index + 1;
  return (0 <= index && index < size) ? [content at : index]:nil;
}

- previous
{
  index = (index < 0) ? -1 : index - 1;
  return (0 <= index && index < size) ? [content at : index]:nil;
}

@end
 
