/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Software for Humanity
 *	RBD
 *
 *	This program is freely distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 *	$Id: all_squeue.c,v 6.2 1999/05/24 16:56:47 kmeyer1 Exp $
 * 
 *	Function:	- generic queue management code
 *			- fully static version
 *				- aqs_init(): create a queue
 *			- other functions macro'ed to the dynamic version
 */

#include <errno.h>

#include <all_queue.h>
#include <portable.h>

/*
 *	aqs_init
 *
 *	Function:	- creates a static queue
 *	Accepts:	- size of queue
 *			- size of queue element
 *			- queue array
 *			- static queue descriptor
 *	Returns:	- static queue descriptor or NULL
 */
SQUEUE *
aqs_init(size, elemsize, queue, aqsd)

int4			size;
int4			elemsize;
void			*queue;
SQUEUE			*aqsd;

{
	if ((size <= 0) || (elemsize <= 0)) {
		errno = EINVAL;
		return((SQUEUE *) 0);
	}
/*
 * Initialize the queue descriptor.
 */
	aqsd->aq_maxnelem = size;
	aqsd->aq_elemsize = elemsize;
	aqsd->aq_nelem = 0;
	aqsd->aq_first = 0;
	aqsd->aq_last = 0;
	aqsd->aq_queue = queue;

	return(aqsd);
}
